/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.apigatewayv2;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.apigatewayv2.IVpcLink;
import software.amazon.awscdk.services.apigatewayv2.VpcLinkAttributes;
import software.amazon.awscdk.services.apigatewayv2.VpcLinkProps;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.ISubnet;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_apigatewayv2.VpcLink")
public class VpcLink
extends Resource
implements IVpcLink {
    protected VpcLink(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected VpcLink(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public VpcLink(@NotNull Construct scope, @NotNull String id, @NotNull VpcLinkProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IVpcLink fromVpcLinkAttributes(@NotNull Construct scope, @NotNull String id, @NotNull VpcLinkAttributes attrs) {
        return (IVpcLink)JsiiObject.jsiiStaticCall(VpcLink.class, (String)"fromVpcLinkAttributes", (NativeType)NativeType.forClass(IVpcLink.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    public void addSecurityGroups(ISecurityGroup ... groups) {
        Kernel.call((Object)this, (String)"addSecurityGroups", (NativeType)NativeType.VOID, (Object[])Arrays.stream(groups).toArray(Object[]::new));
    }

    public void addSubnets(ISubnet ... subnets) {
        Kernel.call((Object)this, (String)"addSubnets", (NativeType)NativeType.VOID, (Object[])Arrays.stream(subnets).toArray(Object[]::new));
    }

    @Override
    @NotNull
    public IVpc getVpc() {
        return (IVpc)Kernel.get((Object)this, (String)"vpc", (NativeType)NativeType.forClass(IVpc.class));
    }

    @Override
    @NotNull
    public String getVpcLinkId() {
        return (String)Kernel.get((Object)this, (String)"vpcLinkId", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<VpcLink> {
        private final Construct scope;
        private final String id;
        private final VpcLinkProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new VpcLinkProps.Builder();
        }

        public Builder vpc(IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        public Builder securityGroups(List<? extends ISecurityGroup> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        public Builder subnets(SubnetSelection subnets) {
            this.props.subnets(subnets);
            return this;
        }

        public Builder vpcLinkName(String vpcLinkName) {
            this.props.vpcLinkName(vpcLinkName);
            return this;
        }

        public VpcLink build() {
            return new VpcLink(this.scope, this.id, this.props.build());
        }
    }
}

