/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.services.ec2.InitElement;
import software.amazon.awscdk.services.ec2.InitServiceRestartHandle;
import software.amazon.awscdk.services.ec2.InitSourceAssetOptions;
import software.amazon.awscdk.services.ec2.InitSourceOptions;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.awscdk.services.s3.assets.Asset;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ec2.InitSource")
public abstract class InitSource
extends InitElement {
    protected InitSource(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected InitSource(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    protected InitSource(@NotNull String targetDirectory, @Nullable List<InitServiceRestartHandle> serviceHandles) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(targetDirectory, "targetDirectory is required"), serviceHandles});
    }

    protected InitSource(@NotNull String targetDirectory) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(targetDirectory, "targetDirectory is required")});
    }

    @NotNull
    public static InitSource fromAsset(@NotNull String targetDirectory, @NotNull String path, @Nullable InitSourceAssetOptions options) {
        return (InitSource)((Object)JsiiObject.jsiiStaticCall(InitSource.class, (String)"fromAsset", (NativeType)NativeType.forClass(InitSource.class), (Object[])new Object[]{Objects.requireNonNull(targetDirectory, "targetDirectory is required"), Objects.requireNonNull(path, "path is required"), options}));
    }

    @NotNull
    public static InitSource fromAsset(@NotNull String targetDirectory, @NotNull String path) {
        return (InitSource)((Object)JsiiObject.jsiiStaticCall(InitSource.class, (String)"fromAsset", (NativeType)NativeType.forClass(InitSource.class), (Object[])new Object[]{Objects.requireNonNull(targetDirectory, "targetDirectory is required"), Objects.requireNonNull(path, "path is required")}));
    }

    @NotNull
    public static InitSource fromExistingAsset(@NotNull String targetDirectory, @NotNull Asset asset, @Nullable InitSourceOptions options) {
        return (InitSource)((Object)JsiiObject.jsiiStaticCall(InitSource.class, (String)"fromExistingAsset", (NativeType)NativeType.forClass(InitSource.class), (Object[])new Object[]{Objects.requireNonNull(targetDirectory, "targetDirectory is required"), Objects.requireNonNull(asset, "asset is required"), options}));
    }

    @NotNull
    public static InitSource fromExistingAsset(@NotNull String targetDirectory, @NotNull Asset asset) {
        return (InitSource)((Object)JsiiObject.jsiiStaticCall(InitSource.class, (String)"fromExistingAsset", (NativeType)NativeType.forClass(InitSource.class), (Object[])new Object[]{Objects.requireNonNull(targetDirectory, "targetDirectory is required"), Objects.requireNonNull(asset, "asset is required")}));
    }

    @NotNull
    public static InitSource fromGitHub(@NotNull String targetDirectory, @NotNull String owner, @NotNull String repo, @Nullable String refSpec, @Nullable InitSourceOptions options) {
        return (InitSource)((Object)JsiiObject.jsiiStaticCall(InitSource.class, (String)"fromGitHub", (NativeType)NativeType.forClass(InitSource.class), (Object[])new Object[]{Objects.requireNonNull(targetDirectory, "targetDirectory is required"), Objects.requireNonNull(owner, "owner is required"), Objects.requireNonNull(repo, "repo is required"), refSpec, options}));
    }

    @NotNull
    public static InitSource fromGitHub(@NotNull String targetDirectory, @NotNull String owner, @NotNull String repo, @Nullable String refSpec) {
        return (InitSource)((Object)JsiiObject.jsiiStaticCall(InitSource.class, (String)"fromGitHub", (NativeType)NativeType.forClass(InitSource.class), (Object[])new Object[]{Objects.requireNonNull(targetDirectory, "targetDirectory is required"), Objects.requireNonNull(owner, "owner is required"), Objects.requireNonNull(repo, "repo is required"), refSpec}));
    }

    @NotNull
    public static InitSource fromGitHub(@NotNull String targetDirectory, @NotNull String owner, @NotNull String repo) {
        return (InitSource)((Object)JsiiObject.jsiiStaticCall(InitSource.class, (String)"fromGitHub", (NativeType)NativeType.forClass(InitSource.class), (Object[])new Object[]{Objects.requireNonNull(targetDirectory, "targetDirectory is required"), Objects.requireNonNull(owner, "owner is required"), Objects.requireNonNull(repo, "repo is required")}));
    }

    @NotNull
    public static InitSource fromS3Object(@NotNull String targetDirectory, @NotNull IBucket bucket, @NotNull String key, @Nullable InitSourceOptions options) {
        return (InitSource)((Object)JsiiObject.jsiiStaticCall(InitSource.class, (String)"fromS3Object", (NativeType)NativeType.forClass(InitSource.class), (Object[])new Object[]{Objects.requireNonNull(targetDirectory, "targetDirectory is required"), Objects.requireNonNull(bucket, "bucket is required"), Objects.requireNonNull(key, "key is required"), options}));
    }

    @NotNull
    public static InitSource fromS3Object(@NotNull String targetDirectory, @NotNull IBucket bucket, @NotNull String key) {
        return (InitSource)((Object)JsiiObject.jsiiStaticCall(InitSource.class, (String)"fromS3Object", (NativeType)NativeType.forClass(InitSource.class), (Object[])new Object[]{Objects.requireNonNull(targetDirectory, "targetDirectory is required"), Objects.requireNonNull(bucket, "bucket is required"), Objects.requireNonNull(key, "key is required")}));
    }

    @NotNull
    public static InitSource fromUrl(@NotNull String targetDirectory, @NotNull String url, @Nullable InitSourceOptions options) {
        return (InitSource)((Object)JsiiObject.jsiiStaticCall(InitSource.class, (String)"fromUrl", (NativeType)NativeType.forClass(InitSource.class), (Object[])new Object[]{Objects.requireNonNull(targetDirectory, "targetDirectory is required"), Objects.requireNonNull(url, "url is required"), options}));
    }

    @NotNull
    public static InitSource fromUrl(@NotNull String targetDirectory, @NotNull String url) {
        return (InitSource)((Object)JsiiObject.jsiiStaticCall(InitSource.class, (String)"fromUrl", (NativeType)NativeType.forClass(InitSource.class), (Object[])new Object[]{Objects.requireNonNull(targetDirectory, "targetDirectory is required"), Objects.requireNonNull(url, "url is required")}));
    }

    @Override
    @NotNull
    public String getElementType() {
        return (String)Kernel.get((Object)((Object)this), (String)"elementType", (NativeType)NativeType.forClass(String.class));
    }
}

