/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.elasticloadbalancingv2;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.services.cloudwatch.Metric;
import software.amazon.awscdk.services.cloudwatch.MetricOptions;
import software.amazon.awscdk.services.ec2.IConnectable;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.Port;
import software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol;
import software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocolVersion;
import software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationTargetGroupProps;
import software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck;
import software.amazon.awscdk.services.elasticloadbalancingv2.HttpCodeTarget;
import software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener;
import software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget;
import software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup;
import software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroupMetrics;
import software.amazon.awscdk.services.elasticloadbalancingv2.TargetGroupAttributes;
import software.amazon.awscdk.services.elasticloadbalancingv2.TargetGroupBase;
import software.amazon.awscdk.services.elasticloadbalancingv2.TargetGroupLoadBalancingAlgorithmType;
import software.amazon.awscdk.services.elasticloadbalancingv2.TargetType;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;
import software.constructs.IConstruct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationTargetGroup")
public class ApplicationTargetGroup
extends TargetGroupBase
implements IApplicationTargetGroup {
    protected ApplicationTargetGroup(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ApplicationTargetGroup(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public ApplicationTargetGroup(@NotNull Construct scope, @NotNull String id, @Nullable ApplicationTargetGroupProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public ApplicationTargetGroup(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public static IApplicationTargetGroup fromTargetGroupAttributes(@NotNull Construct scope, @NotNull String id, @NotNull TargetGroupAttributes attrs) {
        return (IApplicationTargetGroup)JsiiObject.jsiiStaticCall(ApplicationTargetGroup.class, (String)"fromTargetGroupAttributes", (NativeType)NativeType.forClass(IApplicationTargetGroup.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @Override
    public void addTarget(IApplicationLoadBalancerTarget ... targets) {
        Kernel.call((Object)this, (String)"addTarget", (NativeType)NativeType.VOID, (Object[])Arrays.stream(targets).toArray(Object[]::new));
    }

    public void enableCookieStickiness(@NotNull Duration duration, @Nullable String cookieName) {
        Kernel.call((Object)this, (String)"enableCookieStickiness", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(duration, "duration is required"), cookieName});
    }

    public void enableCookieStickiness(@NotNull Duration duration) {
        Kernel.call((Object)this, (String)"enableCookieStickiness", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(duration, "duration is required")});
    }

    @NotNull
    public Metric metric(@NotNull String metricName, @Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metric", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(metricName, "metricName is required"), props});
    }

    @NotNull
    public Metric metric(@NotNull String metricName) {
        return (Metric)Kernel.call((Object)this, (String)"metric", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(metricName, "metricName is required")});
    }

    @Deprecated
    @NotNull
    public Metric metricHealthyHostCount(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricHealthyHostCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Deprecated
    @NotNull
    public Metric metricHealthyHostCount() {
        return (Metric)Kernel.call((Object)this, (String)"metricHealthyHostCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Deprecated
    @NotNull
    public Metric metricHttpCodeTarget(@NotNull HttpCodeTarget code, @Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricHttpCodeTarget", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(code, "code is required"), props});
    }

    @Deprecated
    @NotNull
    public Metric metricHttpCodeTarget(@NotNull HttpCodeTarget code) {
        return (Metric)Kernel.call((Object)this, (String)"metricHttpCodeTarget", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(code, "code is required")});
    }

    @Deprecated
    @NotNull
    public Metric metricIpv6RequestCount(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricIpv6RequestCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Deprecated
    @NotNull
    public Metric metricIpv6RequestCount() {
        return (Metric)Kernel.call((Object)this, (String)"metricIpv6RequestCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Deprecated
    @NotNull
    public Metric metricRequestCount(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricRequestCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Deprecated
    @NotNull
    public Metric metricRequestCount() {
        return (Metric)Kernel.call((Object)this, (String)"metricRequestCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Deprecated
    @NotNull
    public Metric metricRequestCountPerTarget(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricRequestCountPerTarget", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Deprecated
    @NotNull
    public Metric metricRequestCountPerTarget() {
        return (Metric)Kernel.call((Object)this, (String)"metricRequestCountPerTarget", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Deprecated
    @NotNull
    public Metric metricTargetConnectionErrorCount(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricTargetConnectionErrorCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Deprecated
    @NotNull
    public Metric metricTargetConnectionErrorCount() {
        return (Metric)Kernel.call((Object)this, (String)"metricTargetConnectionErrorCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Deprecated
    @NotNull
    public Metric metricTargetResponseTime(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricTargetResponseTime", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Deprecated
    @NotNull
    public Metric metricTargetResponseTime() {
        return (Metric)Kernel.call((Object)this, (String)"metricTargetResponseTime", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Deprecated
    @NotNull
    public Metric metricTargetTLSNegotiationErrorCount(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricTargetTLSNegotiationErrorCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Deprecated
    @NotNull
    public Metric metricTargetTLSNegotiationErrorCount() {
        return (Metric)Kernel.call((Object)this, (String)"metricTargetTLSNegotiationErrorCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Deprecated
    @NotNull
    public Metric metricUnhealthyHostCount(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricUnhealthyHostCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Deprecated
    @NotNull
    public Metric metricUnhealthyHostCount() {
        return (Metric)Kernel.call((Object)this, (String)"metricUnhealthyHostCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    public void registerConnectable(@NotNull IConnectable connectable, @Nullable Port portRange) {
        Kernel.call((Object)this, (String)"registerConnectable", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(connectable, "connectable is required"), portRange});
    }

    @Override
    public void registerConnectable(@NotNull IConnectable connectable) {
        Kernel.call((Object)this, (String)"registerConnectable", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(connectable, "connectable is required")});
    }

    @Override
    public void registerListener(@NotNull IApplicationListener listener, @Nullable IConstruct associatingConstruct) {
        Kernel.call((Object)this, (String)"registerListener", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(listener, "listener is required"), associatingConstruct});
    }

    @Override
    public void registerListener(@NotNull IApplicationListener listener) {
        Kernel.call((Object)this, (String)"registerListener", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(listener, "listener is required")});
    }

    @Override
    @NotNull
    protected List<String> validateTargetGroup() {
        return Collections.unmodifiableList((List)Kernel.call((Object)this, (String)"validateTargetGroup", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)), (Object[])new Object[0]));
    }

    @Override
    @NotNull
    public String getFirstLoadBalancerFullName() {
        return (String)Kernel.get((Object)this, (String)"firstLoadBalancerFullName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public IApplicationTargetGroupMetrics getMetrics() {
        return (IApplicationTargetGroupMetrics)Kernel.get((Object)this, (String)"metrics", (NativeType)NativeType.forClass(IApplicationTargetGroupMetrics.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<ApplicationTargetGroup> {
        private final Construct scope;
        private final String id;
        private ApplicationTargetGroupProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder deregistrationDelay(Duration deregistrationDelay) {
            this.props().deregistrationDelay(deregistrationDelay);
            return this;
        }

        public Builder healthCheck(HealthCheck healthCheck) {
            this.props().healthCheck(healthCheck);
            return this;
        }

        public Builder targetGroupName(String targetGroupName) {
            this.props().targetGroupName(targetGroupName);
            return this;
        }

        public Builder targetType(TargetType targetType) {
            this.props().targetType(targetType);
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.props().vpc(vpc);
            return this;
        }

        public Builder loadBalancingAlgorithmType(TargetGroupLoadBalancingAlgorithmType loadBalancingAlgorithmType) {
            this.props().loadBalancingAlgorithmType(loadBalancingAlgorithmType);
            return this;
        }

        public Builder port(Number port) {
            this.props().port(port);
            return this;
        }

        public Builder protocol(ApplicationProtocol protocol) {
            this.props().protocol(protocol);
            return this;
        }

        public Builder protocolVersion(ApplicationProtocolVersion protocolVersion) {
            this.props().protocolVersion(protocolVersion);
            return this;
        }

        public Builder slowStart(Duration slowStart) {
            this.props().slowStart(slowStart);
            return this;
        }

        public Builder stickinessCookieDuration(Duration stickinessCookieDuration) {
            this.props().stickinessCookieDuration(stickinessCookieDuration);
            return this;
        }

        public Builder stickinessCookieName(String stickinessCookieName) {
            this.props().stickinessCookieName(stickinessCookieName);
            return this;
        }

        public Builder targets(List<? extends IApplicationLoadBalancerTarget> targets) {
            this.props().targets(targets);
            return this;
        }

        public ApplicationTargetGroup build() {
            return new ApplicationTargetGroup(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private ApplicationTargetGroupProps.Builder props() {
            if (this.props == null) {
                this.props = new ApplicationTargetGroupProps.Builder();
            }
            return this.props;
        }
    }
}

