/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.pcaconnectorad;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.pcaconnectorad.CfnTemplate;
import software.amazon.awscdk.services.pcaconnectorad.CfnTemplateProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pcaconnectorad.CfnTemplate")
public class CfnTemplate
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnTemplate.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnTemplate(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnTemplate(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnTemplate(@NotNull Construct scope, @NotNull String id, @NotNull CfnTemplateProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrTemplateArn() {
        return (String)Kernel.get((Object)this, (String)"attrTemplateArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getConnectorArn() {
        return (String)Kernel.get((Object)this, (String)"connectorArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setConnectorArn(@NotNull String value) {
        Kernel.set((Object)this, (String)"connectorArn", (Object)Objects.requireNonNull(value, "connectorArn is required"));
    }

    @NotNull
    public Object getDefinition() {
        return Kernel.get((Object)this, (String)"definition", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDefinition(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"definition", (Object)Objects.requireNonNull(value, "definition is required"));
    }

    public void setDefinition(@NotNull TemplateDefinitionProperty value) {
        Kernel.set((Object)this, (String)"definition", (Object)Objects.requireNonNull(value, "definition is required"));
    }

    @NotNull
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@NotNull String value) {
        Kernel.set((Object)this, (String)"name", (Object)Objects.requireNonNull(value, "name is required"));
    }

    @Nullable
    public Object getReenrollAllCertificateHolders() {
        return Kernel.get((Object)this, (String)"reenrollAllCertificateHolders", (NativeType)NativeType.forClass(Object.class));
    }

    public void setReenrollAllCertificateHolders(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"reenrollAllCertificateHolders", (Object)value);
    }

    public void setReenrollAllCertificateHolders(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"reenrollAllCertificateHolders", (Object)value);
    }

    @Nullable
    public Map<String, String> getTags() {
        return Optional.ofNullable((Map)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableMap).orElse(null);
    }

    public void setTags(@Nullable Map<String, String> value) {
        Kernel.set((Object)this, (String)"tags", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnTemplate> {
        private final Construct scope;
        private final String id;
        private final CfnTemplateProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnTemplateProps.Builder();
        }

        public Builder connectorArn(String connectorArn) {
            this.props.connectorArn(connectorArn);
            return this;
        }

        public Builder definition(IResolvable definition) {
            this.props.definition(definition);
            return this;
        }

        public Builder definition(TemplateDefinitionProperty definition) {
            this.props.definition(definition);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder reenrollAllCertificateHolders(Boolean reenrollAllCertificateHolders) {
            this.props.reenrollAllCertificateHolders(reenrollAllCertificateHolders);
            return this;
        }

        public Builder reenrollAllCertificateHolders(IResolvable reenrollAllCertificateHolders) {
            this.props.reenrollAllCertificateHolders(reenrollAllCertificateHolders);
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnTemplate build() {
            return new CfnTemplate(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.ValidityPeriodProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ValidityPeriodProperty
    extends JsiiSerializable {
        @NotNull
        public Number getPeriod();

        @NotNull
        public String getPeriodType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ValidityPeriodProperty> {
            Number period;
            String periodType;

            public Builder period(Number period) {
                this.period = period;
                return this;
            }

            public Builder periodType(String periodType) {
                this.periodType = periodType;
                return this;
            }

            public ValidityPeriodProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.TemplateV4Property")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TemplateV4Property
    extends JsiiSerializable {
        @NotNull
        public Object getCertificateValidity();

        @NotNull
        public Object getEnrollmentFlags();

        @NotNull
        public Object getExtensions();

        @NotNull
        public Object getGeneralFlags();

        @NotNull
        public Object getPrivateKeyAttributes();

        @NotNull
        public Object getPrivateKeyFlags();

        @NotNull
        public Object getSubjectNameFlags();

        @Nullable
        default public String getHashAlgorithm() {
            return null;
        }

        @Nullable
        default public List<String> getSupersededTemplates() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TemplateV4Property> {
            Object certificateValidity;
            Object enrollmentFlags;
            Object extensions;
            Object generalFlags;
            Object privateKeyAttributes;
            Object privateKeyFlags;
            Object subjectNameFlags;
            String hashAlgorithm;
            List<String> supersededTemplates;

            public Builder certificateValidity(IResolvable certificateValidity) {
                this.certificateValidity = certificateValidity;
                return this;
            }

            public Builder certificateValidity(CertificateValidityProperty certificateValidity) {
                this.certificateValidity = certificateValidity;
                return this;
            }

            public Builder enrollmentFlags(IResolvable enrollmentFlags) {
                this.enrollmentFlags = enrollmentFlags;
                return this;
            }

            public Builder enrollmentFlags(EnrollmentFlagsV4Property enrollmentFlags) {
                this.enrollmentFlags = enrollmentFlags;
                return this;
            }

            public Builder extensions(IResolvable extensions) {
                this.extensions = extensions;
                return this;
            }

            public Builder extensions(ExtensionsV4Property extensions) {
                this.extensions = extensions;
                return this;
            }

            public Builder generalFlags(IResolvable generalFlags) {
                this.generalFlags = generalFlags;
                return this;
            }

            public Builder generalFlags(GeneralFlagsV4Property generalFlags) {
                this.generalFlags = generalFlags;
                return this;
            }

            public Builder privateKeyAttributes(IResolvable privateKeyAttributes) {
                this.privateKeyAttributes = privateKeyAttributes;
                return this;
            }

            public Builder privateKeyAttributes(PrivateKeyAttributesV4Property privateKeyAttributes) {
                this.privateKeyAttributes = privateKeyAttributes;
                return this;
            }

            public Builder privateKeyFlags(IResolvable privateKeyFlags) {
                this.privateKeyFlags = privateKeyFlags;
                return this;
            }

            public Builder privateKeyFlags(PrivateKeyFlagsV4Property privateKeyFlags) {
                this.privateKeyFlags = privateKeyFlags;
                return this;
            }

            public Builder subjectNameFlags(IResolvable subjectNameFlags) {
                this.subjectNameFlags = subjectNameFlags;
                return this;
            }

            public Builder subjectNameFlags(SubjectNameFlagsV4Property subjectNameFlags) {
                this.subjectNameFlags = subjectNameFlags;
                return this;
            }

            public Builder hashAlgorithm(String hashAlgorithm) {
                this.hashAlgorithm = hashAlgorithm;
                return this;
            }

            public Builder supersededTemplates(List<String> supersededTemplates) {
                this.supersededTemplates = supersededTemplates;
                return this;
            }

            public TemplateV4Property build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.TemplateV3Property")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TemplateV3Property
    extends JsiiSerializable {
        @NotNull
        public Object getCertificateValidity();

        @NotNull
        public Object getEnrollmentFlags();

        @NotNull
        public Object getExtensions();

        @NotNull
        public Object getGeneralFlags();

        @NotNull
        public String getHashAlgorithm();

        @NotNull
        public Object getPrivateKeyAttributes();

        @NotNull
        public Object getPrivateKeyFlags();

        @NotNull
        public Object getSubjectNameFlags();

        @Nullable
        default public List<String> getSupersededTemplates() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TemplateV3Property> {
            Object certificateValidity;
            Object enrollmentFlags;
            Object extensions;
            Object generalFlags;
            String hashAlgorithm;
            Object privateKeyAttributes;
            Object privateKeyFlags;
            Object subjectNameFlags;
            List<String> supersededTemplates;

            public Builder certificateValidity(IResolvable certificateValidity) {
                this.certificateValidity = certificateValidity;
                return this;
            }

            public Builder certificateValidity(CertificateValidityProperty certificateValidity) {
                this.certificateValidity = certificateValidity;
                return this;
            }

            public Builder enrollmentFlags(IResolvable enrollmentFlags) {
                this.enrollmentFlags = enrollmentFlags;
                return this;
            }

            public Builder enrollmentFlags(EnrollmentFlagsV3Property enrollmentFlags) {
                this.enrollmentFlags = enrollmentFlags;
                return this;
            }

            public Builder extensions(IResolvable extensions) {
                this.extensions = extensions;
                return this;
            }

            public Builder extensions(ExtensionsV3Property extensions) {
                this.extensions = extensions;
                return this;
            }

            public Builder generalFlags(IResolvable generalFlags) {
                this.generalFlags = generalFlags;
                return this;
            }

            public Builder generalFlags(GeneralFlagsV3Property generalFlags) {
                this.generalFlags = generalFlags;
                return this;
            }

            public Builder hashAlgorithm(String hashAlgorithm) {
                this.hashAlgorithm = hashAlgorithm;
                return this;
            }

            public Builder privateKeyAttributes(IResolvable privateKeyAttributes) {
                this.privateKeyAttributes = privateKeyAttributes;
                return this;
            }

            public Builder privateKeyAttributes(PrivateKeyAttributesV3Property privateKeyAttributes) {
                this.privateKeyAttributes = privateKeyAttributes;
                return this;
            }

            public Builder privateKeyFlags(IResolvable privateKeyFlags) {
                this.privateKeyFlags = privateKeyFlags;
                return this;
            }

            public Builder privateKeyFlags(PrivateKeyFlagsV3Property privateKeyFlags) {
                this.privateKeyFlags = privateKeyFlags;
                return this;
            }

            public Builder subjectNameFlags(IResolvable subjectNameFlags) {
                this.subjectNameFlags = subjectNameFlags;
                return this;
            }

            public Builder subjectNameFlags(SubjectNameFlagsV3Property subjectNameFlags) {
                this.subjectNameFlags = subjectNameFlags;
                return this;
            }

            public Builder supersededTemplates(List<String> supersededTemplates) {
                this.supersededTemplates = supersededTemplates;
                return this;
            }

            public TemplateV3Property build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.TemplateV2Property")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TemplateV2Property
    extends JsiiSerializable {
        @NotNull
        public Object getCertificateValidity();

        @NotNull
        public Object getEnrollmentFlags();

        @NotNull
        public Object getExtensions();

        @NotNull
        public Object getGeneralFlags();

        @NotNull
        public Object getPrivateKeyAttributes();

        @NotNull
        public Object getPrivateKeyFlags();

        @NotNull
        public Object getSubjectNameFlags();

        @Nullable
        default public List<String> getSupersededTemplates() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TemplateV2Property> {
            Object certificateValidity;
            Object enrollmentFlags;
            Object extensions;
            Object generalFlags;
            Object privateKeyAttributes;
            Object privateKeyFlags;
            Object subjectNameFlags;
            List<String> supersededTemplates;

            public Builder certificateValidity(IResolvable certificateValidity) {
                this.certificateValidity = certificateValidity;
                return this;
            }

            public Builder certificateValidity(CertificateValidityProperty certificateValidity) {
                this.certificateValidity = certificateValidity;
                return this;
            }

            public Builder enrollmentFlags(IResolvable enrollmentFlags) {
                this.enrollmentFlags = enrollmentFlags;
                return this;
            }

            public Builder enrollmentFlags(EnrollmentFlagsV2Property enrollmentFlags) {
                this.enrollmentFlags = enrollmentFlags;
                return this;
            }

            public Builder extensions(IResolvable extensions) {
                this.extensions = extensions;
                return this;
            }

            public Builder extensions(ExtensionsV2Property extensions) {
                this.extensions = extensions;
                return this;
            }

            public Builder generalFlags(IResolvable generalFlags) {
                this.generalFlags = generalFlags;
                return this;
            }

            public Builder generalFlags(GeneralFlagsV2Property generalFlags) {
                this.generalFlags = generalFlags;
                return this;
            }

            public Builder privateKeyAttributes(IResolvable privateKeyAttributes) {
                this.privateKeyAttributes = privateKeyAttributes;
                return this;
            }

            public Builder privateKeyAttributes(PrivateKeyAttributesV2Property privateKeyAttributes) {
                this.privateKeyAttributes = privateKeyAttributes;
                return this;
            }

            public Builder privateKeyFlags(IResolvable privateKeyFlags) {
                this.privateKeyFlags = privateKeyFlags;
                return this;
            }

            public Builder privateKeyFlags(PrivateKeyFlagsV2Property privateKeyFlags) {
                this.privateKeyFlags = privateKeyFlags;
                return this;
            }

            public Builder subjectNameFlags(IResolvable subjectNameFlags) {
                this.subjectNameFlags = subjectNameFlags;
                return this;
            }

            public Builder subjectNameFlags(SubjectNameFlagsV2Property subjectNameFlags) {
                this.subjectNameFlags = subjectNameFlags;
                return this;
            }

            public Builder supersededTemplates(List<String> supersededTemplates) {
                this.supersededTemplates = supersededTemplates;
                return this;
            }

            public TemplateV2Property build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.TemplateDefinitionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TemplateDefinitionProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getTemplateV2() {
            return null;
        }

        @Nullable
        default public Object getTemplateV3() {
            return null;
        }

        @Nullable
        default public Object getTemplateV4() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TemplateDefinitionProperty> {
            Object templateV2;
            Object templateV3;
            Object templateV4;

            public Builder templateV2(IResolvable templateV2) {
                this.templateV2 = templateV2;
                return this;
            }

            public Builder templateV2(TemplateV2Property templateV2) {
                this.templateV2 = templateV2;
                return this;
            }

            public Builder templateV3(IResolvable templateV3) {
                this.templateV3 = templateV3;
                return this;
            }

            public Builder templateV3(TemplateV3Property templateV3) {
                this.templateV3 = templateV3;
                return this;
            }

            public Builder templateV4(IResolvable templateV4) {
                this.templateV4 = templateV4;
                return this;
            }

            public Builder templateV4(TemplateV4Property templateV4) {
                this.templateV4 = templateV4;
                return this;
            }

            public TemplateDefinitionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.SubjectNameFlagsV4Property")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SubjectNameFlagsV4Property
    extends JsiiSerializable {
        @Nullable
        default public Object getRequireCommonName() {
            return null;
        }

        @Nullable
        default public Object getRequireDirectoryPath() {
            return null;
        }

        @Nullable
        default public Object getRequireDnsAsCn() {
            return null;
        }

        @Nullable
        default public Object getRequireEmail() {
            return null;
        }

        @Nullable
        default public Object getSanRequireDirectoryGuid() {
            return null;
        }

        @Nullable
        default public Object getSanRequireDns() {
            return null;
        }

        @Nullable
        default public Object getSanRequireDomainDns() {
            return null;
        }

        @Nullable
        default public Object getSanRequireEmail() {
            return null;
        }

        @Nullable
        default public Object getSanRequireSpn() {
            return null;
        }

        @Nullable
        default public Object getSanRequireUpn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SubjectNameFlagsV4Property> {
            Object requireCommonName;
            Object requireDirectoryPath;
            Object requireDnsAsCn;
            Object requireEmail;
            Object sanRequireDirectoryGuid;
            Object sanRequireDns;
            Object sanRequireDomainDns;
            Object sanRequireEmail;
            Object sanRequireSpn;
            Object sanRequireUpn;

            public Builder requireCommonName(Boolean requireCommonName) {
                this.requireCommonName = requireCommonName;
                return this;
            }

            public Builder requireCommonName(IResolvable requireCommonName) {
                this.requireCommonName = requireCommonName;
                return this;
            }

            public Builder requireDirectoryPath(Boolean requireDirectoryPath) {
                this.requireDirectoryPath = requireDirectoryPath;
                return this;
            }

            public Builder requireDirectoryPath(IResolvable requireDirectoryPath) {
                this.requireDirectoryPath = requireDirectoryPath;
                return this;
            }

            public Builder requireDnsAsCn(Boolean requireDnsAsCn) {
                this.requireDnsAsCn = requireDnsAsCn;
                return this;
            }

            public Builder requireDnsAsCn(IResolvable requireDnsAsCn) {
                this.requireDnsAsCn = requireDnsAsCn;
                return this;
            }

            public Builder requireEmail(Boolean requireEmail) {
                this.requireEmail = requireEmail;
                return this;
            }

            public Builder requireEmail(IResolvable requireEmail) {
                this.requireEmail = requireEmail;
                return this;
            }

            public Builder sanRequireDirectoryGuid(Boolean sanRequireDirectoryGuid) {
                this.sanRequireDirectoryGuid = sanRequireDirectoryGuid;
                return this;
            }

            public Builder sanRequireDirectoryGuid(IResolvable sanRequireDirectoryGuid) {
                this.sanRequireDirectoryGuid = sanRequireDirectoryGuid;
                return this;
            }

            public Builder sanRequireDns(Boolean sanRequireDns) {
                this.sanRequireDns = sanRequireDns;
                return this;
            }

            public Builder sanRequireDns(IResolvable sanRequireDns) {
                this.sanRequireDns = sanRequireDns;
                return this;
            }

            public Builder sanRequireDomainDns(Boolean sanRequireDomainDns) {
                this.sanRequireDomainDns = sanRequireDomainDns;
                return this;
            }

            public Builder sanRequireDomainDns(IResolvable sanRequireDomainDns) {
                this.sanRequireDomainDns = sanRequireDomainDns;
                return this;
            }

            public Builder sanRequireEmail(Boolean sanRequireEmail) {
                this.sanRequireEmail = sanRequireEmail;
                return this;
            }

            public Builder sanRequireEmail(IResolvable sanRequireEmail) {
                this.sanRequireEmail = sanRequireEmail;
                return this;
            }

            public Builder sanRequireSpn(Boolean sanRequireSpn) {
                this.sanRequireSpn = sanRequireSpn;
                return this;
            }

            public Builder sanRequireSpn(IResolvable sanRequireSpn) {
                this.sanRequireSpn = sanRequireSpn;
                return this;
            }

            public Builder sanRequireUpn(Boolean sanRequireUpn) {
                this.sanRequireUpn = sanRequireUpn;
                return this;
            }

            public Builder sanRequireUpn(IResolvable sanRequireUpn) {
                this.sanRequireUpn = sanRequireUpn;
                return this;
            }

            public SubjectNameFlagsV4Property build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.SubjectNameFlagsV3Property")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SubjectNameFlagsV3Property
    extends JsiiSerializable {
        @Nullable
        default public Object getRequireCommonName() {
            return null;
        }

        @Nullable
        default public Object getRequireDirectoryPath() {
            return null;
        }

        @Nullable
        default public Object getRequireDnsAsCn() {
            return null;
        }

        @Nullable
        default public Object getRequireEmail() {
            return null;
        }

        @Nullable
        default public Object getSanRequireDirectoryGuid() {
            return null;
        }

        @Nullable
        default public Object getSanRequireDns() {
            return null;
        }

        @Nullable
        default public Object getSanRequireDomainDns() {
            return null;
        }

        @Nullable
        default public Object getSanRequireEmail() {
            return null;
        }

        @Nullable
        default public Object getSanRequireSpn() {
            return null;
        }

        @Nullable
        default public Object getSanRequireUpn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SubjectNameFlagsV3Property> {
            Object requireCommonName;
            Object requireDirectoryPath;
            Object requireDnsAsCn;
            Object requireEmail;
            Object sanRequireDirectoryGuid;
            Object sanRequireDns;
            Object sanRequireDomainDns;
            Object sanRequireEmail;
            Object sanRequireSpn;
            Object sanRequireUpn;

            public Builder requireCommonName(Boolean requireCommonName) {
                this.requireCommonName = requireCommonName;
                return this;
            }

            public Builder requireCommonName(IResolvable requireCommonName) {
                this.requireCommonName = requireCommonName;
                return this;
            }

            public Builder requireDirectoryPath(Boolean requireDirectoryPath) {
                this.requireDirectoryPath = requireDirectoryPath;
                return this;
            }

            public Builder requireDirectoryPath(IResolvable requireDirectoryPath) {
                this.requireDirectoryPath = requireDirectoryPath;
                return this;
            }

            public Builder requireDnsAsCn(Boolean requireDnsAsCn) {
                this.requireDnsAsCn = requireDnsAsCn;
                return this;
            }

            public Builder requireDnsAsCn(IResolvable requireDnsAsCn) {
                this.requireDnsAsCn = requireDnsAsCn;
                return this;
            }

            public Builder requireEmail(Boolean requireEmail) {
                this.requireEmail = requireEmail;
                return this;
            }

            public Builder requireEmail(IResolvable requireEmail) {
                this.requireEmail = requireEmail;
                return this;
            }

            public Builder sanRequireDirectoryGuid(Boolean sanRequireDirectoryGuid) {
                this.sanRequireDirectoryGuid = sanRequireDirectoryGuid;
                return this;
            }

            public Builder sanRequireDirectoryGuid(IResolvable sanRequireDirectoryGuid) {
                this.sanRequireDirectoryGuid = sanRequireDirectoryGuid;
                return this;
            }

            public Builder sanRequireDns(Boolean sanRequireDns) {
                this.sanRequireDns = sanRequireDns;
                return this;
            }

            public Builder sanRequireDns(IResolvable sanRequireDns) {
                this.sanRequireDns = sanRequireDns;
                return this;
            }

            public Builder sanRequireDomainDns(Boolean sanRequireDomainDns) {
                this.sanRequireDomainDns = sanRequireDomainDns;
                return this;
            }

            public Builder sanRequireDomainDns(IResolvable sanRequireDomainDns) {
                this.sanRequireDomainDns = sanRequireDomainDns;
                return this;
            }

            public Builder sanRequireEmail(Boolean sanRequireEmail) {
                this.sanRequireEmail = sanRequireEmail;
                return this;
            }

            public Builder sanRequireEmail(IResolvable sanRequireEmail) {
                this.sanRequireEmail = sanRequireEmail;
                return this;
            }

            public Builder sanRequireSpn(Boolean sanRequireSpn) {
                this.sanRequireSpn = sanRequireSpn;
                return this;
            }

            public Builder sanRequireSpn(IResolvable sanRequireSpn) {
                this.sanRequireSpn = sanRequireSpn;
                return this;
            }

            public Builder sanRequireUpn(Boolean sanRequireUpn) {
                this.sanRequireUpn = sanRequireUpn;
                return this;
            }

            public Builder sanRequireUpn(IResolvable sanRequireUpn) {
                this.sanRequireUpn = sanRequireUpn;
                return this;
            }

            public SubjectNameFlagsV3Property build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.SubjectNameFlagsV2Property")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SubjectNameFlagsV2Property
    extends JsiiSerializable {
        @Nullable
        default public Object getRequireCommonName() {
            return null;
        }

        @Nullable
        default public Object getRequireDirectoryPath() {
            return null;
        }

        @Nullable
        default public Object getRequireDnsAsCn() {
            return null;
        }

        @Nullable
        default public Object getRequireEmail() {
            return null;
        }

        @Nullable
        default public Object getSanRequireDirectoryGuid() {
            return null;
        }

        @Nullable
        default public Object getSanRequireDns() {
            return null;
        }

        @Nullable
        default public Object getSanRequireDomainDns() {
            return null;
        }

        @Nullable
        default public Object getSanRequireEmail() {
            return null;
        }

        @Nullable
        default public Object getSanRequireSpn() {
            return null;
        }

        @Nullable
        default public Object getSanRequireUpn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SubjectNameFlagsV2Property> {
            Object requireCommonName;
            Object requireDirectoryPath;
            Object requireDnsAsCn;
            Object requireEmail;
            Object sanRequireDirectoryGuid;
            Object sanRequireDns;
            Object sanRequireDomainDns;
            Object sanRequireEmail;
            Object sanRequireSpn;
            Object sanRequireUpn;

            public Builder requireCommonName(Boolean requireCommonName) {
                this.requireCommonName = requireCommonName;
                return this;
            }

            public Builder requireCommonName(IResolvable requireCommonName) {
                this.requireCommonName = requireCommonName;
                return this;
            }

            public Builder requireDirectoryPath(Boolean requireDirectoryPath) {
                this.requireDirectoryPath = requireDirectoryPath;
                return this;
            }

            public Builder requireDirectoryPath(IResolvable requireDirectoryPath) {
                this.requireDirectoryPath = requireDirectoryPath;
                return this;
            }

            public Builder requireDnsAsCn(Boolean requireDnsAsCn) {
                this.requireDnsAsCn = requireDnsAsCn;
                return this;
            }

            public Builder requireDnsAsCn(IResolvable requireDnsAsCn) {
                this.requireDnsAsCn = requireDnsAsCn;
                return this;
            }

            public Builder requireEmail(Boolean requireEmail) {
                this.requireEmail = requireEmail;
                return this;
            }

            public Builder requireEmail(IResolvable requireEmail) {
                this.requireEmail = requireEmail;
                return this;
            }

            public Builder sanRequireDirectoryGuid(Boolean sanRequireDirectoryGuid) {
                this.sanRequireDirectoryGuid = sanRequireDirectoryGuid;
                return this;
            }

            public Builder sanRequireDirectoryGuid(IResolvable sanRequireDirectoryGuid) {
                this.sanRequireDirectoryGuid = sanRequireDirectoryGuid;
                return this;
            }

            public Builder sanRequireDns(Boolean sanRequireDns) {
                this.sanRequireDns = sanRequireDns;
                return this;
            }

            public Builder sanRequireDns(IResolvable sanRequireDns) {
                this.sanRequireDns = sanRequireDns;
                return this;
            }

            public Builder sanRequireDomainDns(Boolean sanRequireDomainDns) {
                this.sanRequireDomainDns = sanRequireDomainDns;
                return this;
            }

            public Builder sanRequireDomainDns(IResolvable sanRequireDomainDns) {
                this.sanRequireDomainDns = sanRequireDomainDns;
                return this;
            }

            public Builder sanRequireEmail(Boolean sanRequireEmail) {
                this.sanRequireEmail = sanRequireEmail;
                return this;
            }

            public Builder sanRequireEmail(IResolvable sanRequireEmail) {
                this.sanRequireEmail = sanRequireEmail;
                return this;
            }

            public Builder sanRequireSpn(Boolean sanRequireSpn) {
                this.sanRequireSpn = sanRequireSpn;
                return this;
            }

            public Builder sanRequireSpn(IResolvable sanRequireSpn) {
                this.sanRequireSpn = sanRequireSpn;
                return this;
            }

            public Builder sanRequireUpn(Boolean sanRequireUpn) {
                this.sanRequireUpn = sanRequireUpn;
                return this;
            }

            public Builder sanRequireUpn(IResolvable sanRequireUpn) {
                this.sanRequireUpn = sanRequireUpn;
                return this;
            }

            public SubjectNameFlagsV2Property build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.PrivateKeyFlagsV4Property")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PrivateKeyFlagsV4Property
    extends JsiiSerializable {
        @NotNull
        public String getClientVersion();

        @Nullable
        default public Object getExportableKey() {
            return null;
        }

        @Nullable
        default public Object getRequireAlternateSignatureAlgorithm() {
            return null;
        }

        @Nullable
        default public Object getRequireSameKeyRenewal() {
            return null;
        }

        @Nullable
        default public Object getStrongKeyProtectionRequired() {
            return null;
        }

        @Nullable
        default public Object getUseLegacyProvider() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PrivateKeyFlagsV4Property> {
            String clientVersion;
            Object exportableKey;
            Object requireAlternateSignatureAlgorithm;
            Object requireSameKeyRenewal;
            Object strongKeyProtectionRequired;
            Object useLegacyProvider;

            public Builder clientVersion(String clientVersion) {
                this.clientVersion = clientVersion;
                return this;
            }

            public Builder exportableKey(Boolean exportableKey) {
                this.exportableKey = exportableKey;
                return this;
            }

            public Builder exportableKey(IResolvable exportableKey) {
                this.exportableKey = exportableKey;
                return this;
            }

            public Builder requireAlternateSignatureAlgorithm(Boolean requireAlternateSignatureAlgorithm) {
                this.requireAlternateSignatureAlgorithm = requireAlternateSignatureAlgorithm;
                return this;
            }

            public Builder requireAlternateSignatureAlgorithm(IResolvable requireAlternateSignatureAlgorithm) {
                this.requireAlternateSignatureAlgorithm = requireAlternateSignatureAlgorithm;
                return this;
            }

            public Builder requireSameKeyRenewal(Boolean requireSameKeyRenewal) {
                this.requireSameKeyRenewal = requireSameKeyRenewal;
                return this;
            }

            public Builder requireSameKeyRenewal(IResolvable requireSameKeyRenewal) {
                this.requireSameKeyRenewal = requireSameKeyRenewal;
                return this;
            }

            public Builder strongKeyProtectionRequired(Boolean strongKeyProtectionRequired) {
                this.strongKeyProtectionRequired = strongKeyProtectionRequired;
                return this;
            }

            public Builder strongKeyProtectionRequired(IResolvable strongKeyProtectionRequired) {
                this.strongKeyProtectionRequired = strongKeyProtectionRequired;
                return this;
            }

            public Builder useLegacyProvider(Boolean useLegacyProvider) {
                this.useLegacyProvider = useLegacyProvider;
                return this;
            }

            public Builder useLegacyProvider(IResolvable useLegacyProvider) {
                this.useLegacyProvider = useLegacyProvider;
                return this;
            }

            public PrivateKeyFlagsV4Property build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.PrivateKeyFlagsV3Property")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PrivateKeyFlagsV3Property
    extends JsiiSerializable {
        @NotNull
        public String getClientVersion();

        @Nullable
        default public Object getExportableKey() {
            return null;
        }

        @Nullable
        default public Object getRequireAlternateSignatureAlgorithm() {
            return null;
        }

        @Nullable
        default public Object getStrongKeyProtectionRequired() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PrivateKeyFlagsV3Property> {
            String clientVersion;
            Object exportableKey;
            Object requireAlternateSignatureAlgorithm;
            Object strongKeyProtectionRequired;

            public Builder clientVersion(String clientVersion) {
                this.clientVersion = clientVersion;
                return this;
            }

            public Builder exportableKey(Boolean exportableKey) {
                this.exportableKey = exportableKey;
                return this;
            }

            public Builder exportableKey(IResolvable exportableKey) {
                this.exportableKey = exportableKey;
                return this;
            }

            public Builder requireAlternateSignatureAlgorithm(Boolean requireAlternateSignatureAlgorithm) {
                this.requireAlternateSignatureAlgorithm = requireAlternateSignatureAlgorithm;
                return this;
            }

            public Builder requireAlternateSignatureAlgorithm(IResolvable requireAlternateSignatureAlgorithm) {
                this.requireAlternateSignatureAlgorithm = requireAlternateSignatureAlgorithm;
                return this;
            }

            public Builder strongKeyProtectionRequired(Boolean strongKeyProtectionRequired) {
                this.strongKeyProtectionRequired = strongKeyProtectionRequired;
                return this;
            }

            public Builder strongKeyProtectionRequired(IResolvable strongKeyProtectionRequired) {
                this.strongKeyProtectionRequired = strongKeyProtectionRequired;
                return this;
            }

            public PrivateKeyFlagsV3Property build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.PrivateKeyFlagsV2Property")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PrivateKeyFlagsV2Property
    extends JsiiSerializable {
        @NotNull
        public String getClientVersion();

        @Nullable
        default public Object getExportableKey() {
            return null;
        }

        @Nullable
        default public Object getStrongKeyProtectionRequired() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PrivateKeyFlagsV2Property> {
            String clientVersion;
            Object exportableKey;
            Object strongKeyProtectionRequired;

            public Builder clientVersion(String clientVersion) {
                this.clientVersion = clientVersion;
                return this;
            }

            public Builder exportableKey(Boolean exportableKey) {
                this.exportableKey = exportableKey;
                return this;
            }

            public Builder exportableKey(IResolvable exportableKey) {
                this.exportableKey = exportableKey;
                return this;
            }

            public Builder strongKeyProtectionRequired(Boolean strongKeyProtectionRequired) {
                this.strongKeyProtectionRequired = strongKeyProtectionRequired;
                return this;
            }

            public Builder strongKeyProtectionRequired(IResolvable strongKeyProtectionRequired) {
                this.strongKeyProtectionRequired = strongKeyProtectionRequired;
                return this;
            }

            public PrivateKeyFlagsV2Property build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.PrivateKeyAttributesV4Property")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PrivateKeyAttributesV4Property
    extends JsiiSerializable {
        @NotNull
        public String getKeySpec();

        @NotNull
        public Number getMinimalKeyLength();

        @Nullable
        default public String getAlgorithm() {
            return null;
        }

        @Nullable
        default public List<String> getCryptoProviders() {
            return null;
        }

        @Nullable
        default public Object getKeyUsageProperty() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PrivateKeyAttributesV4Property> {
            String keySpec;
            Number minimalKeyLength;
            String algorithm;
            List<String> cryptoProviders;
            Object keyUsageProperty;

            public Builder keySpec(String keySpec) {
                this.keySpec = keySpec;
                return this;
            }

            public Builder minimalKeyLength(Number minimalKeyLength) {
                this.minimalKeyLength = minimalKeyLength;
                return this;
            }

            public Builder algorithm(String algorithm) {
                this.algorithm = algorithm;
                return this;
            }

            public Builder cryptoProviders(List<String> cryptoProviders) {
                this.cryptoProviders = cryptoProviders;
                return this;
            }

            public Builder keyUsageProperty(IResolvable keyUsageProperty) {
                this.keyUsageProperty = keyUsageProperty;
                return this;
            }

            public Builder keyUsageProperty(KeyUsagePropertyProperty keyUsageProperty) {
                this.keyUsageProperty = keyUsageProperty;
                return this;
            }

            public PrivateKeyAttributesV4Property build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.PrivateKeyAttributesV3Property")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PrivateKeyAttributesV3Property
    extends JsiiSerializable {
        @NotNull
        public String getAlgorithm();

        @NotNull
        public String getKeySpec();

        @NotNull
        public Object getKeyUsageProperty();

        @NotNull
        public Number getMinimalKeyLength();

        @Nullable
        default public List<String> getCryptoProviders() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PrivateKeyAttributesV3Property> {
            String algorithm;
            String keySpec;
            Object keyUsageProperty;
            Number minimalKeyLength;
            List<String> cryptoProviders;

            public Builder algorithm(String algorithm) {
                this.algorithm = algorithm;
                return this;
            }

            public Builder keySpec(String keySpec) {
                this.keySpec = keySpec;
                return this;
            }

            public Builder keyUsageProperty(IResolvable keyUsageProperty) {
                this.keyUsageProperty = keyUsageProperty;
                return this;
            }

            public Builder keyUsageProperty(KeyUsagePropertyProperty keyUsageProperty) {
                this.keyUsageProperty = keyUsageProperty;
                return this;
            }

            public Builder minimalKeyLength(Number minimalKeyLength) {
                this.minimalKeyLength = minimalKeyLength;
                return this;
            }

            public Builder cryptoProviders(List<String> cryptoProviders) {
                this.cryptoProviders = cryptoProviders;
                return this;
            }

            public PrivateKeyAttributesV3Property build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.PrivateKeyAttributesV2Property")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PrivateKeyAttributesV2Property
    extends JsiiSerializable {
        @NotNull
        public String getKeySpec();

        @NotNull
        public Number getMinimalKeyLength();

        @Nullable
        default public List<String> getCryptoProviders() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PrivateKeyAttributesV2Property> {
            String keySpec;
            Number minimalKeyLength;
            List<String> cryptoProviders;

            public Builder keySpec(String keySpec) {
                this.keySpec = keySpec;
                return this;
            }

            public Builder minimalKeyLength(Number minimalKeyLength) {
                this.minimalKeyLength = minimalKeyLength;
                return this;
            }

            public Builder cryptoProviders(List<String> cryptoProviders) {
                this.cryptoProviders = cryptoProviders;
                return this;
            }

            public PrivateKeyAttributesV2Property build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.KeyUsagePropertyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KeyUsagePropertyProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getPropertyFlags() {
            return null;
        }

        @Nullable
        default public String getPropertyType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KeyUsagePropertyProperty> {
            Object propertyFlags;
            String propertyType;

            public Builder propertyFlags(IResolvable propertyFlags) {
                this.propertyFlags = propertyFlags;
                return this;
            }

            public Builder propertyFlags(KeyUsagePropertyFlagsProperty propertyFlags) {
                this.propertyFlags = propertyFlags;
                return this;
            }

            public Builder propertyType(String propertyType) {
                this.propertyType = propertyType;
                return this;
            }

            public KeyUsagePropertyProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.KeyUsagePropertyFlagsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KeyUsagePropertyFlagsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDecrypt() {
            return null;
        }

        @Nullable
        default public Object getKeyAgreement() {
            return null;
        }

        @Nullable
        default public Object getSign() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KeyUsagePropertyFlagsProperty> {
            Object decrypt;
            Object keyAgreement;
            Object sign;

            public Builder decrypt(Boolean decrypt) {
                this.decrypt = decrypt;
                return this;
            }

            public Builder decrypt(IResolvable decrypt) {
                this.decrypt = decrypt;
                return this;
            }

            public Builder keyAgreement(Boolean keyAgreement) {
                this.keyAgreement = keyAgreement;
                return this;
            }

            public Builder keyAgreement(IResolvable keyAgreement) {
                this.keyAgreement = keyAgreement;
                return this;
            }

            public Builder sign(Boolean sign) {
                this.sign = sign;
                return this;
            }

            public Builder sign(IResolvable sign) {
                this.sign = sign;
                return this;
            }

            public KeyUsagePropertyFlagsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.KeyUsageProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KeyUsageProperty
    extends JsiiSerializable {
        @NotNull
        public Object getUsageFlags();

        @Nullable
        default public Object getCritical() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KeyUsageProperty> {
            Object usageFlags;
            Object critical;

            public Builder usageFlags(IResolvable usageFlags) {
                this.usageFlags = usageFlags;
                return this;
            }

            public Builder usageFlags(KeyUsageFlagsProperty usageFlags) {
                this.usageFlags = usageFlags;
                return this;
            }

            public Builder critical(Boolean critical) {
                this.critical = critical;
                return this;
            }

            public Builder critical(IResolvable critical) {
                this.critical = critical;
                return this;
            }

            public KeyUsageProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.KeyUsageFlagsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KeyUsageFlagsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDataEncipherment() {
            return null;
        }

        @Nullable
        default public Object getDigitalSignature() {
            return null;
        }

        @Nullable
        default public Object getKeyAgreement() {
            return null;
        }

        @Nullable
        default public Object getKeyEncipherment() {
            return null;
        }

        @Nullable
        default public Object getNonRepudiation() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KeyUsageFlagsProperty> {
            Object dataEncipherment;
            Object digitalSignature;
            Object keyAgreement;
            Object keyEncipherment;
            Object nonRepudiation;

            public Builder dataEncipherment(Boolean dataEncipherment) {
                this.dataEncipherment = dataEncipherment;
                return this;
            }

            public Builder dataEncipherment(IResolvable dataEncipherment) {
                this.dataEncipherment = dataEncipherment;
                return this;
            }

            public Builder digitalSignature(Boolean digitalSignature) {
                this.digitalSignature = digitalSignature;
                return this;
            }

            public Builder digitalSignature(IResolvable digitalSignature) {
                this.digitalSignature = digitalSignature;
                return this;
            }

            public Builder keyAgreement(Boolean keyAgreement) {
                this.keyAgreement = keyAgreement;
                return this;
            }

            public Builder keyAgreement(IResolvable keyAgreement) {
                this.keyAgreement = keyAgreement;
                return this;
            }

            public Builder keyEncipherment(Boolean keyEncipherment) {
                this.keyEncipherment = keyEncipherment;
                return this;
            }

            public Builder keyEncipherment(IResolvable keyEncipherment) {
                this.keyEncipherment = keyEncipherment;
                return this;
            }

            public Builder nonRepudiation(Boolean nonRepudiation) {
                this.nonRepudiation = nonRepudiation;
                return this;
            }

            public Builder nonRepudiation(IResolvable nonRepudiation) {
                this.nonRepudiation = nonRepudiation;
                return this;
            }

            public KeyUsageFlagsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.GeneralFlagsV4Property")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GeneralFlagsV4Property
    extends JsiiSerializable {
        @Nullable
        default public Object getAutoEnrollment() {
            return null;
        }

        @Nullable
        default public Object getMachineType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GeneralFlagsV4Property> {
            Object autoEnrollment;
            Object machineType;

            public Builder autoEnrollment(Boolean autoEnrollment) {
                this.autoEnrollment = autoEnrollment;
                return this;
            }

            public Builder autoEnrollment(IResolvable autoEnrollment) {
                this.autoEnrollment = autoEnrollment;
                return this;
            }

            public Builder machineType(Boolean machineType) {
                this.machineType = machineType;
                return this;
            }

            public Builder machineType(IResolvable machineType) {
                this.machineType = machineType;
                return this;
            }

            public GeneralFlagsV4Property build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.GeneralFlagsV3Property")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GeneralFlagsV3Property
    extends JsiiSerializable {
        @Nullable
        default public Object getAutoEnrollment() {
            return null;
        }

        @Nullable
        default public Object getMachineType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GeneralFlagsV3Property> {
            Object autoEnrollment;
            Object machineType;

            public Builder autoEnrollment(Boolean autoEnrollment) {
                this.autoEnrollment = autoEnrollment;
                return this;
            }

            public Builder autoEnrollment(IResolvable autoEnrollment) {
                this.autoEnrollment = autoEnrollment;
                return this;
            }

            public Builder machineType(Boolean machineType) {
                this.machineType = machineType;
                return this;
            }

            public Builder machineType(IResolvable machineType) {
                this.machineType = machineType;
                return this;
            }

            public GeneralFlagsV3Property build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.GeneralFlagsV2Property")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GeneralFlagsV2Property
    extends JsiiSerializable {
        @Nullable
        default public Object getAutoEnrollment() {
            return null;
        }

        @Nullable
        default public Object getMachineType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GeneralFlagsV2Property> {
            Object autoEnrollment;
            Object machineType;

            public Builder autoEnrollment(Boolean autoEnrollment) {
                this.autoEnrollment = autoEnrollment;
                return this;
            }

            public Builder autoEnrollment(IResolvable autoEnrollment) {
                this.autoEnrollment = autoEnrollment;
                return this;
            }

            public Builder machineType(Boolean machineType) {
                this.machineType = machineType;
                return this;
            }

            public Builder machineType(IResolvable machineType) {
                this.machineType = machineType;
                return this;
            }

            public GeneralFlagsV2Property build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.ExtensionsV4Property")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ExtensionsV4Property
    extends JsiiSerializable {
        @NotNull
        public Object getKeyUsage();

        @Nullable
        default public Object getApplicationPolicies() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ExtensionsV4Property> {
            Object keyUsage;
            Object applicationPolicies;

            public Builder keyUsage(IResolvable keyUsage) {
                this.keyUsage = keyUsage;
                return this;
            }

            public Builder keyUsage(KeyUsageProperty keyUsage) {
                this.keyUsage = keyUsage;
                return this;
            }

            public Builder applicationPolicies(IResolvable applicationPolicies) {
                this.applicationPolicies = applicationPolicies;
                return this;
            }

            public Builder applicationPolicies(ApplicationPoliciesProperty applicationPolicies) {
                this.applicationPolicies = applicationPolicies;
                return this;
            }

            public ExtensionsV4Property build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.ExtensionsV3Property")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ExtensionsV3Property
    extends JsiiSerializable {
        @NotNull
        public Object getKeyUsage();

        @Nullable
        default public Object getApplicationPolicies() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ExtensionsV3Property> {
            Object keyUsage;
            Object applicationPolicies;

            public Builder keyUsage(IResolvable keyUsage) {
                this.keyUsage = keyUsage;
                return this;
            }

            public Builder keyUsage(KeyUsageProperty keyUsage) {
                this.keyUsage = keyUsage;
                return this;
            }

            public Builder applicationPolicies(IResolvable applicationPolicies) {
                this.applicationPolicies = applicationPolicies;
                return this;
            }

            public Builder applicationPolicies(ApplicationPoliciesProperty applicationPolicies) {
                this.applicationPolicies = applicationPolicies;
                return this;
            }

            public ExtensionsV3Property build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.ExtensionsV2Property")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ExtensionsV2Property
    extends JsiiSerializable {
        @NotNull
        public Object getKeyUsage();

        @Nullable
        default public Object getApplicationPolicies() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ExtensionsV2Property> {
            Object keyUsage;
            Object applicationPolicies;

            public Builder keyUsage(IResolvable keyUsage) {
                this.keyUsage = keyUsage;
                return this;
            }

            public Builder keyUsage(KeyUsageProperty keyUsage) {
                this.keyUsage = keyUsage;
                return this;
            }

            public Builder applicationPolicies(IResolvable applicationPolicies) {
                this.applicationPolicies = applicationPolicies;
                return this;
            }

            public Builder applicationPolicies(ApplicationPoliciesProperty applicationPolicies) {
                this.applicationPolicies = applicationPolicies;
                return this;
            }

            public ExtensionsV2Property build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.EnrollmentFlagsV4Property")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EnrollmentFlagsV4Property
    extends JsiiSerializable {
        @Nullable
        default public Object getEnableKeyReuseOnNtTokenKeysetStorageFull() {
            return null;
        }

        @Nullable
        default public Object getIncludeSymmetricAlgorithms() {
            return null;
        }

        @Nullable
        default public Object getNoSecurityExtension() {
            return null;
        }

        @Nullable
        default public Object getRemoveInvalidCertificateFromPersonalStore() {
            return null;
        }

        @Nullable
        default public Object getUserInteractionRequired() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EnrollmentFlagsV4Property> {
            Object enableKeyReuseOnNtTokenKeysetStorageFull;
            Object includeSymmetricAlgorithms;
            Object noSecurityExtension;
            Object removeInvalidCertificateFromPersonalStore;
            Object userInteractionRequired;

            public Builder enableKeyReuseOnNtTokenKeysetStorageFull(Boolean enableKeyReuseOnNtTokenKeysetStorageFull) {
                this.enableKeyReuseOnNtTokenKeysetStorageFull = enableKeyReuseOnNtTokenKeysetStorageFull;
                return this;
            }

            public Builder enableKeyReuseOnNtTokenKeysetStorageFull(IResolvable enableKeyReuseOnNtTokenKeysetStorageFull) {
                this.enableKeyReuseOnNtTokenKeysetStorageFull = enableKeyReuseOnNtTokenKeysetStorageFull;
                return this;
            }

            public Builder includeSymmetricAlgorithms(Boolean includeSymmetricAlgorithms) {
                this.includeSymmetricAlgorithms = includeSymmetricAlgorithms;
                return this;
            }

            public Builder includeSymmetricAlgorithms(IResolvable includeSymmetricAlgorithms) {
                this.includeSymmetricAlgorithms = includeSymmetricAlgorithms;
                return this;
            }

            public Builder noSecurityExtension(Boolean noSecurityExtension) {
                this.noSecurityExtension = noSecurityExtension;
                return this;
            }

            public Builder noSecurityExtension(IResolvable noSecurityExtension) {
                this.noSecurityExtension = noSecurityExtension;
                return this;
            }

            public Builder removeInvalidCertificateFromPersonalStore(Boolean removeInvalidCertificateFromPersonalStore) {
                this.removeInvalidCertificateFromPersonalStore = removeInvalidCertificateFromPersonalStore;
                return this;
            }

            public Builder removeInvalidCertificateFromPersonalStore(IResolvable removeInvalidCertificateFromPersonalStore) {
                this.removeInvalidCertificateFromPersonalStore = removeInvalidCertificateFromPersonalStore;
                return this;
            }

            public Builder userInteractionRequired(Boolean userInteractionRequired) {
                this.userInteractionRequired = userInteractionRequired;
                return this;
            }

            public Builder userInteractionRequired(IResolvable userInteractionRequired) {
                this.userInteractionRequired = userInteractionRequired;
                return this;
            }

            public EnrollmentFlagsV4Property build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.EnrollmentFlagsV3Property")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EnrollmentFlagsV3Property
    extends JsiiSerializable {
        @Nullable
        default public Object getEnableKeyReuseOnNtTokenKeysetStorageFull() {
            return null;
        }

        @Nullable
        default public Object getIncludeSymmetricAlgorithms() {
            return null;
        }

        @Nullable
        default public Object getNoSecurityExtension() {
            return null;
        }

        @Nullable
        default public Object getRemoveInvalidCertificateFromPersonalStore() {
            return null;
        }

        @Nullable
        default public Object getUserInteractionRequired() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EnrollmentFlagsV3Property> {
            Object enableKeyReuseOnNtTokenKeysetStorageFull;
            Object includeSymmetricAlgorithms;
            Object noSecurityExtension;
            Object removeInvalidCertificateFromPersonalStore;
            Object userInteractionRequired;

            public Builder enableKeyReuseOnNtTokenKeysetStorageFull(Boolean enableKeyReuseOnNtTokenKeysetStorageFull) {
                this.enableKeyReuseOnNtTokenKeysetStorageFull = enableKeyReuseOnNtTokenKeysetStorageFull;
                return this;
            }

            public Builder enableKeyReuseOnNtTokenKeysetStorageFull(IResolvable enableKeyReuseOnNtTokenKeysetStorageFull) {
                this.enableKeyReuseOnNtTokenKeysetStorageFull = enableKeyReuseOnNtTokenKeysetStorageFull;
                return this;
            }

            public Builder includeSymmetricAlgorithms(Boolean includeSymmetricAlgorithms) {
                this.includeSymmetricAlgorithms = includeSymmetricAlgorithms;
                return this;
            }

            public Builder includeSymmetricAlgorithms(IResolvable includeSymmetricAlgorithms) {
                this.includeSymmetricAlgorithms = includeSymmetricAlgorithms;
                return this;
            }

            public Builder noSecurityExtension(Boolean noSecurityExtension) {
                this.noSecurityExtension = noSecurityExtension;
                return this;
            }

            public Builder noSecurityExtension(IResolvable noSecurityExtension) {
                this.noSecurityExtension = noSecurityExtension;
                return this;
            }

            public Builder removeInvalidCertificateFromPersonalStore(Boolean removeInvalidCertificateFromPersonalStore) {
                this.removeInvalidCertificateFromPersonalStore = removeInvalidCertificateFromPersonalStore;
                return this;
            }

            public Builder removeInvalidCertificateFromPersonalStore(IResolvable removeInvalidCertificateFromPersonalStore) {
                this.removeInvalidCertificateFromPersonalStore = removeInvalidCertificateFromPersonalStore;
                return this;
            }

            public Builder userInteractionRequired(Boolean userInteractionRequired) {
                this.userInteractionRequired = userInteractionRequired;
                return this;
            }

            public Builder userInteractionRequired(IResolvable userInteractionRequired) {
                this.userInteractionRequired = userInteractionRequired;
                return this;
            }

            public EnrollmentFlagsV3Property build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.EnrollmentFlagsV2Property")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EnrollmentFlagsV2Property
    extends JsiiSerializable {
        @Nullable
        default public Object getEnableKeyReuseOnNtTokenKeysetStorageFull() {
            return null;
        }

        @Nullable
        default public Object getIncludeSymmetricAlgorithms() {
            return null;
        }

        @Nullable
        default public Object getNoSecurityExtension() {
            return null;
        }

        @Nullable
        default public Object getRemoveInvalidCertificateFromPersonalStore() {
            return null;
        }

        @Nullable
        default public Object getUserInteractionRequired() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EnrollmentFlagsV2Property> {
            Object enableKeyReuseOnNtTokenKeysetStorageFull;
            Object includeSymmetricAlgorithms;
            Object noSecurityExtension;
            Object removeInvalidCertificateFromPersonalStore;
            Object userInteractionRequired;

            public Builder enableKeyReuseOnNtTokenKeysetStorageFull(Boolean enableKeyReuseOnNtTokenKeysetStorageFull) {
                this.enableKeyReuseOnNtTokenKeysetStorageFull = enableKeyReuseOnNtTokenKeysetStorageFull;
                return this;
            }

            public Builder enableKeyReuseOnNtTokenKeysetStorageFull(IResolvable enableKeyReuseOnNtTokenKeysetStorageFull) {
                this.enableKeyReuseOnNtTokenKeysetStorageFull = enableKeyReuseOnNtTokenKeysetStorageFull;
                return this;
            }

            public Builder includeSymmetricAlgorithms(Boolean includeSymmetricAlgorithms) {
                this.includeSymmetricAlgorithms = includeSymmetricAlgorithms;
                return this;
            }

            public Builder includeSymmetricAlgorithms(IResolvable includeSymmetricAlgorithms) {
                this.includeSymmetricAlgorithms = includeSymmetricAlgorithms;
                return this;
            }

            public Builder noSecurityExtension(Boolean noSecurityExtension) {
                this.noSecurityExtension = noSecurityExtension;
                return this;
            }

            public Builder noSecurityExtension(IResolvable noSecurityExtension) {
                this.noSecurityExtension = noSecurityExtension;
                return this;
            }

            public Builder removeInvalidCertificateFromPersonalStore(Boolean removeInvalidCertificateFromPersonalStore) {
                this.removeInvalidCertificateFromPersonalStore = removeInvalidCertificateFromPersonalStore;
                return this;
            }

            public Builder removeInvalidCertificateFromPersonalStore(IResolvable removeInvalidCertificateFromPersonalStore) {
                this.removeInvalidCertificateFromPersonalStore = removeInvalidCertificateFromPersonalStore;
                return this;
            }

            public Builder userInteractionRequired(Boolean userInteractionRequired) {
                this.userInteractionRequired = userInteractionRequired;
                return this;
            }

            public Builder userInteractionRequired(IResolvable userInteractionRequired) {
                this.userInteractionRequired = userInteractionRequired;
                return this;
            }

            public EnrollmentFlagsV2Property build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.CertificateValidityProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CertificateValidityProperty
    extends JsiiSerializable {
        @NotNull
        public Object getRenewalPeriod();

        @NotNull
        public Object getValidityPeriod();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CertificateValidityProperty> {
            Object renewalPeriod;
            Object validityPeriod;

            public Builder renewalPeriod(IResolvable renewalPeriod) {
                this.renewalPeriod = renewalPeriod;
                return this;
            }

            public Builder renewalPeriod(ValidityPeriodProperty renewalPeriod) {
                this.renewalPeriod = renewalPeriod;
                return this;
            }

            public Builder validityPeriod(IResolvable validityPeriod) {
                this.validityPeriod = validityPeriod;
                return this;
            }

            public Builder validityPeriod(ValidityPeriodProperty validityPeriod) {
                this.validityPeriod = validityPeriod;
                return this;
            }

            public CertificateValidityProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.ApplicationPolicyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ApplicationPolicyProperty
    extends JsiiSerializable {
        @Nullable
        default public String getPolicyObjectIdentifier() {
            return null;
        }

        @Nullable
        default public String getPolicyType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ApplicationPolicyProperty> {
            String policyObjectIdentifier;
            String policyType;

            public Builder policyObjectIdentifier(String policyObjectIdentifier) {
                this.policyObjectIdentifier = policyObjectIdentifier;
                return this;
            }

            public Builder policyType(String policyType) {
                this.policyType = policyType;
                return this;
            }

            public ApplicationPolicyProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_pcaconnectorad.CfnTemplate.ApplicationPoliciesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ApplicationPoliciesProperty
    extends JsiiSerializable {
        @NotNull
        public Object getPolicies();

        @Nullable
        default public Object getCritical() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ApplicationPoliciesProperty> {
            Object policies;
            Object critical;

            public Builder policies(IResolvable policies) {
                this.policies = policies;
                return this;
            }

            public Builder policies(List<? extends Object> policies) {
                this.policies = policies;
                return this;
            }

            public Builder critical(Boolean critical) {
                this.critical = critical;
                return this;
            }

            public Builder critical(IResolvable critical) {
                this.critical = critical;
                return this;
            }

            public ApplicationPoliciesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

