/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum RecordType {
    CNAME("CNAME"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private RecordType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RecordType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(RecordType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RecordType> knownValues() {
        return Stream.of(RecordType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

