/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.endpoints.internal;

import java.net.URI;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cognitoidentity.endpoints.CognitoIdentityEndpointParams;
import software.amazon.awssdk.services.cognitoidentity.endpoints.CognitoIdentityEndpointProvider;
import software.amazon.awssdk.services.cognitoidentity.endpoints.internal.RulePartition;
import software.amazon.awssdk.services.cognitoidentity.endpoints.internal.RuleResult;
import software.amazon.awssdk.services.cognitoidentity.endpoints.internal.RulesFunctions;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultCognitoIdentityEndpointProvider
implements CognitoIdentityEndpointProvider {
    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(CognitoIdentityEndpointParams params) {
        Validate.notNull((Object)params.useDualStack(), (String)"Parameter 'UseDualStack' must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)params.useFips(), (String)"Parameter 'UseFIPS' must not be null", (Object[])new Object[0]);
        try {
            Region region = params.region();
            String regionId = region == null ? null : region.id();
            RuleResult result = DefaultCognitoIdentityEndpointProvider.endpointRule0(params, regionId);
            if (result.canContinue()) {
                throw SdkClientException.create((String)"Rule engine did not reach an error or endpoint result");
            }
            if (result.isError()) {
                String errorMsg = result.error();
                if (errorMsg.contains("Invalid ARN") && errorMsg.contains(":s3:::")) {
                    errorMsg = errorMsg + ". Use the bucket name instead of simple bucket ARNs in GetBucketLocationRequest.";
                }
                throw SdkClientException.create((String)errorMsg);
            }
            return CompletableFuture.completedFuture(result.endpoint());
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static RuleResult endpointRule0(CognitoIdentityEndpointParams params, String region) {
        RuleResult result = DefaultCognitoIdentityEndpointProvider.endpointRule1(params);
        if (result.isResolved()) {
            return result;
        }
        result = DefaultCognitoIdentityEndpointProvider.endpointRule5(params, region);
        if (result.isResolved()) {
            return result;
        }
        return RuleResult.error("Invalid Configuration: Missing Region");
    }

    private static RuleResult endpointRule1(CognitoIdentityEndpointParams params) {
        if (params.endpoint() != null) {
            if (params.useFips().booleanValue()) {
                return RuleResult.error("Invalid Configuration: FIPS and custom endpoint are not supported");
            }
            if (params.useDualStack().booleanValue()) {
                return RuleResult.error("Invalid Configuration: Dualstack and custom endpoint are not supported");
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create(params.endpoint())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule5(CognitoIdentityEndpointParams params, String region) {
        if (region != null) {
            return DefaultCognitoIdentityEndpointProvider.endpointRule6(params, region);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule6(CognitoIdentityEndpointParams params, String region) {
        RulePartition partitionResult = RulesFunctions.awsPartition(region);
        if (partitionResult != null) {
            RuleResult result = DefaultCognitoIdentityEndpointProvider.endpointRule7(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultCognitoIdentityEndpointProvider.endpointRule15(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultCognitoIdentityEndpointProvider.endpointRule19(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://cognito-identity." + region + "." + partitionResult.dnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule7(CognitoIdentityEndpointParams params, RulePartition partitionResult, String region) {
        if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            RuleResult result = DefaultCognitoIdentityEndpointProvider.endpointRule8(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS and DualStack are enabled, but this partition does not support one or both");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule8(CognitoIdentityEndpointParams params, RulePartition partitionResult, String region) {
        if (partitionResult.supportsFIPS() && partitionResult.supportsDualStack()) {
            if ("us-east-1".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://cognito-identity-fips.us-east-1.amazonaws.com")).build());
            }
            if ("us-east-2".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://cognito-identity-fips.us-east-2.amazonaws.com")).build());
            }
            if ("us-west-1".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://cognito-identity-fips.us-west-1.amazonaws.com")).build());
            }
            if ("us-west-2".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://cognito-identity-fips.us-west-2.amazonaws.com")).build());
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://cognito-identity-fips." + region + "." + partitionResult.dualStackDnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule15(CognitoIdentityEndpointParams params, RulePartition partitionResult, String region) {
        if (params.useFips().booleanValue()) {
            RuleResult result = DefaultCognitoIdentityEndpointProvider.endpointRule16(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS is enabled but this partition does not support FIPS");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule16(CognitoIdentityEndpointParams params, RulePartition partitionResult, String region) {
        if (partitionResult.supportsFIPS()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://cognito-identity-fips." + region + "." + partitionResult.dnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule19(CognitoIdentityEndpointParams params, RulePartition partitionResult, String region) {
        if (params.useDualStack().booleanValue()) {
            RuleResult result = DefaultCognitoIdentityEndpointProvider.endpointRule20(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("DualStack is enabled but this partition does not support DualStack");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule20(CognitoIdentityEndpointParams params, RulePartition partitionResult, String region) {
        if (partitionResult.supportsDualStack()) {
            if ("aws".equals(partitionResult.name())) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://cognito-identity." + region + ".amazonaws.com")).build());
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://cognito-identity." + region + "." + partitionResult.dualStackDnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    public boolean equals(Object rhs) {
        return rhs != null && this.getClass().equals(rhs.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

