/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.cognitoidentity.CognitoIdentityAsyncClient;
import software.amazon.awssdk.services.cognitoidentity.CognitoIdentityServiceClientConfiguration;
import software.amazon.awssdk.services.cognitoidentity.internal.CognitoIdentityServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.cognitoidentity.model.CognitoIdentityException;
import software.amazon.awssdk.services.cognitoidentity.model.ConcurrentModificationException;
import software.amazon.awssdk.services.cognitoidentity.model.CreateIdentityPoolRequest;
import software.amazon.awssdk.services.cognitoidentity.model.CreateIdentityPoolResponse;
import software.amazon.awssdk.services.cognitoidentity.model.DeleteIdentitiesRequest;
import software.amazon.awssdk.services.cognitoidentity.model.DeleteIdentitiesResponse;
import software.amazon.awssdk.services.cognitoidentity.model.DeleteIdentityPoolRequest;
import software.amazon.awssdk.services.cognitoidentity.model.DeleteIdentityPoolResponse;
import software.amazon.awssdk.services.cognitoidentity.model.DescribeIdentityPoolRequest;
import software.amazon.awssdk.services.cognitoidentity.model.DescribeIdentityPoolResponse;
import software.amazon.awssdk.services.cognitoidentity.model.DescribeIdentityRequest;
import software.amazon.awssdk.services.cognitoidentity.model.DescribeIdentityResponse;
import software.amazon.awssdk.services.cognitoidentity.model.DeveloperUserAlreadyRegisteredException;
import software.amazon.awssdk.services.cognitoidentity.model.ExternalServiceException;
import software.amazon.awssdk.services.cognitoidentity.model.GetCredentialsForIdentityRequest;
import software.amazon.awssdk.services.cognitoidentity.model.GetCredentialsForIdentityResponse;
import software.amazon.awssdk.services.cognitoidentity.model.GetIdRequest;
import software.amazon.awssdk.services.cognitoidentity.model.GetIdResponse;
import software.amazon.awssdk.services.cognitoidentity.model.GetIdentityPoolRolesRequest;
import software.amazon.awssdk.services.cognitoidentity.model.GetIdentityPoolRolesResponse;
import software.amazon.awssdk.services.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityRequest;
import software.amazon.awssdk.services.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityResponse;
import software.amazon.awssdk.services.cognitoidentity.model.GetOpenIdTokenRequest;
import software.amazon.awssdk.services.cognitoidentity.model.GetOpenIdTokenResponse;
import software.amazon.awssdk.services.cognitoidentity.model.GetPrincipalTagAttributeMapRequest;
import software.amazon.awssdk.services.cognitoidentity.model.GetPrincipalTagAttributeMapResponse;
import software.amazon.awssdk.services.cognitoidentity.model.InternalErrorException;
import software.amazon.awssdk.services.cognitoidentity.model.InvalidIdentityPoolConfigurationException;
import software.amazon.awssdk.services.cognitoidentity.model.InvalidParameterException;
import software.amazon.awssdk.services.cognitoidentity.model.LimitExceededException;
import software.amazon.awssdk.services.cognitoidentity.model.ListIdentitiesRequest;
import software.amazon.awssdk.services.cognitoidentity.model.ListIdentitiesResponse;
import software.amazon.awssdk.services.cognitoidentity.model.ListIdentityPoolsRequest;
import software.amazon.awssdk.services.cognitoidentity.model.ListIdentityPoolsResponse;
import software.amazon.awssdk.services.cognitoidentity.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.cognitoidentity.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.cognitoidentity.model.LookupDeveloperIdentityRequest;
import software.amazon.awssdk.services.cognitoidentity.model.LookupDeveloperIdentityResponse;
import software.amazon.awssdk.services.cognitoidentity.model.MergeDeveloperIdentitiesRequest;
import software.amazon.awssdk.services.cognitoidentity.model.MergeDeveloperIdentitiesResponse;
import software.amazon.awssdk.services.cognitoidentity.model.NotAuthorizedException;
import software.amazon.awssdk.services.cognitoidentity.model.ResourceConflictException;
import software.amazon.awssdk.services.cognitoidentity.model.ResourceNotFoundException;
import software.amazon.awssdk.services.cognitoidentity.model.SetIdentityPoolRolesRequest;
import software.amazon.awssdk.services.cognitoidentity.model.SetIdentityPoolRolesResponse;
import software.amazon.awssdk.services.cognitoidentity.model.SetPrincipalTagAttributeMapRequest;
import software.amazon.awssdk.services.cognitoidentity.model.SetPrincipalTagAttributeMapResponse;
import software.amazon.awssdk.services.cognitoidentity.model.TagResourceRequest;
import software.amazon.awssdk.services.cognitoidentity.model.TagResourceResponse;
import software.amazon.awssdk.services.cognitoidentity.model.TooManyRequestsException;
import software.amazon.awssdk.services.cognitoidentity.model.UnlinkDeveloperIdentityRequest;
import software.amazon.awssdk.services.cognitoidentity.model.UnlinkDeveloperIdentityResponse;
import software.amazon.awssdk.services.cognitoidentity.model.UnlinkIdentityRequest;
import software.amazon.awssdk.services.cognitoidentity.model.UnlinkIdentityResponse;
import software.amazon.awssdk.services.cognitoidentity.model.UntagResourceRequest;
import software.amazon.awssdk.services.cognitoidentity.model.UntagResourceResponse;
import software.amazon.awssdk.services.cognitoidentity.model.UpdateIdentityPoolRequest;
import software.amazon.awssdk.services.cognitoidentity.model.UpdateIdentityPoolResponse;
import software.amazon.awssdk.services.cognitoidentity.transform.CreateIdentityPoolRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.DeleteIdentitiesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.DeleteIdentityPoolRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.DescribeIdentityPoolRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.DescribeIdentityRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.GetCredentialsForIdentityRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.GetIdRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.GetIdentityPoolRolesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.GetOpenIdTokenForDeveloperIdentityRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.GetOpenIdTokenRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.GetPrincipalTagAttributeMapRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.ListIdentitiesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.ListIdentityPoolsRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.LookupDeveloperIdentityRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.MergeDeveloperIdentitiesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.SetIdentityPoolRolesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.SetPrincipalTagAttributeMapRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.UnlinkDeveloperIdentityRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.UnlinkIdentityRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.UpdateIdentityPoolRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultCognitoIdentityAsyncClient
implements CognitoIdentityAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultCognitoIdentityAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCognitoIdentityAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Cognito_Identity#2.37.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<CreateIdentityPoolResponse> createIdentityPool(CreateIdentityPoolRequest createIdentityPoolRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createIdentityPoolRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityAsyncClient.resolveMetricPublishers(clientConfiguration, createIdentityPoolRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateIdentityPool");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateIdentityPoolResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DeveloperUserAlreadyRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeveloperUserAlreadyRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeveloperUserAlreadyRegisteredException::builder).build());
                    }
                    case "ResourceConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                    }
                    case "ExternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExternalServiceException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "InvalidIdentityPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdentityPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdentityPoolConfigurationException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateIdentityPool").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateIdentityPoolRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createIdentityPoolRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityAsyncClient.lambda$createIdentityPool$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityAsyncClient.lambda$createIdentityPool$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteIdentitiesResponse> deleteIdentities(DeleteIdentitiesRequest deleteIdentitiesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteIdentitiesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityAsyncClient.resolveMetricPublishers(clientConfiguration, deleteIdentitiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteIdentities");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteIdentitiesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DeveloperUserAlreadyRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeveloperUserAlreadyRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeveloperUserAlreadyRegisteredException::builder).build());
                    }
                    case "ResourceConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                    }
                    case "ExternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExternalServiceException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "InvalidIdentityPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdentityPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdentityPoolConfigurationException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteIdentities").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteIdentitiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteIdentitiesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityAsyncClient.lambda$deleteIdentities$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityAsyncClient.lambda$deleteIdentities$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteIdentityPoolResponse> deleteIdentityPool(DeleteIdentityPoolRequest deleteIdentityPoolRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteIdentityPoolRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityAsyncClient.resolveMetricPublishers(clientConfiguration, deleteIdentityPoolRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteIdentityPool");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteIdentityPoolResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DeveloperUserAlreadyRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeveloperUserAlreadyRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeveloperUserAlreadyRegisteredException::builder).build());
                    }
                    case "ResourceConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                    }
                    case "ExternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExternalServiceException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "InvalidIdentityPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdentityPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdentityPoolConfigurationException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteIdentityPool").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteIdentityPoolRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteIdentityPoolRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityAsyncClient.lambda$deleteIdentityPool$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityAsyncClient.lambda$deleteIdentityPool$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeIdentityResponse> describeIdentity(DescribeIdentityRequest describeIdentityRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeIdentityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityAsyncClient.resolveMetricPublishers(clientConfiguration, describeIdentityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeIdentity");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeIdentityResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DeveloperUserAlreadyRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeveloperUserAlreadyRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeveloperUserAlreadyRegisteredException::builder).build());
                    }
                    case "ResourceConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                    }
                    case "ExternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExternalServiceException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "InvalidIdentityPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdentityPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdentityPoolConfigurationException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeIdentity").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeIdentityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeIdentityRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityAsyncClient.lambda$describeIdentity$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityAsyncClient.lambda$describeIdentity$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeIdentityPoolResponse> describeIdentityPool(DescribeIdentityPoolRequest describeIdentityPoolRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeIdentityPoolRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityAsyncClient.resolveMetricPublishers(clientConfiguration, describeIdentityPoolRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeIdentityPool");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeIdentityPoolResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DeveloperUserAlreadyRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeveloperUserAlreadyRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeveloperUserAlreadyRegisteredException::builder).build());
                    }
                    case "ResourceConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                    }
                    case "ExternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExternalServiceException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "InvalidIdentityPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdentityPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdentityPoolConfigurationException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeIdentityPool").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeIdentityPoolRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeIdentityPoolRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityAsyncClient.lambda$describeIdentityPool$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityAsyncClient.lambda$describeIdentityPool$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetCredentialsForIdentityResponse> getCredentialsForIdentity(GetCredentialsForIdentityRequest getCredentialsForIdentityRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getCredentialsForIdentityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityAsyncClient.resolveMetricPublishers(clientConfiguration, getCredentialsForIdentityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCredentialsForIdentity");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCredentialsForIdentityResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DeveloperUserAlreadyRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeveloperUserAlreadyRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeveloperUserAlreadyRegisteredException::builder).build());
                    }
                    case "ResourceConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                    }
                    case "ExternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExternalServiceException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "InvalidIdentityPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdentityPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdentityPoolConfigurationException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCredentialsForIdentity").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetCredentialsForIdentityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getCredentialsForIdentityRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityAsyncClient.lambda$getCredentialsForIdentity$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityAsyncClient.lambda$getCredentialsForIdentity$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetIdResponse> getId(GetIdRequest getIdRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getIdRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityAsyncClient.resolveMetricPublishers(clientConfiguration, getIdRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetId");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetIdResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DeveloperUserAlreadyRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeveloperUserAlreadyRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeveloperUserAlreadyRegisteredException::builder).build());
                    }
                    case "ResourceConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                    }
                    case "ExternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExternalServiceException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "InvalidIdentityPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdentityPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdentityPoolConfigurationException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetId").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetIdRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getIdRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityAsyncClient.lambda$getId$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityAsyncClient.lambda$getId$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetIdentityPoolRolesResponse> getIdentityPoolRoles(GetIdentityPoolRolesRequest getIdentityPoolRolesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getIdentityPoolRolesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityAsyncClient.resolveMetricPublishers(clientConfiguration, getIdentityPoolRolesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetIdentityPoolRoles");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetIdentityPoolRolesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DeveloperUserAlreadyRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeveloperUserAlreadyRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeveloperUserAlreadyRegisteredException::builder).build());
                    }
                    case "ResourceConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                    }
                    case "ExternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExternalServiceException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "InvalidIdentityPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdentityPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdentityPoolConfigurationException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetIdentityPoolRoles").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetIdentityPoolRolesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getIdentityPoolRolesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityAsyncClient.lambda$getIdentityPoolRoles$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityAsyncClient.lambda$getIdentityPoolRoles$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetOpenIdTokenResponse> getOpenIdToken(GetOpenIdTokenRequest getOpenIdTokenRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getOpenIdTokenRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityAsyncClient.resolveMetricPublishers(clientConfiguration, getOpenIdTokenRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetOpenIdToken");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetOpenIdTokenResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DeveloperUserAlreadyRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeveloperUserAlreadyRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeveloperUserAlreadyRegisteredException::builder).build());
                    }
                    case "ResourceConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                    }
                    case "ExternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExternalServiceException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "InvalidIdentityPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdentityPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdentityPoolConfigurationException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetOpenIdToken").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetOpenIdTokenRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getOpenIdTokenRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityAsyncClient.lambda$getOpenIdToken$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityAsyncClient.lambda$getOpenIdToken$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetOpenIdTokenForDeveloperIdentityResponse> getOpenIdTokenForDeveloperIdentity(GetOpenIdTokenForDeveloperIdentityRequest getOpenIdTokenForDeveloperIdentityRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getOpenIdTokenForDeveloperIdentityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityAsyncClient.resolveMetricPublishers(clientConfiguration, getOpenIdTokenForDeveloperIdentityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetOpenIdTokenForDeveloperIdentity");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetOpenIdTokenForDeveloperIdentityResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DeveloperUserAlreadyRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeveloperUserAlreadyRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeveloperUserAlreadyRegisteredException::builder).build());
                    }
                    case "ResourceConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                    }
                    case "ExternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExternalServiceException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "InvalidIdentityPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdentityPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdentityPoolConfigurationException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetOpenIdTokenForDeveloperIdentity").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetOpenIdTokenForDeveloperIdentityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getOpenIdTokenForDeveloperIdentityRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityAsyncClient.lambda$getOpenIdTokenForDeveloperIdentity$38(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityAsyncClient.lambda$getOpenIdTokenForDeveloperIdentity$39((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetPrincipalTagAttributeMapResponse> getPrincipalTagAttributeMap(GetPrincipalTagAttributeMapRequest getPrincipalTagAttributeMapRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getPrincipalTagAttributeMapRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityAsyncClient.resolveMetricPublishers(clientConfiguration, getPrincipalTagAttributeMapRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPrincipalTagAttributeMap");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPrincipalTagAttributeMapResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DeveloperUserAlreadyRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeveloperUserAlreadyRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeveloperUserAlreadyRegisteredException::builder).build());
                    }
                    case "ResourceConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                    }
                    case "ExternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExternalServiceException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "InvalidIdentityPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdentityPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdentityPoolConfigurationException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPrincipalTagAttributeMap").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetPrincipalTagAttributeMapRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getPrincipalTagAttributeMapRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityAsyncClient.lambda$getPrincipalTagAttributeMap$42(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityAsyncClient.lambda$getPrincipalTagAttributeMap$43((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListIdentitiesResponse> listIdentities(ListIdentitiesRequest listIdentitiesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listIdentitiesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityAsyncClient.resolveMetricPublishers(clientConfiguration, listIdentitiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListIdentities");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListIdentitiesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DeveloperUserAlreadyRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeveloperUserAlreadyRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeveloperUserAlreadyRegisteredException::builder).build());
                    }
                    case "ResourceConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                    }
                    case "ExternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExternalServiceException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "InvalidIdentityPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdentityPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdentityPoolConfigurationException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListIdentities").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListIdentitiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listIdentitiesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityAsyncClient.lambda$listIdentities$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityAsyncClient.lambda$listIdentities$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListIdentityPoolsResponse> listIdentityPools(ListIdentityPoolsRequest listIdentityPoolsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listIdentityPoolsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityAsyncClient.resolveMetricPublishers(clientConfiguration, listIdentityPoolsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListIdentityPools");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListIdentityPoolsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DeveloperUserAlreadyRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeveloperUserAlreadyRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeveloperUserAlreadyRegisteredException::builder).build());
                    }
                    case "ResourceConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                    }
                    case "ExternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExternalServiceException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "InvalidIdentityPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdentityPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdentityPoolConfigurationException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListIdentityPools").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListIdentityPoolsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listIdentityPoolsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityAsyncClient.lambda$listIdentityPools$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityAsyncClient.lambda$listIdentityPools$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityAsyncClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DeveloperUserAlreadyRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeveloperUserAlreadyRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeveloperUserAlreadyRegisteredException::builder).build());
                    }
                    case "ResourceConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                    }
                    case "ExternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExternalServiceException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "InvalidIdentityPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdentityPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdentityPoolConfigurationException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTagsForResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityAsyncClient.lambda$listTagsForResource$54(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityAsyncClient.lambda$listTagsForResource$55((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<LookupDeveloperIdentityResponse> lookupDeveloperIdentity(LookupDeveloperIdentityRequest lookupDeveloperIdentityRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)lookupDeveloperIdentityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityAsyncClient.resolveMetricPublishers(clientConfiguration, lookupDeveloperIdentityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"LookupDeveloperIdentity");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, LookupDeveloperIdentityResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DeveloperUserAlreadyRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeveloperUserAlreadyRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeveloperUserAlreadyRegisteredException::builder).build());
                    }
                    case "ResourceConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                    }
                    case "ExternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExternalServiceException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "InvalidIdentityPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdentityPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdentityPoolConfigurationException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("LookupDeveloperIdentity").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new LookupDeveloperIdentityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)lookupDeveloperIdentityRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityAsyncClient.lambda$lookupDeveloperIdentity$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityAsyncClient.lambda$lookupDeveloperIdentity$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<MergeDeveloperIdentitiesResponse> mergeDeveloperIdentities(MergeDeveloperIdentitiesRequest mergeDeveloperIdentitiesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)mergeDeveloperIdentitiesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityAsyncClient.resolveMetricPublishers(clientConfiguration, mergeDeveloperIdentitiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"MergeDeveloperIdentities");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, MergeDeveloperIdentitiesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DeveloperUserAlreadyRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeveloperUserAlreadyRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeveloperUserAlreadyRegisteredException::builder).build());
                    }
                    case "ResourceConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                    }
                    case "ExternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExternalServiceException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "InvalidIdentityPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdentityPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdentityPoolConfigurationException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("MergeDeveloperIdentities").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new MergeDeveloperIdentitiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)mergeDeveloperIdentitiesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityAsyncClient.lambda$mergeDeveloperIdentities$62(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityAsyncClient.lambda$mergeDeveloperIdentities$63((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SetIdentityPoolRolesResponse> setIdentityPoolRoles(SetIdentityPoolRolesRequest setIdentityPoolRolesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)setIdentityPoolRolesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityAsyncClient.resolveMetricPublishers(clientConfiguration, setIdentityPoolRolesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetIdentityPoolRoles");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SetIdentityPoolRolesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DeveloperUserAlreadyRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeveloperUserAlreadyRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeveloperUserAlreadyRegisteredException::builder).build());
                    }
                    case "ResourceConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                    }
                    case "ExternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExternalServiceException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "InvalidIdentityPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdentityPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdentityPoolConfigurationException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetIdentityPoolRoles").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new SetIdentityPoolRolesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)setIdentityPoolRolesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityAsyncClient.lambda$setIdentityPoolRoles$66(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityAsyncClient.lambda$setIdentityPoolRoles$67((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SetPrincipalTagAttributeMapResponse> setPrincipalTagAttributeMap(SetPrincipalTagAttributeMapRequest setPrincipalTagAttributeMapRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)setPrincipalTagAttributeMapRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityAsyncClient.resolveMetricPublishers(clientConfiguration, setPrincipalTagAttributeMapRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetPrincipalTagAttributeMap");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SetPrincipalTagAttributeMapResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DeveloperUserAlreadyRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeveloperUserAlreadyRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeveloperUserAlreadyRegisteredException::builder).build());
                    }
                    case "ResourceConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                    }
                    case "ExternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExternalServiceException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "InvalidIdentityPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdentityPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdentityPoolConfigurationException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetPrincipalTagAttributeMap").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new SetPrincipalTagAttributeMapRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)setPrincipalTagAttributeMapRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityAsyncClient.lambda$setPrincipalTagAttributeMap$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityAsyncClient.lambda$setPrincipalTagAttributeMap$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityAsyncClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DeveloperUserAlreadyRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeveloperUserAlreadyRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeveloperUserAlreadyRegisteredException::builder).build());
                    }
                    case "ResourceConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                    }
                    case "ExternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExternalServiceException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "InvalidIdentityPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdentityPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdentityPoolConfigurationException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityAsyncClient.lambda$tagResource$74(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityAsyncClient.lambda$tagResource$75((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UnlinkDeveloperIdentityResponse> unlinkDeveloperIdentity(UnlinkDeveloperIdentityRequest unlinkDeveloperIdentityRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)unlinkDeveloperIdentityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityAsyncClient.resolveMetricPublishers(clientConfiguration, unlinkDeveloperIdentityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UnlinkDeveloperIdentity");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UnlinkDeveloperIdentityResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DeveloperUserAlreadyRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeveloperUserAlreadyRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeveloperUserAlreadyRegisteredException::builder).build());
                    }
                    case "ResourceConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                    }
                    case "ExternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExternalServiceException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "InvalidIdentityPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdentityPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdentityPoolConfigurationException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UnlinkDeveloperIdentity").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UnlinkDeveloperIdentityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)unlinkDeveloperIdentityRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityAsyncClient.lambda$unlinkDeveloperIdentity$78(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityAsyncClient.lambda$unlinkDeveloperIdentity$79((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UnlinkIdentityResponse> unlinkIdentity(UnlinkIdentityRequest unlinkIdentityRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)unlinkIdentityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityAsyncClient.resolveMetricPublishers(clientConfiguration, unlinkIdentityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UnlinkIdentity");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UnlinkIdentityResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DeveloperUserAlreadyRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeveloperUserAlreadyRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeveloperUserAlreadyRegisteredException::builder).build());
                    }
                    case "ResourceConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                    }
                    case "ExternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExternalServiceException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "InvalidIdentityPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdentityPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdentityPoolConfigurationException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UnlinkIdentity").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UnlinkIdentityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)unlinkIdentityRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityAsyncClient.lambda$unlinkIdentity$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityAsyncClient.lambda$unlinkIdentity$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityAsyncClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DeveloperUserAlreadyRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeveloperUserAlreadyRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeveloperUserAlreadyRegisteredException::builder).build());
                    }
                    case "ResourceConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                    }
                    case "ExternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExternalServiceException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "InvalidIdentityPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdentityPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdentityPoolConfigurationException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityAsyncClient.lambda$untagResource$86(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityAsyncClient.lambda$untagResource$87((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateIdentityPoolResponse> updateIdentityPool(UpdateIdentityPoolRequest updateIdentityPoolRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateIdentityPoolRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityAsyncClient.resolveMetricPublishers(clientConfiguration, updateIdentityPoolRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateIdentityPool");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateIdentityPoolResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DeveloperUserAlreadyRegisteredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeveloperUserAlreadyRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeveloperUserAlreadyRegisteredException::builder).build());
                    }
                    case "ResourceConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                    }
                    case "ExternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExternalServiceException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "InvalidIdentityPoolConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdentityPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdentityPoolConfigurationException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateIdentityPool").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateIdentityPoolRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateIdentityPoolRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoIdentityAsyncClient.lambda$updateIdentityPool$90(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityAsyncClient.lambda$updateIdentityPool$91((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public final CognitoIdentityServiceClientConfiguration serviceClientConfiguration() {
        return new CognitoIdentityServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "cognito-identity";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(CognitoIdentityException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        CognitoIdentityServiceClientConfigurationBuilder serviceConfigBuilder = new CognitoIdentityServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateIdentityPool$91(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateIdentityPool$90(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateIdentityPoolResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$untagResource$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$86(List metricPublishers, MetricCollector apiCallMetricCollector, UntagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$unlinkIdentity$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$unlinkIdentity$82(List metricPublishers, MetricCollector apiCallMetricCollector, UnlinkIdentityResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$unlinkDeveloperIdentity$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$unlinkDeveloperIdentity$78(List metricPublishers, MetricCollector apiCallMetricCollector, UnlinkDeveloperIdentityResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$tagResource$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$74(List metricPublishers, MetricCollector apiCallMetricCollector, TagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$setPrincipalTagAttributeMap$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setPrincipalTagAttributeMap$70(List metricPublishers, MetricCollector apiCallMetricCollector, SetPrincipalTagAttributeMapResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$setIdentityPoolRoles$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setIdentityPoolRoles$66(List metricPublishers, MetricCollector apiCallMetricCollector, SetIdentityPoolRolesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$mergeDeveloperIdentities$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$mergeDeveloperIdentities$62(List metricPublishers, MetricCollector apiCallMetricCollector, MergeDeveloperIdentitiesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$lookupDeveloperIdentity$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$lookupDeveloperIdentity$58(List metricPublishers, MetricCollector apiCallMetricCollector, LookupDeveloperIdentityResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTagsForResource$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$54(List metricPublishers, MetricCollector apiCallMetricCollector, ListTagsForResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listIdentityPools$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listIdentityPools$50(List metricPublishers, MetricCollector apiCallMetricCollector, ListIdentityPoolsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listIdentities$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listIdentities$46(List metricPublishers, MetricCollector apiCallMetricCollector, ListIdentitiesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getPrincipalTagAttributeMap$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPrincipalTagAttributeMap$42(List metricPublishers, MetricCollector apiCallMetricCollector, GetPrincipalTagAttributeMapResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getOpenIdTokenForDeveloperIdentity$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getOpenIdTokenForDeveloperIdentity$38(List metricPublishers, MetricCollector apiCallMetricCollector, GetOpenIdTokenForDeveloperIdentityResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getOpenIdToken$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getOpenIdToken$34(List metricPublishers, MetricCollector apiCallMetricCollector, GetOpenIdTokenResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getIdentityPoolRoles$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getIdentityPoolRoles$30(List metricPublishers, MetricCollector apiCallMetricCollector, GetIdentityPoolRolesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getId$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getId$26(List metricPublishers, MetricCollector apiCallMetricCollector, GetIdResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getCredentialsForIdentity$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCredentialsForIdentity$22(List metricPublishers, MetricCollector apiCallMetricCollector, GetCredentialsForIdentityResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeIdentityPool$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeIdentityPool$18(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeIdentityPoolResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeIdentity$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeIdentity$14(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeIdentityResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteIdentityPool$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteIdentityPool$10(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteIdentityPoolResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteIdentities$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteIdentities$6(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteIdentitiesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createIdentityPool$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createIdentityPool$2(List metricPublishers, MetricCollector apiCallMetricCollector, CreateIdentityPoolResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

