/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.cognitoidentity.CognitoIdentityClient;
import software.amazon.awssdk.services.cognitoidentity.CognitoIdentityServiceClientConfiguration;
import software.amazon.awssdk.services.cognitoidentity.internal.CognitoIdentityServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.cognitoidentity.model.CognitoIdentityException;
import software.amazon.awssdk.services.cognitoidentity.model.ConcurrentModificationException;
import software.amazon.awssdk.services.cognitoidentity.model.CreateIdentityPoolRequest;
import software.amazon.awssdk.services.cognitoidentity.model.CreateIdentityPoolResponse;
import software.amazon.awssdk.services.cognitoidentity.model.DeleteIdentitiesRequest;
import software.amazon.awssdk.services.cognitoidentity.model.DeleteIdentitiesResponse;
import software.amazon.awssdk.services.cognitoidentity.model.DeleteIdentityPoolRequest;
import software.amazon.awssdk.services.cognitoidentity.model.DeleteIdentityPoolResponse;
import software.amazon.awssdk.services.cognitoidentity.model.DescribeIdentityPoolRequest;
import software.amazon.awssdk.services.cognitoidentity.model.DescribeIdentityPoolResponse;
import software.amazon.awssdk.services.cognitoidentity.model.DescribeIdentityRequest;
import software.amazon.awssdk.services.cognitoidentity.model.DescribeIdentityResponse;
import software.amazon.awssdk.services.cognitoidentity.model.DeveloperUserAlreadyRegisteredException;
import software.amazon.awssdk.services.cognitoidentity.model.ExternalServiceException;
import software.amazon.awssdk.services.cognitoidentity.model.GetCredentialsForIdentityRequest;
import software.amazon.awssdk.services.cognitoidentity.model.GetCredentialsForIdentityResponse;
import software.amazon.awssdk.services.cognitoidentity.model.GetIdRequest;
import software.amazon.awssdk.services.cognitoidentity.model.GetIdResponse;
import software.amazon.awssdk.services.cognitoidentity.model.GetIdentityPoolRolesRequest;
import software.amazon.awssdk.services.cognitoidentity.model.GetIdentityPoolRolesResponse;
import software.amazon.awssdk.services.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityRequest;
import software.amazon.awssdk.services.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityResponse;
import software.amazon.awssdk.services.cognitoidentity.model.GetOpenIdTokenRequest;
import software.amazon.awssdk.services.cognitoidentity.model.GetOpenIdTokenResponse;
import software.amazon.awssdk.services.cognitoidentity.model.GetPrincipalTagAttributeMapRequest;
import software.amazon.awssdk.services.cognitoidentity.model.GetPrincipalTagAttributeMapResponse;
import software.amazon.awssdk.services.cognitoidentity.model.InternalErrorException;
import software.amazon.awssdk.services.cognitoidentity.model.InvalidIdentityPoolConfigurationException;
import software.amazon.awssdk.services.cognitoidentity.model.InvalidParameterException;
import software.amazon.awssdk.services.cognitoidentity.model.LimitExceededException;
import software.amazon.awssdk.services.cognitoidentity.model.ListIdentitiesRequest;
import software.amazon.awssdk.services.cognitoidentity.model.ListIdentitiesResponse;
import software.amazon.awssdk.services.cognitoidentity.model.ListIdentityPoolsRequest;
import software.amazon.awssdk.services.cognitoidentity.model.ListIdentityPoolsResponse;
import software.amazon.awssdk.services.cognitoidentity.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.cognitoidentity.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.cognitoidentity.model.LookupDeveloperIdentityRequest;
import software.amazon.awssdk.services.cognitoidentity.model.LookupDeveloperIdentityResponse;
import software.amazon.awssdk.services.cognitoidentity.model.MergeDeveloperIdentitiesRequest;
import software.amazon.awssdk.services.cognitoidentity.model.MergeDeveloperIdentitiesResponse;
import software.amazon.awssdk.services.cognitoidentity.model.NotAuthorizedException;
import software.amazon.awssdk.services.cognitoidentity.model.ResourceConflictException;
import software.amazon.awssdk.services.cognitoidentity.model.ResourceNotFoundException;
import software.amazon.awssdk.services.cognitoidentity.model.SetIdentityPoolRolesRequest;
import software.amazon.awssdk.services.cognitoidentity.model.SetIdentityPoolRolesResponse;
import software.amazon.awssdk.services.cognitoidentity.model.SetPrincipalTagAttributeMapRequest;
import software.amazon.awssdk.services.cognitoidentity.model.SetPrincipalTagAttributeMapResponse;
import software.amazon.awssdk.services.cognitoidentity.model.TagResourceRequest;
import software.amazon.awssdk.services.cognitoidentity.model.TagResourceResponse;
import software.amazon.awssdk.services.cognitoidentity.model.TooManyRequestsException;
import software.amazon.awssdk.services.cognitoidentity.model.UnlinkDeveloperIdentityRequest;
import software.amazon.awssdk.services.cognitoidentity.model.UnlinkDeveloperIdentityResponse;
import software.amazon.awssdk.services.cognitoidentity.model.UnlinkIdentityRequest;
import software.amazon.awssdk.services.cognitoidentity.model.UnlinkIdentityResponse;
import software.amazon.awssdk.services.cognitoidentity.model.UntagResourceRequest;
import software.amazon.awssdk.services.cognitoidentity.model.UntagResourceResponse;
import software.amazon.awssdk.services.cognitoidentity.model.UpdateIdentityPoolRequest;
import software.amazon.awssdk.services.cognitoidentity.model.UpdateIdentityPoolResponse;
import software.amazon.awssdk.services.cognitoidentity.transform.CreateIdentityPoolRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.DeleteIdentitiesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.DeleteIdentityPoolRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.DescribeIdentityPoolRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.DescribeIdentityRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.GetCredentialsForIdentityRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.GetIdRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.GetIdentityPoolRolesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.GetOpenIdTokenForDeveloperIdentityRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.GetOpenIdTokenRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.GetPrincipalTagAttributeMapRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.ListIdentitiesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.ListIdentityPoolsRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.LookupDeveloperIdentityRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.MergeDeveloperIdentitiesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.SetIdentityPoolRolesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.SetPrincipalTagAttributeMapRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.UnlinkDeveloperIdentityRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.UnlinkIdentityRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.UpdateIdentityPoolRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultCognitoIdentityClient
implements CognitoIdentityClient {
    private static final Logger log = Logger.loggerFor(DefaultCognitoIdentityClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCognitoIdentityClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Cognito_Identity#2.38.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateIdentityPoolResponse createIdentityPool(CreateIdentityPoolRequest createIdentityPoolRequest) throws InvalidParameterException, NotAuthorizedException, ResourceConflictException, TooManyRequestsException, InternalErrorException, LimitExceededException, AwsServiceException, SdkClientException, CognitoIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateIdentityPoolResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "DeveloperUserAlreadyRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeveloperUserAlreadyRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeveloperUserAlreadyRegisteredException::builder).build());
                }
                case "ResourceConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                }
                case "ExternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExternalServiceException::builder).build());
                }
                case "NotAuthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                }
                case "InvalidIdentityPoolConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdentityPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdentityPoolConfigurationException::builder).build());
                }
                case "InternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createIdentityPoolRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityClient.resolveMetricPublishers(clientConfiguration, createIdentityPoolRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateIdentityPool");
            CreateIdentityPoolResponse createIdentityPoolResponse = (CreateIdentityPoolResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateIdentityPool").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createIdentityPoolRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateIdentityPoolRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createIdentityPoolResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityClient.lambda$createIdentityPool$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteIdentitiesResponse deleteIdentities(DeleteIdentitiesRequest deleteIdentitiesRequest) throws InvalidParameterException, TooManyRequestsException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteIdentitiesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "DeveloperUserAlreadyRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeveloperUserAlreadyRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeveloperUserAlreadyRegisteredException::builder).build());
                }
                case "ResourceConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                }
                case "ExternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExternalServiceException::builder).build());
                }
                case "NotAuthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                }
                case "InvalidIdentityPoolConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdentityPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdentityPoolConfigurationException::builder).build());
                }
                case "InternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteIdentitiesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityClient.resolveMetricPublishers(clientConfiguration, deleteIdentitiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteIdentities");
            DeleteIdentitiesResponse deleteIdentitiesResponse = (DeleteIdentitiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteIdentities").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteIdentitiesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteIdentitiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteIdentitiesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityClient.lambda$deleteIdentities$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteIdentityPoolResponse deleteIdentityPool(DeleteIdentityPoolRequest deleteIdentityPoolRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteIdentityPoolResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "DeveloperUserAlreadyRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeveloperUserAlreadyRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeveloperUserAlreadyRegisteredException::builder).build());
                }
                case "ResourceConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                }
                case "ExternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExternalServiceException::builder).build());
                }
                case "NotAuthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                }
                case "InvalidIdentityPoolConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdentityPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdentityPoolConfigurationException::builder).build());
                }
                case "InternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteIdentityPoolRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityClient.resolveMetricPublishers(clientConfiguration, deleteIdentityPoolRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteIdentityPool");
            DeleteIdentityPoolResponse deleteIdentityPoolResponse = (DeleteIdentityPoolResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteIdentityPool").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteIdentityPoolRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteIdentityPoolRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteIdentityPoolResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityClient.lambda$deleteIdentityPool$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeIdentityResponse describeIdentity(DescribeIdentityRequest describeIdentityRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeIdentityResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "DeveloperUserAlreadyRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeveloperUserAlreadyRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeveloperUserAlreadyRegisteredException::builder).build());
                }
                case "ResourceConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                }
                case "ExternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExternalServiceException::builder).build());
                }
                case "NotAuthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                }
                case "InvalidIdentityPoolConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdentityPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdentityPoolConfigurationException::builder).build());
                }
                case "InternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeIdentityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityClient.resolveMetricPublishers(clientConfiguration, describeIdentityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeIdentity");
            DescribeIdentityResponse describeIdentityResponse = (DescribeIdentityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeIdentity").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeIdentityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeIdentityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeIdentityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityClient.lambda$describeIdentity$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeIdentityPoolResponse describeIdentityPool(DescribeIdentityPoolRequest describeIdentityPoolRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeIdentityPoolResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "DeveloperUserAlreadyRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeveloperUserAlreadyRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeveloperUserAlreadyRegisteredException::builder).build());
                }
                case "ResourceConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                }
                case "ExternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExternalServiceException::builder).build());
                }
                case "NotAuthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                }
                case "InvalidIdentityPoolConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdentityPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdentityPoolConfigurationException::builder).build());
                }
                case "InternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeIdentityPoolRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityClient.resolveMetricPublishers(clientConfiguration, describeIdentityPoolRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeIdentityPool");
            DescribeIdentityPoolResponse describeIdentityPoolResponse = (DescribeIdentityPoolResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeIdentityPool").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeIdentityPoolRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeIdentityPoolRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeIdentityPoolResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityClient.lambda$describeIdentityPool$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCredentialsForIdentityResponse getCredentialsForIdentity(GetCredentialsForIdentityRequest getCredentialsForIdentityRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, ResourceConflictException, TooManyRequestsException, InvalidIdentityPoolConfigurationException, InternalErrorException, ExternalServiceException, AwsServiceException, SdkClientException, CognitoIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCredentialsForIdentityResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "DeveloperUserAlreadyRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeveloperUserAlreadyRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeveloperUserAlreadyRegisteredException::builder).build());
                }
                case "ResourceConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                }
                case "ExternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExternalServiceException::builder).build());
                }
                case "NotAuthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                }
                case "InvalidIdentityPoolConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdentityPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdentityPoolConfigurationException::builder).build());
                }
                case "InternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getCredentialsForIdentityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityClient.resolveMetricPublishers(clientConfiguration, getCredentialsForIdentityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCredentialsForIdentity");
            GetCredentialsForIdentityResponse getCredentialsForIdentityResponse = (GetCredentialsForIdentityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCredentialsForIdentity").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getCredentialsForIdentityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetCredentialsForIdentityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getCredentialsForIdentityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityClient.lambda$getCredentialsForIdentity$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetIdResponse getId(GetIdRequest getIdRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, ResourceConflictException, TooManyRequestsException, InternalErrorException, LimitExceededException, ExternalServiceException, AwsServiceException, SdkClientException, CognitoIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetIdResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "DeveloperUserAlreadyRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeveloperUserAlreadyRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeveloperUserAlreadyRegisteredException::builder).build());
                }
                case "ResourceConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                }
                case "ExternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExternalServiceException::builder).build());
                }
                case "NotAuthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                }
                case "InvalidIdentityPoolConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdentityPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdentityPoolConfigurationException::builder).build());
                }
                case "InternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getIdRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityClient.resolveMetricPublishers(clientConfiguration, getIdRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetId");
            GetIdResponse getIdResponse = (GetIdResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetId").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getIdRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetIdRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getIdResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityClient.lambda$getId$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetIdentityPoolRolesResponse getIdentityPoolRoles(GetIdentityPoolRolesRequest getIdentityPoolRolesRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, ResourceConflictException, TooManyRequestsException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetIdentityPoolRolesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "DeveloperUserAlreadyRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeveloperUserAlreadyRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeveloperUserAlreadyRegisteredException::builder).build());
                }
                case "ResourceConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                }
                case "ExternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExternalServiceException::builder).build());
                }
                case "NotAuthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                }
                case "InvalidIdentityPoolConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdentityPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdentityPoolConfigurationException::builder).build());
                }
                case "InternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getIdentityPoolRolesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityClient.resolveMetricPublishers(clientConfiguration, getIdentityPoolRolesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetIdentityPoolRoles");
            GetIdentityPoolRolesResponse getIdentityPoolRolesResponse = (GetIdentityPoolRolesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetIdentityPoolRoles").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getIdentityPoolRolesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetIdentityPoolRolesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getIdentityPoolRolesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityClient.lambda$getIdentityPoolRoles$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetOpenIdTokenResponse getOpenIdToken(GetOpenIdTokenRequest getOpenIdTokenRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, ResourceConflictException, TooManyRequestsException, InternalErrorException, ExternalServiceException, AwsServiceException, SdkClientException, CognitoIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetOpenIdTokenResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "DeveloperUserAlreadyRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeveloperUserAlreadyRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeveloperUserAlreadyRegisteredException::builder).build());
                }
                case "ResourceConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                }
                case "ExternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExternalServiceException::builder).build());
                }
                case "NotAuthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                }
                case "InvalidIdentityPoolConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdentityPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdentityPoolConfigurationException::builder).build());
                }
                case "InternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getOpenIdTokenRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityClient.resolveMetricPublishers(clientConfiguration, getOpenIdTokenRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetOpenIdToken");
            GetOpenIdTokenResponse getOpenIdTokenResponse = (GetOpenIdTokenResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetOpenIdToken").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getOpenIdTokenRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetOpenIdTokenRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getOpenIdTokenResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityClient.lambda$getOpenIdToken$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetOpenIdTokenForDeveloperIdentityResponse getOpenIdTokenForDeveloperIdentity(GetOpenIdTokenForDeveloperIdentityRequest getOpenIdTokenForDeveloperIdentityRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, ResourceConflictException, TooManyRequestsException, InternalErrorException, DeveloperUserAlreadyRegisteredException, AwsServiceException, SdkClientException, CognitoIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetOpenIdTokenForDeveloperIdentityResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "DeveloperUserAlreadyRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeveloperUserAlreadyRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeveloperUserAlreadyRegisteredException::builder).build());
                }
                case "ResourceConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                }
                case "ExternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExternalServiceException::builder).build());
                }
                case "NotAuthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                }
                case "InvalidIdentityPoolConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdentityPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdentityPoolConfigurationException::builder).build());
                }
                case "InternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getOpenIdTokenForDeveloperIdentityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityClient.resolveMetricPublishers(clientConfiguration, getOpenIdTokenForDeveloperIdentityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetOpenIdTokenForDeveloperIdentity");
            GetOpenIdTokenForDeveloperIdentityResponse getOpenIdTokenForDeveloperIdentityResponse = (GetOpenIdTokenForDeveloperIdentityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetOpenIdTokenForDeveloperIdentity").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getOpenIdTokenForDeveloperIdentityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetOpenIdTokenForDeveloperIdentityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getOpenIdTokenForDeveloperIdentityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityClient.lambda$getOpenIdTokenForDeveloperIdentity$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPrincipalTagAttributeMapResponse getPrincipalTagAttributeMap(GetPrincipalTagAttributeMapRequest getPrincipalTagAttributeMapRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPrincipalTagAttributeMapResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "DeveloperUserAlreadyRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeveloperUserAlreadyRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeveloperUserAlreadyRegisteredException::builder).build());
                }
                case "ResourceConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                }
                case "ExternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExternalServiceException::builder).build());
                }
                case "NotAuthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                }
                case "InvalidIdentityPoolConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdentityPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdentityPoolConfigurationException::builder).build());
                }
                case "InternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getPrincipalTagAttributeMapRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityClient.resolveMetricPublishers(clientConfiguration, getPrincipalTagAttributeMapRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPrincipalTagAttributeMap");
            GetPrincipalTagAttributeMapResponse getPrincipalTagAttributeMapResponse = (GetPrincipalTagAttributeMapResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPrincipalTagAttributeMap").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getPrincipalTagAttributeMapRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetPrincipalTagAttributeMapRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getPrincipalTagAttributeMapResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityClient.lambda$getPrincipalTagAttributeMap$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListIdentitiesResponse listIdentities(ListIdentitiesRequest listIdentitiesRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListIdentitiesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "DeveloperUserAlreadyRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeveloperUserAlreadyRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeveloperUserAlreadyRegisteredException::builder).build());
                }
                case "ResourceConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                }
                case "ExternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExternalServiceException::builder).build());
                }
                case "NotAuthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                }
                case "InvalidIdentityPoolConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdentityPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdentityPoolConfigurationException::builder).build());
                }
                case "InternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listIdentitiesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityClient.resolveMetricPublishers(clientConfiguration, listIdentitiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListIdentities");
            ListIdentitiesResponse listIdentitiesResponse = (ListIdentitiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListIdentities").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listIdentitiesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListIdentitiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listIdentitiesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityClient.lambda$listIdentities$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListIdentityPoolsResponse listIdentityPools(ListIdentityPoolsRequest listIdentityPoolsRequest) throws InvalidParameterException, NotAuthorizedException, TooManyRequestsException, ResourceNotFoundException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListIdentityPoolsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "DeveloperUserAlreadyRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeveloperUserAlreadyRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeveloperUserAlreadyRegisteredException::builder).build());
                }
                case "ResourceConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                }
                case "ExternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExternalServiceException::builder).build());
                }
                case "NotAuthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                }
                case "InvalidIdentityPoolConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdentityPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdentityPoolConfigurationException::builder).build());
                }
                case "InternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listIdentityPoolsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityClient.resolveMetricPublishers(clientConfiguration, listIdentityPoolsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListIdentityPools");
            ListIdentityPoolsResponse listIdentityPoolsResponse = (ListIdentityPoolsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListIdentityPools").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listIdentityPoolsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListIdentityPoolsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listIdentityPoolsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityClient.lambda$listIdentityPools$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "DeveloperUserAlreadyRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeveloperUserAlreadyRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeveloperUserAlreadyRegisteredException::builder).build());
                }
                case "ResourceConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                }
                case "ExternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExternalServiceException::builder).build());
                }
                case "NotAuthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                }
                case "InvalidIdentityPoolConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdentityPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdentityPoolConfigurationException::builder).build());
                }
                case "InternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityClient.lambda$listTagsForResource$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LookupDeveloperIdentityResponse lookupDeveloperIdentity(LookupDeveloperIdentityRequest lookupDeveloperIdentityRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, ResourceConflictException, TooManyRequestsException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, LookupDeveloperIdentityResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "DeveloperUserAlreadyRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeveloperUserAlreadyRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeveloperUserAlreadyRegisteredException::builder).build());
                }
                case "ResourceConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                }
                case "ExternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExternalServiceException::builder).build());
                }
                case "NotAuthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                }
                case "InvalidIdentityPoolConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdentityPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdentityPoolConfigurationException::builder).build());
                }
                case "InternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)lookupDeveloperIdentityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityClient.resolveMetricPublishers(clientConfiguration, lookupDeveloperIdentityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"LookupDeveloperIdentity");
            LookupDeveloperIdentityResponse lookupDeveloperIdentityResponse = (LookupDeveloperIdentityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("LookupDeveloperIdentity").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)lookupDeveloperIdentityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new LookupDeveloperIdentityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return lookupDeveloperIdentityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityClient.lambda$lookupDeveloperIdentity$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MergeDeveloperIdentitiesResponse mergeDeveloperIdentities(MergeDeveloperIdentitiesRequest mergeDeveloperIdentitiesRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, ResourceConflictException, TooManyRequestsException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, MergeDeveloperIdentitiesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "DeveloperUserAlreadyRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeveloperUserAlreadyRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeveloperUserAlreadyRegisteredException::builder).build());
                }
                case "ResourceConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                }
                case "ExternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExternalServiceException::builder).build());
                }
                case "NotAuthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                }
                case "InvalidIdentityPoolConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdentityPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdentityPoolConfigurationException::builder).build());
                }
                case "InternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)mergeDeveloperIdentitiesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityClient.resolveMetricPublishers(clientConfiguration, mergeDeveloperIdentitiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"MergeDeveloperIdentities");
            MergeDeveloperIdentitiesResponse mergeDeveloperIdentitiesResponse = (MergeDeveloperIdentitiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("MergeDeveloperIdentities").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)mergeDeveloperIdentitiesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new MergeDeveloperIdentitiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return mergeDeveloperIdentitiesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityClient.lambda$mergeDeveloperIdentities$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetIdentityPoolRolesResponse setIdentityPoolRoles(SetIdentityPoolRolesRequest setIdentityPoolRolesRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, ResourceConflictException, TooManyRequestsException, InternalErrorException, ConcurrentModificationException, AwsServiceException, SdkClientException, CognitoIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SetIdentityPoolRolesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "DeveloperUserAlreadyRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeveloperUserAlreadyRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeveloperUserAlreadyRegisteredException::builder).build());
                }
                case "ResourceConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                }
                case "ExternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExternalServiceException::builder).build());
                }
                case "NotAuthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                }
                case "InvalidIdentityPoolConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdentityPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdentityPoolConfigurationException::builder).build());
                }
                case "InternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)setIdentityPoolRolesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityClient.resolveMetricPublishers(clientConfiguration, setIdentityPoolRolesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetIdentityPoolRoles");
            SetIdentityPoolRolesResponse setIdentityPoolRolesResponse = (SetIdentityPoolRolesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetIdentityPoolRoles").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)setIdentityPoolRolesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SetIdentityPoolRolesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return setIdentityPoolRolesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityClient.lambda$setIdentityPoolRoles$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetPrincipalTagAttributeMapResponse setPrincipalTagAttributeMap(SetPrincipalTagAttributeMapRequest setPrincipalTagAttributeMapRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SetPrincipalTagAttributeMapResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "DeveloperUserAlreadyRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeveloperUserAlreadyRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeveloperUserAlreadyRegisteredException::builder).build());
                }
                case "ResourceConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                }
                case "ExternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExternalServiceException::builder).build());
                }
                case "NotAuthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                }
                case "InvalidIdentityPoolConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdentityPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdentityPoolConfigurationException::builder).build());
                }
                case "InternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)setPrincipalTagAttributeMapRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityClient.resolveMetricPublishers(clientConfiguration, setPrincipalTagAttributeMapRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetPrincipalTagAttributeMap");
            SetPrincipalTagAttributeMapResponse setPrincipalTagAttributeMapResponse = (SetPrincipalTagAttributeMapResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetPrincipalTagAttributeMap").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)setPrincipalTagAttributeMapRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SetPrincipalTagAttributeMapRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return setPrincipalTagAttributeMapResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityClient.lambda$setPrincipalTagAttributeMap$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "DeveloperUserAlreadyRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeveloperUserAlreadyRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeveloperUserAlreadyRegisteredException::builder).build());
                }
                case "ResourceConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                }
                case "ExternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExternalServiceException::builder).build());
                }
                case "NotAuthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                }
                case "InvalidIdentityPoolConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdentityPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdentityPoolConfigurationException::builder).build());
                }
                case "InternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityClient.lambda$tagResource$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UnlinkDeveloperIdentityResponse unlinkDeveloperIdentity(UnlinkDeveloperIdentityRequest unlinkDeveloperIdentityRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, ResourceConflictException, TooManyRequestsException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UnlinkDeveloperIdentityResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "DeveloperUserAlreadyRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeveloperUserAlreadyRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeveloperUserAlreadyRegisteredException::builder).build());
                }
                case "ResourceConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                }
                case "ExternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExternalServiceException::builder).build());
                }
                case "NotAuthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                }
                case "InvalidIdentityPoolConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdentityPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdentityPoolConfigurationException::builder).build());
                }
                case "InternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)unlinkDeveloperIdentityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityClient.resolveMetricPublishers(clientConfiguration, unlinkDeveloperIdentityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UnlinkDeveloperIdentity");
            UnlinkDeveloperIdentityResponse unlinkDeveloperIdentityResponse = (UnlinkDeveloperIdentityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UnlinkDeveloperIdentity").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)unlinkDeveloperIdentityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UnlinkDeveloperIdentityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return unlinkDeveloperIdentityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityClient.lambda$unlinkDeveloperIdentity$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UnlinkIdentityResponse unlinkIdentity(UnlinkIdentityRequest unlinkIdentityRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, ResourceConflictException, TooManyRequestsException, InternalErrorException, ExternalServiceException, AwsServiceException, SdkClientException, CognitoIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UnlinkIdentityResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "DeveloperUserAlreadyRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeveloperUserAlreadyRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeveloperUserAlreadyRegisteredException::builder).build());
                }
                case "ResourceConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                }
                case "ExternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExternalServiceException::builder).build());
                }
                case "NotAuthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                }
                case "InvalidIdentityPoolConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdentityPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdentityPoolConfigurationException::builder).build());
                }
                case "InternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)unlinkIdentityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityClient.resolveMetricPublishers(clientConfiguration, unlinkIdentityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UnlinkIdentity");
            UnlinkIdentityResponse unlinkIdentityResponse = (UnlinkIdentityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UnlinkIdentity").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)unlinkIdentityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UnlinkIdentityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return unlinkIdentityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityClient.lambda$unlinkIdentity$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "DeveloperUserAlreadyRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeveloperUserAlreadyRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeveloperUserAlreadyRegisteredException::builder).build());
                }
                case "ResourceConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                }
                case "ExternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExternalServiceException::builder).build());
                }
                case "NotAuthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                }
                case "InvalidIdentityPoolConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdentityPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdentityPoolConfigurationException::builder).build());
                }
                case "InternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityClient.lambda$untagResource$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateIdentityPoolResponse updateIdentityPool(UpdateIdentityPoolRequest updateIdentityPoolRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, ResourceConflictException, TooManyRequestsException, InternalErrorException, ConcurrentModificationException, LimitExceededException, AwsServiceException, SdkClientException, CognitoIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateIdentityPoolResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "DeveloperUserAlreadyRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DeveloperUserAlreadyRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeveloperUserAlreadyRegisteredException::builder).build());
                }
                case "ResourceConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                }
                case "ExternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExternalServiceException::builder).build());
                }
                case "NotAuthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                }
                case "InvalidIdentityPoolConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidIdentityPoolConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidIdentityPoolConfigurationException::builder).build());
                }
                case "InternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateIdentityPoolRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityClient.resolveMetricPublishers(clientConfiguration, updateIdentityPoolRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateIdentityPool");
            UpdateIdentityPoolResponse updateIdentityPoolResponse = (UpdateIdentityPoolResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateIdentityPool").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateIdentityPoolRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateIdentityPoolRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateIdentityPoolResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityClient.lambda$updateIdentityPool$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "cognito-identity";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        CognitoIdentityServiceClientConfigurationBuilder serviceConfigBuilder = new CognitoIdentityServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(CognitoIdentityException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    @Override
    public final CognitoIdentityServiceClientConfiguration serviceClientConfiguration() {
        return new CognitoIdentityServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateIdentityPool$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$unlinkIdentity$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$unlinkDeveloperIdentity$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setPrincipalTagAttributeMap$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setIdentityPoolRoles$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$mergeDeveloperIdentities$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$lookupDeveloperIdentity$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listIdentityPools$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listIdentities$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPrincipalTagAttributeMap$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getOpenIdTokenForDeveloperIdentity$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getOpenIdToken$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getIdentityPoolRoles$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getId$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCredentialsForIdentity$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeIdentityPool$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeIdentity$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteIdentityPool$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteIdentities$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createIdentityPool$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

