/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returned in response to a successful <code>GetIdentityPoolRoles</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetIdentityPoolRolesResponse extends CognitoIdentityResponse implements
        ToCopyableBuilder<GetIdentityPoolRolesResponse.Builder, GetIdentityPoolRolesResponse> {
    private static final SdkField<String> IDENTITY_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityPoolId").getter(getter(GetIdentityPoolRolesResponse::identityPoolId))
            .setter(setter(Builder::identityPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityPoolId").build()).build();

    private static final SdkField<Map<String, String>> ROLES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Roles")
            .getter(getter(GetIdentityPoolRolesResponse::roles))
            .setter(setter(Builder::roles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Roles").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, RoleMapping>> ROLE_MAPPINGS_FIELD = SdkField
            .<Map<String, RoleMapping>> builder(MarshallingType.MAP)
            .memberName("RoleMappings")
            .getter(getter(GetIdentityPoolRolesResponse::roleMappings))
            .setter(setter(Builder::roleMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleMappings").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<RoleMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(RoleMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_POOL_ID_FIELD,
            ROLES_FIELD, ROLE_MAPPINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String identityPoolId;

    private final Map<String, String> roles;

    private final Map<String, RoleMapping> roleMappings;

    private GetIdentityPoolRolesResponse(BuilderImpl builder) {
        super(builder);
        this.identityPoolId = builder.identityPoolId;
        this.roles = builder.roles;
        this.roleMappings = builder.roleMappings;
    }

    /**
     * <p>
     * An identity pool ID in the format REGION:GUID.
     * </p>
     * 
     * @return An identity pool ID in the format REGION:GUID.
     */
    public final String identityPoolId() {
        return identityPoolId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Roles property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasRoles() {
        return roles != null && !(roles instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The map of roles associated with this pool. Currently only authenticated and unauthenticated roles are supported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRoles} method.
     * </p>
     * 
     * @return The map of roles associated with this pool. Currently only authenticated and unauthenticated roles are
     *         supported.
     */
    public final Map<String, String> roles() {
        return roles;
    }

    /**
     * For responses, this returns true if the service returned a value for the RoleMappings property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRoleMappings() {
        return roleMappings != null && !(roleMappings instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * How users for a specific identity provider are to mapped to roles. This is a String-to-<a>RoleMapping</a> object
     * map. The string identifies the identity provider, for example, <code>graph.facebook.com</code> or
     * <code>cognito-idp.us-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRoleMappings} method.
     * </p>
     * 
     * @return How users for a specific identity provider are to mapped to roles. This is a String-to-<a>RoleMapping</a>
     *         object map. The string identifies the identity provider, for example, <code>graph.facebook.com</code> or
     *         <code>cognito-idp.us-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id</code>.
     */
    public final Map<String, RoleMapping> roleMappings() {
        return roleMappings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(hasRoles() ? roles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRoleMappings() ? roleMappings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdentityPoolRolesResponse)) {
            return false;
        }
        GetIdentityPoolRolesResponse other = (GetIdentityPoolRolesResponse) obj;
        return Objects.equals(identityPoolId(), other.identityPoolId()) && hasRoles() == other.hasRoles()
                && Objects.equals(roles(), other.roles()) && hasRoleMappings() == other.hasRoleMappings()
                && Objects.equals(roleMappings(), other.roleMappings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetIdentityPoolRolesResponse").add("IdentityPoolId", identityPoolId())
                .add("Roles", hasRoles() ? roles() : null).add("RoleMappings", hasRoleMappings() ? roleMappings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityPoolId":
            return Optional.ofNullable(clazz.cast(identityPoolId()));
        case "Roles":
            return Optional.ofNullable(clazz.cast(roles()));
        case "RoleMappings":
            return Optional.ofNullable(clazz.cast(roleMappings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IdentityPoolId", IDENTITY_POOL_ID_FIELD);
        map.put("Roles", ROLES_FIELD);
        map.put("RoleMappings", ROLE_MAPPINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetIdentityPoolRolesResponse, T> g) {
        return obj -> g.apply((GetIdentityPoolRolesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CognitoIdentityResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetIdentityPoolRolesResponse> {
        /**
         * <p>
         * An identity pool ID in the format REGION:GUID.
         * </p>
         * 
         * @param identityPoolId
         *        An identity pool ID in the format REGION:GUID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityPoolId(String identityPoolId);

        /**
         * <p>
         * The map of roles associated with this pool. Currently only authenticated and unauthenticated roles are
         * supported.
         * </p>
         * 
         * @param roles
         *        The map of roles associated with this pool. Currently only authenticated and unauthenticated roles are
         *        supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roles(Map<String, String> roles);

        /**
         * <p>
         * How users for a specific identity provider are to mapped to roles. This is a String-to-<a>RoleMapping</a>
         * object map. The string identifies the identity provider, for example, <code>graph.facebook.com</code> or
         * <code>cognito-idp.us-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id</code>.
         * </p>
         * 
         * @param roleMappings
         *        How users for a specific identity provider are to mapped to roles. This is a
         *        String-to-<a>RoleMapping</a> object map. The string identifies the identity provider, for example,
         *        <code>graph.facebook.com</code> or
         *        <code>cognito-idp.us-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleMappings(Map<String, RoleMapping> roleMappings);
    }

    static final class BuilderImpl extends CognitoIdentityResponse.BuilderImpl implements Builder {
        private String identityPoolId;

        private Map<String, String> roles = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, RoleMapping> roleMappings = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdentityPoolRolesResponse model) {
            super(model);
            identityPoolId(model.identityPoolId);
            roles(model.roles);
            roleMappings(model.roleMappings);
        }

        public final String getIdentityPoolId() {
            return identityPoolId;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final Map<String, String> getRoles() {
            if (roles instanceof SdkAutoConstructMap) {
                return null;
            }
            return roles;
        }

        public final void setRoles(Map<String, String> roles) {
            this.roles = RolesMapCopier.copy(roles);
        }

        @Override
        public final Builder roles(Map<String, String> roles) {
            this.roles = RolesMapCopier.copy(roles);
            return this;
        }

        public final Map<String, RoleMapping.Builder> getRoleMappings() {
            Map<String, RoleMapping.Builder> result = RoleMappingMapCopier.copyToBuilder(this.roleMappings);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setRoleMappings(Map<String, RoleMapping.BuilderImpl> roleMappings) {
            this.roleMappings = RoleMappingMapCopier.copyFromBuilder(roleMappings);
        }

        @Override
        public final Builder roleMappings(Map<String, RoleMapping> roleMappings) {
            this.roleMappings = RoleMappingMapCopier.copy(roleMappings);
            return this;
        }

        @Override
        public GetIdentityPoolRolesResponse build() {
            return new GetIdentityPoolRolesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
