/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input to the <code>LookupDeveloperIdentityInput</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LookupDeveloperIdentityRequest extends CognitoIdentityRequest implements
        ToCopyableBuilder<LookupDeveloperIdentityRequest.Builder, LookupDeveloperIdentityRequest> {
    private static final SdkField<String> IDENTITY_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityPoolId").getter(getter(LookupDeveloperIdentityRequest::identityPoolId))
            .setter(setter(Builder::identityPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityPoolId").build()).build();

    private static final SdkField<String> IDENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityId").getter(getter(LookupDeveloperIdentityRequest::identityId))
            .setter(setter(Builder::identityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityId").build()).build();

    private static final SdkField<String> DEVELOPER_USER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeveloperUserIdentifier").getter(getter(LookupDeveloperIdentityRequest::developerUserIdentifier))
            .setter(setter(Builder::developerUserIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeveloperUserIdentifier").build())
            .build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(LookupDeveloperIdentityRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(LookupDeveloperIdentityRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_POOL_ID_FIELD,
            IDENTITY_ID_FIELD, DEVELOPER_USER_IDENTIFIER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String identityPoolId;

    private final String identityId;

    private final String developerUserIdentifier;

    private final Integer maxResults;

    private final String nextToken;

    private LookupDeveloperIdentityRequest(BuilderImpl builder) {
        super(builder);
        this.identityPoolId = builder.identityPoolId;
        this.identityId = builder.identityId;
        this.developerUserIdentifier = builder.developerUserIdentifier;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * An identity pool ID in the format REGION:GUID.
     * </p>
     * 
     * @return An identity pool ID in the format REGION:GUID.
     */
    public final String identityPoolId() {
        return identityPoolId;
    }

    /**
     * <p>
     * A unique identifier in the format REGION:GUID.
     * </p>
     * 
     * @return A unique identifier in the format REGION:GUID.
     */
    public final String identityId() {
        return identityId;
    }

    /**
     * <p>
     * A unique ID used by your backend authentication process to identify a user. Typically, a developer identity
     * provider would issue many developer user identifiers, in keeping with the number of users.
     * </p>
     * 
     * @return A unique ID used by your backend authentication process to identify a user. Typically, a developer
     *         identity provider would issue many developer user identifiers, in keeping with the number of users.
     */
    public final String developerUserIdentifier() {
        return developerUserIdentifier;
    }

    /**
     * <p>
     * The maximum number of identities to return.
     * </p>
     * 
     * @return The maximum number of identities to return.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A pagination token. The first call you make will have <code>NextToken</code> set to null. After that the service
     * will return <code>NextToken</code> values as needed. For example, let's say you make a request with
     * <code>MaxResults</code> set to 10, and there are 20 matches in the database. The service will return a pagination
     * token as a part of the response. This token can be used to call the API again and get results starting from the
     * 11th match.
     * </p>
     * 
     * @return A pagination token. The first call you make will have <code>NextToken</code> set to null. After that the
     *         service will return <code>NextToken</code> values as needed. For example, let's say you make a request
     *         with <code>MaxResults</code> set to 10, and there are 20 matches in the database. The service will return
     *         a pagination token as a part of the response. This token can be used to call the API again and get
     *         results starting from the 11th match.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(identityId());
        hashCode = 31 * hashCode + Objects.hashCode(developerUserIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LookupDeveloperIdentityRequest)) {
            return false;
        }
        LookupDeveloperIdentityRequest other = (LookupDeveloperIdentityRequest) obj;
        return Objects.equals(identityPoolId(), other.identityPoolId()) && Objects.equals(identityId(), other.identityId())
                && Objects.equals(developerUserIdentifier(), other.developerUserIdentifier())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LookupDeveloperIdentityRequest").add("IdentityPoolId", identityPoolId())
                .add("IdentityId", identityId()).add("DeveloperUserIdentifier", developerUserIdentifier())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityPoolId":
            return Optional.ofNullable(clazz.cast(identityPoolId()));
        case "IdentityId":
            return Optional.ofNullable(clazz.cast(identityId()));
        case "DeveloperUserIdentifier":
            return Optional.ofNullable(clazz.cast(developerUserIdentifier()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IdentityPoolId", IDENTITY_POOL_ID_FIELD);
        map.put("IdentityId", IDENTITY_ID_FIELD);
        map.put("DeveloperUserIdentifier", DEVELOPER_USER_IDENTIFIER_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LookupDeveloperIdentityRequest, T> g) {
        return obj -> g.apply((LookupDeveloperIdentityRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CognitoIdentityRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, LookupDeveloperIdentityRequest> {
        /**
         * <p>
         * An identity pool ID in the format REGION:GUID.
         * </p>
         * 
         * @param identityPoolId
         *        An identity pool ID in the format REGION:GUID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityPoolId(String identityPoolId);

        /**
         * <p>
         * A unique identifier in the format REGION:GUID.
         * </p>
         * 
         * @param identityId
         *        A unique identifier in the format REGION:GUID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityId(String identityId);

        /**
         * <p>
         * A unique ID used by your backend authentication process to identify a user. Typically, a developer identity
         * provider would issue many developer user identifiers, in keeping with the number of users.
         * </p>
         * 
         * @param developerUserIdentifier
         *        A unique ID used by your backend authentication process to identify a user. Typically, a developer
         *        identity provider would issue many developer user identifiers, in keeping with the number of users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder developerUserIdentifier(String developerUserIdentifier);

        /**
         * <p>
         * The maximum number of identities to return.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of identities to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A pagination token. The first call you make will have <code>NextToken</code> set to null. After that the
         * service will return <code>NextToken</code> values as needed. For example, let's say you make a request with
         * <code>MaxResults</code> set to 10, and there are 20 matches in the database. The service will return a
         * pagination token as a part of the response. This token can be used to call the API again and get results
         * starting from the 11th match.
         * </p>
         * 
         * @param nextToken
         *        A pagination token. The first call you make will have <code>NextToken</code> set to null. After that
         *        the service will return <code>NextToken</code> values as needed. For example, let's say you make a
         *        request with <code>MaxResults</code> set to 10, and there are 20 matches in the database. The service
         *        will return a pagination token as a part of the response. This token can be used to call the API again
         *        and get results starting from the 11th match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityRequest.BuilderImpl implements Builder {
        private String identityPoolId;

        private String identityId;

        private String developerUserIdentifier;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(LookupDeveloperIdentityRequest model) {
            super(model);
            identityPoolId(model.identityPoolId);
            identityId(model.identityId);
            developerUserIdentifier(model.developerUserIdentifier);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getIdentityPoolId() {
            return identityPoolId;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final String getIdentityId() {
            return identityId;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final String getDeveloperUserIdentifier() {
            return developerUserIdentifier;
        }

        public final void setDeveloperUserIdentifier(String developerUserIdentifier) {
            this.developerUserIdentifier = developerUserIdentifier;
        }

        @Override
        public final Builder developerUserIdentifier(String developerUserIdentifier) {
            this.developerUserIdentifier = developerUserIdentifier;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public LookupDeveloperIdentityRequest build() {
            return new LookupDeveloperIdentityRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
