/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the response from the server to the request to get the header information for the .csv file for the user
 * import job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCsvHeaderResponse extends CognitoIdentityProviderResponse implements
        ToCopyableBuilder<GetCsvHeaderResponse.Builder, GetCsvHeaderResponse> {
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserPoolId").getter(getter(GetCsvHeaderResponse::userPoolId)).setter(setter(Builder::userPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()).build();

    private static final SdkField<List<String>> CSV_HEADER_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CSVHeader")
            .getter(getter(GetCsvHeaderResponse::csvHeader))
            .setter(setter(Builder::csvHeader))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CSVHeader").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ID_FIELD,
            CSV_HEADER_FIELD));

    private final String userPoolId;

    private final List<String> csvHeader;

    private GetCsvHeaderResponse(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.csvHeader = builder.csvHeader;
    }

    /**
     * <p>
     * The user pool ID for the user pool that the users are to be imported into.
     * </p>
     * 
     * @return The user pool ID for the user pool that the users are to be imported into.
     */
    public String userPoolId() {
        return userPoolId;
    }

    /**
     * Returns true if the CSVHeader property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasCsvHeader() {
        return csvHeader != null && !(csvHeader instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The header information for the .csv file for the user import job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCsvHeader()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The header information for the .csv file for the user import job.
     */
    public List<String> csvHeader() {
        return csvHeader;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(csvHeader());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCsvHeaderResponse)) {
            return false;
        }
        GetCsvHeaderResponse other = (GetCsvHeaderResponse) obj;
        return Objects.equals(userPoolId(), other.userPoolId()) && Objects.equals(csvHeader(), other.csvHeader());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetCsvHeaderResponse").add("UserPoolId", userPoolId()).add("CSVHeader", csvHeader()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserPoolId":
            return Optional.ofNullable(clazz.cast(userPoolId()));
        case "CSVHeader":
            return Optional.ofNullable(clazz.cast(csvHeader()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCsvHeaderResponse, T> g) {
        return obj -> g.apply((GetCsvHeaderResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetCsvHeaderResponse> {
        /**
         * <p>
         * The user pool ID for the user pool that the users are to be imported into.
         * </p>
         * 
         * @param userPoolId
         *        The user pool ID for the user pool that the users are to be imported into.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolId(String userPoolId);

        /**
         * <p>
         * The header information for the .csv file for the user import job.
         * </p>
         * 
         * @param csvHeader
         *        The header information for the .csv file for the user import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder csvHeader(Collection<String> csvHeader);

        /**
         * <p>
         * The header information for the .csv file for the user import job.
         * </p>
         * 
         * @param csvHeader
         *        The header information for the .csv file for the user import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder csvHeader(String... csvHeader);
    }

    static final class BuilderImpl extends CognitoIdentityProviderResponse.BuilderImpl implements Builder {
        private String userPoolId;

        private List<String> csvHeader = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetCsvHeaderResponse model) {
            super(model);
            userPoolId(model.userPoolId);
            csvHeader(model.csvHeader);
        }

        public final String getUserPoolId() {
            return userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final Collection<String> getCsvHeader() {
            return csvHeader;
        }

        @Override
        public final Builder csvHeader(Collection<String> csvHeader) {
            this.csvHeader = ListOfStringTypesCopier.copy(csvHeader);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder csvHeader(String... csvHeader) {
            csvHeader(Arrays.asList(csvHeader));
            return this;
        }

        public final void setCsvHeader(Collection<String> csvHeader) {
            this.csvHeader = ListOfStringTypesCopier.copy(csvHeader);
        }

        @Override
        public GetCsvHeaderResponse build() {
            return new GetCsvHeaderResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
