/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The device verifier against which it will be authenticated.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeviceSecretVerifierConfigType implements SdkPojo, Serializable,
        ToCopyableBuilder<DeviceSecretVerifierConfigType.Builder, DeviceSecretVerifierConfigType> {
    private static final SdkField<String> PASSWORD_VERIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PasswordVerifier").getter(getter(DeviceSecretVerifierConfigType::passwordVerifier))
            .setter(setter(Builder::passwordVerifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PasswordVerifier").build()).build();

    private static final SdkField<String> SALT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Salt")
            .getter(getter(DeviceSecretVerifierConfigType::salt)).setter(setter(Builder::salt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Salt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PASSWORD_VERIFIER_FIELD,
            SALT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String passwordVerifier;

    private final String salt;

    private DeviceSecretVerifierConfigType(BuilderImpl builder) {
        this.passwordVerifier = builder.passwordVerifier;
        this.salt = builder.salt;
    }

    /**
     * <p>
     * The password verifier.
     * </p>
     * 
     * @return The password verifier.
     */
    public final String passwordVerifier() {
        return passwordVerifier;
    }

    /**
     * <p>
     * The salt.
     * </p>
     * 
     * @return The salt.
     */
    public final String salt() {
        return salt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(passwordVerifier());
        hashCode = 31 * hashCode + Objects.hashCode(salt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceSecretVerifierConfigType)) {
            return false;
        }
        DeviceSecretVerifierConfigType other = (DeviceSecretVerifierConfigType) obj;
        return Objects.equals(passwordVerifier(), other.passwordVerifier()) && Objects.equals(salt(), other.salt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeviceSecretVerifierConfigType").add("PasswordVerifier", passwordVerifier()).add("Salt", salt())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PasswordVerifier":
            return Optional.ofNullable(clazz.cast(passwordVerifier()));
        case "Salt":
            return Optional.ofNullable(clazz.cast(salt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeviceSecretVerifierConfigType, T> g) {
        return obj -> g.apply((DeviceSecretVerifierConfigType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeviceSecretVerifierConfigType> {
        /**
         * <p>
         * The password verifier.
         * </p>
         * 
         * @param passwordVerifier
         *        The password verifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder passwordVerifier(String passwordVerifier);

        /**
         * <p>
         * The salt.
         * </p>
         * 
         * @param salt
         *        The salt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder salt(String salt);
    }

    static final class BuilderImpl implements Builder {
        private String passwordVerifier;

        private String salt;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceSecretVerifierConfigType model) {
            passwordVerifier(model.passwordVerifier);
            salt(model.salt);
        }

        public final String getPasswordVerifier() {
            return passwordVerifier;
        }

        @Override
        public final Builder passwordVerifier(String passwordVerifier) {
            this.passwordVerifier = passwordVerifier;
            return this;
        }

        public final void setPasswordVerifier(String passwordVerifier) {
            this.passwordVerifier = passwordVerifier;
        }

        public final String getSalt() {
            return salt;
        }

        @Override
        public final Builder salt(String salt) {
            this.salt = salt;
            return this;
        }

        public final void setSalt(String salt) {
            this.salt = salt;
        }

        @Override
        public DeviceSecretVerifierConfigType build() {
            return new DeviceSecretVerifierConfigType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
