/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class VerifySoftwareTokenResponse extends CognitoIdentityProviderResponse implements
        ToCopyableBuilder<VerifySoftwareTokenResponse.Builder, VerifySoftwareTokenResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(VerifySoftwareTokenResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> SESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Session")
            .getter(getter(VerifySoftwareTokenResponse::session)).setter(setter(Builder::session))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Session").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, SESSION_FIELD));

    private final String status;

    private final String session;

    private VerifySoftwareTokenResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.session = builder.session;
    }

    /**
     * <p>
     * The status of the verify software token.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link VerifySoftwareTokenResponseType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the verify software token.
     * @see VerifySoftwareTokenResponseType
     */
    public final VerifySoftwareTokenResponseType status() {
        return VerifySoftwareTokenResponseType.fromValue(status);
    }

    /**
     * <p>
     * The status of the verify software token.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link VerifySoftwareTokenResponseType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the verify software token.
     * @see VerifySoftwareTokenResponseType
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The session which should be passed both ways in challenge-response calls to the service.
     * </p>
     * 
     * @return The session which should be passed both ways in challenge-response calls to the service.
     */
    public final String session() {
        return session;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(session());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifySoftwareTokenResponse)) {
            return false;
        }
        VerifySoftwareTokenResponse other = (VerifySoftwareTokenResponse) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(session(), other.session());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VerifySoftwareTokenResponse").add("Status", statusAsString()).add("Session", session()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Session":
            return Optional.ofNullable(clazz.cast(session()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VerifySoftwareTokenResponse, T> g) {
        return obj -> g.apply((VerifySoftwareTokenResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, VerifySoftwareTokenResponse> {
        /**
         * <p>
         * The status of the verify software token.
         * </p>
         * 
         * @param status
         *        The status of the verify software token.
         * @see VerifySoftwareTokenResponseType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VerifySoftwareTokenResponseType
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the verify software token.
         * </p>
         * 
         * @param status
         *        The status of the verify software token.
         * @see VerifySoftwareTokenResponseType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VerifySoftwareTokenResponseType
         */
        Builder status(VerifySoftwareTokenResponseType status);

        /**
         * <p>
         * The session which should be passed both ways in challenge-response calls to the service.
         * </p>
         * 
         * @param session
         *        The session which should be passed both ways in challenge-response calls to the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder session(String session);
    }

    static final class BuilderImpl extends CognitoIdentityProviderResponse.BuilderImpl implements Builder {
        private String status;

        private String session;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifySoftwareTokenResponse model) {
            super(model);
            status(model.status);
            session(model.session);
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(VerifySoftwareTokenResponseType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getSession() {
            return session;
        }

        @Override
        public final Builder session(String session) {
            this.session = session;
            return this;
        }

        public final void setSession(String session) {
            this.session = session;
        }

        @Override
        public VerifySoftwareTokenResponse build() {
            return new VerifySoftwareTokenResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
