/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VerifySoftwareTokenRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, VerifySoftwareTokenRequest> {
    private static final SdkField<String> ACCESS_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessToken").getter(VerifySoftwareTokenRequest.getter(VerifySoftwareTokenRequest::accessToken)).setter(VerifySoftwareTokenRequest.setter(Builder::accessToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessToken").build()}).build();
    private static final SdkField<String> SESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Session").getter(VerifySoftwareTokenRequest.getter(VerifySoftwareTokenRequest::session)).setter(VerifySoftwareTokenRequest.setter(Builder::session)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Session").build()}).build();
    private static final SdkField<String> USER_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserCode").getter(VerifySoftwareTokenRequest.getter(VerifySoftwareTokenRequest::userCode)).setter(VerifySoftwareTokenRequest.setter(Builder::userCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserCode").build()}).build();
    private static final SdkField<String> FRIENDLY_DEVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FriendlyDeviceName").getter(VerifySoftwareTokenRequest.getter(VerifySoftwareTokenRequest::friendlyDeviceName)).setter(VerifySoftwareTokenRequest.setter(Builder::friendlyDeviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FriendlyDeviceName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_TOKEN_FIELD, SESSION_FIELD, USER_CODE_FIELD, FRIENDLY_DEVICE_NAME_FIELD));
    private final String accessToken;
    private final String session;
    private final String userCode;
    private final String friendlyDeviceName;

    private VerifySoftwareTokenRequest(BuilderImpl builder) {
        super(builder);
        this.accessToken = builder.accessToken;
        this.session = builder.session;
        this.userCode = builder.userCode;
        this.friendlyDeviceName = builder.friendlyDeviceName;
    }

    public final String accessToken() {
        return this.accessToken;
    }

    public final String session() {
        return this.session;
    }

    public final String userCode() {
        return this.userCode;
    }

    public final String friendlyDeviceName() {
        return this.friendlyDeviceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accessToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.session());
        hashCode = 31 * hashCode + Objects.hashCode(this.userCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.friendlyDeviceName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifySoftwareTokenRequest)) {
            return false;
        }
        VerifySoftwareTokenRequest other = (VerifySoftwareTokenRequest)((Object)obj);
        return Objects.equals(this.accessToken(), other.accessToken()) && Objects.equals(this.session(), other.session()) && Objects.equals(this.userCode(), other.userCode()) && Objects.equals(this.friendlyDeviceName(), other.friendlyDeviceName());
    }

    public final String toString() {
        return ToString.builder((String)"VerifySoftwareTokenRequest").add("AccessToken", (Object)(this.accessToken() == null ? null : "*** Sensitive Data Redacted ***")).add("Session", (Object)this.session()).add("UserCode", (Object)this.userCode()).add("FriendlyDeviceName", (Object)this.friendlyDeviceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessToken": {
                return Optional.ofNullable(clazz.cast(this.accessToken()));
            }
            case "Session": {
                return Optional.ofNullable(clazz.cast(this.session()));
            }
            case "UserCode": {
                return Optional.ofNullable(clazz.cast(this.userCode()));
            }
            case "FriendlyDeviceName": {
                return Optional.ofNullable(clazz.cast(this.friendlyDeviceName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VerifySoftwareTokenRequest, T> g) {
        return obj -> g.apply((VerifySoftwareTokenRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String accessToken;
        private String session;
        private String userCode;
        private String friendlyDeviceName;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifySoftwareTokenRequest model) {
            super(model);
            this.accessToken(model.accessToken);
            this.session(model.session);
            this.userCode(model.userCode);
            this.friendlyDeviceName(model.friendlyDeviceName);
        }

        public final String getAccessToken() {
            return this.accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        public final String getSession() {
            return this.session;
        }

        @Override
        public final Builder session(String session) {
            this.session = session;
            return this;
        }

        public final void setSession(String session) {
            this.session = session;
        }

        public final String getUserCode() {
            return this.userCode;
        }

        @Override
        public final Builder userCode(String userCode) {
            this.userCode = userCode;
            return this;
        }

        public final void setUserCode(String userCode) {
            this.userCode = userCode;
        }

        public final String getFriendlyDeviceName() {
            return this.friendlyDeviceName;
        }

        @Override
        public final Builder friendlyDeviceName(String friendlyDeviceName) {
            this.friendlyDeviceName = friendlyDeviceName;
            return this;
        }

        public final void setFriendlyDeviceName(String friendlyDeviceName) {
            this.friendlyDeviceName = friendlyDeviceName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public VerifySoftwareTokenRequest build() {
            return new VerifySoftwareTokenRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, VerifySoftwareTokenRequest> {
        public Builder accessToken(String var1);

        public Builder session(String var1);

        public Builder userCode(String var1);

        public Builder friendlyDeviceName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

