/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetUserPoolMfaConfigResponse extends CognitoIdentityProviderResponse implements
        ToCopyableBuilder<SetUserPoolMfaConfigResponse.Builder, SetUserPoolMfaConfigResponse> {
    private static final SdkField<SmsMfaConfigType> SMS_MFA_CONFIGURATION_FIELD = SdkField
            .<SmsMfaConfigType> builder(MarshallingType.SDK_POJO).memberName("SmsMfaConfiguration")
            .getter(getter(SetUserPoolMfaConfigResponse::smsMfaConfiguration)).setter(setter(Builder::smsMfaConfiguration))
            .constructor(SmsMfaConfigType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmsMfaConfiguration").build())
            .build();

    private static final SdkField<SoftwareTokenMfaConfigType> SOFTWARE_TOKEN_MFA_CONFIGURATION_FIELD = SdkField
            .<SoftwareTokenMfaConfigType> builder(MarshallingType.SDK_POJO)
            .memberName("SoftwareTokenMfaConfiguration")
            .getter(getter(SetUserPoolMfaConfigResponse::softwareTokenMfaConfiguration))
            .setter(setter(Builder::softwareTokenMfaConfiguration))
            .constructor(SoftwareTokenMfaConfigType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SoftwareTokenMfaConfiguration")
                    .build()).build();

    private static final SdkField<EmailMfaConfigType> EMAIL_MFA_CONFIGURATION_FIELD = SdkField
            .<EmailMfaConfigType> builder(MarshallingType.SDK_POJO).memberName("EmailMfaConfiguration")
            .getter(getter(SetUserPoolMfaConfigResponse::emailMfaConfiguration)).setter(setter(Builder::emailMfaConfiguration))
            .constructor(EmailMfaConfigType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailMfaConfiguration").build())
            .build();

    private static final SdkField<String> MFA_CONFIGURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MfaConfiguration").getter(getter(SetUserPoolMfaConfigResponse::mfaConfigurationAsString))
            .setter(setter(Builder::mfaConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MfaConfiguration").build()).build();

    private static final SdkField<WebAuthnConfigurationType> WEB_AUTHN_CONFIGURATION_FIELD = SdkField
            .<WebAuthnConfigurationType> builder(MarshallingType.SDK_POJO).memberName("WebAuthnConfiguration")
            .getter(getter(SetUserPoolMfaConfigResponse::webAuthnConfiguration)).setter(setter(Builder::webAuthnConfiguration))
            .constructor(WebAuthnConfigurationType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebAuthnConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SMS_MFA_CONFIGURATION_FIELD,
            SOFTWARE_TOKEN_MFA_CONFIGURATION_FIELD, EMAIL_MFA_CONFIGURATION_FIELD, MFA_CONFIGURATION_FIELD,
            WEB_AUTHN_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final SmsMfaConfigType smsMfaConfiguration;

    private final SoftwareTokenMfaConfigType softwareTokenMfaConfiguration;

    private final EmailMfaConfigType emailMfaConfiguration;

    private final String mfaConfiguration;

    private final WebAuthnConfigurationType webAuthnConfiguration;

    private SetUserPoolMfaConfigResponse(BuilderImpl builder) {
        super(builder);
        this.smsMfaConfiguration = builder.smsMfaConfiguration;
        this.softwareTokenMfaConfiguration = builder.softwareTokenMfaConfiguration;
        this.emailMfaConfiguration = builder.emailMfaConfiguration;
        this.mfaConfiguration = builder.mfaConfiguration;
        this.webAuthnConfiguration = builder.webAuthnConfiguration;
    }

    /**
     * <p>
     * Shows user pool SMS message configuration for MFA and sign-in with SMS-message OTPs. Includes the message
     * template and the SMS message sending configuration for Amazon SNS.
     * </p>
     * 
     * @return Shows user pool SMS message configuration for MFA and sign-in with SMS-message OTPs. Includes the message
     *         template and the SMS message sending configuration for Amazon SNS.
     */
    public final SmsMfaConfigType smsMfaConfiguration() {
        return smsMfaConfiguration;
    }

    /**
     * <p>
     * Shows user pool configuration for time-based one-time password (TOTP) MFA. Includes TOTP enabled or disabled
     * state.
     * </p>
     * 
     * @return Shows user pool configuration for time-based one-time password (TOTP) MFA. Includes TOTP enabled or
     *         disabled state.
     */
    public final SoftwareTokenMfaConfigType softwareTokenMfaConfiguration() {
        return softwareTokenMfaConfiguration;
    }

    /**
     * <p>
     * Shows configuration for user pool email message MFA and sign-in with one-time passwords (OTPs). Includes the
     * subject and body of the email message template for sign-in and MFA messages. To activate this setting, your user
     * pool must be in the <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/feature-plans-features-essentials.html">
     * Essentials tier</a> or higher.
     * </p>
     * 
     * @return Shows configuration for user pool email message MFA and sign-in with one-time passwords (OTPs). Includes
     *         the subject and body of the email message template for sign-in and MFA messages. To activate this
     *         setting, your user pool must be in the <a
     *         href="https://docs.aws.amazon.com/cognito/latest/developerguide/feature-plans-features-essentials.html">
     *         Essentials tier</a> or higher.
     */
    public final EmailMfaConfigType emailMfaConfiguration() {
        return emailMfaConfiguration;
    }

    /**
     * <p>
     * Displays multi-factor authentication (MFA) as on, off, or optional. When <code>ON</code>, all users must set up
     * MFA before they can sign in. When <code>OPTIONAL</code>, your application must make a client-side determination
     * of whether a user wants to register an MFA device. For user pools with adaptive authentication with threat
     * protection, choose <code>OPTIONAL</code>.
     * </p>
     * <p>
     * When <code>MfaConfiguration</code> is <code>OPTIONAL</code>, managed login doesn't automatically prompt users to
     * set up MFA. Amazon Cognito generates MFA prompts in API responses and in managed login for users who have chosen
     * and configured a preferred MFA factor.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mfaConfiguration}
     * will return {@link UserPoolMfaType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #mfaConfigurationAsString}.
     * </p>
     * 
     * @return Displays multi-factor authentication (MFA) as on, off, or optional. When <code>ON</code>, all users must
     *         set up MFA before they can sign in. When <code>OPTIONAL</code>, your application must make a client-side
     *         determination of whether a user wants to register an MFA device. For user pools with adaptive
     *         authentication with threat protection, choose <code>OPTIONAL</code>.</p>
     *         <p>
     *         When <code>MfaConfiguration</code> is <code>OPTIONAL</code>, managed login doesn't automatically prompt
     *         users to set up MFA. Amazon Cognito generates MFA prompts in API responses and in managed login for users
     *         who have chosen and configured a preferred MFA factor.
     * @see UserPoolMfaType
     */
    public final UserPoolMfaType mfaConfiguration() {
        return UserPoolMfaType.fromValue(mfaConfiguration);
    }

    /**
     * <p>
     * Displays multi-factor authentication (MFA) as on, off, or optional. When <code>ON</code>, all users must set up
     * MFA before they can sign in. When <code>OPTIONAL</code>, your application must make a client-side determination
     * of whether a user wants to register an MFA device. For user pools with adaptive authentication with threat
     * protection, choose <code>OPTIONAL</code>.
     * </p>
     * <p>
     * When <code>MfaConfiguration</code> is <code>OPTIONAL</code>, managed login doesn't automatically prompt users to
     * set up MFA. Amazon Cognito generates MFA prompts in API responses and in managed login for users who have chosen
     * and configured a preferred MFA factor.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mfaConfiguration}
     * will return {@link UserPoolMfaType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #mfaConfigurationAsString}.
     * </p>
     * 
     * @return Displays multi-factor authentication (MFA) as on, off, or optional. When <code>ON</code>, all users must
     *         set up MFA before they can sign in. When <code>OPTIONAL</code>, your application must make a client-side
     *         determination of whether a user wants to register an MFA device. For user pools with adaptive
     *         authentication with threat protection, choose <code>OPTIONAL</code>.</p>
     *         <p>
     *         When <code>MfaConfiguration</code> is <code>OPTIONAL</code>, managed login doesn't automatically prompt
     *         users to set up MFA. Amazon Cognito generates MFA prompts in API responses and in managed login for users
     *         who have chosen and configured a preferred MFA factor.
     * @see UserPoolMfaType
     */
    public final String mfaConfigurationAsString() {
        return mfaConfiguration;
    }

    /**
     * <p>
     * The configuration of your user pool for passkey, or WebAuthn, sign-in with authenticators like biometric and
     * security-key devices. Includes relying-party configuration and settings for user-verification requirements.
     * </p>
     * 
     * @return The configuration of your user pool for passkey, or WebAuthn, sign-in with authenticators like biometric
     *         and security-key devices. Includes relying-party configuration and settings for user-verification
     *         requirements.
     */
    public final WebAuthnConfigurationType webAuthnConfiguration() {
        return webAuthnConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(smsMfaConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(softwareTokenMfaConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(emailMfaConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(mfaConfigurationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(webAuthnConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetUserPoolMfaConfigResponse)) {
            return false;
        }
        SetUserPoolMfaConfigResponse other = (SetUserPoolMfaConfigResponse) obj;
        return Objects.equals(smsMfaConfiguration(), other.smsMfaConfiguration())
                && Objects.equals(softwareTokenMfaConfiguration(), other.softwareTokenMfaConfiguration())
                && Objects.equals(emailMfaConfiguration(), other.emailMfaConfiguration())
                && Objects.equals(mfaConfigurationAsString(), other.mfaConfigurationAsString())
                && Objects.equals(webAuthnConfiguration(), other.webAuthnConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SetUserPoolMfaConfigResponse").add("SmsMfaConfiguration", smsMfaConfiguration())
                .add("SoftwareTokenMfaConfiguration", softwareTokenMfaConfiguration())
                .add("EmailMfaConfiguration", emailMfaConfiguration()).add("MfaConfiguration", mfaConfigurationAsString())
                .add("WebAuthnConfiguration", webAuthnConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SmsMfaConfiguration":
            return Optional.ofNullable(clazz.cast(smsMfaConfiguration()));
        case "SoftwareTokenMfaConfiguration":
            return Optional.ofNullable(clazz.cast(softwareTokenMfaConfiguration()));
        case "EmailMfaConfiguration":
            return Optional.ofNullable(clazz.cast(emailMfaConfiguration()));
        case "MfaConfiguration":
            return Optional.ofNullable(clazz.cast(mfaConfigurationAsString()));
        case "WebAuthnConfiguration":
            return Optional.ofNullable(clazz.cast(webAuthnConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SmsMfaConfiguration", SMS_MFA_CONFIGURATION_FIELD);
        map.put("SoftwareTokenMfaConfiguration", SOFTWARE_TOKEN_MFA_CONFIGURATION_FIELD);
        map.put("EmailMfaConfiguration", EMAIL_MFA_CONFIGURATION_FIELD);
        map.put("MfaConfiguration", MFA_CONFIGURATION_FIELD);
        map.put("WebAuthnConfiguration", WEB_AUTHN_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SetUserPoolMfaConfigResponse, T> g) {
        return obj -> g.apply((SetUserPoolMfaConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, SetUserPoolMfaConfigResponse> {
        /**
         * <p>
         * Shows user pool SMS message configuration for MFA and sign-in with SMS-message OTPs. Includes the message
         * template and the SMS message sending configuration for Amazon SNS.
         * </p>
         * 
         * @param smsMfaConfiguration
         *        Shows user pool SMS message configuration for MFA and sign-in with SMS-message OTPs. Includes the
         *        message template and the SMS message sending configuration for Amazon SNS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smsMfaConfiguration(SmsMfaConfigType smsMfaConfiguration);

        /**
         * <p>
         * Shows user pool SMS message configuration for MFA and sign-in with SMS-message OTPs. Includes the message
         * template and the SMS message sending configuration for Amazon SNS.
         * </p>
         * This is a convenience method that creates an instance of the {@link SmsMfaConfigType.Builder} avoiding the
         * need to create one manually via {@link SmsMfaConfigType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SmsMfaConfigType.Builder#build()} is called immediately and its
         * result is passed to {@link #smsMfaConfiguration(SmsMfaConfigType)}.
         * 
         * @param smsMfaConfiguration
         *        a consumer that will call methods on {@link SmsMfaConfigType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #smsMfaConfiguration(SmsMfaConfigType)
         */
        default Builder smsMfaConfiguration(Consumer<SmsMfaConfigType.Builder> smsMfaConfiguration) {
            return smsMfaConfiguration(SmsMfaConfigType.builder().applyMutation(smsMfaConfiguration).build());
        }

        /**
         * <p>
         * Shows user pool configuration for time-based one-time password (TOTP) MFA. Includes TOTP enabled or disabled
         * state.
         * </p>
         * 
         * @param softwareTokenMfaConfiguration
         *        Shows user pool configuration for time-based one-time password (TOTP) MFA. Includes TOTP enabled or
         *        disabled state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder softwareTokenMfaConfiguration(SoftwareTokenMfaConfigType softwareTokenMfaConfiguration);

        /**
         * <p>
         * Shows user pool configuration for time-based one-time password (TOTP) MFA. Includes TOTP enabled or disabled
         * state.
         * </p>
         * This is a convenience method that creates an instance of the {@link SoftwareTokenMfaConfigType.Builder}
         * avoiding the need to create one manually via {@link SoftwareTokenMfaConfigType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SoftwareTokenMfaConfigType.Builder#build()} is called immediately
         * and its result is passed to {@link #softwareTokenMfaConfiguration(SoftwareTokenMfaConfigType)}.
         * 
         * @param softwareTokenMfaConfiguration
         *        a consumer that will call methods on {@link SoftwareTokenMfaConfigType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #softwareTokenMfaConfiguration(SoftwareTokenMfaConfigType)
         */
        default Builder softwareTokenMfaConfiguration(Consumer<SoftwareTokenMfaConfigType.Builder> softwareTokenMfaConfiguration) {
            return softwareTokenMfaConfiguration(SoftwareTokenMfaConfigType.builder()
                    .applyMutation(softwareTokenMfaConfiguration).build());
        }

        /**
         * <p>
         * Shows configuration for user pool email message MFA and sign-in with one-time passwords (OTPs). Includes the
         * subject and body of the email message template for sign-in and MFA messages. To activate this setting, your
         * user pool must be in the <a
         * href="https://docs.aws.amazon.com/cognito/latest/developerguide/feature-plans-features-essentials.html">
         * Essentials tier</a> or higher.
         * </p>
         * 
         * @param emailMfaConfiguration
         *        Shows configuration for user pool email message MFA and sign-in with one-time passwords (OTPs).
         *        Includes the subject and body of the email message template for sign-in and MFA messages. To activate
         *        this setting, your user pool must be in the <a href=
         *        "https://docs.aws.amazon.com/cognito/latest/developerguide/feature-plans-features-essentials.html">
         *        Essentials tier</a> or higher.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailMfaConfiguration(EmailMfaConfigType emailMfaConfiguration);

        /**
         * <p>
         * Shows configuration for user pool email message MFA and sign-in with one-time passwords (OTPs). Includes the
         * subject and body of the email message template for sign-in and MFA messages. To activate this setting, your
         * user pool must be in the <a
         * href="https://docs.aws.amazon.com/cognito/latest/developerguide/feature-plans-features-essentials.html">
         * Essentials tier</a> or higher.
         * </p>
         * This is a convenience method that creates an instance of the {@link EmailMfaConfigType.Builder} avoiding the
         * need to create one manually via {@link EmailMfaConfigType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EmailMfaConfigType.Builder#build()} is called immediately and its
         * result is passed to {@link #emailMfaConfiguration(EmailMfaConfigType)}.
         * 
         * @param emailMfaConfiguration
         *        a consumer that will call methods on {@link EmailMfaConfigType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emailMfaConfiguration(EmailMfaConfigType)
         */
        default Builder emailMfaConfiguration(Consumer<EmailMfaConfigType.Builder> emailMfaConfiguration) {
            return emailMfaConfiguration(EmailMfaConfigType.builder().applyMutation(emailMfaConfiguration).build());
        }

        /**
         * <p>
         * Displays multi-factor authentication (MFA) as on, off, or optional. When <code>ON</code>, all users must set
         * up MFA before they can sign in. When <code>OPTIONAL</code>, your application must make a client-side
         * determination of whether a user wants to register an MFA device. For user pools with adaptive authentication
         * with threat protection, choose <code>OPTIONAL</code>.
         * </p>
         * <p>
         * When <code>MfaConfiguration</code> is <code>OPTIONAL</code>, managed login doesn't automatically prompt users
         * to set up MFA. Amazon Cognito generates MFA prompts in API responses and in managed login for users who have
         * chosen and configured a preferred MFA factor.
         * </p>
         * 
         * @param mfaConfiguration
         *        Displays multi-factor authentication (MFA) as on, off, or optional. When <code>ON</code>, all users
         *        must set up MFA before they can sign in. When <code>OPTIONAL</code>, your application must make a
         *        client-side determination of whether a user wants to register an MFA device. For user pools with
         *        adaptive authentication with threat protection, choose <code>OPTIONAL</code>.</p>
         *        <p>
         *        When <code>MfaConfiguration</code> is <code>OPTIONAL</code>, managed login doesn't automatically
         *        prompt users to set up MFA. Amazon Cognito generates MFA prompts in API responses and in managed login
         *        for users who have chosen and configured a preferred MFA factor.
         * @see UserPoolMfaType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserPoolMfaType
         */
        Builder mfaConfiguration(String mfaConfiguration);

        /**
         * <p>
         * Displays multi-factor authentication (MFA) as on, off, or optional. When <code>ON</code>, all users must set
         * up MFA before they can sign in. When <code>OPTIONAL</code>, your application must make a client-side
         * determination of whether a user wants to register an MFA device. For user pools with adaptive authentication
         * with threat protection, choose <code>OPTIONAL</code>.
         * </p>
         * <p>
         * When <code>MfaConfiguration</code> is <code>OPTIONAL</code>, managed login doesn't automatically prompt users
         * to set up MFA. Amazon Cognito generates MFA prompts in API responses and in managed login for users who have
         * chosen and configured a preferred MFA factor.
         * </p>
         * 
         * @param mfaConfiguration
         *        Displays multi-factor authentication (MFA) as on, off, or optional. When <code>ON</code>, all users
         *        must set up MFA before they can sign in. When <code>OPTIONAL</code>, your application must make a
         *        client-side determination of whether a user wants to register an MFA device. For user pools with
         *        adaptive authentication with threat protection, choose <code>OPTIONAL</code>.</p>
         *        <p>
         *        When <code>MfaConfiguration</code> is <code>OPTIONAL</code>, managed login doesn't automatically
         *        prompt users to set up MFA. Amazon Cognito generates MFA prompts in API responses and in managed login
         *        for users who have chosen and configured a preferred MFA factor.
         * @see UserPoolMfaType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserPoolMfaType
         */
        Builder mfaConfiguration(UserPoolMfaType mfaConfiguration);

        /**
         * <p>
         * The configuration of your user pool for passkey, or WebAuthn, sign-in with authenticators like biometric and
         * security-key devices. Includes relying-party configuration and settings for user-verification requirements.
         * </p>
         * 
         * @param webAuthnConfiguration
         *        The configuration of your user pool for passkey, or WebAuthn, sign-in with authenticators like
         *        biometric and security-key devices. Includes relying-party configuration and settings for
         *        user-verification requirements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webAuthnConfiguration(WebAuthnConfigurationType webAuthnConfiguration);

        /**
         * <p>
         * The configuration of your user pool for passkey, or WebAuthn, sign-in with authenticators like biometric and
         * security-key devices. Includes relying-party configuration and settings for user-verification requirements.
         * </p>
         * This is a convenience method that creates an instance of the {@link WebAuthnConfigurationType.Builder}
         * avoiding the need to create one manually via {@link WebAuthnConfigurationType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WebAuthnConfigurationType.Builder#build()} is called immediately
         * and its result is passed to {@link #webAuthnConfiguration(WebAuthnConfigurationType)}.
         * 
         * @param webAuthnConfiguration
         *        a consumer that will call methods on {@link WebAuthnConfigurationType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #webAuthnConfiguration(WebAuthnConfigurationType)
         */
        default Builder webAuthnConfiguration(Consumer<WebAuthnConfigurationType.Builder> webAuthnConfiguration) {
            return webAuthnConfiguration(WebAuthnConfigurationType.builder().applyMutation(webAuthnConfiguration).build());
        }
    }

    static final class BuilderImpl extends CognitoIdentityProviderResponse.BuilderImpl implements Builder {
        private SmsMfaConfigType smsMfaConfiguration;

        private SoftwareTokenMfaConfigType softwareTokenMfaConfiguration;

        private EmailMfaConfigType emailMfaConfiguration;

        private String mfaConfiguration;

        private WebAuthnConfigurationType webAuthnConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(SetUserPoolMfaConfigResponse model) {
            super(model);
            smsMfaConfiguration(model.smsMfaConfiguration);
            softwareTokenMfaConfiguration(model.softwareTokenMfaConfiguration);
            emailMfaConfiguration(model.emailMfaConfiguration);
            mfaConfiguration(model.mfaConfiguration);
            webAuthnConfiguration(model.webAuthnConfiguration);
        }

        public final SmsMfaConfigType.Builder getSmsMfaConfiguration() {
            return smsMfaConfiguration != null ? smsMfaConfiguration.toBuilder() : null;
        }

        public final void setSmsMfaConfiguration(SmsMfaConfigType.BuilderImpl smsMfaConfiguration) {
            this.smsMfaConfiguration = smsMfaConfiguration != null ? smsMfaConfiguration.build() : null;
        }

        @Override
        public final Builder smsMfaConfiguration(SmsMfaConfigType smsMfaConfiguration) {
            this.smsMfaConfiguration = smsMfaConfiguration;
            return this;
        }

        public final SoftwareTokenMfaConfigType.Builder getSoftwareTokenMfaConfiguration() {
            return softwareTokenMfaConfiguration != null ? softwareTokenMfaConfiguration.toBuilder() : null;
        }

        public final void setSoftwareTokenMfaConfiguration(SoftwareTokenMfaConfigType.BuilderImpl softwareTokenMfaConfiguration) {
            this.softwareTokenMfaConfiguration = softwareTokenMfaConfiguration != null ? softwareTokenMfaConfiguration.build()
                    : null;
        }

        @Override
        public final Builder softwareTokenMfaConfiguration(SoftwareTokenMfaConfigType softwareTokenMfaConfiguration) {
            this.softwareTokenMfaConfiguration = softwareTokenMfaConfiguration;
            return this;
        }

        public final EmailMfaConfigType.Builder getEmailMfaConfiguration() {
            return emailMfaConfiguration != null ? emailMfaConfiguration.toBuilder() : null;
        }

        public final void setEmailMfaConfiguration(EmailMfaConfigType.BuilderImpl emailMfaConfiguration) {
            this.emailMfaConfiguration = emailMfaConfiguration != null ? emailMfaConfiguration.build() : null;
        }

        @Override
        public final Builder emailMfaConfiguration(EmailMfaConfigType emailMfaConfiguration) {
            this.emailMfaConfiguration = emailMfaConfiguration;
            return this;
        }

        public final String getMfaConfiguration() {
            return mfaConfiguration;
        }

        public final void setMfaConfiguration(String mfaConfiguration) {
            this.mfaConfiguration = mfaConfiguration;
        }

        @Override
        public final Builder mfaConfiguration(String mfaConfiguration) {
            this.mfaConfiguration = mfaConfiguration;
            return this;
        }

        @Override
        public final Builder mfaConfiguration(UserPoolMfaType mfaConfiguration) {
            this.mfaConfiguration(mfaConfiguration == null ? null : mfaConfiguration.toString());
            return this;
        }

        public final WebAuthnConfigurationType.Builder getWebAuthnConfiguration() {
            return webAuthnConfiguration != null ? webAuthnConfiguration.toBuilder() : null;
        }

        public final void setWebAuthnConfiguration(WebAuthnConfigurationType.BuilderImpl webAuthnConfiguration) {
            this.webAuthnConfiguration = webAuthnConfiguration != null ? webAuthnConfiguration.build() : null;
        }

        @Override
        public final Builder webAuthnConfiguration(WebAuthnConfigurationType webAuthnConfiguration) {
            this.webAuthnConfiguration = webAuthnConfiguration;
            return this;
        }

        @Override
        public SetUserPoolMfaConfigResponse build() {
            return new SetUserPoolMfaConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
