/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AnalyticsMetadataType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ClientMetadataTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserContextDataType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfirmSignUpRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, ConfirmSignUpRequest> {
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientId").getter(ConfirmSignUpRequest.getter(ConfirmSignUpRequest::clientId)).setter(ConfirmSignUpRequest.setter(Builder::clientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").build()}).build();
    private static final SdkField<String> SECRET_HASH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretHash").getter(ConfirmSignUpRequest.getter(ConfirmSignUpRequest::secretHash)).setter(ConfirmSignUpRequest.setter(Builder::secretHash)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretHash").build()}).build();
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Username").getter(ConfirmSignUpRequest.getter(ConfirmSignUpRequest::username)).setter(ConfirmSignUpRequest.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()}).build();
    private static final SdkField<String> CONFIRMATION_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfirmationCode").getter(ConfirmSignUpRequest.getter(ConfirmSignUpRequest::confirmationCode)).setter(ConfirmSignUpRequest.setter(Builder::confirmationCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfirmationCode").build()}).build();
    private static final SdkField<Boolean> FORCE_ALIAS_CREATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ForceAliasCreation").getter(ConfirmSignUpRequest.getter(ConfirmSignUpRequest::forceAliasCreation)).setter(ConfirmSignUpRequest.setter(Builder::forceAliasCreation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForceAliasCreation").build()}).build();
    private static final SdkField<AnalyticsMetadataType> ANALYTICS_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AnalyticsMetadata").getter(ConfirmSignUpRequest.getter(ConfirmSignUpRequest::analyticsMetadata)).setter(ConfirmSignUpRequest.setter(Builder::analyticsMetadata)).constructor(AnalyticsMetadataType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalyticsMetadata").build()}).build();
    private static final SdkField<UserContextDataType> USER_CONTEXT_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UserContextData").getter(ConfirmSignUpRequest.getter(ConfirmSignUpRequest::userContextData)).setter(ConfirmSignUpRequest.setter(Builder::userContextData)).constructor(UserContextDataType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserContextData").build()}).build();
    private static final SdkField<Map<String, String>> CLIENT_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ClientMetadata").getter(ConfirmSignUpRequest.getter(ConfirmSignUpRequest::clientMetadata)).setter(ConfirmSignUpRequest.setter(Builder::clientMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientMetadata").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> SESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Session").getter(ConfirmSignUpRequest.getter(ConfirmSignUpRequest::session)).setter(ConfirmSignUpRequest.setter(Builder::session)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Session").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_ID_FIELD, SECRET_HASH_FIELD, USERNAME_FIELD, CONFIRMATION_CODE_FIELD, FORCE_ALIAS_CREATION_FIELD, ANALYTICS_METADATA_FIELD, USER_CONTEXT_DATA_FIELD, CLIENT_METADATA_FIELD, SESSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConfirmSignUpRequest.memberNameToFieldInitializer();
    private final String clientId;
    private final String secretHash;
    private final String username;
    private final String confirmationCode;
    private final Boolean forceAliasCreation;
    private final AnalyticsMetadataType analyticsMetadata;
    private final UserContextDataType userContextData;
    private final Map<String, String> clientMetadata;
    private final String session;

    private ConfirmSignUpRequest(BuilderImpl builder) {
        super(builder);
        this.clientId = builder.clientId;
        this.secretHash = builder.secretHash;
        this.username = builder.username;
        this.confirmationCode = builder.confirmationCode;
        this.forceAliasCreation = builder.forceAliasCreation;
        this.analyticsMetadata = builder.analyticsMetadata;
        this.userContextData = builder.userContextData;
        this.clientMetadata = builder.clientMetadata;
        this.session = builder.session;
    }

    public final String clientId() {
        return this.clientId;
    }

    public final String secretHash() {
        return this.secretHash;
    }

    public final String username() {
        return this.username;
    }

    public final String confirmationCode() {
        return this.confirmationCode;
    }

    public final Boolean forceAliasCreation() {
        return this.forceAliasCreation;
    }

    public final AnalyticsMetadataType analyticsMetadata() {
        return this.analyticsMetadata;
    }

    public final UserContextDataType userContextData() {
        return this.userContextData;
    }

    public final boolean hasClientMetadata() {
        return this.clientMetadata != null && !(this.clientMetadata instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> clientMetadata() {
        return this.clientMetadata;
    }

    public final String session() {
        return this.session;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretHash());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.confirmationCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.forceAliasCreation());
        hashCode = 31 * hashCode + Objects.hashCode(this.analyticsMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.userContextData());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClientMetadata() ? this.clientMetadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.session());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfirmSignUpRequest)) {
            return false;
        }
        ConfirmSignUpRequest other = (ConfirmSignUpRequest)((Object)obj);
        return Objects.equals(this.clientId(), other.clientId()) && Objects.equals(this.secretHash(), other.secretHash()) && Objects.equals(this.username(), other.username()) && Objects.equals(this.confirmationCode(), other.confirmationCode()) && Objects.equals(this.forceAliasCreation(), other.forceAliasCreation()) && Objects.equals(this.analyticsMetadata(), other.analyticsMetadata()) && Objects.equals(this.userContextData(), other.userContextData()) && this.hasClientMetadata() == other.hasClientMetadata() && Objects.equals(this.clientMetadata(), other.clientMetadata()) && Objects.equals(this.session(), other.session());
    }

    public final String toString() {
        return ToString.builder((String)"ConfirmSignUpRequest").add("ClientId", (Object)(this.clientId() == null ? null : "*** Sensitive Data Redacted ***")).add("SecretHash", (Object)(this.secretHash() == null ? null : "*** Sensitive Data Redacted ***")).add("Username", (Object)(this.username() == null ? null : "*** Sensitive Data Redacted ***")).add("ConfirmationCode", (Object)this.confirmationCode()).add("ForceAliasCreation", (Object)this.forceAliasCreation()).add("AnalyticsMetadata", (Object)this.analyticsMetadata()).add("UserContextData", (Object)(this.userContextData() == null ? null : "*** Sensitive Data Redacted ***")).add("ClientMetadata", this.hasClientMetadata() ? this.clientMetadata() : null).add("Session", (Object)(this.session() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientId": {
                return Optional.ofNullable(clazz.cast(this.clientId()));
            }
            case "SecretHash": {
                return Optional.ofNullable(clazz.cast(this.secretHash()));
            }
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "ConfirmationCode": {
                return Optional.ofNullable(clazz.cast(this.confirmationCode()));
            }
            case "ForceAliasCreation": {
                return Optional.ofNullable(clazz.cast(this.forceAliasCreation()));
            }
            case "AnalyticsMetadata": {
                return Optional.ofNullable(clazz.cast(this.analyticsMetadata()));
            }
            case "UserContextData": {
                return Optional.ofNullable(clazz.cast(this.userContextData()));
            }
            case "ClientMetadata": {
                return Optional.ofNullable(clazz.cast(this.clientMetadata()));
            }
            case "Session": {
                return Optional.ofNullable(clazz.cast(this.session()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClientId", CLIENT_ID_FIELD);
        map.put("SecretHash", SECRET_HASH_FIELD);
        map.put("Username", USERNAME_FIELD);
        map.put("ConfirmationCode", CONFIRMATION_CODE_FIELD);
        map.put("ForceAliasCreation", FORCE_ALIAS_CREATION_FIELD);
        map.put("AnalyticsMetadata", ANALYTICS_METADATA_FIELD);
        map.put("UserContextData", USER_CONTEXT_DATA_FIELD);
        map.put("ClientMetadata", CLIENT_METADATA_FIELD);
        map.put("Session", SESSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfirmSignUpRequest, T> g) {
        return obj -> g.apply((ConfirmSignUpRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String clientId;
        private String secretHash;
        private String username;
        private String confirmationCode;
        private Boolean forceAliasCreation;
        private AnalyticsMetadataType analyticsMetadata;
        private UserContextDataType userContextData;
        private Map<String, String> clientMetadata = DefaultSdkAutoConstructMap.getInstance();
        private String session;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfirmSignUpRequest model) {
            super(model);
            this.clientId(model.clientId);
            this.secretHash(model.secretHash);
            this.username(model.username);
            this.confirmationCode(model.confirmationCode);
            this.forceAliasCreation(model.forceAliasCreation);
            this.analyticsMetadata(model.analyticsMetadata);
            this.userContextData(model.userContextData);
            this.clientMetadata(model.clientMetadata);
            this.session(model.session);
        }

        public final String getClientId() {
            return this.clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final String getSecretHash() {
            return this.secretHash;
        }

        public final void setSecretHash(String secretHash) {
            this.secretHash = secretHash;
        }

        @Override
        public final Builder secretHash(String secretHash) {
            this.secretHash = secretHash;
            return this;
        }

        public final String getUsername() {
            return this.username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final String getConfirmationCode() {
            return this.confirmationCode;
        }

        public final void setConfirmationCode(String confirmationCode) {
            this.confirmationCode = confirmationCode;
        }

        @Override
        public final Builder confirmationCode(String confirmationCode) {
            this.confirmationCode = confirmationCode;
            return this;
        }

        public final Boolean getForceAliasCreation() {
            return this.forceAliasCreation;
        }

        public final void setForceAliasCreation(Boolean forceAliasCreation) {
            this.forceAliasCreation = forceAliasCreation;
        }

        @Override
        public final Builder forceAliasCreation(Boolean forceAliasCreation) {
            this.forceAliasCreation = forceAliasCreation;
            return this;
        }

        public final AnalyticsMetadataType.Builder getAnalyticsMetadata() {
            return this.analyticsMetadata != null ? this.analyticsMetadata.toBuilder() : null;
        }

        public final void setAnalyticsMetadata(AnalyticsMetadataType.BuilderImpl analyticsMetadata) {
            this.analyticsMetadata = analyticsMetadata != null ? analyticsMetadata.build() : null;
        }

        @Override
        public final Builder analyticsMetadata(AnalyticsMetadataType analyticsMetadata) {
            this.analyticsMetadata = analyticsMetadata;
            return this;
        }

        public final UserContextDataType.Builder getUserContextData() {
            return this.userContextData != null ? this.userContextData.toBuilder() : null;
        }

        public final void setUserContextData(UserContextDataType.BuilderImpl userContextData) {
            this.userContextData = userContextData != null ? userContextData.build() : null;
        }

        @Override
        public final Builder userContextData(UserContextDataType userContextData) {
            this.userContextData = userContextData;
            return this;
        }

        public final Map<String, String> getClientMetadata() {
            if (this.clientMetadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.clientMetadata;
        }

        public final void setClientMetadata(Map<String, String> clientMetadata) {
            this.clientMetadata = ClientMetadataTypeCopier.copy(clientMetadata);
        }

        @Override
        public final Builder clientMetadata(Map<String, String> clientMetadata) {
            this.clientMetadata = ClientMetadataTypeCopier.copy(clientMetadata);
            return this;
        }

        public final String getSession() {
            return this.session;
        }

        public final void setSession(String session) {
            this.session = session;
        }

        @Override
        public final Builder session(String session) {
            this.session = session;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ConfirmSignUpRequest build() {
            return new ConfirmSignUpRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ConfirmSignUpRequest> {
        public Builder clientId(String var1);

        public Builder secretHash(String var1);

        public Builder username(String var1);

        public Builder confirmationCode(String var1);

        public Builder forceAliasCreation(Boolean var1);

        public Builder analyticsMetadata(AnalyticsMetadataType var1);

        default public Builder analyticsMetadata(Consumer<AnalyticsMetadataType.Builder> analyticsMetadata) {
            return this.analyticsMetadata((AnalyticsMetadataType)((AnalyticsMetadataType.Builder)AnalyticsMetadataType.builder().applyMutation(analyticsMetadata)).build());
        }

        public Builder userContextData(UserContextDataType var1);

        default public Builder userContextData(Consumer<UserContextDataType.Builder> userContextData) {
            return this.userContextData((UserContextDataType)((UserContextDataType.Builder)UserContextDataType.builder().applyMutation(userContextData)).build());
        }

        public Builder clientMetadata(Map<String, String> var1);

        public Builder session(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

