/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AuthFactorType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfiguredUserAuthFactorsListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserMFASettingListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetUserAuthFactorsResponse
extends CognitoIdentityProviderResponse
implements ToCopyableBuilder<Builder, GetUserAuthFactorsResponse> {
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Username").getter(GetUserAuthFactorsResponse.getter(GetUserAuthFactorsResponse::username)).setter(GetUserAuthFactorsResponse.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()}).build();
    private static final SdkField<String> PREFERRED_MFA_SETTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredMfaSetting").getter(GetUserAuthFactorsResponse.getter(GetUserAuthFactorsResponse::preferredMfaSetting)).setter(GetUserAuthFactorsResponse.setter(Builder::preferredMfaSetting)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMfaSetting").build()}).build();
    private static final SdkField<List<String>> USER_MFA_SETTING_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserMFASettingList").getter(GetUserAuthFactorsResponse.getter(GetUserAuthFactorsResponse::userMFASettingList)).setter(GetUserAuthFactorsResponse.setter(Builder::userMFASettingList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserMFASettingList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CONFIGURED_USER_AUTH_FACTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConfiguredUserAuthFactors").getter(GetUserAuthFactorsResponse.getter(GetUserAuthFactorsResponse::configuredUserAuthFactorsAsStrings)).setter(GetUserAuthFactorsResponse.setter(Builder::configuredUserAuthFactorsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfiguredUserAuthFactors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USERNAME_FIELD, PREFERRED_MFA_SETTING_FIELD, USER_MFA_SETTING_LIST_FIELD, CONFIGURED_USER_AUTH_FACTORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetUserAuthFactorsResponse.memberNameToFieldInitializer();
    private final String username;
    private final String preferredMfaSetting;
    private final List<String> userMFASettingList;
    private final List<String> configuredUserAuthFactors;

    private GetUserAuthFactorsResponse(BuilderImpl builder) {
        super(builder);
        this.username = builder.username;
        this.preferredMfaSetting = builder.preferredMfaSetting;
        this.userMFASettingList = builder.userMFASettingList;
        this.configuredUserAuthFactors = builder.configuredUserAuthFactors;
    }

    public final String username() {
        return this.username;
    }

    public final String preferredMfaSetting() {
        return this.preferredMfaSetting;
    }

    public final boolean hasUserMFASettingList() {
        return this.userMFASettingList != null && !(this.userMFASettingList instanceof SdkAutoConstructList);
    }

    public final List<String> userMFASettingList() {
        return this.userMFASettingList;
    }

    public final List<AuthFactorType> configuredUserAuthFactors() {
        return ConfiguredUserAuthFactorsListTypeCopier.copyStringToEnum(this.configuredUserAuthFactors);
    }

    public final boolean hasConfiguredUserAuthFactors() {
        return this.configuredUserAuthFactors != null && !(this.configuredUserAuthFactors instanceof SdkAutoConstructList);
    }

    public final List<String> configuredUserAuthFactorsAsStrings() {
        return this.configuredUserAuthFactors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredMfaSetting());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserMFASettingList() ? this.userMFASettingList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfiguredUserAuthFactors() ? this.configuredUserAuthFactorsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUserAuthFactorsResponse)) {
            return false;
        }
        GetUserAuthFactorsResponse other = (GetUserAuthFactorsResponse)((Object)obj);
        return Objects.equals(this.username(), other.username()) && Objects.equals(this.preferredMfaSetting(), other.preferredMfaSetting()) && this.hasUserMFASettingList() == other.hasUserMFASettingList() && Objects.equals(this.userMFASettingList(), other.userMFASettingList()) && this.hasConfiguredUserAuthFactors() == other.hasConfiguredUserAuthFactors() && Objects.equals(this.configuredUserAuthFactorsAsStrings(), other.configuredUserAuthFactorsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"GetUserAuthFactorsResponse").add("Username", (Object)(this.username() == null ? null : "*** Sensitive Data Redacted ***")).add("PreferredMfaSetting", (Object)this.preferredMfaSetting()).add("UserMFASettingList", this.hasUserMFASettingList() ? this.userMFASettingList() : null).add("ConfiguredUserAuthFactors", this.hasConfiguredUserAuthFactors() ? this.configuredUserAuthFactorsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "PreferredMfaSetting": {
                return Optional.ofNullable(clazz.cast(this.preferredMfaSetting()));
            }
            case "UserMFASettingList": {
                return Optional.ofNullable(clazz.cast(this.userMFASettingList()));
            }
            case "ConfiguredUserAuthFactors": {
                return Optional.ofNullable(clazz.cast(this.configuredUserAuthFactorsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Username", USERNAME_FIELD);
        map.put("PreferredMfaSetting", PREFERRED_MFA_SETTING_FIELD);
        map.put("UserMFASettingList", USER_MFA_SETTING_LIST_FIELD);
        map.put("ConfiguredUserAuthFactors", CONFIGURED_USER_AUTH_FACTORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetUserAuthFactorsResponse, T> g) {
        return obj -> g.apply((GetUserAuthFactorsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderResponse.BuilderImpl
    implements Builder {
        private String username;
        private String preferredMfaSetting;
        private List<String> userMFASettingList = DefaultSdkAutoConstructList.getInstance();
        private List<String> configuredUserAuthFactors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetUserAuthFactorsResponse model) {
            super(model);
            this.username(model.username);
            this.preferredMfaSetting(model.preferredMfaSetting);
            this.userMFASettingList(model.userMFASettingList);
            this.configuredUserAuthFactorsWithStrings(model.configuredUserAuthFactors);
        }

        public final String getUsername() {
            return this.username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final String getPreferredMfaSetting() {
            return this.preferredMfaSetting;
        }

        public final void setPreferredMfaSetting(String preferredMfaSetting) {
            this.preferredMfaSetting = preferredMfaSetting;
        }

        @Override
        public final Builder preferredMfaSetting(String preferredMfaSetting) {
            this.preferredMfaSetting = preferredMfaSetting;
            return this;
        }

        public final Collection<String> getUserMFASettingList() {
            if (this.userMFASettingList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.userMFASettingList;
        }

        public final void setUserMFASettingList(Collection<String> userMFASettingList) {
            this.userMFASettingList = UserMFASettingListTypeCopier.copy(userMFASettingList);
        }

        @Override
        public final Builder userMFASettingList(Collection<String> userMFASettingList) {
            this.userMFASettingList = UserMFASettingListTypeCopier.copy(userMFASettingList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userMFASettingList(String ... userMFASettingList) {
            this.userMFASettingList(Arrays.asList(userMFASettingList));
            return this;
        }

        public final Collection<String> getConfiguredUserAuthFactors() {
            if (this.configuredUserAuthFactors instanceof SdkAutoConstructList) {
                return null;
            }
            return this.configuredUserAuthFactors;
        }

        public final void setConfiguredUserAuthFactors(Collection<String> configuredUserAuthFactors) {
            this.configuredUserAuthFactors = ConfiguredUserAuthFactorsListTypeCopier.copy(configuredUserAuthFactors);
        }

        @Override
        public final Builder configuredUserAuthFactorsWithStrings(Collection<String> configuredUserAuthFactors) {
            this.configuredUserAuthFactors = ConfiguredUserAuthFactorsListTypeCopier.copy(configuredUserAuthFactors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configuredUserAuthFactorsWithStrings(String ... configuredUserAuthFactors) {
            this.configuredUserAuthFactorsWithStrings(Arrays.asList(configuredUserAuthFactors));
            return this;
        }

        @Override
        public final Builder configuredUserAuthFactors(Collection<AuthFactorType> configuredUserAuthFactors) {
            this.configuredUserAuthFactors = ConfiguredUserAuthFactorsListTypeCopier.copyEnumToString(configuredUserAuthFactors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configuredUserAuthFactors(AuthFactorType ... configuredUserAuthFactors) {
            this.configuredUserAuthFactors(Arrays.asList(configuredUserAuthFactors));
            return this;
        }

        @Override
        public GetUserAuthFactorsResponse build() {
            return new GetUserAuthFactorsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetUserAuthFactorsResponse> {
        public Builder username(String var1);

        public Builder preferredMfaSetting(String var1);

        public Builder userMFASettingList(Collection<String> var1);

        public Builder userMFASettingList(String ... var1);

        public Builder configuredUserAuthFactorsWithStrings(Collection<String> var1);

        public Builder configuredUserAuthFactorsWithStrings(String ... var1);

        public Builder configuredUserAuthFactors(Collection<AuthFactorType> var1);

        public Builder configuredUserAuthFactors(AuthFactorType ... var1);
    }
}

