/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a set of terms documents. For more information, see <a href=
 * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-managed-login.html#managed-login-terms-documents"
 * >Terms documents</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TermsDescriptionType implements SdkPojo, Serializable,
        ToCopyableBuilder<TermsDescriptionType.Builder, TermsDescriptionType> {
    private static final SdkField<String> TERMS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TermsId").getter(getter(TermsDescriptionType::termsId)).setter(setter(Builder::termsId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TermsId").build()).build();

    private static final SdkField<String> TERMS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TermsName").getter(getter(TermsDescriptionType::termsName)).setter(setter(Builder::termsName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TermsName").build()).build();

    private static final SdkField<String> ENFORCEMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Enforcement").getter(getter(TermsDescriptionType::enforcementAsString))
            .setter(setter(Builder::enforcement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enforcement").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationDate").getter(getter(TermsDescriptionType::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedDate").getter(getter(TermsDescriptionType::lastModifiedDate))
            .setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TERMS_ID_FIELD,
            TERMS_NAME_FIELD, ENFORCEMENT_FIELD, CREATION_DATE_FIELD, LAST_MODIFIED_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String termsId;

    private final String termsName;

    private final String enforcement;

    private final Instant creationDate;

    private final Instant lastModifiedDate;

    private TermsDescriptionType(BuilderImpl builder) {
        this.termsId = builder.termsId;
        this.termsName = builder.termsName;
        this.enforcement = builder.enforcement;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
    }

    /**
     * <p>
     * The ID of the requested terms documents.
     * </p>
     * 
     * @return The ID of the requested terms documents.
     */
    public final String termsId() {
        return termsId;
    }

    /**
     * <p>
     * The type and friendly name of the requested terms documents.
     * </p>
     * 
     * @return The type and friendly name of the requested terms documents.
     */
    public final String termsName() {
        return termsName;
    }

    /**
     * <p>
     * This parameter is reserved for future use and currently accepts one value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #enforcement} will
     * return {@link TermsEnforcementType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #enforcementAsString}.
     * </p>
     * 
     * @return This parameter is reserved for future use and currently accepts one value.
     * @see TermsEnforcementType
     */
    public final TermsEnforcementType enforcement() {
        return TermsEnforcementType.fromValue(enforcement);
    }

    /**
     * <p>
     * This parameter is reserved for future use and currently accepts one value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #enforcement} will
     * return {@link TermsEnforcementType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #enforcementAsString}.
     * </p>
     * 
     * @return This parameter is reserved for future use and currently accepts one value.
     * @see TermsEnforcementType
     */
    public final String enforcementAsString() {
        return enforcement;
    }

    /**
     * <p>
     * The date and time when the item was created. Amazon Cognito returns this timestamp in UNIX epoch time format.
     * Your SDK might render the output in a human-readable format like ISO 8601 or a Java <code>Date</code> object.
     * </p>
     * 
     * @return The date and time when the item was created. Amazon Cognito returns this timestamp in UNIX epoch time
     *         format. Your SDK might render the output in a human-readable format like ISO 8601 or a Java
     *         <code>Date</code> object.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The date and time when the item was modified. Amazon Cognito returns this timestamp in UNIX epoch time format.
     * Your SDK might render the output in a human-readable format like ISO 8601 or a Java <code>Date</code> object.
     * </p>
     * 
     * @return The date and time when the item was modified. Amazon Cognito returns this timestamp in UNIX epoch time
     *         format. Your SDK might render the output in a human-readable format like ISO 8601 or a Java
     *         <code>Date</code> object.
     */
    public final Instant lastModifiedDate() {
        return lastModifiedDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(termsId());
        hashCode = 31 * hashCode + Objects.hashCode(termsName());
        hashCode = 31 * hashCode + Objects.hashCode(enforcementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TermsDescriptionType)) {
            return false;
        }
        TermsDescriptionType other = (TermsDescriptionType) obj;
        return Objects.equals(termsId(), other.termsId()) && Objects.equals(termsName(), other.termsName())
                && Objects.equals(enforcementAsString(), other.enforcementAsString())
                && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TermsDescriptionType").add("TermsId", termsId()).add("TermsName", termsName())
                .add("Enforcement", enforcementAsString()).add("CreationDate", creationDate())
                .add("LastModifiedDate", lastModifiedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TermsId":
            return Optional.ofNullable(clazz.cast(termsId()));
        case "TermsName":
            return Optional.ofNullable(clazz.cast(termsName()));
        case "Enforcement":
            return Optional.ofNullable(clazz.cast(enforcementAsString()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TermsId", TERMS_ID_FIELD);
        map.put("TermsName", TERMS_NAME_FIELD);
        map.put("Enforcement", ENFORCEMENT_FIELD);
        map.put("CreationDate", CREATION_DATE_FIELD);
        map.put("LastModifiedDate", LAST_MODIFIED_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TermsDescriptionType, T> g) {
        return obj -> g.apply((TermsDescriptionType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TermsDescriptionType> {
        /**
         * <p>
         * The ID of the requested terms documents.
         * </p>
         * 
         * @param termsId
         *        The ID of the requested terms documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder termsId(String termsId);

        /**
         * <p>
         * The type and friendly name of the requested terms documents.
         * </p>
         * 
         * @param termsName
         *        The type and friendly name of the requested terms documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder termsName(String termsName);

        /**
         * <p>
         * This parameter is reserved for future use and currently accepts one value.
         * </p>
         * 
         * @param enforcement
         *        This parameter is reserved for future use and currently accepts one value.
         * @see TermsEnforcementType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TermsEnforcementType
         */
        Builder enforcement(String enforcement);

        /**
         * <p>
         * This parameter is reserved for future use and currently accepts one value.
         * </p>
         * 
         * @param enforcement
         *        This parameter is reserved for future use and currently accepts one value.
         * @see TermsEnforcementType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TermsEnforcementType
         */
        Builder enforcement(TermsEnforcementType enforcement);

        /**
         * <p>
         * The date and time when the item was created. Amazon Cognito returns this timestamp in UNIX epoch time format.
         * Your SDK might render the output in a human-readable format like ISO 8601 or a Java <code>Date</code> object.
         * </p>
         * 
         * @param creationDate
         *        The date and time when the item was created. Amazon Cognito returns this timestamp in UNIX epoch time
         *        format. Your SDK might render the output in a human-readable format like ISO 8601 or a Java
         *        <code>Date</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The date and time when the item was modified. Amazon Cognito returns this timestamp in UNIX epoch time
         * format. Your SDK might render the output in a human-readable format like ISO 8601 or a Java <code>Date</code>
         * object.
         * </p>
         * 
         * @param lastModifiedDate
         *        The date and time when the item was modified. Amazon Cognito returns this timestamp in UNIX epoch time
         *        format. Your SDK might render the output in a human-readable format like ISO 8601 or a Java
         *        <code>Date</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Instant lastModifiedDate);
    }

    static final class BuilderImpl implements Builder {
        private String termsId;

        private String termsName;

        private String enforcement;

        private Instant creationDate;

        private Instant lastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(TermsDescriptionType model) {
            termsId(model.termsId);
            termsName(model.termsName);
            enforcement(model.enforcement);
            creationDate(model.creationDate);
            lastModifiedDate(model.lastModifiedDate);
        }

        public final String getTermsId() {
            return termsId;
        }

        public final void setTermsId(String termsId) {
            this.termsId = termsId;
        }

        @Override
        public final Builder termsId(String termsId) {
            this.termsId = termsId;
            return this;
        }

        public final String getTermsName() {
            return termsName;
        }

        public final void setTermsName(String termsName) {
            this.termsName = termsName;
        }

        @Override
        public final Builder termsName(String termsName) {
            this.termsName = termsName;
            return this;
        }

        public final String getEnforcement() {
            return enforcement;
        }

        public final void setEnforcement(String enforcement) {
            this.enforcement = enforcement;
        }

        @Override
        public final Builder enforcement(String enforcement) {
            this.enforcement = enforcement;
            return this;
        }

        @Override
        public final Builder enforcement(TermsEnforcementType enforcement) {
            this.enforcement(enforcement == null ? null : enforcement.toString());
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getLastModifiedDate() {
            return lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        @Override
        public TermsDescriptionType build() {
            return new TermsDescriptionType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
