/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentityprovider.model.NewDeviceMetadataType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuthenticationResultType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AuthenticationResultType> {
    private static final SdkField<String> ACCESS_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessToken").getter(AuthenticationResultType.getter(AuthenticationResultType::accessToken)).setter(AuthenticationResultType.setter(Builder::accessToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessToken").build()}).build();
    private static final SdkField<Integer> EXPIRES_IN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ExpiresIn").getter(AuthenticationResultType.getter(AuthenticationResultType::expiresIn)).setter(AuthenticationResultType.setter(Builder::expiresIn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpiresIn").build()}).build();
    private static final SdkField<String> TOKEN_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TokenType").getter(AuthenticationResultType.getter(AuthenticationResultType::tokenType)).setter(AuthenticationResultType.setter(Builder::tokenType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenType").build()}).build();
    private static final SdkField<String> REFRESH_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RefreshToken").getter(AuthenticationResultType.getter(AuthenticationResultType::refreshToken)).setter(AuthenticationResultType.setter(Builder::refreshToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshToken").build()}).build();
    private static final SdkField<String> ID_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdToken").getter(AuthenticationResultType.getter(AuthenticationResultType::idToken)).setter(AuthenticationResultType.setter(Builder::idToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdToken").build()}).build();
    private static final SdkField<NewDeviceMetadataType> NEW_DEVICE_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NewDeviceMetadata").getter(AuthenticationResultType.getter(AuthenticationResultType::newDeviceMetadata)).setter(AuthenticationResultType.setter(Builder::newDeviceMetadata)).constructor(NewDeviceMetadataType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewDeviceMetadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_TOKEN_FIELD, EXPIRES_IN_FIELD, TOKEN_TYPE_FIELD, REFRESH_TOKEN_FIELD, ID_TOKEN_FIELD, NEW_DEVICE_METADATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AuthenticationResultType.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String accessToken;
    private final Integer expiresIn;
    private final String tokenType;
    private final String refreshToken;
    private final String idToken;
    private final NewDeviceMetadataType newDeviceMetadata;

    private AuthenticationResultType(BuilderImpl builder) {
        this.accessToken = builder.accessToken;
        this.expiresIn = builder.expiresIn;
        this.tokenType = builder.tokenType;
        this.refreshToken = builder.refreshToken;
        this.idToken = builder.idToken;
        this.newDeviceMetadata = builder.newDeviceMetadata;
    }

    public final String accessToken() {
        return this.accessToken;
    }

    public final Integer expiresIn() {
        return this.expiresIn;
    }

    public final String tokenType() {
        return this.tokenType;
    }

    public final String refreshToken() {
        return this.refreshToken;
    }

    public final String idToken() {
        return this.idToken;
    }

    public final NewDeviceMetadataType newDeviceMetadata() {
        return this.newDeviceMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiresIn());
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenType());
        hashCode = 31 * hashCode + Objects.hashCode(this.refreshToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.idToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.newDeviceMetadata());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthenticationResultType)) {
            return false;
        }
        AuthenticationResultType other = (AuthenticationResultType)obj;
        return Objects.equals(this.accessToken(), other.accessToken()) && Objects.equals(this.expiresIn(), other.expiresIn()) && Objects.equals(this.tokenType(), other.tokenType()) && Objects.equals(this.refreshToken(), other.refreshToken()) && Objects.equals(this.idToken(), other.idToken()) && Objects.equals(this.newDeviceMetadata(), other.newDeviceMetadata());
    }

    public final String toString() {
        return ToString.builder((String)"AuthenticationResultType").add("AccessToken", (Object)(this.accessToken() == null ? null : "*** Sensitive Data Redacted ***")).add("ExpiresIn", (Object)this.expiresIn()).add("TokenType", (Object)this.tokenType()).add("RefreshToken", (Object)(this.refreshToken() == null ? null : "*** Sensitive Data Redacted ***")).add("IdToken", (Object)(this.idToken() == null ? null : "*** Sensitive Data Redacted ***")).add("NewDeviceMetadata", (Object)this.newDeviceMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessToken": {
                return Optional.ofNullable(clazz.cast(this.accessToken()));
            }
            case "ExpiresIn": {
                return Optional.ofNullable(clazz.cast(this.expiresIn()));
            }
            case "TokenType": {
                return Optional.ofNullable(clazz.cast(this.tokenType()));
            }
            case "RefreshToken": {
                return Optional.ofNullable(clazz.cast(this.refreshToken()));
            }
            case "IdToken": {
                return Optional.ofNullable(clazz.cast(this.idToken()));
            }
            case "NewDeviceMetadata": {
                return Optional.ofNullable(clazz.cast(this.newDeviceMetadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AccessToken", ACCESS_TOKEN_FIELD);
        map.put("ExpiresIn", EXPIRES_IN_FIELD);
        map.put("TokenType", TOKEN_TYPE_FIELD);
        map.put("RefreshToken", REFRESH_TOKEN_FIELD);
        map.put("IdToken", ID_TOKEN_FIELD);
        map.put("NewDeviceMetadata", NEW_DEVICE_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuthenticationResultType, T> g) {
        return obj -> g.apply((AuthenticationResultType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accessToken;
        private Integer expiresIn;
        private String tokenType;
        private String refreshToken;
        private String idToken;
        private NewDeviceMetadataType newDeviceMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthenticationResultType model) {
            this.accessToken(model.accessToken);
            this.expiresIn(model.expiresIn);
            this.tokenType(model.tokenType);
            this.refreshToken(model.refreshToken);
            this.idToken(model.idToken);
            this.newDeviceMetadata(model.newDeviceMetadata);
        }

        public final String getAccessToken() {
            return this.accessToken;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final Integer getExpiresIn() {
            return this.expiresIn;
        }

        public final void setExpiresIn(Integer expiresIn) {
            this.expiresIn = expiresIn;
        }

        @Override
        public final Builder expiresIn(Integer expiresIn) {
            this.expiresIn = expiresIn;
            return this;
        }

        public final String getTokenType() {
            return this.tokenType;
        }

        public final void setTokenType(String tokenType) {
            this.tokenType = tokenType;
        }

        @Override
        public final Builder tokenType(String tokenType) {
            this.tokenType = tokenType;
            return this;
        }

        public final String getRefreshToken() {
            return this.refreshToken;
        }

        public final void setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
        }

        @Override
        public final Builder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public final String getIdToken() {
            return this.idToken;
        }

        public final void setIdToken(String idToken) {
            this.idToken = idToken;
        }

        @Override
        public final Builder idToken(String idToken) {
            this.idToken = idToken;
            return this;
        }

        public final NewDeviceMetadataType.Builder getNewDeviceMetadata() {
            return this.newDeviceMetadata != null ? this.newDeviceMetadata.toBuilder() : null;
        }

        public final void setNewDeviceMetadata(NewDeviceMetadataType.BuilderImpl newDeviceMetadata) {
            this.newDeviceMetadata = newDeviceMetadata != null ? newDeviceMetadata.build() : null;
        }

        @Override
        public final Builder newDeviceMetadata(NewDeviceMetadataType newDeviceMetadata) {
            this.newDeviceMetadata = newDeviceMetadata;
            return this;
        }

        public AuthenticationResultType build() {
            return new AuthenticationResultType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AuthenticationResultType> {
        public Builder accessToken(String var1);

        public Builder expiresIn(Integer var1);

        public Builder tokenType(String var1);

        public Builder refreshToken(String var1);

        public Builder idToken(String var1);

        public Builder newDeviceMetadata(NewDeviceMetadataType var1);

        default public Builder newDeviceMetadata(Consumer<NewDeviceMetadataType.Builder> newDeviceMetadata) {
            return this.newDeviceMetadata((NewDeviceMetadataType)((NewDeviceMetadataType.Builder)NewDeviceMetadataType.builder().applyMutation(newDeviceMetadata)).build());
        }
    }
}

