/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cognitoidentityprovider.CognitoIdentityProviderAsyncClient;
import software.amazon.awssdk.services.cognitoidentityprovider.internal.UserAgentUtils;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersInGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersInGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserType;

public class ListUsersInGroupPublisher
implements SdkPublisher<ListUsersInGroupResponse> {
    private final CognitoIdentityProviderAsyncClient client;
    private final ListUsersInGroupRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListUsersInGroupPublisher(CognitoIdentityProviderAsyncClient client, ListUsersInGroupRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListUsersInGroupPublisher(CognitoIdentityProviderAsyncClient client, ListUsersInGroupRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListUsersInGroupResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListUsersInGroupResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<UserType> users() {
        Function<ListUsersInGroupResponse, Iterator> getIterator = response -> {
            if (response != null && response.users() != null) {
                return response.users().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListUsersInGroupResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListUsersInGroupResponseFetcher
    implements AsyncPageFetcher<ListUsersInGroupResponse> {
        private ListUsersInGroupResponseFetcher() {
        }

        public boolean hasNextPage(ListUsersInGroupResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListUsersInGroupResponse> nextPage(ListUsersInGroupResponse previousPage) {
            if (previousPage == null) {
                return ListUsersInGroupPublisher.this.client.listUsersInGroup(ListUsersInGroupPublisher.this.firstRequest);
            }
            return ListUsersInGroupPublisher.this.client.listUsersInGroup((ListUsersInGroupRequest)((Object)ListUsersInGroupPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

