/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LogLevel {
    ERROR("ERROR"),
    INFO("INFO"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LogLevel> VALUE_MAP;
    private final String value;

    private LogLevel(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LogLevel fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LogLevel> knownValues() {
        EnumSet<LogLevel> knownValues = EnumSet.allOf(LogLevel.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LogLevel.class, LogLevel::toString);
    }
}

