/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum MatchOption {
    EQUALS("EQUALS"),
    STARTS_WITH("STARTS_WITH"),
    ENDS_WITH("ENDS_WITH"),
    CONTAINS("CONTAINS"),
    CASE_SENSITIVE("CASE_SENSITIVE"),
    CASE_INSENSITIVE("CASE_INSENSITIVE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private MatchOption(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MatchOption fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(MatchOption.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MatchOption> knownValues() {
        return Stream.of(MatchOption.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

