/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum SourceRepository {
    CODE_COMMIT("CodeCommit"),
    S3("S3"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private SourceRepository(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SourceRepository fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(SourceRepository.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SourceRepository> knownValues() {
        return Stream.of(SourceRepository.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

