/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fsx.model.FSxResponse;
import software.amazon.awssdk.services.fsx.model.FileSystem;
import software.amazon.awssdk.services.fsx.model.FileSystemsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeFileSystemsResponse
extends FSxResponse
implements ToCopyableBuilder<Builder, DescribeFileSystemsResponse> {
    private static final SdkField<List<FileSystem>> FILE_SYSTEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeFileSystemsResponse.getter(DescribeFileSystemsResponse::fileSystems)).setter(DescribeFileSystemsResponse.setter(Builder::fileSystems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FileSystem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeFileSystemsResponse.getter(DescribeFileSystemsResponse::nextToken)).setter(DescribeFileSystemsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SYSTEMS_FIELD, NEXT_TOKEN_FIELD));
    private final List<FileSystem> fileSystems;
    private final String nextToken;

    private DescribeFileSystemsResponse(BuilderImpl builder) {
        super(builder);
        this.fileSystems = builder.fileSystems;
        this.nextToken = builder.nextToken;
    }

    public boolean hasFileSystems() {
        return this.fileSystems != null && !(this.fileSystems instanceof SdkAutoConstructList);
    }

    public List<FileSystem> fileSystems() {
        return this.fileSystems;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystems());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFileSystemsResponse)) {
            return false;
        }
        DescribeFileSystemsResponse other = (DescribeFileSystemsResponse)((Object)obj);
        return Objects.equals(this.fileSystems(), other.fileSystems()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeFileSystemsResponse").add("FileSystems", this.fileSystems()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FileSystems": {
                return Optional.ofNullable(clazz.cast(this.fileSystems()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFileSystemsResponse, T> g) {
        return obj -> g.apply((DescribeFileSystemsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FSxResponse.BuilderImpl
    implements Builder {
        private List<FileSystem> fileSystems = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFileSystemsResponse model) {
            super(model);
            this.fileSystems(model.fileSystems);
            this.nextToken(model.nextToken);
        }

        public final Collection<FileSystem.Builder> getFileSystems() {
            return this.fileSystems != null ? (Collection)this.fileSystems.stream().map(FileSystem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder fileSystems(Collection<FileSystem> fileSystems) {
            this.fileSystems = FileSystemsCopier.copy(fileSystems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystems(FileSystem ... fileSystems) {
            this.fileSystems(Arrays.asList(fileSystems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystems(Consumer<FileSystem.Builder> ... fileSystems) {
            this.fileSystems(Stream.of(fileSystems).map(c -> (FileSystem)((FileSystem.Builder)FileSystem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFileSystems(Collection<FileSystem.BuilderImpl> fileSystems) {
            this.fileSystems = FileSystemsCopier.copyFromBuilder(fileSystems);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeFileSystemsResponse build() {
            return new DescribeFileSystemsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FSxResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeFileSystemsResponse> {
        public Builder fileSystems(Collection<FileSystem> var1);

        public Builder fileSystems(FileSystem ... var1);

        public Builder fileSystems(Consumer<FileSystem.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

