/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PasswordPolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PasswordPolicy> {
    private static final SdkField<Integer> MINIMUM_PASSWORD_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(PasswordPolicy.getter(PasswordPolicy::minimumPasswordLength)).setter(PasswordPolicy.setter(Builder::minimumPasswordLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumPasswordLength").build()}).build();
    private static final SdkField<Boolean> REQUIRE_SYMBOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(PasswordPolicy.getter(PasswordPolicy::requireSymbols)).setter(PasswordPolicy.setter(Builder::requireSymbols)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequireSymbols").build()}).build();
    private static final SdkField<Boolean> REQUIRE_NUMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(PasswordPolicy.getter(PasswordPolicy::requireNumbers)).setter(PasswordPolicy.setter(Builder::requireNumbers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequireNumbers").build()}).build();
    private static final SdkField<Boolean> REQUIRE_UPPERCASE_CHARACTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(PasswordPolicy.getter(PasswordPolicy::requireUppercaseCharacters)).setter(PasswordPolicy.setter(Builder::requireUppercaseCharacters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequireUppercaseCharacters").build()}).build();
    private static final SdkField<Boolean> REQUIRE_LOWERCASE_CHARACTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(PasswordPolicy.getter(PasswordPolicy::requireLowercaseCharacters)).setter(PasswordPolicy.setter(Builder::requireLowercaseCharacters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequireLowercaseCharacters").build()}).build();
    private static final SdkField<Boolean> ALLOW_USERS_TO_CHANGE_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(PasswordPolicy.getter(PasswordPolicy::allowUsersToChangePassword)).setter(PasswordPolicy.setter(Builder::allowUsersToChangePassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowUsersToChangePassword").build()}).build();
    private static final SdkField<Boolean> EXPIRE_PASSWORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(PasswordPolicy.getter(PasswordPolicy::expirePasswords)).setter(PasswordPolicy.setter(Builder::expirePasswords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirePasswords").build()}).build();
    private static final SdkField<Integer> MAX_PASSWORD_AGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(PasswordPolicy.getter(PasswordPolicy::maxPasswordAge)).setter(PasswordPolicy.setter(Builder::maxPasswordAge)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxPasswordAge").build()}).build();
    private static final SdkField<Integer> PASSWORD_REUSE_PREVENTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(PasswordPolicy.getter(PasswordPolicy::passwordReusePrevention)).setter(PasswordPolicy.setter(Builder::passwordReusePrevention)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PasswordReusePrevention").build()}).build();
    private static final SdkField<Boolean> HARD_EXPIRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(PasswordPolicy.getter(PasswordPolicy::hardExpiry)).setter(PasswordPolicy.setter(Builder::hardExpiry)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HardExpiry").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MINIMUM_PASSWORD_LENGTH_FIELD, REQUIRE_SYMBOLS_FIELD, REQUIRE_NUMBERS_FIELD, REQUIRE_UPPERCASE_CHARACTERS_FIELD, REQUIRE_LOWERCASE_CHARACTERS_FIELD, ALLOW_USERS_TO_CHANGE_PASSWORD_FIELD, EXPIRE_PASSWORDS_FIELD, MAX_PASSWORD_AGE_FIELD, PASSWORD_REUSE_PREVENTION_FIELD, HARD_EXPIRY_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer minimumPasswordLength;
    private final Boolean requireSymbols;
    private final Boolean requireNumbers;
    private final Boolean requireUppercaseCharacters;
    private final Boolean requireLowercaseCharacters;
    private final Boolean allowUsersToChangePassword;
    private final Boolean expirePasswords;
    private final Integer maxPasswordAge;
    private final Integer passwordReusePrevention;
    private final Boolean hardExpiry;

    private PasswordPolicy(BuilderImpl builder) {
        this.minimumPasswordLength = builder.minimumPasswordLength;
        this.requireSymbols = builder.requireSymbols;
        this.requireNumbers = builder.requireNumbers;
        this.requireUppercaseCharacters = builder.requireUppercaseCharacters;
        this.requireLowercaseCharacters = builder.requireLowercaseCharacters;
        this.allowUsersToChangePassword = builder.allowUsersToChangePassword;
        this.expirePasswords = builder.expirePasswords;
        this.maxPasswordAge = builder.maxPasswordAge;
        this.passwordReusePrevention = builder.passwordReusePrevention;
        this.hardExpiry = builder.hardExpiry;
    }

    public Integer minimumPasswordLength() {
        return this.minimumPasswordLength;
    }

    public Boolean requireSymbols() {
        return this.requireSymbols;
    }

    public Boolean requireNumbers() {
        return this.requireNumbers;
    }

    public Boolean requireUppercaseCharacters() {
        return this.requireUppercaseCharacters;
    }

    public Boolean requireLowercaseCharacters() {
        return this.requireLowercaseCharacters;
    }

    public Boolean allowUsersToChangePassword() {
        return this.allowUsersToChangePassword;
    }

    public Boolean expirePasswords() {
        return this.expirePasswords;
    }

    public Integer maxPasswordAge() {
        return this.maxPasswordAge;
    }

    public Integer passwordReusePrevention() {
        return this.passwordReusePrevention;
    }

    public Boolean hardExpiry() {
        return this.hardExpiry;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumPasswordLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.requireSymbols());
        hashCode = 31 * hashCode + Objects.hashCode(this.requireNumbers());
        hashCode = 31 * hashCode + Objects.hashCode(this.requireUppercaseCharacters());
        hashCode = 31 * hashCode + Objects.hashCode(this.requireLowercaseCharacters());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowUsersToChangePassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirePasswords());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxPasswordAge());
        hashCode = 31 * hashCode + Objects.hashCode(this.passwordReusePrevention());
        hashCode = 31 * hashCode + Objects.hashCode(this.hardExpiry());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PasswordPolicy)) {
            return false;
        }
        PasswordPolicy other = (PasswordPolicy)obj;
        return Objects.equals(this.minimumPasswordLength(), other.minimumPasswordLength()) && Objects.equals(this.requireSymbols(), other.requireSymbols()) && Objects.equals(this.requireNumbers(), other.requireNumbers()) && Objects.equals(this.requireUppercaseCharacters(), other.requireUppercaseCharacters()) && Objects.equals(this.requireLowercaseCharacters(), other.requireLowercaseCharacters()) && Objects.equals(this.allowUsersToChangePassword(), other.allowUsersToChangePassword()) && Objects.equals(this.expirePasswords(), other.expirePasswords()) && Objects.equals(this.maxPasswordAge(), other.maxPasswordAge()) && Objects.equals(this.passwordReusePrevention(), other.passwordReusePrevention()) && Objects.equals(this.hardExpiry(), other.hardExpiry());
    }

    public String toString() {
        return ToString.builder((String)"PasswordPolicy").add("MinimumPasswordLength", (Object)this.minimumPasswordLength()).add("RequireSymbols", (Object)this.requireSymbols()).add("RequireNumbers", (Object)this.requireNumbers()).add("RequireUppercaseCharacters", (Object)this.requireUppercaseCharacters()).add("RequireLowercaseCharacters", (Object)this.requireLowercaseCharacters()).add("AllowUsersToChangePassword", (Object)this.allowUsersToChangePassword()).add("ExpirePasswords", (Object)this.expirePasswords()).add("MaxPasswordAge", (Object)this.maxPasswordAge()).add("PasswordReusePrevention", (Object)this.passwordReusePrevention()).add("HardExpiry", (Object)this.hardExpiry()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MinimumPasswordLength": {
                return Optional.ofNullable(clazz.cast(this.minimumPasswordLength()));
            }
            case "RequireSymbols": {
                return Optional.ofNullable(clazz.cast(this.requireSymbols()));
            }
            case "RequireNumbers": {
                return Optional.ofNullable(clazz.cast(this.requireNumbers()));
            }
            case "RequireUppercaseCharacters": {
                return Optional.ofNullable(clazz.cast(this.requireUppercaseCharacters()));
            }
            case "RequireLowercaseCharacters": {
                return Optional.ofNullable(clazz.cast(this.requireLowercaseCharacters()));
            }
            case "AllowUsersToChangePassword": {
                return Optional.ofNullable(clazz.cast(this.allowUsersToChangePassword()));
            }
            case "ExpirePasswords": {
                return Optional.ofNullable(clazz.cast(this.expirePasswords()));
            }
            case "MaxPasswordAge": {
                return Optional.ofNullable(clazz.cast(this.maxPasswordAge()));
            }
            case "PasswordReusePrevention": {
                return Optional.ofNullable(clazz.cast(this.passwordReusePrevention()));
            }
            case "HardExpiry": {
                return Optional.ofNullable(clazz.cast(this.hardExpiry()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PasswordPolicy, T> g) {
        return obj -> g.apply((PasswordPolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer minimumPasswordLength;
        private Boolean requireSymbols;
        private Boolean requireNumbers;
        private Boolean requireUppercaseCharacters;
        private Boolean requireLowercaseCharacters;
        private Boolean allowUsersToChangePassword;
        private Boolean expirePasswords;
        private Integer maxPasswordAge;
        private Integer passwordReusePrevention;
        private Boolean hardExpiry;

        private BuilderImpl() {
        }

        private BuilderImpl(PasswordPolicy model) {
            this.minimumPasswordLength(model.minimumPasswordLength);
            this.requireSymbols(model.requireSymbols);
            this.requireNumbers(model.requireNumbers);
            this.requireUppercaseCharacters(model.requireUppercaseCharacters);
            this.requireLowercaseCharacters(model.requireLowercaseCharacters);
            this.allowUsersToChangePassword(model.allowUsersToChangePassword);
            this.expirePasswords(model.expirePasswords);
            this.maxPasswordAge(model.maxPasswordAge);
            this.passwordReusePrevention(model.passwordReusePrevention);
            this.hardExpiry(model.hardExpiry);
        }

        public final Integer getMinimumPasswordLength() {
            return this.minimumPasswordLength;
        }

        @Override
        public final Builder minimumPasswordLength(Integer minimumPasswordLength) {
            this.minimumPasswordLength = minimumPasswordLength;
            return this;
        }

        public final void setMinimumPasswordLength(Integer minimumPasswordLength) {
            this.minimumPasswordLength = minimumPasswordLength;
        }

        public final Boolean getRequireSymbols() {
            return this.requireSymbols;
        }

        @Override
        public final Builder requireSymbols(Boolean requireSymbols) {
            this.requireSymbols = requireSymbols;
            return this;
        }

        public final void setRequireSymbols(Boolean requireSymbols) {
            this.requireSymbols = requireSymbols;
        }

        public final Boolean getRequireNumbers() {
            return this.requireNumbers;
        }

        @Override
        public final Builder requireNumbers(Boolean requireNumbers) {
            this.requireNumbers = requireNumbers;
            return this;
        }

        public final void setRequireNumbers(Boolean requireNumbers) {
            this.requireNumbers = requireNumbers;
        }

        public final Boolean getRequireUppercaseCharacters() {
            return this.requireUppercaseCharacters;
        }

        @Override
        public final Builder requireUppercaseCharacters(Boolean requireUppercaseCharacters) {
            this.requireUppercaseCharacters = requireUppercaseCharacters;
            return this;
        }

        public final void setRequireUppercaseCharacters(Boolean requireUppercaseCharacters) {
            this.requireUppercaseCharacters = requireUppercaseCharacters;
        }

        public final Boolean getRequireLowercaseCharacters() {
            return this.requireLowercaseCharacters;
        }

        @Override
        public final Builder requireLowercaseCharacters(Boolean requireLowercaseCharacters) {
            this.requireLowercaseCharacters = requireLowercaseCharacters;
            return this;
        }

        public final void setRequireLowercaseCharacters(Boolean requireLowercaseCharacters) {
            this.requireLowercaseCharacters = requireLowercaseCharacters;
        }

        public final Boolean getAllowUsersToChangePassword() {
            return this.allowUsersToChangePassword;
        }

        @Override
        public final Builder allowUsersToChangePassword(Boolean allowUsersToChangePassword) {
            this.allowUsersToChangePassword = allowUsersToChangePassword;
            return this;
        }

        public final void setAllowUsersToChangePassword(Boolean allowUsersToChangePassword) {
            this.allowUsersToChangePassword = allowUsersToChangePassword;
        }

        public final Boolean getExpirePasswords() {
            return this.expirePasswords;
        }

        @Override
        public final Builder expirePasswords(Boolean expirePasswords) {
            this.expirePasswords = expirePasswords;
            return this;
        }

        public final void setExpirePasswords(Boolean expirePasswords) {
            this.expirePasswords = expirePasswords;
        }

        public final Integer getMaxPasswordAge() {
            return this.maxPasswordAge;
        }

        @Override
        public final Builder maxPasswordAge(Integer maxPasswordAge) {
            this.maxPasswordAge = maxPasswordAge;
            return this;
        }

        public final void setMaxPasswordAge(Integer maxPasswordAge) {
            this.maxPasswordAge = maxPasswordAge;
        }

        public final Integer getPasswordReusePrevention() {
            return this.passwordReusePrevention;
        }

        @Override
        public final Builder passwordReusePrevention(Integer passwordReusePrevention) {
            this.passwordReusePrevention = passwordReusePrevention;
            return this;
        }

        public final void setPasswordReusePrevention(Integer passwordReusePrevention) {
            this.passwordReusePrevention = passwordReusePrevention;
        }

        public final Boolean getHardExpiry() {
            return this.hardExpiry;
        }

        @Override
        public final Builder hardExpiry(Boolean hardExpiry) {
            this.hardExpiry = hardExpiry;
            return this;
        }

        public final void setHardExpiry(Boolean hardExpiry) {
            this.hardExpiry = hardExpiry;
        }

        public PasswordPolicy build() {
            return new PasswordPolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PasswordPolicy> {
        public Builder minimumPasswordLength(Integer var1);

        public Builder requireSymbols(Boolean var1);

        public Builder requireNumbers(Boolean var1);

        public Builder requireUppercaseCharacters(Boolean var1);

        public Builder requireLowercaseCharacters(Boolean var1);

        public Builder allowUsersToChangePassword(Boolean var1);

        public Builder expirePasswords(Boolean var1);

        public Builder maxPasswordAge(Integer var1);

        public Builder passwordReusePrevention(Integer var1);

        public Builder hardExpiry(Boolean var1);
    }
}

