/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotthingsgraph.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotthingsgraph.model.DeploymentTarget;
import software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceDeploymentStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SystemInstanceSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SystemInstanceSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SystemInstanceSummary.getter(SystemInstanceSummary::id)).setter(SystemInstanceSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SystemInstanceSummary.getter(SystemInstanceSummary::arn)).setter(SystemInstanceSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SystemInstanceSummary.getter(SystemInstanceSummary::statusAsString)).setter(SystemInstanceSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SystemInstanceSummary.getter(SystemInstanceSummary::targetAsString)).setter(SystemInstanceSummary.setter(Builder::target)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()}).build();
    private static final SdkField<String> GREENGRASS_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SystemInstanceSummary.getter(SystemInstanceSummary::greengrassGroupName)).setter(SystemInstanceSummary.setter(Builder::greengrassGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("greengrassGroupName").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(SystemInstanceSummary.getter(SystemInstanceSummary::createdAt)).setter(SystemInstanceSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(SystemInstanceSummary.getter(SystemInstanceSummary::updatedAt)).setter(SystemInstanceSummary.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final SdkField<String> GREENGRASS_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SystemInstanceSummary.getter(SystemInstanceSummary::greengrassGroupId)).setter(SystemInstanceSummary.setter(Builder::greengrassGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("greengrassGroupId").build()}).build();
    private static final SdkField<String> GREENGRASS_GROUP_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SystemInstanceSummary.getter(SystemInstanceSummary::greengrassGroupVersionId)).setter(SystemInstanceSummary.setter(Builder::greengrassGroupVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("greengrassGroupVersionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, STATUS_FIELD, TARGET_FIELD, GREENGRASS_GROUP_NAME_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, GREENGRASS_GROUP_ID_FIELD, GREENGRASS_GROUP_VERSION_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String arn;
    private final String status;
    private final String target;
    private final String greengrassGroupName;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final String greengrassGroupId;
    private final String greengrassGroupVersionId;

    private SystemInstanceSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.status = builder.status;
        this.target = builder.target;
        this.greengrassGroupName = builder.greengrassGroupName;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.greengrassGroupId = builder.greengrassGroupId;
        this.greengrassGroupVersionId = builder.greengrassGroupVersionId;
    }

    public String id() {
        return this.id;
    }

    public String arn() {
        return this.arn;
    }

    public SystemInstanceDeploymentStatus status() {
        return SystemInstanceDeploymentStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public DeploymentTarget target() {
        return DeploymentTarget.fromValue(this.target);
    }

    public String targetAsString() {
        return this.target;
    }

    public String greengrassGroupName() {
        return this.greengrassGroupName;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public Instant updatedAt() {
        return this.updatedAt;
    }

    public String greengrassGroupId() {
        return this.greengrassGroupId;
    }

    public String greengrassGroupVersionId() {
        return this.greengrassGroupVersionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.greengrassGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.greengrassGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.greengrassGroupVersionId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SystemInstanceSummary)) {
            return false;
        }
        SystemInstanceSummary other = (SystemInstanceSummary)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.targetAsString(), other.targetAsString()) && Objects.equals(this.greengrassGroupName(), other.greengrassGroupName()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.greengrassGroupId(), other.greengrassGroupId()) && Objects.equals(this.greengrassGroupVersionId(), other.greengrassGroupVersionId());
    }

    public String toString() {
        return ToString.builder((String)"SystemInstanceSummary").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("Status", (Object)this.statusAsString()).add("Target", (Object)this.targetAsString()).add("GreengrassGroupName", (Object)this.greengrassGroupName()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("GreengrassGroupId", (Object)this.greengrassGroupId()).add("GreengrassGroupVersionId", (Object)this.greengrassGroupVersionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "target": {
                return Optional.ofNullable(clazz.cast(this.targetAsString()));
            }
            case "greengrassGroupName": {
                return Optional.ofNullable(clazz.cast(this.greengrassGroupName()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "greengrassGroupId": {
                return Optional.ofNullable(clazz.cast(this.greengrassGroupId()));
            }
            case "greengrassGroupVersionId": {
                return Optional.ofNullable(clazz.cast(this.greengrassGroupVersionId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SystemInstanceSummary, T> g) {
        return obj -> g.apply((SystemInstanceSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String status;
        private String target;
        private String greengrassGroupName;
        private Instant createdAt;
        private Instant updatedAt;
        private String greengrassGroupId;
        private String greengrassGroupVersionId;

        private BuilderImpl() {
        }

        private BuilderImpl(SystemInstanceSummary model) {
            this.id(model.id);
            this.arn(model.arn);
            this.status(model.status);
            this.target(model.target);
            this.greengrassGroupName(model.greengrassGroupName);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.greengrassGroupId(model.greengrassGroupId);
            this.greengrassGroupVersionId(model.greengrassGroupVersionId);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SystemInstanceDeploymentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getTarget() {
            return this.target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        @Override
        public final Builder target(DeploymentTarget target) {
            this.target(target == null ? null : target.toString());
            return this;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        public final String getGreengrassGroupName() {
            return this.greengrassGroupName;
        }

        @Override
        public final Builder greengrassGroupName(String greengrassGroupName) {
            this.greengrassGroupName = greengrassGroupName;
            return this;
        }

        public final void setGreengrassGroupName(String greengrassGroupName) {
            this.greengrassGroupName = greengrassGroupName;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        public final String getGreengrassGroupId() {
            return this.greengrassGroupId;
        }

        @Override
        public final Builder greengrassGroupId(String greengrassGroupId) {
            this.greengrassGroupId = greengrassGroupId;
            return this;
        }

        public final void setGreengrassGroupId(String greengrassGroupId) {
            this.greengrassGroupId = greengrassGroupId;
        }

        public final String getGreengrassGroupVersionId() {
            return this.greengrassGroupVersionId;
        }

        @Override
        public final Builder greengrassGroupVersionId(String greengrassGroupVersionId) {
            this.greengrassGroupVersionId = greengrassGroupVersionId;
            return this;
        }

        public final void setGreengrassGroupVersionId(String greengrassGroupVersionId) {
            this.greengrassGroupVersionId = greengrassGroupVersionId;
        }

        public SystemInstanceSummary build() {
            return new SystemInstanceSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SystemInstanceSummary> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder status(String var1);

        public Builder status(SystemInstanceDeploymentStatus var1);

        public Builder target(String var1);

        public Builder target(DeploymentTarget var1);

        public Builder greengrassGroupName(String var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder greengrassGroupId(String var1);

        public Builder greengrassGroupVersionId(String var1);
    }
}

