/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotthingsgraph.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotthingsgraph.IoTThingsGraphClient;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemTemplatesRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemTemplatesResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.SystemTemplateSummary;

public class SearchSystemTemplatesIterable
implements SdkIterable<SearchSystemTemplatesResponse> {
    private final IoTThingsGraphClient client;
    private final SearchSystemTemplatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchSystemTemplatesIterable(IoTThingsGraphClient client, SearchSystemTemplatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new SearchSystemTemplatesResponseFetcher();
    }

    public Iterator<SearchSystemTemplatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SystemTemplateSummary> summaries() {
        Function<SearchSystemTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.summaries() != null) {
                return response.summaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchSystemTemplatesResponseFetcher
    implements SyncPageFetcher<SearchSystemTemplatesResponse> {
        private SearchSystemTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(SearchSystemTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchSystemTemplatesResponse nextPage(SearchSystemTemplatesResponse previousPage) {
            if (previousPage == null) {
                return SearchSystemTemplatesIterable.this.client.searchSystemTemplates(SearchSystemTemplatesIterable.this.firstRequest);
            }
            return SearchSystemTemplatesIterable.this.client.searchSystemTemplates((SearchSystemTemplatesRequest)((Object)SearchSystemTemplatesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

