/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.outposts.OutpostsClient;
import software.amazon.awssdk.services.outposts.model.ListSitesRequest;
import software.amazon.awssdk.services.outposts.model.ListSitesResponse;

public class ListSitesIterable
implements SdkIterable<ListSitesResponse> {
    private final OutpostsClient client;
    private final ListSitesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSitesIterable(OutpostsClient client, ListSitesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListSitesResponseFetcher();
    }

    public Iterator<ListSitesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListSitesResponseFetcher
    implements SyncPageFetcher<ListSitesResponse> {
        private ListSitesResponseFetcher() {
        }

        public boolean hasNextPage(ListSitesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSitesResponse nextPage(ListSitesResponse previousPage) {
            if (previousPage == null) {
                return ListSitesIterable.this.client.listSites(ListSitesIterable.this.firstRequest);
            }
            return ListSitesIterable.this.client.listSites((ListSitesRequest)((Object)ListSitesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

