/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DBProxyStatus {
    AVAILABLE("available"),
    MODIFYING("modifying"),
    INCOMPATIBLE_NETWORK("incompatible-network"),
    INSUFFICIENT_RESOURCE_LIMITS("insufficient-resource-limits"),
    CREATING("creating"),
    DELETING("deleting"),
    SUSPENDED("suspended"),
    SUSPENDING("suspending"),
    REACTIVATING("reactivating"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DBProxyStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DBProxyStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DBProxyStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DBProxyStatus> knownValues() {
        return Stream.of(DBProxyStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

