/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rds.RdsClient;
import software.amazon.awssdk.services.rds.model.DBProxyTarget;
import software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetsResponse;

public class DescribeDBProxyTargetsIterable
implements SdkIterable<DescribeDbProxyTargetsResponse> {
    private final RdsClient client;
    private final DescribeDbProxyTargetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDBProxyTargetsIterable(RdsClient client, DescribeDbProxyTargetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeDbProxyTargetsResponseFetcher();
    }

    public Iterator<DescribeDbProxyTargetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DBProxyTarget> targets() {
        Function<DescribeDbProxyTargetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.targets() != null) {
                return response.targets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeDbProxyTargetsResponseFetcher
    implements SyncPageFetcher<DescribeDbProxyTargetsResponse> {
        private DescribeDbProxyTargetsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDbProxyTargetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeDbProxyTargetsResponse nextPage(DescribeDbProxyTargetsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBProxyTargetsIterable.this.client.describeDBProxyTargets(DescribeDBProxyTargetsIterable.this.firstRequest);
            }
            return DescribeDBProxyTargetsIterable.this.client.describeDBProxyTargets((DescribeDbProxyTargetsRequest)((Object)DescribeDBProxyTargetsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

