/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sfn.model.SfnRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SendTaskFailureRequest
extends SfnRequest
implements ToCopyableBuilder<Builder, SendTaskFailureRequest> {
    private static final SdkField<String> TASK_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SendTaskFailureRequest.getter(SendTaskFailureRequest::taskToken)).setter(SendTaskFailureRequest.setter(Builder::taskToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskToken").build()}).build();
    private static final SdkField<String> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SendTaskFailureRequest.getter(SendTaskFailureRequest::error)).setter(SendTaskFailureRequest.setter(Builder::error)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()}).build();
    private static final SdkField<String> CAUSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SendTaskFailureRequest.getter(SendTaskFailureRequest::cause)).setter(SendTaskFailureRequest.setter(Builder::cause)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cause").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_TOKEN_FIELD, ERROR_FIELD, CAUSE_FIELD));
    private final String taskToken;
    private final String error;
    private final String causeValue;

    private SendTaskFailureRequest(BuilderImpl builder) {
        super(builder);
        this.taskToken = builder.taskToken;
        this.error = builder.error;
        this.causeValue = builder.causeValue;
    }

    public String taskToken() {
        return this.taskToken;
    }

    public String error() {
        return this.error;
    }

    public String cause() {
        return this.causeValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.taskToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        hashCode = 31 * hashCode + Objects.hashCode(this.cause());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendTaskFailureRequest)) {
            return false;
        }
        SendTaskFailureRequest other = (SendTaskFailureRequest)((Object)obj);
        return Objects.equals(this.taskToken(), other.taskToken()) && Objects.equals(this.error(), other.error()) && Objects.equals(this.cause(), other.cause());
    }

    public String toString() {
        return ToString.builder((String)"SendTaskFailureRequest").add("TaskToken", (Object)this.taskToken()).add("Error", (Object)(this.error() == null ? null : "*** Sensitive Data Redacted ***")).add("Cause", (Object)(this.cause() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "taskToken": {
                return Optional.ofNullable(clazz.cast(this.taskToken()));
            }
            case "error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
            case "cause": {
                return Optional.ofNullable(clazz.cast(this.cause()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendTaskFailureRequest, T> g) {
        return obj -> g.apply((SendTaskFailureRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SfnRequest.BuilderImpl
    implements Builder {
        private String taskToken;
        private String error;
        private String causeValue;

        private BuilderImpl() {
        }

        private BuilderImpl(SendTaskFailureRequest model) {
            super(model);
            this.taskToken(model.taskToken);
            this.error(model.error);
            this.cause(model.causeValue);
        }

        public final String getTaskToken() {
            return this.taskToken;
        }

        @Override
        public final Builder taskToken(String taskToken) {
            this.taskToken = taskToken;
            return this;
        }

        public final void setTaskToken(String taskToken) {
            this.taskToken = taskToken;
        }

        public final String getError() {
            return this.error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        public final void setError(String error) {
            this.error = error;
        }

        public final String getCause() {
            return this.causeValue;
        }

        @Override
        public final Builder cause(String causeValue) {
            this.causeValue = causeValue;
            return this;
        }

        public final void setCause(String causeValue) {
            this.causeValue = causeValue;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendTaskFailureRequest build() {
            return new SendTaskFailureRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SfnRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SendTaskFailureRequest> {
        public Builder taskToken(String var1);

        public Builder error(String var1);

        public Builder cause(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

