/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of compliance information by compliance type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComplianceSummaryItem implements SdkPojo, Serializable,
        ToCopyableBuilder<ComplianceSummaryItem.Builder, ComplianceSummaryItem> {
    private static final SdkField<String> COMPLIANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComplianceType").getter(getter(ComplianceSummaryItem::complianceType))
            .setter(setter(Builder::complianceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceType").build()).build();

    private static final SdkField<CompliantSummary> COMPLIANT_SUMMARY_FIELD = SdkField
            .<CompliantSummary> builder(MarshallingType.SDK_POJO).memberName("CompliantSummary")
            .getter(getter(ComplianceSummaryItem::compliantSummary)).setter(setter(Builder::compliantSummary))
            .constructor(CompliantSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompliantSummary").build()).build();

    private static final SdkField<NonCompliantSummary> NON_COMPLIANT_SUMMARY_FIELD = SdkField
            .<NonCompliantSummary> builder(MarshallingType.SDK_POJO).memberName("NonCompliantSummary")
            .getter(getter(ComplianceSummaryItem::nonCompliantSummary)).setter(setter(Builder::nonCompliantSummary))
            .constructor(NonCompliantSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NonCompliantSummary").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLIANCE_TYPE_FIELD,
            COMPLIANT_SUMMARY_FIELD, NON_COMPLIANT_SUMMARY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String complianceType;

    private final CompliantSummary compliantSummary;

    private final NonCompliantSummary nonCompliantSummary;

    private ComplianceSummaryItem(BuilderImpl builder) {
        this.complianceType = builder.complianceType;
        this.compliantSummary = builder.compliantSummary;
        this.nonCompliantSummary = builder.nonCompliantSummary;
    }

    /**
     * <p>
     * The type of compliance item. For example, the compliance type can be Association, Patch, or Custom:string.
     * </p>
     * 
     * @return The type of compliance item. For example, the compliance type can be Association, Patch, or
     *         Custom:string.
     */
    public String complianceType() {
        return complianceType;
    }

    /**
     * <p>
     * A list of COMPLIANT items for the specified compliance type.
     * </p>
     * 
     * @return A list of COMPLIANT items for the specified compliance type.
     */
    public CompliantSummary compliantSummary() {
        return compliantSummary;
    }

    /**
     * <p>
     * A list of NON_COMPLIANT items for the specified compliance type.
     * </p>
     * 
     * @return A list of NON_COMPLIANT items for the specified compliance type.
     */
    public NonCompliantSummary nonCompliantSummary() {
        return nonCompliantSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(complianceType());
        hashCode = 31 * hashCode + Objects.hashCode(compliantSummary());
        hashCode = 31 * hashCode + Objects.hashCode(nonCompliantSummary());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComplianceSummaryItem)) {
            return false;
        }
        ComplianceSummaryItem other = (ComplianceSummaryItem) obj;
        return Objects.equals(complianceType(), other.complianceType())
                && Objects.equals(compliantSummary(), other.compliantSummary())
                && Objects.equals(nonCompliantSummary(), other.nonCompliantSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ComplianceSummaryItem").add("ComplianceType", complianceType())
                .add("CompliantSummary", compliantSummary()).add("NonCompliantSummary", nonCompliantSummary()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComplianceType":
            return Optional.ofNullable(clazz.cast(complianceType()));
        case "CompliantSummary":
            return Optional.ofNullable(clazz.cast(compliantSummary()));
        case "NonCompliantSummary":
            return Optional.ofNullable(clazz.cast(nonCompliantSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComplianceSummaryItem, T> g) {
        return obj -> g.apply((ComplianceSummaryItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComplianceSummaryItem> {
        /**
         * <p>
         * The type of compliance item. For example, the compliance type can be Association, Patch, or Custom:string.
         * </p>
         * 
         * @param complianceType
         *        The type of compliance item. For example, the compliance type can be Association, Patch, or
         *        Custom:string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceType(String complianceType);

        /**
         * <p>
         * A list of COMPLIANT items for the specified compliance type.
         * </p>
         * 
         * @param compliantSummary
         *        A list of COMPLIANT items for the specified compliance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compliantSummary(CompliantSummary compliantSummary);

        /**
         * <p>
         * A list of COMPLIANT items for the specified compliance type.
         * </p>
         * This is a convenience that creates an instance of the {@link CompliantSummary.Builder} avoiding the need to
         * create one manually via {@link CompliantSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link CompliantSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #compliantSummary(CompliantSummary)}.
         * 
         * @param compliantSummary
         *        a consumer that will call methods on {@link CompliantSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #compliantSummary(CompliantSummary)
         */
        default Builder compliantSummary(Consumer<CompliantSummary.Builder> compliantSummary) {
            return compliantSummary(CompliantSummary.builder().applyMutation(compliantSummary).build());
        }

        /**
         * <p>
         * A list of NON_COMPLIANT items for the specified compliance type.
         * </p>
         * 
         * @param nonCompliantSummary
         *        A list of NON_COMPLIANT items for the specified compliance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonCompliantSummary(NonCompliantSummary nonCompliantSummary);

        /**
         * <p>
         * A list of NON_COMPLIANT items for the specified compliance type.
         * </p>
         * This is a convenience that creates an instance of the {@link NonCompliantSummary.Builder} avoiding the need
         * to create one manually via {@link NonCompliantSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link NonCompliantSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #nonCompliantSummary(NonCompliantSummary)}.
         * 
         * @param nonCompliantSummary
         *        a consumer that will call methods on {@link NonCompliantSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nonCompliantSummary(NonCompliantSummary)
         */
        default Builder nonCompliantSummary(Consumer<NonCompliantSummary.Builder> nonCompliantSummary) {
            return nonCompliantSummary(NonCompliantSummary.builder().applyMutation(nonCompliantSummary).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String complianceType;

        private CompliantSummary compliantSummary;

        private NonCompliantSummary nonCompliantSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(ComplianceSummaryItem model) {
            complianceType(model.complianceType);
            compliantSummary(model.compliantSummary);
            nonCompliantSummary(model.nonCompliantSummary);
        }

        public final String getComplianceType() {
            return complianceType;
        }

        @Override
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        public final CompliantSummary.Builder getCompliantSummary() {
            return compliantSummary != null ? compliantSummary.toBuilder() : null;
        }

        @Override
        public final Builder compliantSummary(CompliantSummary compliantSummary) {
            this.compliantSummary = compliantSummary;
            return this;
        }

        public final void setCompliantSummary(CompliantSummary.BuilderImpl compliantSummary) {
            this.compliantSummary = compliantSummary != null ? compliantSummary.build() : null;
        }

        public final NonCompliantSummary.Builder getNonCompliantSummary() {
            return nonCompliantSummary != null ? nonCompliantSummary.toBuilder() : null;
        }

        @Override
        public final Builder nonCompliantSummary(NonCompliantSummary nonCompliantSummary) {
            this.nonCompliantSummary = nonCompliantSummary;
            return this;
        }

        public final void setNonCompliantSummary(NonCompliantSummary.BuilderImpl nonCompliantSummary) {
            this.nonCompliantSummary = nonCompliantSummary != null ? nonCompliantSummary.build() : null;
        }

        @Override
        public ComplianceSummaryItem build() {
            return new ComplianceSummaryItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
