/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.textract.model.Block;
import software.amazon.awssdk.services.textract.model.BlockListCopier;
import software.amazon.awssdk.services.textract.model.DocumentMetadata;
import software.amazon.awssdk.services.textract.model.TextractResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetectDocumentTextResponse
extends TextractResponse
implements ToCopyableBuilder<Builder, DetectDocumentTextResponse> {
    private static final SdkField<DocumentMetadata> DOCUMENT_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DetectDocumentTextResponse.getter(DetectDocumentTextResponse::documentMetadata)).setter(DetectDocumentTextResponse.setter(Builder::documentMetadata)).constructor(DocumentMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentMetadata").build()}).build();
    private static final SdkField<List<Block>> BLOCKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DetectDocumentTextResponse.getter(DetectDocumentTextResponse::blocks)).setter(DetectDocumentTextResponse.setter(Builder::blocks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Blocks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Block::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DETECT_DOCUMENT_TEXT_MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DetectDocumentTextResponse.getter(DetectDocumentTextResponse::detectDocumentTextModelVersion)).setter(DetectDocumentTextResponse.setter(Builder::detectDocumentTextModelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetectDocumentTextModelVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_METADATA_FIELD, BLOCKS_FIELD, DETECT_DOCUMENT_TEXT_MODEL_VERSION_FIELD));
    private final DocumentMetadata documentMetadata;
    private final List<Block> blocks;
    private final String detectDocumentTextModelVersion;

    private DetectDocumentTextResponse(BuilderImpl builder) {
        super(builder);
        this.documentMetadata = builder.documentMetadata;
        this.blocks = builder.blocks;
        this.detectDocumentTextModelVersion = builder.detectDocumentTextModelVersion;
    }

    public DocumentMetadata documentMetadata() {
        return this.documentMetadata;
    }

    public boolean hasBlocks() {
        return this.blocks != null && !(this.blocks instanceof SdkAutoConstructList);
    }

    public List<Block> blocks() {
        return this.blocks;
    }

    public String detectDocumentTextModelVersion() {
        return this.detectDocumentTextModelVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.documentMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.blocks());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectDocumentTextModelVersion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectDocumentTextResponse)) {
            return false;
        }
        DetectDocumentTextResponse other = (DetectDocumentTextResponse)((Object)obj);
        return Objects.equals(this.documentMetadata(), other.documentMetadata()) && Objects.equals(this.blocks(), other.blocks()) && Objects.equals(this.detectDocumentTextModelVersion(), other.detectDocumentTextModelVersion());
    }

    public String toString() {
        return ToString.builder((String)"DetectDocumentTextResponse").add("DocumentMetadata", (Object)this.documentMetadata()).add("Blocks", this.blocks()).add("DetectDocumentTextModelVersion", (Object)this.detectDocumentTextModelVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DocumentMetadata": {
                return Optional.ofNullable(clazz.cast(this.documentMetadata()));
            }
            case "Blocks": {
                return Optional.ofNullable(clazz.cast(this.blocks()));
            }
            case "DetectDocumentTextModelVersion": {
                return Optional.ofNullable(clazz.cast(this.detectDocumentTextModelVersion()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectDocumentTextResponse, T> g) {
        return obj -> g.apply((DetectDocumentTextResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TextractResponse.BuilderImpl
    implements Builder {
        private DocumentMetadata documentMetadata;
        private List<Block> blocks = DefaultSdkAutoConstructList.getInstance();
        private String detectDocumentTextModelVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectDocumentTextResponse model) {
            super(model);
            this.documentMetadata(model.documentMetadata);
            this.blocks(model.blocks);
            this.detectDocumentTextModelVersion(model.detectDocumentTextModelVersion);
        }

        public final DocumentMetadata.Builder getDocumentMetadata() {
            return this.documentMetadata != null ? this.documentMetadata.toBuilder() : null;
        }

        @Override
        public final Builder documentMetadata(DocumentMetadata documentMetadata) {
            this.documentMetadata = documentMetadata;
            return this;
        }

        public final void setDocumentMetadata(DocumentMetadata.BuilderImpl documentMetadata) {
            this.documentMetadata = documentMetadata != null ? documentMetadata.build() : null;
        }

        public final Collection<Block.Builder> getBlocks() {
            return this.blocks != null ? (Collection)this.blocks.stream().map(Block::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder blocks(Collection<Block> blocks) {
            this.blocks = BlockListCopier.copy(blocks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blocks(Block ... blocks) {
            this.blocks(Arrays.asList(blocks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blocks(Consumer<Block.Builder> ... blocks) {
            this.blocks(Stream.of(blocks).map(c -> (Block)((Block.Builder)Block.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBlocks(Collection<Block.BuilderImpl> blocks) {
            this.blocks = BlockListCopier.copyFromBuilder(blocks);
        }

        public final String getDetectDocumentTextModelVersion() {
            return this.detectDocumentTextModelVersion;
        }

        @Override
        public final Builder detectDocumentTextModelVersion(String detectDocumentTextModelVersion) {
            this.detectDocumentTextModelVersion = detectDocumentTextModelVersion;
            return this;
        }

        public final void setDetectDocumentTextModelVersion(String detectDocumentTextModelVersion) {
            this.detectDocumentTextModelVersion = detectDocumentTextModelVersion;
        }

        @Override
        public DetectDocumentTextResponse build() {
            return new DetectDocumentTextResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TextractResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DetectDocumentTextResponse> {
        public Builder documentMetadata(DocumentMetadata var1);

        default public Builder documentMetadata(Consumer<DocumentMetadata.Builder> documentMetadata) {
            return this.documentMetadata((DocumentMetadata)((DocumentMetadata.Builder)DocumentMetadata.builder().applyMutation(documentMetadata)).build());
        }

        public Builder blocks(Collection<Block> var1);

        public Builder blocks(Block ... var1);

        public Builder blocks(Consumer<Block.Builder> ... var1);

        public Builder detectDocumentTextModelVersion(String var1);
    }
}

