/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum TextTransformation {
    NONE("NONE"),
    COMPRESS_WHITE_SPACE("COMPRESS_WHITE_SPACE"),
    HTML_ENTITY_DECODE("HTML_ENTITY_DECODE"),
    LOWERCASE("LOWERCASE"),
    CMD_LINE("CMD_LINE"),
    URL_DECODE("URL_DECODE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private TextTransformation(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TextTransformation fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(TextTransformation.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TextTransformation> knownValues() {
        return Stream.of(TextTransformation.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

