/*
 * Decompiled with CFR 0.152.
 */
package sp.sd.flywayrunner.builder;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.io.Files;
import com.google.common.io.LineProcessor;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.Computer;
import hudson.model.EnvironmentSpecific;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolInstallation;
import hudson.util.ArgumentListBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.annotation.Nullable;
import sp.sd.flywayrunner.builder.CliOption;

public class Util {
    private static final String ERROR_STRING = "Errors:";
    static final String OPTION_HYPHENS = "-";

    private Util() {
    }

    protected static boolean doesErrorExist(File logFile) throws IOException {
        return (Boolean)Files.readLines((File)logFile, (Charset)Charsets.UTF_8, (LineProcessor)new LineProcessor<Boolean>(){
            boolean containsError;

            public boolean processLine(String line) throws IOException {
                boolean continueProcessing = true;
                if (line != null && line.contains(Util.ERROR_STRING)) {
                    this.containsError = true;
                    continueProcessing = false;
                }
                return continueProcessing;
            }

            public Boolean getResult() {
                return this.containsError;
            }
        });
    }

    static void addOptionIfPresent(ArgumentListBuilder cmdExecArgs, CliOption cliOption, String value) {
        if (!Strings.isNullOrEmpty((String)value)) {
            cmdExecArgs.add(OPTION_HYPHENS + cliOption.getCliOption() + "=" + value);
        }
    }

    public static <T extends ToolInstallation & NodeSpecific<T>> T getInstallation(@Nullable T tool, EnvVars env, TaskListener listener, FilePath workspace) throws IOException, InterruptedException {
        Computer computer = workspace.toComputer();
        if (computer == null) {
            return null;
        }
        Node node = computer.getNode();
        if (tool == null || node == null) {
            return null;
        }
        ToolInstallation t = (ToolInstallation)((NodeSpecific<T>)tool).forNode(node, listener);
        t = (ToolInstallation)((EnvironmentSpecific)t).forEnvironment(env);
        return (T)t;
    }
}

