/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.jsf;

import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.VariableResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.jsf.FacesContextUtils;

public class DelegatingVariableResolver
extends VariableResolver {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected final VariableResolver originalVariableResolver;

    public DelegatingVariableResolver(VariableResolver originalVariableResolver) {
        this.originalVariableResolver = originalVariableResolver;
    }

    protected final VariableResolver getOriginalVariableResolver() {
        return this.originalVariableResolver;
    }

    public Object resolveVariable(FacesContext facesContext, String name) throws EvaluationException {
        WebApplicationContext wac;
        Object originalResult;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Attempting to resolve variable '" + name + "' in via original VariableResolver"));
        }
        if ((originalResult = this.getOriginalVariableResolver().resolveVariable(facesContext, name)) != null) {
            return originalResult;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Attempting to resolve variable '" + name + "' in root WebApplicationContext"));
        }
        if ((wac = this.getWebApplicationContext(facesContext)).containsBean(name)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Successfully resolved variable '" + name + "' in root WebApplicationContext"));
            }
            return wac.getBean(name);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Could not resolve variable '" + name + "'"));
        }
        return null;
    }

    protected WebApplicationContext getWebApplicationContext(FacesContext facesContext) {
        return FacesContextUtils.getRequiredWebApplicationContext(facesContext);
    }
}

