/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.authentication;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.transport.SshMessage;
import java.io.IOException;

public class SshMsgUserAuthRequest
extends SshMessage {
    public static final int SSH_MSG_USERAUTH_REQUEST = 50;
    private String methodName;
    private String serviceName;
    private String username;
    private byte[] requestData;

    public SshMsgUserAuthRequest() {
        super(50);
    }

    public SshMsgUserAuthRequest(String string, String string2, String string3, byte[] byArray) {
        super(50);
        this.username = string;
        this.serviceName = string2;
        this.methodName = string3;
        this.requestData = byArray;
    }

    public String getMessageName() {
        return "SSH_MSG_USERAUTH_REQUEST";
    }

    public String getMethodName() {
        return this.methodName;
    }

    public byte[] getRequestData() {
        return this.requestData;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getUsername() {
        return this.username;
    }

    protected void constructByteArray(ByteArrayWriter byteArrayWriter) throws InvalidMessageException {
        try {
            byteArrayWriter.writeString(this.username);
            byteArrayWriter.writeString(this.serviceName);
            byteArrayWriter.writeString(this.methodName);
            if (this.requestData != null) {
                byteArrayWriter.write(this.requestData);
            }
        }
        catch (IOException iOException) {
            throw new InvalidMessageException("Invalid message data");
        }
    }

    protected void constructMessage(ByteArrayReader byteArrayReader) throws InvalidMessageException {
        try {
            this.username = byteArrayReader.readString();
            this.serviceName = byteArrayReader.readString();
            this.methodName = byteArrayReader.readString();
            if (byteArrayReader.available() > 0) {
                this.requestData = new byte[byteArrayReader.available()];
                byteArrayReader.read(this.requestData);
            }
        }
        catch (IOException iOException) {
            throw new InvalidMessageException("Invalid message data");
        }
    }
}

