/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon.authentication;

import com.sshtools.daemon.authentication.AuthenticationProtocolServer;
import com.sshtools.daemon.authentication.SshAuthenticationServer;
import com.sshtools.daemon.platform.NativeAuthenticationProvider;
import com.sshtools.daemon.platform.PasswordChangeException;
import com.sshtools.j2ssh.authentication.SshMsgUserAuthInfoRequest;
import com.sshtools.j2ssh.authentication.SshMsgUserAuthInfoResponse;
import com.sshtools.j2ssh.authentication.SshMsgUserAuthRequest;
import com.sshtools.j2ssh.transport.SshMessage;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KBIPasswordAuthenticationServer
extends SshAuthenticationServer {
    private static Log log = LogFactory.getLog((Class)(class$com$sshtools$daemon$authentication$KBIPasswordAuthenticationServer == null ? (class$com$sshtools$daemon$authentication$KBIPasswordAuthenticationServer = KBIPasswordAuthenticationServer.class$("com.sshtools.daemon.authentication.KBIPasswordAuthenticationServer")) : class$com$sshtools$daemon$authentication$KBIPasswordAuthenticationServer));
    static /* synthetic */ Class class$com$sshtools$daemon$authentication$KBIPasswordAuthenticationServer;
    static /* synthetic */ Class class$com$sshtools$j2ssh$authentication$SshMsgUserAuthInfoResponse;

    public final String getMethodName() {
        return "keyboard-interactive";
    }

    public void setAuthenticatedTokens(Map map) {
    }

    public int authenticate(AuthenticationProtocolServer authenticationProtocolServer, SshMsgUserAuthRequest sshMsgUserAuthRequest) throws IOException {
        NativeAuthenticationProvider nativeAuthenticationProvider = NativeAuthenticationProvider.getInstance();
        if (nativeAuthenticationProvider == null) {
            log.error((Object)"Cannot perfrom authentication witout native authentication provider");
            return 2;
        }
        authenticationProtocolServer.registerMessage(61, class$com$sshtools$j2ssh$authentication$SshMsgUserAuthInfoResponse == null ? (class$com$sshtools$j2ssh$authentication$SshMsgUserAuthInfoResponse = KBIPasswordAuthenticationServer.class$("com.sshtools.j2ssh.authentication.SshMsgUserAuthInfoResponse")) : class$com$sshtools$j2ssh$authentication$SshMsgUserAuthInfoResponse);
        SshMsgUserAuthInfoRequest sshMsgUserAuthInfoRequest = new SshMsgUserAuthInfoRequest("Password authentication", "", "");
        sshMsgUserAuthInfoRequest.addPrompt(sshMsgUserAuthRequest.getUsername() + "'s password", false);
        authenticationProtocolServer.sendMessage((SshMessage)sshMsgUserAuthInfoRequest);
        SshMessage sshMessage = authenticationProtocolServer.readMessage();
        if (sshMessage instanceof SshMsgUserAuthInfoResponse) {
            String[] stringArray = ((SshMsgUserAuthInfoResponse)sshMessage).getResponses();
            if (stringArray.length == 1) {
                String string = stringArray[0];
                try {
                    if (nativeAuthenticationProvider.logonUser(sshMsgUserAuthRequest.getUsername(), string)) {
                        log.info((Object)(sshMsgUserAuthRequest.getUsername() + " has passed password authentication"));
                        return 4;
                    }
                    log.info((Object)(sshMsgUserAuthRequest.getUsername() + " has failed password authentication"));
                    return 2;
                }
                catch (PasswordChangeException passwordChangeException) {
                    sshMsgUserAuthInfoRequest = new SshMsgUserAuthInfoRequest("Password change required", "", "");
                    sshMsgUserAuthInfoRequest.addPrompt("New password", false);
                    sshMsgUserAuthInfoRequest.addPrompt("Confirm password", false);
                    authenticationProtocolServer.sendMessage((SshMessage)sshMsgUserAuthInfoRequest);
                    sshMessage = authenticationProtocolServer.readMessage();
                    if (sshMessage instanceof SshMsgUserAuthInfoResponse) {
                        stringArray = ((SshMsgUserAuthInfoResponse)sshMessage).getResponses();
                        if (stringArray.length == 2) {
                            if (stringArray[0].equals(stringArray[1])) {
                                if (nativeAuthenticationProvider.changePassword(sshMsgUserAuthRequest.getUsername(), string, stringArray[0])) {
                                    return 4;
                                }
                                return 2;
                            }
                            return 2;
                        }
                        log.error((Object)("Client replied with an invalid message " + sshMessage.getMessageName()));
                        return 2;
                    }
                    log.error((Object)("Client replied with an invalid message " + sshMessage.getMessageName()));
                    return 2;
                }
            }
            log.error((Object)"Client responded with too many values!");
            return 2;
        }
        log.error((Object)("Client replied with an invalid message " + sshMessage.getMessageName()));
        return 2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

