/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon.terminal;

import com.sshtools.daemon.terminal.BufferOverflowException;
import java.util.Vector;

class CharBuffer {
    private Vector myBuffer;
    private int mySize;

    public CharBuffer(int n) {
        this.myBuffer = new Vector(n);
        this.mySize = n;
    }

    public char getCharAt(int n) throws IndexOutOfBoundsException {
        return ((Character)this.myBuffer.elementAt(n)).charValue();
    }

    public void setCharAt(int n, char c) throws IndexOutOfBoundsException {
        this.myBuffer.setElementAt(new Character(c), n);
    }

    public void insertCharAt(int n, char c) throws BufferOverflowException, IndexOutOfBoundsException {
        this.myBuffer.insertElementAt(new Character(c), n);
    }

    public void append(char c) throws BufferOverflowException {
        this.myBuffer.addElement(new Character(c));
    }

    public void removeCharAt(int n) throws IndexOutOfBoundsException {
        this.myBuffer.removeElementAt(n);
    }

    public void clear() {
        this.myBuffer.removeAllElements();
    }

    public int size() {
        return this.myBuffer.size();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.myBuffer.size(); ++i) {
            stringBuffer.append(((Character)this.myBuffer.elementAt(i)).charValue());
        }
        return stringBuffer.toString();
    }

    public void ensureSpace(int n) throws BufferOverflowException {
        if (n > this.mySize - this.myBuffer.size()) {
            throw new BufferOverflowException();
        }
    }
}

