/*
 * Decompiled with CFR 0.152.
 */
package org.opends.messages;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.opends.messages.Category;
import org.opends.messages.Message;
import org.opends.messages.Severity;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;

@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=false, mayExtend=false, mayInvoke=true)
public abstract class MessageDescriptor {
    public static final int NULL_ID = -1;
    public static final int DESCRIPTOR_MAX_ARG_HANDLER = 11;
    public static final String DESCRIPTOR_CLASS_BASE_NAME = "Arg";
    private final String rbBase;
    private final String key;
    private final Category category;
    private final Integer mask;
    private final Severity severity;
    private final Integer ordinal;
    private final ClassLoader classLoader;
    private final Map<Locale, String> formatStrMap = new HashMap<Locale, String>();

    public final Category getCategory() {
        return this.category;
    }

    public final Severity getSeverity() {
        return this.severity;
    }

    public final int getOrdinal() {
        if (this.ordinal == null) {
            return 0;
        }
        return this.ordinal;
    }

    public final int getId() {
        if (this.ordinal == null) {
            return -1;
        }
        return this.ordinal | this.category.getMask() | this.severity.getMask();
    }

    public final int getMask() {
        if (this.mask != null) {
            return this.mask;
        }
        return this.category.getMask();
    }

    public final String getKey() {
        return this.key;
    }

    public final String getBase() {
        return this.rbBase;
    }

    abstract boolean requiresFormatter();

    final String getFormatString() {
        return this.getFormatString(Locale.getDefault());
    }

    String getFormatString(Locale locale) {
        String fmtStr = this.formatStrMap.get(locale);
        if (fmtStr == null) {
            ResourceBundle bundle = this.getBundle(locale);
            fmtStr = bundle.getString(this.key);
            this.formatStrMap.put(locale, fmtStr);
        }
        return fmtStr;
    }

    protected final boolean containsArgumentLiterals(String s) {
        return s.matches(".*%[n|%].*");
    }

    private ResourceBundle getBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (this.classLoader == null) {
            return ResourceBundle.getBundle(this.rbBase, locale);
        }
        return ResourceBundle.getBundle(this.rbBase, locale, this.classLoader);
    }

    private MessageDescriptor(String rbBase, String key, Category category, Severity severity, Integer ordinal, ClassLoader classLoader) {
        if (category == null) {
            throw new NullPointerException("Null Category value for message descriptor with key " + key);
        }
        if (severity == null) {
            throw new NullPointerException("Null Severity value for message descriptor with key " + key);
        }
        this.rbBase = rbBase;
        this.key = key;
        this.category = category;
        this.severity = severity;
        this.ordinal = ordinal;
        this.classLoader = classLoader;
        this.mask = null;
    }

    private MessageDescriptor(String rbBase, String key, int mask, Severity severity, Integer ordinal, ClassLoader classLoader) {
        if (severity == null) {
            throw new NullPointerException("Null Severity value for message descriptor with key " + key);
        }
        this.rbBase = rbBase;
        this.key = key;
        this.category = Category.USER_DEFINED;
        this.severity = severity;
        this.ordinal = ordinal;
        this.classLoader = classLoader;
        this.mask = mask;
    }

    @PublicAPI(stability=StabilityLevel.PRIVATE)
    static final class Raw
    extends MessageDescriptor {
        private String formatString;
        private boolean requiresFormatter;

        Raw(CharSequence formatString) {
            this(formatString, Category.USER_DEFINED, Severity.INFORMATION);
        }

        Raw(CharSequence formatString, Category category, Severity severity) {
            super(null, null, category, severity, null, null);
            this.formatString = formatString != null ? ((Object)formatString).toString() : "";
            this.requiresFormatter = ((Object)formatString).toString().matches(".*%.*");
        }

        Raw(CharSequence formatString, int mask, Severity severity) {
            super(null, null, mask, severity, null, null);
            this.formatString = formatString != null ? ((Object)formatString).toString() : "";
        }

        public Message get(Object ... args) {
            return new Message(this, args);
        }

        String getFormatString(Locale locale) {
            return this.formatString;
        }

        boolean requiresFormatter() {
            return this.requiresFormatter;
        }
    }

    @PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=true, mayExtend=false, mayInvoke=true)
    public static final class ArgN
    extends MessageDescriptor {
        public ArgN(String rbBase, String key, Category category, Severity severity, int ordinal, ClassLoader classLoader) {
            super(rbBase, key, category, severity, (Integer)ordinal, classLoader);
        }

        public ArgN(String rbBase, String key, int mask, Severity severity, int ordinal, ClassLoader classLoader) {
            super(rbBase, key, mask, severity, (Integer)ordinal, classLoader);
        }

        public Message get(Object ... args) {
            return new Message(this, args);
        }

        boolean requiresFormatter() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=true, mayExtend=false, mayInvoke=true)
    public static final class Arg11<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11>
    extends MessageDescriptor {
        public Arg11(String rbBase, String key, Category category, Severity severity, int ordinal, ClassLoader classLoader) {
            super(rbBase, key, category, severity, (Integer)ordinal, classLoader);
        }

        public Arg11(String rbBase, String key, int mask, Severity severity, int ordinal, ClassLoader classLoader) {
            super(rbBase, key, mask, severity, (Integer)ordinal, classLoader);
        }

        public Message get(T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, T8 a8, T9 a9, T10 a10, T11 a11) {
            return new Message(this, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11);
        }

        @Override
        boolean requiresFormatter() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=true, mayExtend=false, mayInvoke=true)
    public static final class Arg10<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10>
    extends MessageDescriptor {
        public Arg10(String rbBase, String key, Category category, Severity severity, int ordinal, ClassLoader classLoader) {
            super(rbBase, key, category, severity, (Integer)ordinal, classLoader);
        }

        public Arg10(String rbBase, String key, int mask, Severity severity, int ordinal, ClassLoader classLoader) {
            super(rbBase, key, mask, severity, (Integer)ordinal, classLoader);
        }

        public Message get(T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, T8 a8, T9 a9, T10 a10) {
            return new Message(this, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10);
        }

        @Override
        boolean requiresFormatter() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=true, mayExtend=false, mayInvoke=true)
    public static final class Arg9<T1, T2, T3, T4, T5, T6, T7, T8, T9>
    extends MessageDescriptor {
        public Arg9(String rbBase, String key, Category category, Severity severity, int ordinal, ClassLoader classLoader) {
            super(rbBase, key, category, severity, (Integer)ordinal, classLoader);
        }

        public Arg9(String rbBase, String key, int mask, Severity severity, int ordinal, ClassLoader classLoader) {
            super(rbBase, key, mask, severity, (Integer)ordinal, classLoader);
        }

        public Message get(T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, T8 a8, T9 a9) {
            return new Message(this, a1, a2, a3, a4, a5, a6, a7, a8, a9);
        }

        @Override
        boolean requiresFormatter() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=true, mayExtend=false, mayInvoke=true)
    public static final class Arg8<T1, T2, T3, T4, T5, T6, T7, T8>
    extends MessageDescriptor {
        public Arg8(String rbBase, String key, Category category, Severity severity, int ordinal, ClassLoader classLoader) {
            super(rbBase, key, category, severity, (Integer)ordinal, classLoader);
        }

        public Arg8(String rbBase, String key, int mask, Severity severity, int ordinal, ClassLoader classLoader) {
            super(rbBase, key, mask, severity, (Integer)ordinal, classLoader);
        }

        public Message get(T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, T8 a8) {
            return new Message(this, a1, a2, a3, a4, a5, a6, a7, a8);
        }

        @Override
        boolean requiresFormatter() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=true, mayExtend=false, mayInvoke=true)
    public static final class Arg7<T1, T2, T3, T4, T5, T6, T7>
    extends MessageDescriptor {
        public Arg7(String rbBase, String key, Category category, Severity severity, int ordinal, ClassLoader classLoader) {
            super(rbBase, key, category, severity, (Integer)ordinal, classLoader);
        }

        public Arg7(String rbBase, String key, int mask, Severity severity, int ordinal, ClassLoader classLoader) {
            super(rbBase, key, mask, severity, (Integer)ordinal, classLoader);
        }

        public Message get(T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7) {
            return new Message(this, a1, a2, a3, a4, a5, a6, a7);
        }

        @Override
        boolean requiresFormatter() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=true, mayExtend=false, mayInvoke=true)
    public static final class Arg6<T1, T2, T3, T4, T5, T6>
    extends MessageDescriptor {
        public Arg6(String rbBase, String key, Category category, Severity severity, int ordinal, ClassLoader classLoader) {
            super(rbBase, key, category, severity, (Integer)ordinal, classLoader);
        }

        public Arg6(String rbBase, String key, int mask, Severity severity, int ordinal, ClassLoader classLoader) {
            super(rbBase, key, mask, severity, (Integer)ordinal, classLoader);
        }

        public Message get(T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6) {
            return new Message(this, a1, a2, a3, a4, a5, a6);
        }

        @Override
        boolean requiresFormatter() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=true, mayExtend=false, mayInvoke=true)
    public static final class Arg5<T1, T2, T3, T4, T5>
    extends MessageDescriptor {
        public Arg5(String rbBase, String key, Category category, Severity severity, int ordinal, ClassLoader classLoader) {
            super(rbBase, key, category, severity, (Integer)ordinal, classLoader);
        }

        public Arg5(String rbBase, String key, int mask, Severity severity, int ordinal, ClassLoader classLoader) {
            super(rbBase, key, mask, severity, (Integer)ordinal, classLoader);
        }

        public Message get(T1 a1, T2 a2, T3 a3, T4 a4, T5 a5) {
            return new Message(this, a1, a2, a3, a4, a5);
        }

        @Override
        boolean requiresFormatter() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=true, mayExtend=false, mayInvoke=true)
    public static final class Arg4<T1, T2, T3, T4>
    extends MessageDescriptor {
        public Arg4(String rbBase, String key, Category category, Severity severity, int ordinal, ClassLoader classLoader) {
            super(rbBase, key, category, severity, (Integer)ordinal, classLoader);
        }

        public Arg4(String rbBase, String key, int mask, Severity severity, int ordinal, ClassLoader classLoader) {
            super(rbBase, key, mask, severity, (Integer)ordinal, classLoader);
        }

        public Message get(T1 a1, T2 a2, T3 a3, T4 a4) {
            return new Message(this, a1, a2, a3, a4);
        }

        @Override
        boolean requiresFormatter() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=true, mayExtend=false, mayInvoke=true)
    public static final class Arg3<T1, T2, T3>
    extends MessageDescriptor {
        public Arg3(String rbBase, String key, Category category, Severity severity, int ordinal, ClassLoader classLoader) {
            super(rbBase, key, category, severity, (Integer)ordinal, classLoader);
        }

        public Arg3(String rbBase, String key, int mask, Severity severity, int ordinal, ClassLoader classLoader) {
            super(rbBase, key, mask, severity, (Integer)ordinal, classLoader);
        }

        public Message get(T1 a1, T2 a2, T3 a3) {
            return new Message(this, a1, a2, a3);
        }

        @Override
        boolean requiresFormatter() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=true, mayExtend=false, mayInvoke=true)
    public static final class Arg2<T1, T2>
    extends MessageDescriptor {
        public Arg2(String rbBase, String key, Category category, Severity severity, int ordinal, ClassLoader classLoader) {
            super(rbBase, key, category, severity, (Integer)ordinal, classLoader);
        }

        public Arg2(String rbBase, String key, int mask, Severity severity, int ordinal, ClassLoader classLoader) {
            super(rbBase, key, mask, severity, (Integer)ordinal, classLoader);
        }

        public Message get(T1 a1, T2 a2) {
            return new Message(this, a1, a2);
        }

        @Override
        boolean requiresFormatter() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=true, mayExtend=false, mayInvoke=true)
    public static final class Arg1<T1>
    extends MessageDescriptor {
        public Arg1(String rbBase, String key, Category category, Severity severity, int ordinal, ClassLoader classLoader) {
            super(rbBase, key, category, severity, (Integer)ordinal, classLoader);
        }

        public Arg1(String rbBase, String key, int mask, Severity severity, int ordinal, ClassLoader classLoader) {
            super(rbBase, key, mask, severity, (Integer)ordinal, classLoader);
        }

        public Message get(T1 a1) {
            return new Message(this, a1);
        }

        @Override
        boolean requiresFormatter() {
            return true;
        }
    }

    @PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=true, mayExtend=false, mayInvoke=true)
    public static final class Arg0
    extends MessageDescriptor {
        private Message message = new Message(this, new Object[0]);
        private boolean requiresFormat = this.containsArgumentLiterals(this.getFormatString());

        public Arg0(String rbBase, String key, Category category, Severity severity, int ordinal, ClassLoader classLoader) {
            super(rbBase, key, category, severity, (Integer)ordinal, classLoader);
        }

        public Arg0(String rbBase, String key, int mask, Severity severity, int ordinal, ClassLoader classLoader) {
            super(rbBase, key, mask, severity, (Integer)ordinal, classLoader);
        }

        public Message get() {
            return this.message;
        }

        boolean requiresFormatter() {
            return this.requiresFormat;
        }
    }
}

