/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapName;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.TrustManager;
import org.opends.admin.ads.TopologyCacheException;
import org.opends.admin.ads.util.ConnectionUtils;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.MessageDescriptor;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.ApplicationException;
import org.opends.quicksetup.BuildInformation;
import org.opends.quicksetup.Constants;
import org.opends.quicksetup.Installation;
import org.opends.quicksetup.util.CompatibleJava;
import org.opends.quicksetup.util.EmptyPrintStream;
import org.opends.quicksetup.util.IncompatibleVersionException;
import org.opends.server.util.SetupUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    private static final Logger LOG = Logger.getLogger(Utils.class.getName());
    private static final int BUFFER_SIZE = 1024;
    private static final int MAX_LINE_WIDTH = 80;
    private static EmptyPrintStream emptyStream = new EmptyPrintStream();

    private Utils() {
    }

    public static boolean canUseAsPort(int port) {
        return SetupUtils.canUseAsPort(port);
    }

    public static boolean isPriviledgedPort(int port) {
        return SetupUtils.isPriviledgedPort(port);
    }

    public static boolean createFile(File f) throws IOException {
        boolean success = false;
        if (f != null) {
            File parent = f.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            success = f.createNewFile();
        }
        return success;
    }

    public static String getPath(String parentPath, String relativePath) {
        return Utils.getPath(new File(new File(parentPath), relativePath));
    }

    public static String getScriptPath(String script) {
        return SetupUtils.getScriptPath(script);
    }

    public static String getPath(File f) {
        String path = null;
        if (f != null) {
            try {
                File canonical;
                f = canonical = f.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            path = f.toString();
        }
        return path;
    }

    public static boolean isDescendant(File descendant, File path) {
        boolean isDescendant = false;
        if (descendant != null && path != null) {
            File parent = descendant.getParentFile();
            while (parent != null && !isDescendant) {
                isDescendant = path.equals(parent);
                if (isDescendant) continue;
                parent = parent.getParentFile();
            }
        }
        return isDescendant;
    }

    public static boolean isWindows() {
        return SetupUtils.isWindows();
    }

    public static boolean isMacOS() {
        return SetupUtils.isMacOS();
    }

    public static boolean isUnix() {
        return SetupUtils.isUnix();
    }

    public static String getOSString() {
        return SetupUtils.getOSString();
    }

    public static boolean parentDirectoryExists(String path) {
        File parentFile;
        boolean parentExists = false;
        File f = new File(path);
        if (f != null && (parentFile = f.getParentFile()) != null) {
            parentExists = parentFile.isDirectory();
        }
        return parentExists;
    }

    public static boolean fileExists(String path) {
        boolean isFile = false;
        File f = new File(path);
        if (f != null) {
            isFile = f.isFile();
        }
        return isFile;
    }

    public static boolean directoryExistsAndIsNotEmpty(String path) {
        boolean directoryExistsAndIsNotEmpty = false;
        boolean isDirectory = false;
        File f = new File(path);
        if (f != null) {
            isDirectory = f.isDirectory();
        }
        if (isDirectory) {
            String[] ch = f.list();
            directoryExistsAndIsNotEmpty = ch != null && ch.length > 0;
        }
        return directoryExistsAndIsNotEmpty;
    }

    public static boolean directoryExistsAndIsEmpty(String path) {
        boolean directoryExistsAndIsEmpty = false;
        boolean isDirectory = false;
        File f = new File(path);
        if (f != null) {
            isDirectory = f.isDirectory();
        }
        if (isDirectory) {
            String[] ch = f.list();
            directoryExistsAndIsEmpty = ch == null || ch.length == 0;
        }
        return directoryExistsAndIsEmpty;
    }

    public static boolean isDn(String dn) {
        boolean isDn = true;
        try {
            new LdapName(dn);
        }
        catch (Exception ex) {
            isDn = false;
        }
        return isDn;
    }

    public static boolean isConfigurationDn(String dn) {
        boolean isConfigurationDn = false;
        String[] configDns = new String[]{"cn=config", "cn=schema"};
        for (int i = 0; i < configDns.length && !isConfigurationDn; ++i) {
            isConfigurationDn = Utils.areDnsEqual(dn, configDns[i]);
        }
        return isConfigurationDn;
    }

    public static boolean areDnsEqual(String dn1, String dn2) {
        boolean areDnsEqual = false;
        try {
            LdapName name1 = new LdapName(dn1);
            LdapName name2 = new LdapName(dn2);
            areDnsEqual = name1.equals(name2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return areDnsEqual;
    }

    public static boolean createParentPath(String path) {
        File f;
        boolean parentPathExists = true;
        if (!Utils.parentDirectoryExists(path) && (f = new File(path)) != null) {
            File parentFile = f.getParentFile();
            parentPathExists = parentFile.mkdirs();
        }
        return parentPathExists;
    }

    public static boolean insureParentsExist(File f) {
        File parent = f.getParentFile();
        boolean b = parent.exists();
        if (!b) {
            b = parent.mkdirs();
        }
        return b;
    }

    public static boolean canWrite(String path) {
        File parentFile;
        File file = new File(path);
        boolean canWrite = file.exists() ? file.canWrite() : ((parentFile = file.getParentFile()) != null ? parentFile.canWrite() : false);
        return canWrite;
    }

    public static boolean createDirectory(String path) throws IOException {
        return Utils.createDirectory(new File(path));
    }

    public static boolean createDirectory(File f) throws IOException {
        boolean directoryCreated = !f.exists() ? f.mkdirs() : f.isDirectory();
        return directoryCreated;
    }

    public static void createFile(String path, InputStream is) throws IOException {
        Utils.createFile(new File(path), is);
    }

    public static void createFile(File path, InputStream is) throws IOException {
        int count;
        byte[] data = new byte[1024];
        FileOutputStream out = new FileOutputStream(path);
        BufferedOutputStream dest = new BufferedOutputStream(out);
        while ((count = is.read(data, 0, 1024)) != -1) {
            dest.write(data, 0, count);
        }
        dest.flush();
        dest.close();
    }

    public static void createFile(String path, String content) throws IOException {
        FileWriter file = new FileWriter(path);
        PrintWriter out = new PrintWriter(file);
        out.println(content);
        out.flush();
        out.close();
    }

    public static String getStringFromCollection(Collection<String> col, String separator) {
        StringBuilder msg = new StringBuilder();
        for (String m : col) {
            if (msg.length() > 0) {
                msg.append(separator);
            }
            msg.append(m);
        }
        return msg.toString();
    }

    public static Message getMessageFromCollection(Collection<Message> col, String separator) {
        Message message = null;
        if (col != null) {
            MessageBuilder mb = null;
            for (Message m : col) {
                if (mb == null) {
                    mb = new MessageBuilder(m);
                    continue;
                }
                mb.append(separator).append(m);
            }
            if (mb == null) {
                mb = new MessageBuilder();
            }
            message = mb.toMessage();
        }
        return message;
    }

    public static String getDefaultServerLocation() {
        String firstLocation;
        String userDir = System.getProperty("user.home");
        String serverLocation = firstLocation = userDir + File.separator + "OpenDS";
        int i = 1;
        while (Utils.fileExists(serverLocation) || Utils.directoryExistsAndIsNotEmpty(serverLocation)) {
            serverLocation = firstLocation + "-" + i;
            ++i;
        }
        return serverLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean hasEnoughSpace(String directoryPath, long bytes) {
        boolean hasEnoughSpace = false;
        File file = null;
        RandomAccessFile raf = null;
        File directory = new File(directoryPath);
        boolean deleteDirectory = false;
        if (!directory.exists()) {
            deleteDirectory = directory.mkdir();
        }
        try {
            file = File.createTempFile("temp" + System.nanoTime(), ".tmp", directory);
            raf = new RandomAccessFile(file, "rw");
            raf.setLength(bytes);
            hasEnoughSpace = true;
        }
        catch (IOException ex) {
        }
        finally {
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (IOException ex2) {}
            }
            if (file != null) {
                file.delete();
            }
        }
        if (deleteDirectory) {
            directory.delete();
        }
        return hasEnoughSpace;
    }

    public static Message getThrowableMsg(Message message, Throwable t) {
        MessageBuilder mb = new MessageBuilder(message);
        MessageDescriptor.Arg1<CharSequence> tag = Utils.isOutOfMemory(t) ? QuickSetupMessages.INFO_EXCEPTION_OUT_OF_MEMORY_DETAILS : QuickSetupMessages.INFO_EXCEPTION_DETAILS;
        String detail = t.toString();
        if (detail != null) {
            mb.append("  ").append(tag.get(detail));
        }
        return mb.toMessage();
    }

    public static Message getMessage(TopologyCacheException te) {
        MessageBuilder buf = new MessageBuilder();
        String ldapUrl = te.getLdapUrl();
        if (ldapUrl != null) {
            String hostName = ldapUrl.substring(ldapUrl.indexOf("://") + 3);
            buf.append(QuickSetupMessages.INFO_SERVER_ERROR.get(hostName));
            buf.append(" ");
        }
        if (te.getType() == TopologyCacheException.Type.TIMEOUT) {
            buf.append(QuickSetupMessages.INFO_ERROR_CONNECTING_TIMEOUT.get());
        } else if (te.getCause() instanceof NamingException) {
            buf.append(Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_CONNECTING_TO_LOCAL.get(), te.getCause()));
        } else {
            LOG.log(Level.WARNING, "Unexpected error: " + te, te);
            if (te.getCause() != null) {
                buf.append(Utils.getThrowableMsg(QuickSetupMessages.INFO_BUG_MSG.get(), te.getCause()));
            } else {
                buf.append(Utils.getThrowableMsg(QuickSetupMessages.INFO_BUG_MSG.get(), te));
            }
        }
        return buf.toMessage();
    }

    public static int setPermissionsUnix(ArrayList<String> paths, String permissions) throws IOException, InterruptedException {
        String[] args = new String[paths.size() + 2];
        args[0] = "chmod";
        args[1] = permissions;
        for (int i = 2; i < args.length; ++i) {
            args[i] = paths.get(i - 2);
        }
        Process p = Runtime.getRuntime().exec(args);
        return p.waitFor();
    }

    public static int setPermissionsUnix(String path, String permissions) throws IOException, InterruptedException {
        String[] args = new String[]{"chmod", permissions, path};
        Process p = Runtime.getRuntime().exec(args);
        return p.waitFor();
    }

    public static String getHostNameForLdapUrl(String host) {
        return ConnectionUtils.getHostNameForLdapUrl(host);
    }

    private static int changePermissionsWindows(String path, String unixPerm) throws IOException, InterruptedException {
        int i = Integer.parseInt(unixPerm.substring(0, 1));
        String windowsPerm = Integer.lowestOneBit(i) == 1 ? "F" : (Integer.highestOneBit(i) == 4 ? "W" : (Integer.highestOneBit(i) == 2 ? "R" : "N"));
        String user = System.getProperty("user.name");
        String[] args = new String[]{"cacls", path, "/P", user + ":" + windowsPerm};
        Process p = Runtime.getRuntime().exec(args);
        p.getOutputStream().write("Y\n".getBytes());
        p.getOutputStream().flush();
        return p.waitFor();
    }

    public static boolean isWebStart() {
        return SetupUtils.isWebStart();
    }

    public static boolean isCli() {
        return "true".equals(System.getProperty("org.opends.quicksetup.cli"));
    }

    public static InitialLdapContext createLdapContext(String ldapURL, String dn, String pwd, int timeout, Hashtable<String, String> env) throws NamingException {
        return ConnectionUtils.createLdapContext(ldapURL, dn, pwd, timeout, env);
    }

    public static InitialLdapContext createLdapsContext(String ldapsURL, String dn, String pwd, int timeout, Hashtable<String, String> env, TrustManager trustManager) throws NamingException {
        return ConnectionUtils.createLdapsContext(ldapsURL, dn, pwd, timeout, env, trustManager, null);
    }

    public static InitialLdapContext createStartTLSContext(String ldapsURL, String dn, String pwd, int timeout, Hashtable<String, String> env, TrustManager trustManager, HostnameVerifier verifier) throws NamingException {
        return ConnectionUtils.createStartTLSContext(ldapsURL, dn, pwd, timeout, env, trustManager, null, verifier);
    }

    public static boolean canConnectAsAdministrativeUser(String ldapUrl, String dn, String pwd) {
        return ConnectionUtils.canConnectAsAdministrativeUser(ldapUrl, dn, pwd);
    }

    public static boolean isCertificateException(Throwable t) {
        return ConnectionUtils.isCertificateException(t);
    }

    public static int getDefaultLDAPTimeout() {
        return ConnectionUtils.getDefaultLDAPTimeout();
    }

    public static String getInstallPathFromClasspath() {
        String installPath = null;
        String sep = System.getProperty("path.separator");
        String[] classPaths = System.getProperty("java.class.path").split(sep);
        String path = null;
        for (int i = 0; i < classPaths.length && path == null; ++i) {
            for (int j = 0; j < Installation.OPEN_DS_JAR_RELATIVE_PATHS.length && path == null; ++j) {
                String normPath = classPaths[i].replace(File.separatorChar, '/');
                if (!normPath.endsWith(Installation.OPEN_DS_JAR_RELATIVE_PATHS[j])) continue;
                path = classPaths[i];
            }
        }
        if (path != null) {
            File f = new File(path).getAbsoluteFile();
            File librariesDir = f.getParentFile();
            try {
                installPath = librariesDir.getParentFile().getCanonicalPath();
            }
            catch (IOException ioe) {
                installPath = librariesDir.getParent();
            }
        }
        return installPath;
    }

    public static int getCommandLineMaxLineWidth() {
        return 80;
    }

    public static void setMacOSXMenuBar(Message appName) {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", String.valueOf(appName));
    }

    private static boolean isOutOfMemory(Throwable t) {
        boolean isOutOfMemory = false;
        while (!isOutOfMemory && t != null) {
            String msg;
            if (t instanceof OutOfMemoryError) {
                isOutOfMemory = true;
            } else if (t instanceof IOException && (msg = t.toString()) != null) {
                isOutOfMemory = msg.indexOf("Not enough space") != -1;
            }
            t = t.getCause();
        }
        return isOutOfMemory;
    }

    public static int getNumberZipEntries() {
        return 165;
    }

    public static boolean isParentOf(File ancestor, File descendant) {
        if (ancestor != null) {
            if (ancestor.equals(descendant)) {
                return false;
            }
            while (descendant != null && !ancestor.equals(descendant)) {
                descendant = descendant.getParentFile();
            }
        }
        return ancestor != null && descendant != null;
    }

    public static String listToString(List<?> list, String separator) {
        return Utils.listToString(list, separator, null, null);
    }

    public static Message listToMessage(List<Message> list, String separator, String prefix, String suffix) {
        MessageBuilder sb = new MessageBuilder();
        for (int i = 0; i < list.size(); ++i) {
            if (prefix != null) {
                sb.append(prefix);
            }
            sb.append(list.get(i));
            if (suffix != null) {
                sb.append(suffix);
            }
            if (i >= list.size() - 1) continue;
            sb.append(separator);
        }
        return sb.toMessage();
    }

    public static String listToString(List<?> list, String separator, String prefix, String suffix) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            if (prefix != null) {
                sb.append(prefix);
            }
            sb.append(list.get(i));
            if (suffix != null) {
                sb.append(suffix);
            }
            if (i >= list.size() - 1) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static String stringArrayToString(String[] array, String separator) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            sb.append(array[i]);
            if (i >= array.length - 1) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static String getFileSystemPermissions(String path) {
        return Utils.getFileSystemPermissions(new File(path));
    }

    public static String getFileSystemPermissions(File file) {
        String name = file.getName();
        String perm = file.getParent().endsWith(File.separator + "bat") || file.getParent().endsWith(File.separator + "bin") ? (name.endsWith(".bat") ? "644" : "755") : (name.endsWith(".sh") ? "755" : (name.endsWith("setup") || name.endsWith("uninstall") || name.endsWith("upgrade") ? "755" : (name.endsWith("JavaApplicationStub") ? "755" : "644")));
        return perm;
    }

    public static String getBuildString(Installation installation) {
        String b = null;
        try {
            BuildInformation bi = installation.getBuildInformation();
            if (bi != null) {
                b = bi.toString();
            }
        }
        catch (ApplicationException e) {
            LOG.log(Level.INFO, "error trying to determine current build string", e);
        }
        if (b == null) {
            b = QuickSetupMessages.INFO_UPGRADE_BUILD_ID_UNKNOWN.get().toString();
        }
        return b;
    }

    public static String getFirstValue(SearchResult entry, String attrName) throws NamingException {
        return ConnectionUtils.getFirstValue(entry, attrName);
    }

    public static String breakHtmlString(CharSequence cs, int maxll) {
        if (cs != null) {
            String d = ((Object)cs).toString();
            int len = d.length();
            if (len <= 0) {
                return d;
            }
            if (len > maxll) {
                for (String tag : Constants.BREAKING_TAGS) {
                    int p = d.lastIndexOf(tag, maxll);
                    if (p <= 0 || p >= len) continue;
                    return d.substring(0, p + tag.length()) + Utils.breakHtmlString(d.substring(p + tag.length()), maxll);
                }
                int p = d.lastIndexOf(32, maxll);
                if (p <= 0) {
                    p = d.indexOf(32, maxll);
                }
                if (p > 0 && p < len) {
                    return d.substring(0, p) + "<br>" + Utils.breakHtmlString(d.substring(p + 1), maxll);
                }
                return d;
            }
            return d;
        }
        return null;
    }

    public static String convertHtmlBreakToLineSeparator(String s) {
        return s.replaceAll("\\<br\\>", Constants.LINE_SEPARATOR);
    }

    public static String stripHtml(String s) {
        String o = null;
        if (s != null) {
            o = s.replaceAll("\\<.*?\\>", "");
        }
        return o;
    }

    public static boolean containsHtml(String text) {
        return text != null && text.indexOf(60) != -1 && text.indexOf(62) != -1;
    }

    public static EmptyPrintStream getEmptyPrintStream() {
        if (emptyStream == null) {
            emptyStream = new EmptyPrintStream();
        }
        return emptyStream;
    }

    public static long getServerClock(InitialLdapContext ctx) {
        long time = -1L;
        String v = null;
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(0);
        ctls.setReturningAttributes(new String[]{"currentTime"});
        String filter = "(objectclass=*)";
        try {
            LdapName jndiName = new LdapName("cn=monitor");
            NamingEnumeration<SearchResult> listeners = ctx.search((Name)jndiName, filter, ctls);
            while (listeners.hasMore()) {
                SearchResult sr = listeners.next();
                v = Utils.getFirstValue(sr, "currentTime");
                TimeZone utcTimeZone = TimeZone.getTimeZone("UTC");
                SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
                formatter.setTimeZone(utcTimeZone);
                time = formatter.parse(v).getTime();
            }
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "Error retrieving server current time: " + t, t);
        }
        return time;
    }

    public static void checkJavaVersion() throws IncompatibleVersionException {
        String vendor = System.getProperty("java.vendor");
        String version = System.getProperty("java.version");
        for (CompatibleJava i : CompatibleJava.values()) {
            boolean versionCompatible;
            if (!i.getVendor().equalsIgnoreCase(vendor)) continue;
            boolean bl = versionCompatible = i.getVersion().compareToIgnoreCase(version) <= 0;
            if (versionCompatible) continue;
            String javaBin = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
            throw new IncompatibleVersionException(QuickSetupMessages.ERR_INCOMPATIBLE_VERSION.get(i.getVersion(), version, javaBin), null);
        }
    }

    static String escapeHtml(String rawString) {
        StringBuilder buffer = new StringBuilder();
        block6: for (int i = 0; i < rawString.length(); ++i) {
            char c = rawString.charAt(i);
            switch (c) {
                case '<': {
                    buffer.append("&lt;");
                    continue block6;
                }
                case '>': {
                    buffer.append("&gt;");
                    continue block6;
                }
                case '&': {
                    buffer.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    buffer.append("&quot;");
                    continue block6;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }

    public static String getHtml(String text) {
        StringBuilder buffer = new StringBuilder();
        if (text != null) {
            text = text.replaceAll("\r\n", "\n");
            String[] lines = text.split("[\n\r\u0085\u2028\u2029]");
            for (int i = 0; i < lines.length; ++i) {
                if (i != 0) {
                    buffer.append("<br>");
                }
                buffer.append(Utils.escapeHtml(lines[i]));
            }
        }
        return buffer.toString();
    }
}

