/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.std.meta;

import java.util.Collection;
import java.util.SortedSet;
import org.opends.server.admin.AdministratorAction;
import org.opends.server.admin.BooleanPropertyDefinition;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.DefinedDefaultBehaviorProvider;
import org.opends.server.admin.DurationPropertyDefinition;
import org.opends.server.admin.IntegerPropertyDefinition;
import org.opends.server.admin.ManagedObjectAlreadyExistsException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.PropertyProvider;
import org.opends.server.admin.StringPropertyDefinition;
import org.opends.server.admin.Tag;
import org.opends.server.admin.UndefinedDefaultBehaviorProvider;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.MissingMandatoryPropertiesException;
import org.opends.server.admin.client.OperationRejectedException;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ServerManagedObject;
import org.opends.server.admin.std.client.FIFOEntryCacheCfgClient;
import org.opends.server.admin.std.meta.EntryCacheCfgDefn;
import org.opends.server.admin.std.server.EntryCacheCfg;
import org.opends.server.admin.std.server.FIFOEntryCacheCfg;
import org.opends.server.types.DN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FIFOEntryCacheCfgDefn
extends ManagedObjectDefinition<FIFOEntryCacheCfgClient, FIFOEntryCacheCfg> {
    private static final FIFOEntryCacheCfgDefn INSTANCE = new FIFOEntryCacheCfgDefn();
    private static final StringPropertyDefinition PD_EXCLUDE_FILTER;
    private static final StringPropertyDefinition PD_INCLUDE_FILTER;
    private static final ClassPropertyDefinition PD_JAVA_CLASS;
    private static final DurationPropertyDefinition PD_LOCK_TIMEOUT;
    private static final IntegerPropertyDefinition PD_MAX_ENTRIES;
    private static final IntegerPropertyDefinition PD_MAX_MEMORY_PERCENT;

    public static FIFOEntryCacheCfgDefn getInstance() {
        return INSTANCE;
    }

    private FIFOEntryCacheCfgDefn() {
        super("fifo-entry-cache", EntryCacheCfgDefn.getInstance());
    }

    @Override
    public FIFOEntryCacheCfgClient createClientConfiguration(ManagedObject<? extends FIFOEntryCacheCfgClient> impl) {
        return new FIFOEntryCacheCfgClientImpl(impl);
    }

    @Override
    public FIFOEntryCacheCfg createServerConfiguration(ServerManagedObject<? extends FIFOEntryCacheCfg> impl) {
        return new FIFOEntryCacheCfgServerImpl(impl);
    }

    @Override
    public Class<FIFOEntryCacheCfg> getServerConfigurationClass() {
        return FIFOEntryCacheCfg.class;
    }

    public IntegerPropertyDefinition getCacheLevelPropertyDefinition() {
        return EntryCacheCfgDefn.getInstance().getCacheLevelPropertyDefinition();
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return EntryCacheCfgDefn.getInstance().getEnabledPropertyDefinition();
    }

    public StringPropertyDefinition getExcludeFilterPropertyDefinition() {
        return PD_EXCLUDE_FILTER;
    }

    public StringPropertyDefinition getIncludeFilterPropertyDefinition() {
        return PD_INCLUDE_FILTER;
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    public DurationPropertyDefinition getLockTimeoutPropertyDefinition() {
        return PD_LOCK_TIMEOUT;
    }

    public IntegerPropertyDefinition getMaxEntriesPropertyDefinition() {
        return PD_MAX_ENTRIES;
    }

    public IntegerPropertyDefinition getMaxMemoryPercentPropertyDefinition() {
        return PD_MAX_MEMORY_PERCENT;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = StringPropertyDefinition.createBuilder(INSTANCE, "exclude-filter");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "exclude-filter"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_EXCLUDE_FILTER = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_EXCLUDE_FILTER);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "include-filter");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "include-filter"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_INCLUDE_FILTER = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_INCLUDE_FILTER);
        builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "java-class"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("org.opends.server.extensions.FIFOEntryCache");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.api.EntryCache");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        builder = DurationPropertyDefinition.createBuilder(INSTANCE, "lock-timeout");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "lock-timeout"));
        provider = new DefinedDefaultBehaviorProvider("2000.0ms");
        builder.setDefaultBehaviorProvider(provider);
        ((DurationPropertyDefinition.Builder)builder).setAllowUnlimited(true);
        ((DurationPropertyDefinition.Builder)builder).setBaseUnit("ms");
        ((DurationPropertyDefinition.Builder)builder).setLowerLimit("0");
        PD_LOCK_TIMEOUT = (DurationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_LOCK_TIMEOUT);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "max-entries");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "max-entries"));
        provider = new DefinedDefaultBehaviorProvider("2147483647");
        builder.setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(0);
        PD_MAX_ENTRIES = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_MAX_ENTRIES);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "max-memory-percent");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "max-memory-percent"));
        provider = new DefinedDefaultBehaviorProvider("90");
        builder.setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)builder).setUpperLimit(100);
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(1);
        PD_MAX_MEMORY_PERCENT = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_MAX_MEMORY_PERCENT);
        INSTANCE.registerTag(Tag.valueOf("database"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FIFOEntryCacheCfgServerImpl
    implements FIFOEntryCacheCfg {
        private ServerManagedObject<? extends FIFOEntryCacheCfg> impl;
        private final int pCacheLevel;
        private final boolean pEnabled;
        private final SortedSet<String> pExcludeFilter;
        private final SortedSet<String> pIncludeFilter;
        private final String pJavaClass;
        private final long pLockTimeout;
        private final int pMaxEntries;
        private final int pMaxMemoryPercent;

        private FIFOEntryCacheCfgServerImpl(ServerManagedObject<? extends FIFOEntryCacheCfg> impl) {
            this.impl = impl;
            this.pCacheLevel = impl.getPropertyValue(INSTANCE.getCacheLevelPropertyDefinition());
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pExcludeFilter = impl.getPropertyValues((PropertyDefinition)INSTANCE.getExcludeFilterPropertyDefinition());
            this.pIncludeFilter = impl.getPropertyValues((PropertyDefinition)INSTANCE.getIncludeFilterPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
            this.pLockTimeout = impl.getPropertyValue(INSTANCE.getLockTimeoutPropertyDefinition());
            this.pMaxEntries = impl.getPropertyValue(INSTANCE.getMaxEntriesPropertyDefinition());
            this.pMaxMemoryPercent = impl.getPropertyValue(INSTANCE.getMaxMemoryPercentPropertyDefinition());
        }

        @Override
        public void addFIFOChangeListener(ConfigurationChangeListener<FIFOEntryCacheCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeFIFOChangeListener(ConfigurationChangeListener<FIFOEntryCacheCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<EntryCacheCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<EntryCacheCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public int getCacheLevel() {
            return this.pCacheLevel;
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public SortedSet<String> getExcludeFilter() {
            return this.pExcludeFilter;
        }

        @Override
        public SortedSet<String> getIncludeFilter() {
            return this.pIncludeFilter;
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public long getLockTimeout() {
            return this.pLockTimeout;
        }

        @Override
        public int getMaxEntries() {
            return this.pMaxEntries;
        }

        @Override
        public int getMaxMemoryPercent() {
            return this.pMaxMemoryPercent;
        }

        @Override
        public Class<? extends FIFOEntryCacheCfg> configurationClass() {
            return FIFOEntryCacheCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FIFOEntryCacheCfgClientImpl
    implements FIFOEntryCacheCfgClient {
        private ManagedObject<? extends FIFOEntryCacheCfgClient> impl;

        private FIFOEntryCacheCfgClientImpl(ManagedObject<? extends FIFOEntryCacheCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public Integer getCacheLevel() {
            return this.impl.getPropertyValue(INSTANCE.getCacheLevelPropertyDefinition());
        }

        @Override
        public void setCacheLevel(int value) {
            this.impl.setPropertyValue(INSTANCE.getCacheLevelPropertyDefinition(), value);
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public SortedSet<String> getExcludeFilter() {
            return this.impl.getPropertyValues(INSTANCE.getExcludeFilterPropertyDefinition());
        }

        @Override
        public void setExcludeFilter(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getExcludeFilterPropertyDefinition(), values);
        }

        @Override
        public SortedSet<String> getIncludeFilter() {
            return this.impl.getPropertyValues(INSTANCE.getIncludeFilterPropertyDefinition());
        }

        @Override
        public void setIncludeFilter(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getIncludeFilterPropertyDefinition(), values);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public long getLockTimeout() {
            return this.impl.getPropertyValue(INSTANCE.getLockTimeoutPropertyDefinition());
        }

        @Override
        public void setLockTimeout(Long value) {
            this.impl.setPropertyValue(INSTANCE.getLockTimeoutPropertyDefinition(), value);
        }

        @Override
        public int getMaxEntries() {
            return this.impl.getPropertyValue(INSTANCE.getMaxEntriesPropertyDefinition());
        }

        @Override
        public void setMaxEntries(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getMaxEntriesPropertyDefinition(), value);
        }

        @Override
        public int getMaxMemoryPercent() {
            return this.impl.getPropertyValue(INSTANCE.getMaxMemoryPercentPropertyDefinition());
        }

        @Override
        public void setMaxMemoryPercent(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getMaxMemoryPercentPropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends FIFOEntryCacheCfgClient, ? extends FIFOEntryCacheCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, AuthorizationException, CommunicationException {
            this.impl.commit();
        }
    }
}

