/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.std.meta;

import java.util.Collection;
import java.util.SortedSet;
import org.opends.server.admin.AdministratorAction;
import org.opends.server.admin.BooleanPropertyDefinition;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.DefinedDefaultBehaviorProvider;
import org.opends.server.admin.DurationPropertyDefinition;
import org.opends.server.admin.IPAddressMaskPropertyDefinition;
import org.opends.server.admin.ManagedObjectAlreadyExistsException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.PropertyProvider;
import org.opends.server.admin.StringPropertyDefinition;
import org.opends.server.admin.Tag;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.MissingMandatoryPropertiesException;
import org.opends.server.admin.client.OperationRejectedException;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ServerManagedObject;
import org.opends.server.admin.std.client.LDIFConnectionHandlerCfgClient;
import org.opends.server.admin.std.meta.ConnectionHandlerCfgDefn;
import org.opends.server.admin.std.server.ConnectionHandlerCfg;
import org.opends.server.admin.std.server.LDIFConnectionHandlerCfg;
import org.opends.server.types.AddressMask;
import org.opends.server.types.DN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LDIFConnectionHandlerCfgDefn
extends ManagedObjectDefinition<LDIFConnectionHandlerCfgClient, LDIFConnectionHandlerCfg> {
    private static final LDIFConnectionHandlerCfgDefn INSTANCE = new LDIFConnectionHandlerCfgDefn();
    private static final ClassPropertyDefinition PD_JAVA_CLASS;
    private static final StringPropertyDefinition PD_LDIF_DIRECTORY;
    private static final DurationPropertyDefinition PD_POLL_INTERVAL;

    public static LDIFConnectionHandlerCfgDefn getInstance() {
        return INSTANCE;
    }

    private LDIFConnectionHandlerCfgDefn() {
        super("ldif-connection-handler", ConnectionHandlerCfgDefn.getInstance());
    }

    @Override
    public LDIFConnectionHandlerCfgClient createClientConfiguration(ManagedObject<? extends LDIFConnectionHandlerCfgClient> impl) {
        return new LDIFConnectionHandlerCfgClientImpl(impl);
    }

    @Override
    public LDIFConnectionHandlerCfg createServerConfiguration(ServerManagedObject<? extends LDIFConnectionHandlerCfg> impl) {
        return new LDIFConnectionHandlerCfgServerImpl(impl);
    }

    @Override
    public Class<LDIFConnectionHandlerCfg> getServerConfigurationClass() {
        return LDIFConnectionHandlerCfg.class;
    }

    public IPAddressMaskPropertyDefinition getAllowedClientPropertyDefinition() {
        return ConnectionHandlerCfgDefn.getInstance().getAllowedClientPropertyDefinition();
    }

    public IPAddressMaskPropertyDefinition getDeniedClientPropertyDefinition() {
        return ConnectionHandlerCfgDefn.getInstance().getDeniedClientPropertyDefinition();
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return ConnectionHandlerCfgDefn.getInstance().getEnabledPropertyDefinition();
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    public StringPropertyDefinition getLDIFDirectoryPropertyDefinition() {
        return PD_LDIF_DIRECTORY;
    }

    public DurationPropertyDefinition getPollIntervalPropertyDefinition() {
        return PD_POLL_INTERVAL;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "java-class"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("org.opends.server.protocols.LDIFConnectionHandler");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.api.ConnectionHandler");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "ldif-directory");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "ldif-directory"));
        provider = new DefinedDefaultBehaviorProvider("config/auto-process-ldif");
        builder.setDefaultBehaviorProvider(provider);
        PD_LDIF_DIRECTORY = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_LDIF_DIRECTORY);
        builder = DurationPropertyDefinition.createBuilder(INSTANCE, "poll-interval");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "poll-interval"));
        provider = new DefinedDefaultBehaviorProvider("5 seconds");
        builder.setDefaultBehaviorProvider(provider);
        ((DurationPropertyDefinition.Builder)builder).setBaseUnit("ms");
        ((DurationPropertyDefinition.Builder)builder).setLowerLimit("1");
        PD_POLL_INTERVAL = (DurationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_POLL_INTERVAL);
        INSTANCE.registerTag(Tag.valueOf("core-server"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LDIFConnectionHandlerCfgServerImpl
    implements LDIFConnectionHandlerCfg {
        private ServerManagedObject<? extends LDIFConnectionHandlerCfg> impl;
        private final SortedSet<AddressMask> pAllowedClient;
        private final SortedSet<AddressMask> pDeniedClient;
        private final boolean pEnabled;
        private final String pJavaClass;
        private final String pLDIFDirectory;
        private final long pPollInterval;

        private LDIFConnectionHandlerCfgServerImpl(ServerManagedObject<? extends LDIFConnectionHandlerCfg> impl) {
            this.impl = impl;
            this.pAllowedClient = impl.getPropertyValues((PropertyDefinition)INSTANCE.getAllowedClientPropertyDefinition());
            this.pDeniedClient = impl.getPropertyValues((PropertyDefinition)INSTANCE.getDeniedClientPropertyDefinition());
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
            this.pLDIFDirectory = impl.getPropertyValue(INSTANCE.getLDIFDirectoryPropertyDefinition());
            this.pPollInterval = impl.getPropertyValue(INSTANCE.getPollIntervalPropertyDefinition());
        }

        @Override
        public void addLDIFChangeListener(ConfigurationChangeListener<LDIFConnectionHandlerCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeLDIFChangeListener(ConfigurationChangeListener<LDIFConnectionHandlerCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<ConnectionHandlerCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<ConnectionHandlerCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public SortedSet<AddressMask> getAllowedClient() {
            return this.pAllowedClient;
        }

        @Override
        public SortedSet<AddressMask> getDeniedClient() {
            return this.pDeniedClient;
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public String getLDIFDirectory() {
            return this.pLDIFDirectory;
        }

        @Override
        public long getPollInterval() {
            return this.pPollInterval;
        }

        @Override
        public Class<? extends LDIFConnectionHandlerCfg> configurationClass() {
            return LDIFConnectionHandlerCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LDIFConnectionHandlerCfgClientImpl
    implements LDIFConnectionHandlerCfgClient {
        private ManagedObject<? extends LDIFConnectionHandlerCfgClient> impl;

        private LDIFConnectionHandlerCfgClientImpl(ManagedObject<? extends LDIFConnectionHandlerCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public SortedSet<AddressMask> getAllowedClient() {
            return this.impl.getPropertyValues(INSTANCE.getAllowedClientPropertyDefinition());
        }

        @Override
        public void setAllowedClient(Collection<AddressMask> values) {
            this.impl.setPropertyValues(INSTANCE.getAllowedClientPropertyDefinition(), values);
        }

        @Override
        public SortedSet<AddressMask> getDeniedClient() {
            return this.impl.getPropertyValues(INSTANCE.getDeniedClientPropertyDefinition());
        }

        @Override
        public void setDeniedClient(Collection<AddressMask> values) {
            this.impl.setPropertyValues(INSTANCE.getDeniedClientPropertyDefinition(), values);
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public String getLDIFDirectory() {
            return this.impl.getPropertyValue(INSTANCE.getLDIFDirectoryPropertyDefinition());
        }

        @Override
        public void setLDIFDirectory(String value) {
            this.impl.setPropertyValue(INSTANCE.getLDIFDirectoryPropertyDefinition(), value);
        }

        @Override
        public long getPollInterval() {
            return this.impl.getPropertyValue(INSTANCE.getPollIntervalPropertyDefinition());
        }

        @Override
        public void setPollInterval(long value) {
            this.impl.setPropertyValue(INSTANCE.getPollIntervalPropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends LDIFConnectionHandlerCfgClient, ? extends LDIFConnectionHandlerCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, AuthorizationException, CommunicationException {
            this.impl.commit();
        }
    }
}

