/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.authorization.dseecompat;

import java.net.InetAddress;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opends.messages.AccessControlMessages;
import org.opends.messages.Message;
import org.opends.server.authorization.dseecompat.AciEvalContext;
import org.opends.server.authorization.dseecompat.AciException;
import org.opends.server.authorization.dseecompat.EnumBindRuleType;
import org.opends.server.authorization.dseecompat.EnumEvalResult;
import org.opends.server.authorization.dseecompat.KeywordBindRule;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DNS
implements KeywordBindRule {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    LinkedList<String> patterns = null;
    private EnumBindRuleType type = null;
    private static final String valueRegex = "([a-zA-Z0-9\\.\\-\\*]+)";
    private static final String valuesRegExGroup = "([a-zA-Z0-9\\.\\-\\*]+)\\s*(,\\s*([a-zA-Z0-9\\.\\-\\*]+))*";

    DNS(LinkedList<String> patterns, EnumBindRuleType type) {
        this.patterns = patterns;
        this.type = type;
    }

    public static DNS decode(String expr, EnumBindRuleType type) throws AciException {
        if (!Pattern.matches(valuesRegExGroup, expr)) {
            Message message = AccessControlMessages.WARN_ACI_SYNTAX_INVALID_DNS_EXPRESSION.get(expr);
            throw new AciException(message);
        }
        LinkedList<String> dns = new LinkedList<String>();
        int valuePos = 1;
        Pattern valuePattern = Pattern.compile(valueRegex);
        Matcher valueMatcher = valuePattern.matcher(expr);
        while (valueMatcher.find()) {
            String hn = valueMatcher.group(valuePos);
            String[] hnArray = hn.split("\\.", -1);
            int n = hnArray.length;
            for (int i = 1; i < n; ++i) {
                if (!hnArray[i].equals("*")) continue;
                Message message = AccessControlMessages.WARN_ACI_SYNTAX_INVALID_DNS_WILDCARD.get(expr);
                throw new AciException(message);
            }
            if (hn.indexOf("*") < 0) {
                try {
                    for (InetAddress addr : InetAddress.getAllByName(hn)) {
                        Message message;
                        String canonicalName = addr.getCanonicalHostName();
                        if (hn.equalsIgnoreCase(canonicalName)) continue;
                        if (hn.equalsIgnoreCase("localhost") && !dns.contains(canonicalName)) {
                            dns.add(canonicalName);
                            message = AccessControlMessages.WARN_ACI_LOCALHOST_DOESNT_MATCH_CANONICAL_VALUE.get(expr, hn, canonicalName);
                            ErrorLogger.logError(message);
                            continue;
                        }
                        message = AccessControlMessages.WARN_ACI_HOSTNAME_DOESNT_MATCH_CANONICAL_VALUE.get(expr, hn, addr.getHostAddress(), addr.getCanonicalHostName());
                        ErrorLogger.logError(message);
                    }
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    Message message = AccessControlMessages.WARN_ACI_ERROR_CHECKING_CANONICAL_HOSTNAME.get(hn, expr, StaticUtils.getExceptionMessage(e));
                    ErrorLogger.logError(message);
                }
            }
            dns.add(hn);
        }
        return new DNS(dns, type);
    }

    @Override
    public EnumEvalResult evaluate(AciEvalContext evalCtx) {
        EnumEvalResult matched = EnumEvalResult.FALSE;
        String[] remoteHost = evalCtx.getHostName().split("\\.", -1);
        for (String p : this.patterns) {
            String[] pat = p.split("\\.", -1);
            if (!this.evalHostName(remoteHost, pat)) continue;
            matched = EnumEvalResult.TRUE;
            break;
        }
        return matched.getRet(this.type, false);
    }

    boolean evalHostName(String[] remoteHostName, String[] pat) {
        boolean wildCard = pat[0].equals("*");
        if (pat.length == 1 && wildCard) {
            return true;
        }
        int remoteHnIndex = remoteHostName.length - pat.length;
        if (remoteHnIndex < 0) {
            return false;
        }
        int patternIndex = 0;
        if (!wildCard) {
            remoteHnIndex = 0;
        } else {
            patternIndex = 1;
            ++remoteHnIndex;
        }
        for (int i = remoteHnIndex; i < remoteHostName.length; ++i) {
            if (pat[patternIndex++].equalsIgnoreCase(remoteHostName[i])) continue;
            return false;
        }
        return true;
    }
}

