/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.authorization.dseecompat;

import java.util.HashSet;
import java.util.regex.Pattern;
import org.opends.messages.AccessControlMessages;
import org.opends.messages.Message;
import org.opends.server.authorization.dseecompat.AciException;
import org.opends.server.authorization.dseecompat.EnumTargetOperator;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.AttributeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetAttr {
    private EnumTargetOperator operator = EnumTargetOperator.EQUALITY;
    private boolean allUserAttributes = false;
    private boolean allOpAttributes = false;
    private HashSet<AttributeType> attributes = new HashSet();
    private HashSet<AttributeType> opAttributes = new HashSet();
    private static final String attrListRegex = "\\s*((?i)[a-z\\d]{1}[[a-z]\\d-_.;]*(?-i)|\\*{1}|\\+{1})\\s*(\\|\\|\\s*((?i)[a-z\\d]{1}[[a-z]\\d-_.;]*(?-i)|\\*{1}|\\+{1})\\s*)*";

    private TargetAttr(EnumTargetOperator operator, String attrString) throws AciException {
        this.operator = operator;
        if (attrString != null) {
            if (Pattern.matches("\\s*\\*\\s*", attrString)) {
                this.allUserAttributes = true;
            } else if (Pattern.matches("\\s*\\+\\s*", attrString)) {
                this.allOpAttributes = true;
            } else if (Pattern.matches("\\s*", attrString)) {
                this.allUserAttributes = false;
                this.allOpAttributes = false;
            } else if (Pattern.matches(attrListRegex, attrString)) {
                Pattern separatorPattern = Pattern.compile("\\|\\|");
                attrString = attrString.replaceAll("\\s*", "");
                String[] attributeArray = separatorPattern.split(attrString);
                this.arrayToAttributeTypes(attributeArray, attrString);
            } else {
                Message message = AccessControlMessages.WARN_ACI_SYNTAX_INVALID_TARGETATTRKEYWORD_EXPRESSION.get(attrString);
                throw new AciException(message);
            }
        }
    }

    private void arrayToAttributeTypes(String[] attributeArray, String attrStr) throws AciException {
        int n = attributeArray.length;
        for (int i = 0; i < n; ++i) {
            Message message;
            String attribute = attributeArray[i].toLowerCase();
            if (attribute.equals("*")) {
                if (!this.allUserAttributes) {
                    this.allUserAttributes = true;
                    continue;
                }
                message = AccessControlMessages.WARN_ACI_TARGETATTR_INVALID_ATTR_TOKEN.get(attrStr);
                throw new AciException(message);
            }
            if (attribute.equals("+")) {
                if (!this.allOpAttributes) {
                    this.allOpAttributes = true;
                    continue;
                }
                message = AccessControlMessages.WARN_ACI_TARGETATTR_INVALID_ATTR_TOKEN.get(attrStr);
                throw new AciException(message);
            }
            AttributeType attributeType = DirectoryServer.getAttributeType(attribute);
            if (attributeType == null) {
                attributeType = DirectoryServer.getDefaultAttributeType(attribute);
            }
            if (attributeType.isOperational()) {
                this.opAttributes.add(attributeType);
                continue;
            }
            this.attributes.add(attributeType);
        }
    }

    public EnumTargetOperator getOperator() {
        return this.operator;
    }

    public boolean isAllUserAttributes() {
        return this.allUserAttributes;
    }

    public boolean isAllOpAttributes() {
        return this.allOpAttributes;
    }

    public HashSet<AttributeType> getAttributes() {
        return this.attributes;
    }

    public HashSet<AttributeType> getOpAttributes() {
        return this.opAttributes;
    }

    public static TargetAttr decode(EnumTargetOperator operator, String expr) throws AciException {
        return new TargetAttr(operator, expr);
    }

    public static boolean isApplicable(AttributeType a, TargetAttr targetAttr) {
        boolean ret = targetAttr.isAllUserAttributes() && targetAttr.isAllOpAttributes() ? !targetAttr.getOperator().equals((Object)EnumTargetOperator.NOT_EQUALITY) : TargetAttr.evalAttrType(a, targetAttr);
        return ret;
    }

    private static boolean evalAttrType(AttributeType a, TargetAttr targetAttr) {
        boolean ret = false;
        if (a.isOperational()) {
            if (targetAttr.isAllOpAttributes() || targetAttr.opAttributes.contains(a)) {
                ret = true;
            }
            if ((targetAttr.isAllOpAttributes() || !targetAttr.opAttributes.isEmpty()) && targetAttr.getOperator().equals((Object)EnumTargetOperator.NOT_EQUALITY)) {
                ret = !ret;
            }
        } else {
            if (targetAttr.isAllUserAttributes() || targetAttr.attributes.contains(a)) {
                ret = true;
            }
            if ((targetAttr.isAllUserAttributes() || !targetAttr.attributes.isEmpty()) && targetAttr.getOperator().equals((Object)EnumTargetOperator.NOT_EQUALITY)) {
                ret = !ret;
            }
        }
        return ret;
    }
}

