/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.opends.messages.JebMessages;
import org.opends.server.backends.jeb.DatabaseContainer;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.EntryIDSet;
import org.opends.server.backends.jeb.IndexBuffer;
import org.opends.server.backends.jeb.Indexer;
import org.opends.server.backends.jeb.State;
import org.opends.server.backends.jeb.importLDIF.ImportIDSet;
import org.opends.server.backends.jeb.importLDIF.IntegerImportIDSet;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ConditionResult;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.Modification;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Index
extends DatabaseContainer {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    public Indexer indexer;
    private Comparator<byte[]> comparator;
    private int indexEntryLimit;
    private int cursorEntryLimit;
    private int entryLimitExceededCount;
    final int phantomWriteRetires = 3;
    boolean maintainCount;
    private State state;
    private boolean trusted = false;
    private boolean rebuildRunning = false;
    private ThreadLocal<Cursor> curLocal = new ThreadLocal();

    public Index(String name, Indexer indexer, State state, int indexEntryLimit, int cursorEntryLimit, boolean maintainCount, Environment env, EntryContainer entryContainer) throws DatabaseException {
        super(name, env, entryContainer);
        this.indexer = indexer;
        this.comparator = indexer.getComparator();
        this.indexEntryLimit = indexEntryLimit;
        this.cursorEntryLimit = cursorEntryLimit;
        this.maintainCount = maintainCount;
        DatabaseConfig dbNodupsConfig = new DatabaseConfig();
        if (env.getConfig().getReadOnly()) {
            dbNodupsConfig.setReadOnly(true);
            dbNodupsConfig.setAllowCreate(false);
            dbNodupsConfig.setTransactional(false);
        } else if (!env.getConfig().getTransactional()) {
            dbNodupsConfig.setAllowCreate(true);
            dbNodupsConfig.setTransactional(false);
            dbNodupsConfig.setDeferredWrite(true);
        } else {
            dbNodupsConfig.setAllowCreate(true);
            dbNodupsConfig.setTransactional(true);
        }
        this.dbConfig = dbNodupsConfig;
        this.dbConfig.setOverrideBtreeComparator(true);
        this.dbConfig.setBtreeComparator(this.comparator.getClass());
        this.state = state;
        this.trusted = state.getIndexTrustState(null, this);
        if (!this.trusted && entryContainer.getHighestEntryID().equals(new EntryID(0L))) {
            this.setTrusted(null, true);
        }
        if (!this.trusted) {
            ErrorLogger.logError(JebMessages.NOTE_JEB_INDEX_ADD_REQUIRES_REBUILD.get(name));
        }
    }

    public boolean insertID(IndexBuffer buffer, byte[] keyBytes, EntryID entryID) {
        TreeMap<byte[], IndexBuffer.BufferedIndexValues> bufferedOperations = buffer.getBufferedIndex(this);
        IndexBuffer.BufferedIndexValues values = null;
        if (bufferedOperations == null) {
            bufferedOperations = new TreeMap(this.comparator);
            buffer.putBufferedIndex(this, bufferedOperations);
        } else {
            values = bufferedOperations.get(keyBytes);
        }
        if (values == null) {
            values = new IndexBuffer.BufferedIndexValues();
            bufferedOperations.put(keyBytes, values);
        }
        if (values.deletedIDs != null && values.deletedIDs.contains(entryID)) {
            values.deletedIDs.remove(entryID);
            return true;
        }
        if (values.addedIDs == null) {
            values.addedIDs = new EntryIDSet(keyBytes, null);
        }
        values.addedIDs.add(entryID);
        return true;
    }

    public boolean insertID(Transaction txn, DatabaseEntry key, EntryID entryID) throws DatabaseException {
        DatabaseEntry entryIDData = entryID.getDatabaseEntry();
        DatabaseEntry data = new DatabaseEntry();
        boolean success = false;
        if (this.maintainCount) {
            for (int i = 0; i < 3; ++i) {
                if (this.insertIDWithRMW(txn, key, data, entryIDData, entryID) != OperationStatus.SUCCESS) continue;
                return true;
            }
        } else {
            OperationStatus status = this.read(txn, key, data, LockMode.READ_COMMITTED);
            if (status == OperationStatus.SUCCESS) {
                EntryIDSet entryIDList = new EntryIDSet(key.getData(), data.getData());
                if (entryIDList.isDefined()) {
                    for (int i = 0; i < 3; ++i) {
                        if (this.insertIDWithRMW(txn, key, data, entryIDData, entryID) != OperationStatus.SUCCESS) continue;
                        return true;
                    }
                }
            } else if (this.rebuildRunning || this.trusted) {
                status = this.insert(txn, key, entryIDData);
                if (status == OperationStatus.KEYEXIST) {
                    for (int i = 1; i < 3; ++i) {
                        if (this.insertIDWithRMW(txn, key, data, entryIDData, entryID) != OperationStatus.SUCCESS) continue;
                        return true;
                    }
                }
            } else {
                return true;
            }
        }
        return success;
    }

    private void insert(DatabaseEntry key, ImportIDSet importIdSet, DatabaseEntry data, Cursor cursor) throws DatabaseException {
        OperationStatus status = cursor.getSearchKey(key, data, LockMode.DEFAULT);
        if (status == OperationStatus.SUCCESS) {
            IntegerImportIDSet newImportIDSet = new IntegerImportIDSet();
            if (newImportIDSet.merge(data.getData(), importIdSet, this.indexEntryLimit, this.maintainCount) && importIdSet.isDirty()) {
                ++this.entryLimitExceededCount;
                importIdSet.setDirty(false);
            }
            data.setData(newImportIDSet.toDatabase());
            cursor.putCurrent(data);
        } else if (status == OperationStatus.NOTFOUND) {
            if (!importIdSet.isDefined() && importIdSet.isDirty()) {
                ++this.entryLimitExceededCount;
                importIdSet.setDirty(false);
            }
            data.setData(importIdSet.toDatabase());
            cursor.put(key, data);
        } else {
            throw new DatabaseException();
        }
    }

    public void insert(DatabaseEntry key, ImportIDSet importIdSet, DatabaseEntry data) throws DatabaseException {
        Cursor cursor = this.curLocal.get();
        if (cursor == null) {
            cursor = this.openCursor(null, null);
            this.curLocal.set(cursor);
        }
        this.insert(key, importIdSet, data, cursor);
    }

    public synchronized boolean insert(ImportIDSet importIDSet, Set<byte[]> keySet, DatabaseEntry keyData, DatabaseEntry data) throws DatabaseException {
        Cursor cursor = this.curLocal.get();
        if (cursor == null) {
            cursor = this.openCursor(null, null);
            this.curLocal.set(cursor);
        }
        for (byte[] key : keySet) {
            keyData.setData(key);
            this.insert(keyData, importIDSet, data, cursor);
        }
        keyData.setData(null);
        data.setData(null);
        return true;
    }

    private OperationStatus insertIDWithRMW(Transaction txn, DatabaseEntry key, DatabaseEntry data, DatabaseEntry entryIDData, EntryID entryID) throws DatabaseException {
        OperationStatus status = this.read(txn, key, data, LockMode.RMW);
        if (status == OperationStatus.SUCCESS) {
            EntryIDSet entryIDList = new EntryIDSet(key.getData(), data.getData());
            if (entryIDList.isDefined() && this.indexEntryLimit > 0 && entryIDList.size() >= (long)this.indexEntryLimit) {
                entryIDList = this.maintainCount ? new EntryIDSet(entryIDList.size()) : new EntryIDSet();
                ++this.entryLimitExceededCount;
                if (DebugLogger.debugEnabled()) {
                    StringBuilder builder = new StringBuilder();
                    StaticUtils.byteArrayToHexPlusAscii(builder, key.getData(), 4);
                    TRACER.debugInfo("Index entry exceeded in index %s. Limit: %d. ID list size: %d.\nKey:", this.name, this.indexEntryLimit, entryIDList.size(), builder);
                }
            }
            entryIDList.add(entryID);
            byte[] after = entryIDList.toDatabase();
            data.setData(after);
            return this.put(txn, key, data);
        }
        if (this.rebuildRunning || this.trusted) {
            return this.insert(txn, key, entryIDData);
        }
        return OperationStatus.SUCCESS;
    }

    void updateKey(Transaction txn, DatabaseEntry key, EntryIDSet deletedIDs, EntryIDSet addedIDs) throws DatabaseException {
        block11: {
            OperationStatus status;
            DatabaseEntry data;
            block12: {
                block10: {
                    data = new DatabaseEntry();
                    if (deletedIDs != null && deletedIDs.size() == 0L && (addedIDs == null || addedIDs.size() == 0L)) {
                        return;
                    }
                    if (addedIDs != null && addedIDs.size() == 0L && (deletedIDs == null || deletedIDs.size() == 0L)) {
                        return;
                    }
                    if (deletedIDs == null && addedIDs == null) {
                        OperationStatus status2 = this.delete(txn, key);
                        if (status2 != OperationStatus.SUCCESS && DebugLogger.debugEnabled()) {
                            StringBuilder builder = new StringBuilder();
                            StaticUtils.byteArrayToHexPlusAscii(builder, key.getData(), 4);
                            TRACER.debugError("The expected key does not exist in the index %s.\nKey:%s", this.name, builder.toString());
                        }
                        return;
                    }
                    if (!this.maintainCount) break block10;
                    for (int i = 0; i < 3; ++i) {
                        if (this.updateKeyWithRMW(txn, key, data, deletedIDs, addedIDs) != OperationStatus.SUCCESS) continue;
                        return;
                    }
                    break block11;
                }
                status = this.read(txn, key, data, LockMode.READ_COMMITTED);
                if (status != OperationStatus.SUCCESS) break block12;
                EntryIDSet entryIDList = new EntryIDSet(key.getData(), data.getData());
                if (!entryIDList.isDefined()) break block11;
                for (int i = 0; i < 3; ++i) {
                    if (this.updateKeyWithRMW(txn, key, data, deletedIDs, addedIDs) != OperationStatus.SUCCESS) continue;
                    return;
                }
                break block11;
            }
            if (this.rebuildRunning || this.trusted) {
                if (deletedIDs != null && DebugLogger.debugEnabled()) {
                    StringBuilder builder = new StringBuilder();
                    StaticUtils.byteArrayToHexPlusAscii(builder, key.getData(), 4);
                    TRACER.debugError("The expected key does not exist in the index %s.\nKey:%s", this.name, builder.toString());
                }
                data.setData(addedIDs.toDatabase());
                status = this.insert(txn, key, data);
                if (status == OperationStatus.KEYEXIST) {
                    for (int i = 1; i < 3; ++i) {
                        if (this.updateKeyWithRMW(txn, key, data, deletedIDs, addedIDs) != OperationStatus.SUCCESS) continue;
                        return;
                    }
                }
            }
        }
    }

    private OperationStatus updateKeyWithRMW(Transaction txn, DatabaseEntry key, DatabaseEntry data, EntryIDSet deletedIDs, EntryIDSet addedIDs) throws DatabaseException {
        OperationStatus status = this.read(txn, key, data, LockMode.RMW);
        if (status == OperationStatus.SUCCESS) {
            EntryIDSet entryIDList = new EntryIDSet(key.getData(), data.getData());
            if (addedIDs != null) {
                if (entryIDList.isDefined() && this.indexEntryLimit > 0) {
                    long idCountDelta = addedIDs.size();
                    if (deletedIDs != null) {
                        idCountDelta -= deletedIDs.size();
                    }
                    if (idCountDelta + entryIDList.size() >= (long)this.indexEntryLimit) {
                        entryIDList = this.maintainCount ? new EntryIDSet(entryIDList.size() + idCountDelta) : new EntryIDSet();
                        ++this.entryLimitExceededCount;
                        if (DebugLogger.debugEnabled()) {
                            StringBuilder builder = new StringBuilder();
                            StaticUtils.byteArrayToHexPlusAscii(builder, key.getData(), 4);
                            TRACER.debugInfo("Index entry exceeded in index %s. Limit: %d. ID list size: %d.\nKey:", this.name, this.indexEntryLimit, idCountDelta + addedIDs.size(), builder);
                        }
                    } else {
                        entryIDList.addAll(addedIDs);
                        if (deletedIDs != null) {
                            entryIDList.deleteAll(deletedIDs);
                        }
                    }
                } else {
                    entryIDList.addAll(addedIDs);
                    if (deletedIDs != null) {
                        entryIDList.deleteAll(deletedIDs);
                    }
                }
            } else if (deletedIDs != null) {
                entryIDList.deleteAll(deletedIDs);
            }
            byte[] after = entryIDList.toDatabase();
            if (after == null) {
                return this.delete(txn, key);
            }
            data.setData(after);
            return this.put(txn, key, data);
        }
        if (this.rebuildRunning || this.trusted) {
            if (deletedIDs != null && DebugLogger.debugEnabled()) {
                StringBuilder builder = new StringBuilder();
                StaticUtils.byteArrayToHexPlusAscii(builder, key.getData(), 4);
                TRACER.debugError("The expected key does not exist in the index %s.\nKey:%s", this.name, builder.toString());
            }
            data.setData(addedIDs.toDatabase());
            return this.insert(txn, key, data);
        }
        return OperationStatus.SUCCESS;
    }

    public boolean removeID(IndexBuffer buffer, byte[] keyBytes, EntryID entryID) {
        TreeMap<byte[], IndexBuffer.BufferedIndexValues> bufferedOperations = buffer.getBufferedIndex(this);
        IndexBuffer.BufferedIndexValues values = null;
        if (bufferedOperations == null) {
            bufferedOperations = new TreeMap(this.comparator);
            buffer.putBufferedIndex(this, bufferedOperations);
        } else {
            values = bufferedOperations.get(keyBytes);
        }
        if (values == null) {
            values = new IndexBuffer.BufferedIndexValues();
            bufferedOperations.put(keyBytes, values);
        }
        if (values.addedIDs != null && values.addedIDs.contains(entryID)) {
            values.addedIDs.remove(entryID);
            return true;
        }
        if (values.deletedIDs == null) {
            values.deletedIDs = new EntryIDSet(keyBytes, null);
        }
        values.deletedIDs.add(entryID);
        return true;
    }

    public void removeID(Transaction txn, DatabaseEntry key, EntryID entryID) throws DatabaseException {
        DatabaseEntry data = new DatabaseEntry();
        if (this.maintainCount) {
            this.removeIDWithRMW(txn, key, data, entryID);
        } else {
            OperationStatus status = this.read(txn, key, data, LockMode.READ_COMMITTED);
            if (status == OperationStatus.SUCCESS) {
                EntryIDSet entryIDList = new EntryIDSet(key.getData(), data.getData());
                if (entryIDList.isDefined()) {
                    this.removeIDWithRMW(txn, key, data, entryID);
                }
            } else if (this.trusted && !this.rebuildRunning) {
                this.setTrusted(txn, false);
                if (DebugLogger.debugEnabled()) {
                    StringBuilder builder = new StringBuilder();
                    StaticUtils.byteArrayToHexPlusAscii(builder, key.getData(), 4);
                    TRACER.debugError("The expected key does not exist in the index %s.\nKey:%s", this.name, builder.toString());
                }
                ErrorLogger.logError(JebMessages.ERR_JEB_INDEX_CORRUPT_REQUIRES_REBUILD.get(this.name));
            }
        }
    }

    public synchronized void delete(Transaction txn, Set<byte[]> keySet, EntryID entryID) throws DatabaseException {
        this.setTrusted(txn, false);
        for (byte[] key : keySet) {
            this.removeIDWithRMW(txn, new DatabaseEntry(key), new DatabaseEntry(), entryID);
        }
        this.setTrusted(txn, true);
    }

    private void removeIDWithRMW(Transaction txn, DatabaseEntry key, DatabaseEntry data, EntryID entryID) throws DatabaseException {
        OperationStatus status = this.read(txn, key, data, LockMode.RMW);
        if (status == OperationStatus.SUCCESS) {
            EntryIDSet entryIDList = new EntryIDSet(key.getData(), data.getData());
            if (!entryIDList.remove(entryID) && !this.rebuildRunning) {
                if (this.trusted) {
                    this.setTrusted(txn, false);
                    if (DebugLogger.debugEnabled()) {
                        StringBuilder builder = new StringBuilder();
                        StaticUtils.byteArrayToHexPlusAscii(builder, key.getData(), 4);
                        TRACER.debugError("The expected entry ID does not exist in the entry ID list for index %s.\nKey:%s", this.name, builder.toString());
                    }
                    ErrorLogger.logError(JebMessages.ERR_JEB_INDEX_CORRUPT_REQUIRES_REBUILD.get(this.name));
                }
            } else {
                byte[] after = entryIDList.toDatabase();
                if (after == null) {
                    this.delete(txn, key);
                } else {
                    data.setData(after);
                    this.put(txn, key, data);
                }
            }
        } else if (this.trusted && !this.rebuildRunning) {
            this.setTrusted(txn, false);
            if (DebugLogger.debugEnabled()) {
                StringBuilder builder = new StringBuilder();
                StaticUtils.byteArrayToHexPlusAscii(builder, key.getData(), 4);
                TRACER.debugError("The expected key does not exist in the index %s.\nKey:%s", this.name, builder.toString());
            }
            ErrorLogger.logError(JebMessages.ERR_JEB_INDEX_CORRUPT_REQUIRES_REBUILD.get(this.name));
        }
    }

    public void delete(IndexBuffer buffer, byte[] keyBytes) {
        TreeMap<byte[], IndexBuffer.BufferedIndexValues> bufferedOperations = buffer.getBufferedIndex(this);
        IndexBuffer.BufferedIndexValues values = null;
        if (bufferedOperations == null) {
            bufferedOperations = new TreeMap(this.comparator);
            buffer.putBufferedIndex(this, bufferedOperations);
        } else {
            values = bufferedOperations.get(keyBytes);
        }
        if (values == null) {
            values = new IndexBuffer.BufferedIndexValues();
            bufferedOperations.put(keyBytes, values);
        }
    }

    public ConditionResult containsID(Transaction txn, DatabaseEntry key, EntryID entryID) throws DatabaseException {
        if (this.rebuildRunning) {
            return ConditionResult.UNDEFINED;
        }
        DatabaseEntry data = new DatabaseEntry();
        LockMode lockMode = LockMode.DEFAULT;
        OperationStatus status = this.read(txn, key, data, lockMode);
        if (status == OperationStatus.SUCCESS) {
            EntryIDSet entryIDList = new EntryIDSet(key.getData(), data.getData());
            if (!entryIDList.isDefined()) {
                return ConditionResult.UNDEFINED;
            }
            if (entryIDList.contains(entryID)) {
                return ConditionResult.TRUE;
            }
            return ConditionResult.FALSE;
        }
        if (this.trusted) {
            return ConditionResult.FALSE;
        }
        return ConditionResult.UNDEFINED;
    }

    public EntryIDSet readKey(DatabaseEntry key, Transaction txn, LockMode lockMode) {
        if (this.rebuildRunning) {
            return new EntryIDSet();
        }
        try {
            DatabaseEntry data = new DatabaseEntry();
            OperationStatus status = this.read(txn, key, data, lockMode);
            if (status != OperationStatus.SUCCESS) {
                if (this.trusted) {
                    return new EntryIDSet(key.getData(), null);
                }
                return new EntryIDSet();
            }
            return new EntryIDSet(key.getData(), data.getData());
        }
        catch (DatabaseException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return new EntryIDSet();
        }
    }

    public void writeKey(Transaction txn, DatabaseEntry key, EntryIDSet entryIDList) throws DatabaseException {
        DatabaseEntry data = new DatabaseEntry();
        byte[] after = entryIDList.toDatabase();
        if (after == null) {
            this.delete(txn, key);
        } else {
            if (!entryIDList.isDefined()) {
                ++this.entryLimitExceededCount;
            }
            data.setData(after);
            this.put(txn, key, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EntryIDSet readRange(byte[] lower, byte[] upper, boolean lowerIncluded, boolean upperIncluded) {
        LockMode lockMode = LockMode.DEFAULT;
        if (this.rebuildRunning) return new EntryIDSet();
        if (!this.trusted) {
            return new EntryIDSet();
        }
        try {
            int totalIDCount = 0;
            DatabaseEntry data = new DatabaseEntry();
            ArrayList<EntryIDSet> lists = new ArrayList<EntryIDSet>();
            Cursor cursor = this.openCursor(null, CursorConfig.READ_COMMITTED);
            try {
                int cmp;
                OperationStatus status;
                DatabaseEntry key;
                if (lower.length > 0) {
                    key = new DatabaseEntry(lower);
                    status = cursor.getSearchKeyRange(key, data, lockMode);
                    if (status == OperationStatus.SUCCESS && !lowerIncluded && this.comparator.compare(key.getData(), lower) == 0) {
                        status = cursor.getNext(key, data, lockMode);
                    }
                } else {
                    key = new DatabaseEntry();
                    status = cursor.getNext(key, data, lockMode);
                }
                if (status != OperationStatus.SUCCESS) {
                    EntryIDSet entryIDSet = new EntryIDSet(key.getData(), null);
                    return entryIDSet;
                }
                while (status == OperationStatus.SUCCESS && (upper.length <= 0 || (cmp = this.comparator.compare(key.getData(), upper)) <= 0 && (cmp != 0 || upperIncluded))) {
                    EntryIDSet list = new EntryIDSet(key.getData(), data.getData());
                    if (!list.isDefined()) {
                        EntryIDSet entryIDSet = list;
                        return entryIDSet;
                    }
                    totalIDCount = (int)((long)totalIDCount + list.size());
                    if (this.cursorEntryLimit > 0 && totalIDCount > this.cursorEntryLimit) {
                        EntryIDSet entryIDSet = new EntryIDSet();
                        return entryIDSet;
                    }
                    lists.add(list);
                    status = cursor.getNext(key, data, LockMode.DEFAULT);
                }
                EntryIDSet entryIDSet = EntryIDSet.unionOfSets(lists, false);
                return entryIDSet;
            }
            finally {
                cursor.close();
            }
        }
        catch (DatabaseException e) {
            if (!DebugLogger.debugEnabled()) return new EntryIDSet();
            TRACER.debugCaught(DebugLogLevel.ERROR, e);
            return new EntryIDSet();
        }
    }

    public int getEntryLimitExceededCount() {
        return this.entryLimitExceededCount;
    }

    public void closeCursor() throws DatabaseException {
        Cursor cursor = this.curLocal.get();
        if (cursor != null) {
            cursor.close();
            this.curLocal.remove();
        }
    }

    public void incEntryLimitExceededCount() {
        ++this.entryLimitExceededCount;
    }

    public boolean addEntry(IndexBuffer buffer, EntryID entryID, Entry entry) throws DatabaseException, DirectoryException {
        HashSet<byte[]> addKeys = new HashSet<byte[]>();
        boolean success = true;
        this.indexer.indexEntry(entry, addKeys);
        for (byte[] keyBytes : addKeys) {
            if (this.insertID(buffer, keyBytes, entryID)) continue;
            success = false;
        }
        return success;
    }

    public boolean addEntry(Transaction txn, EntryID entryID, Entry entry) throws DatabaseException, DirectoryException {
        TreeSet<byte[]> addKeys = new TreeSet<byte[]>(this.indexer.getComparator());
        boolean success = true;
        this.indexer.indexEntry(entry, addKeys);
        DatabaseEntry key = new DatabaseEntry();
        for (byte[] keyBytes : addKeys) {
            key.setData(keyBytes);
            if (this.insertID(txn, key, entryID)) continue;
            success = false;
        }
        return success;
    }

    public void removeEntry(IndexBuffer buffer, EntryID entryID, Entry entry) throws DatabaseException, DirectoryException {
        HashSet<byte[]> delKeys = new HashSet<byte[]>();
        this.indexer.indexEntry(entry, delKeys);
        for (byte[] keyBytes : delKeys) {
            this.removeID(buffer, keyBytes, entryID);
        }
    }

    public void removeEntry(Transaction txn, EntryID entryID, Entry entry) throws DatabaseException, DirectoryException {
        TreeSet<byte[]> delKeys = new TreeSet<byte[]>(this.indexer.getComparator());
        this.indexer.indexEntry(entry, delKeys);
        DatabaseEntry key = new DatabaseEntry();
        for (byte[] keyBytes : delKeys) {
            key.setData(keyBytes);
            this.removeID(txn, key, entryID);
        }
    }

    public void modifyEntry(Transaction txn, EntryID entryID, Entry oldEntry, Entry newEntry, List<Modification> mods) throws DatabaseException {
        TreeMap<byte[], Boolean> modifiedKeys = new TreeMap<byte[], Boolean>(this.indexer.getComparator());
        this.indexer.modifyEntry(oldEntry, newEntry, mods, modifiedKeys);
        DatabaseEntry key = new DatabaseEntry();
        for (Map.Entry<byte[], Boolean> modifiedKey : modifiedKeys.entrySet()) {
            key.setData(modifiedKey.getKey());
            if (modifiedKey.getValue().booleanValue()) {
                this.insertID(txn, key, entryID);
                continue;
            }
            this.removeID(txn, key, entryID);
        }
    }

    public void modifyEntry(IndexBuffer buffer, EntryID entryID, Entry oldEntry, Entry newEntry, List<Modification> mods) throws DatabaseException {
        HashMap<byte[], Boolean> modifiedKeys = new HashMap<byte[], Boolean>();
        this.indexer.modifyEntry(oldEntry, newEntry, mods, modifiedKeys);
        for (Map.Entry<byte[], Boolean> modifiedKey : modifiedKeys.entrySet()) {
            if (modifiedKey.getValue().booleanValue()) {
                this.insertID(buffer, modifiedKey.getKey(), entryID);
                continue;
            }
            this.removeID(buffer, modifiedKey.getKey(), entryID);
        }
    }

    public boolean setIndexEntryLimit(int indexEntryLimit) {
        boolean rebuildRequired = false;
        if (this.indexEntryLimit < indexEntryLimit && this.entryLimitExceededCount > 0) {
            rebuildRequired = true;
        }
        this.indexEntryLimit = indexEntryLimit;
        return rebuildRequired;
    }

    public void setIndexer(Indexer indexer) {
        this.indexer = indexer;
    }

    public int getIndexEntryLimit() {
        return this.indexEntryLimit;
    }

    public synchronized void setTrusted(Transaction txn, boolean trusted) throws DatabaseException {
        this.trusted = trusted;
        this.state.putIndexTrustState(txn, this, trusted);
    }

    public synchronized boolean isTrusted() {
        return this.trusted;
    }

    public synchronized void setRebuildStatus(boolean rebuildRunning) {
        this.rebuildRunning = rebuildRunning;
    }

    public boolean getMaintainCount() {
        return this.maintainCount;
    }
}

