/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb.importLDIF;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.opends.server.admin.std.server.LocalDBBackendCfg;
import org.opends.server.backends.jeb.AttributeIndex;
import org.opends.server.backends.jeb.DN2ID;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.Index;
import org.opends.server.backends.jeb.VLVIndex;
import org.opends.server.backends.jeb.importLDIF.BufferManager;
import org.opends.server.backends.jeb.importLDIF.WorkElement;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DN;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.util.LDIFReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DNContext {
    private DN baseDN;
    private List<DN> includeBranches;
    private List<DN> excludeBranches;
    private LocalDBBackendCfg config;
    private LDIFImportConfig ldifImportConfig;
    private LDIFReader ldifReader;
    private EntryContainer entryContainer;
    private EntryContainer srcEntryContainer;
    private BlockingQueue<WorkElement> workQueue;
    private ArrayList<VLVIndex> vlvIndexes = new ArrayList();
    private static final int PARENT_ID_MAP_SIZE = 100;
    private HashMap<DN, EntryID> parentIDMap = new HashMap(100);
    private ConcurrentHashMap<DN, DN> pendingMap = new ConcurrentHashMap();
    private final Object synchObject = new Object();
    private AtomicLong entryInsertCount = new AtomicLong(0L);
    private DN parentDN;
    private ArrayList<EntryID> IDs;
    private BufferManager bufferManager;

    public BlockingQueue<WorkElement> getWorkQueue() {
        return this.workQueue;
    }

    public void setWorkQueue(BlockingQueue<WorkElement> workQueue) {
        this.workQueue = workQueue;
    }

    public void setBaseDN(DN baseDN) {
        this.baseDN = baseDN;
    }

    public DN getBaseDN() {
        return this.baseDN;
    }

    public void setConfig(LocalDBBackendCfg config) {
        this.config = config;
    }

    public LocalDBBackendCfg getConfig() {
        return this.config;
    }

    public void setLDIFImportConfig(LDIFImportConfig ldifImportConfig) {
        this.ldifImportConfig = ldifImportConfig;
    }

    public LDIFImportConfig getLDIFImportConfig() {
        return this.ldifImportConfig;
    }

    public void setLDIFReader(LDIFReader ldifReader) {
        this.ldifReader = ldifReader;
    }

    public LDIFReader getLDIFReader() {
        return this.ldifReader;
    }

    public void setEntryContainer(EntryContainer entryContainer) {
        this.entryContainer = entryContainer;
    }

    public EntryContainer getEntryContainer() {
        return this.entryContainer;
    }

    public void setSrcEntryContainer(EntryContainer srcEntryContainer) {
        this.srcEntryContainer = srcEntryContainer;
    }

    public EntryContainer getSrcEntryContainer() {
        return this.srcEntryContainer;
    }

    public long getEntryInsertCount() {
        return this.entryInsertCount.get();
    }

    public void incrEntryInsertCount(long delta) {
        this.entryInsertCount.getAndAdd(delta);
    }

    public DN getParentDN() {
        return this.parentDN;
    }

    public void setParentDN(DN parentDN) {
        this.parentDN = parentDN;
    }

    public ArrayList<EntryID> getIDs() {
        return this.IDs;
    }

    public void setIDs(ArrayList<EntryID> IDs) {
        this.IDs = IDs;
    }

    public List<DN> getExcludeBranches() {
        return this.excludeBranches;
    }

    public void setExcludeBranches(List<DN> excludeBranches) {
        this.excludeBranches = excludeBranches == null ? new ArrayList<DN>(0) : excludeBranches;
    }

    public List<DN> getIncludeBranches() {
        return this.includeBranches;
    }

    public void setIncludeBranches(List<DN> includeBranches) {
        this.includeBranches = includeBranches == null ? new ArrayList<DN>(0) : includeBranches;
    }

    public Map<AttributeType, AttributeIndex> getAttrIndexMap() {
        return this.entryContainer.getAttributeIndexMap();
    }

    public void setIndexesTrusted() throws DatabaseException {
        this.entryContainer.getID2Children().setTrusted(null, true);
        this.entryContainer.getID2Subtree().setTrusted(null, true);
        for (AttributeIndex attributeIndex : this.entryContainer.getAttributeIndexes()) {
            Index index = attributeIndex.getEqualityIndex();
            if (index != null) {
                index.setTrusted(null, true);
            }
            if ((index = attributeIndex.getPresenceIndex()) != null) {
                index.setTrusted(null, true);
            }
            if ((index = attributeIndex.getSubstringIndex()) != null) {
                index.setTrusted(null, true);
            }
            if ((index = attributeIndex.getOrderingIndex()) != null) {
                index.setTrusted(null, true);
            }
            if ((index = attributeIndex.getApproximateIndex()) == null) continue;
            index.setTrusted(null, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntryID getParentID(DN parentDN, DN2ID dn2id) throws DatabaseException {
        EntryID parentID;
        Object object = this.synchObject;
        synchronized (object) {
            parentID = this.parentIDMap.get(parentDN);
            if (parentID != null) {
                return parentID;
            }
        }
        int i = 0;
        while (this.isPending(parentDN)) {
            try {
                Thread.sleep(50L);
                if (i == 10) {
                    return null;
                }
                ++i;
            }
            catch (Exception e) {
                return null;
            }
        }
        parentID = dn2id.get(null, parentDN, LockMode.DEFAULT);
        if (parentID != null) {
            Object object2 = this.synchObject;
            synchronized (object2) {
                if (this.parentIDMap.size() >= 100) {
                    Iterator<DN> iterator = this.parentIDMap.keySet().iterator();
                    iterator.next();
                    iterator.remove();
                }
                this.parentIDMap.put(parentDN, parentID);
            }
        }
        return parentID;
    }

    private boolean isPending(DN parentDN) {
        boolean ret = false;
        if (this.pendingMap.containsKey(parentDN)) {
            ret = true;
        }
        return ret;
    }

    public void addPending(DN dn) {
        this.pendingMap.putIfAbsent(dn, dn);
    }

    public void removePending(DN dn) {
        this.pendingMap.remove(dn);
    }

    public void setBufferManager(BufferManager bufferManager) {
        this.bufferManager = bufferManager;
    }

    public BufferManager getBufferManager() {
        return this.bufferManager;
    }
}

