/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.task;

import java.io.File;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import org.opends.messages.BackendMessages;
import org.opends.messages.Message;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.TaskBackendCfg;
import org.opends.server.api.Backend;
import org.opends.server.backends.task.RecurringTask;
import org.opends.server.backends.task.Task;
import org.opends.server.backends.task.TaskScheduler;
import org.opends.server.backends.task.TaskState;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.AddOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.BackupConfig;
import org.opends.server.types.BackupDirectory;
import org.opends.server.types.CanceledOperationException;
import org.opends.server.types.ConditionResult;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.IndexType;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.LDIFImportResult;
import org.opends.server.types.LockManager;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;
import org.opends.server.types.RestoreConfig;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchScope;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskBackend
extends Backend
implements ConfigurationChangeListener<TaskBackendCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private TaskBackendCfg currentConfig;
    private DN configEntryDN;
    private DN recurringTaskParentDN;
    private DN scheduledTaskParentDN;
    private DN taskRootDN;
    private DN[] baseDNs;
    private HashSet<String> supportedControls;
    private HashSet<String> supportedFeatures;
    private long retentionTime;
    private String notificationSenderAddress;
    private String taskBackingFile;
    private TaskScheduler taskScheduler;

    @Override
    public void configureBackend(Configuration config) throws ConfigException {
        Validator.ensureNotNull(config);
        Validator.ensureTrue(config instanceof TaskBackendCfg);
        TaskBackendCfg cfg = (TaskBackendCfg)config;
        DN[] baseDNs = new DN[cfg.getBaseDN().size()];
        cfg.getBaseDN().toArray(baseDNs);
        ConfigEntry configEntry = DirectoryServer.getConfigEntry(cfg.dn());
        this.configEntryDN = configEntry.getDN();
        if (baseDNs == null || baseDNs.length == 0) {
            Message message = BackendMessages.ERR_TASKBE_NO_BASE_DNS.get();
            throw new ConfigException(message);
        }
        if (baseDNs.length > 1) {
            Message message = BackendMessages.ERR_TASKBE_MULTIPLE_BASE_DNS.get();
            throw new ConfigException(message);
        }
        this.baseDNs = baseDNs;
        this.taskRootDN = baseDNs[0];
        String recurringTaskBaseString = "cn=Recurring Tasks," + this.taskRootDN.toString();
        try {
            this.recurringTaskParentDN = DN.decode(recurringTaskBaseString);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = BackendMessages.ERR_TASKBE_CANNOT_DECODE_RECURRING_TASK_BASE_DN.get(String.valueOf(recurringTaskBaseString), StaticUtils.getExceptionMessage(e));
            throw new ConfigException(message, (Throwable)e);
        }
        String scheduledTaskBaseString = "cn=Scheduled Tasks," + this.taskRootDN.toString();
        try {
            this.scheduledTaskParentDN = DN.decode(scheduledTaskBaseString);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = BackendMessages.ERR_TASKBE_CANNOT_DECODE_SCHEDULED_TASK_BASE_DN.get(String.valueOf(scheduledTaskBaseString), StaticUtils.getExceptionMessage(e));
            throw new ConfigException(message, (Throwable)e);
        }
        this.retentionTime = cfg.getTaskRetentionTime();
        this.notificationSenderAddress = cfg.getNotificationSenderAddress();
        if (this.notificationSenderAddress == null) {
            try {
                this.notificationSenderAddress = "opends-task-notification@" + InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (Exception e) {
                this.notificationSenderAddress = "opends-task-notification@opends.org";
            }
        }
        this.taskBackingFile = cfg.getTaskBackingFile();
        this.supportedControls = new HashSet(0);
        this.supportedFeatures = new HashSet(0);
        this.currentConfig = cfg;
    }

    @Override
    public void initializeBackend() throws ConfigException, InitializationException {
        this.taskScheduler = new TaskScheduler(this);
        this.taskScheduler.start();
        this.currentConfig.addTaskChangeListener(this);
        try {
            DirectoryServer.registerBaseDN(this.taskRootDN, this, true);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = BackendMessages.ERR_BACKEND_CANNOT_REGISTER_BASEDN.get(this.taskRootDN.toString(), StaticUtils.getExceptionMessage(e));
            throw new InitializationException(message, (Throwable)e);
        }
    }

    @Override
    public void finalizeBackend() {
        block8: {
            block7: {
                block6: {
                    this.currentConfig.removeTaskChangeListener(this);
                    try {
                        this.taskScheduler.stopScheduler();
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) break block6;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
                try {
                    Message message = BackendMessages.INFO_TASKBE_INTERRUPTED_BY_SHUTDOWN.get();
                    this.taskScheduler.interruptRunningTasks(TaskState.STOPPED_BY_SHUTDOWN, message, true);
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block7;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            try {
                DirectoryServer.deregisterBaseDN(this.taskRootDN);
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block8;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    @Override
    public DN[] getBaseDNs() {
        return this.baseDNs;
    }

    @Override
    public long getEntryCount() {
        if (this.taskScheduler != null) {
            return this.taskScheduler.getEntryCount();
        }
        return -1L;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public boolean isIndexed(AttributeType attributeType, IndexType indexType) {
        return true;
    }

    @Override
    public ConditionResult hasSubordinates(DN entryDN) throws DirectoryException {
        long ret = this.numSubordinates(entryDN, false);
        if (ret < 0L) {
            return ConditionResult.UNDEFINED;
        }
        if (ret == 0L) {
            return ConditionResult.FALSE;
        }
        return ConditionResult.TRUE;
    }

    @Override
    public long numSubordinates(DN entryDN, boolean subtree) throws DirectoryException {
        if (entryDN == null) {
            return -1L;
        }
        if (entryDN.equals(this.taskRootDN)) {
            if (!subtree) {
                return 2L;
            }
            return this.taskScheduler.getScheduledTaskCount() + this.taskScheduler.getRecurringTaskCount() + 2L;
        }
        if (entryDN.equals(this.scheduledTaskParentDN)) {
            return this.taskScheduler.getScheduledTaskCount();
        }
        if (entryDN.equals(this.recurringTaskParentDN)) {
            return this.taskScheduler.getRecurringTaskCount();
        }
        DN parentDN = entryDN.getParentDNInSuffix();
        if (parentDN == null) {
            return -1L;
        }
        if (parentDN.equals(this.scheduledTaskParentDN) && this.taskScheduler.getScheduledTask(entryDN) != null) {
            return 0L;
        }
        if (parentDN.equals(this.recurringTaskParentDN) && this.taskScheduler.getRecurringTask(entryDN) != null) {
            return 0L;
        }
        return -1L;
    }

    @Override
    public Entry getEntry(DN entryDN) throws DirectoryException {
        if (entryDN == null) {
            return null;
        }
        if (entryDN.equals(this.taskRootDN)) {
            return this.taskScheduler.getTaskRootEntry();
        }
        if (entryDN.equals(this.scheduledTaskParentDN)) {
            return this.taskScheduler.getScheduledTaskParentEntry();
        }
        if (entryDN.equals(this.recurringTaskParentDN)) {
            return this.taskScheduler.getRecurringTaskParentEntry();
        }
        DN parentDN = entryDN.getParentDNInSuffix();
        if (parentDN == null) {
            return null;
        }
        if (parentDN.equals(this.scheduledTaskParentDN)) {
            return this.taskScheduler.getScheduledTaskEntry(entryDN);
        }
        if (parentDN.equals(this.recurringTaskParentDN)) {
            return this.taskScheduler.getRecurringTaskEntry(entryDN);
        }
        return null;
    }

    @Override
    public void addEntry(Entry entry, AddOperation addOperation) throws DirectoryException {
        Entry e = entry.duplicate(false);
        DN entryDN = e.getDN();
        DN parentDN = entryDN.getParentDNInSuffix();
        if (parentDN == null) {
            Message message = BackendMessages.ERR_TASKBE_ADD_DISALLOWED_DN.get(String.valueOf(this.scheduledTaskParentDN), String.valueOf(this.recurringTaskParentDN));
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
        }
        if (parentDN.equals(this.scheduledTaskParentDN)) {
            Task task = this.taskScheduler.entryToScheduledTask(e, addOperation);
            this.taskScheduler.scheduleTask(task, true);
            return;
        }
        if (parentDN.equals(this.recurringTaskParentDN)) {
            RecurringTask recurringTask = this.taskScheduler.entryToRecurringTask(e);
            this.taskScheduler.addRecurringTask(recurringTask, true);
            return;
        }
        Message message = BackendMessages.ERR_TASKBE_ADD_DISALLOWED_DN.get(String.valueOf(this.scheduledTaskParentDN), String.valueOf(this.recurringTaskParentDN));
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void deleteEntry(DN entryDN, DeleteOperation deleteOperation) throws DirectoryException {
        DN parentDN = entryDN.getParentDNInSuffix();
        if (parentDN == null) {
            Message message = BackendMessages.ERR_TASKBE_DELETE_INVALID_ENTRY.get(String.valueOf(entryDN));
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
        }
        if (parentDN.equals(this.scheduledTaskParentDN)) {
            Task t = this.taskScheduler.getScheduledTask(entryDN);
            if (t == null) {
                Message message = BackendMessages.ERR_TASKBE_DELETE_NO_SUCH_TASK.get(String.valueOf(entryDN));
                throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message);
            }
            TaskState state = t.getTaskState();
            if (TaskState.isPending(state)) {
                this.taskScheduler.removePendingTask(t.getTaskID());
                return;
            }
            if (TaskState.isDone(t.getTaskState())) {
                this.taskScheduler.removeCompletedTask(t.getTaskID());
                return;
            }
            Message message = BackendMessages.ERR_TASKBE_DELETE_RUNNING.get(String.valueOf(entryDN));
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
        }
        if (!parentDN.equals(this.recurringTaskParentDN)) {
            Message message = BackendMessages.ERR_TASKBE_DELETE_INVALID_ENTRY.get(String.valueOf(entryDN));
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
        }
        RecurringTask rt = this.taskScheduler.getRecurringTask(entryDN);
        if (rt == null) {
            Message message = BackendMessages.ERR_TASKBE_DELETE_NO_SUCH_RECURRING_TASK.get(String.valueOf(entryDN));
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message);
        }
        this.taskScheduler.removeRecurringTask(rt.getRecurringTaskID());
    }

    @Override
    public void replaceEntry(Entry entry, ModifyOperation modifyOperation) throws DirectoryException {
        DN entryDN = entry.getDN();
        Lock entryLock = null;
        if (!this.taskScheduler.holdsSchedulerLock()) {
            for (int i = 0; i < 3 && (entryLock = LockManager.lockWrite(entryDN)) == null; ++i) {
            }
            if (entryLock == null) {
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), BackendMessages.ERR_TASKBE_MODIFY_CANNOT_LOCK_ENTRY.get(String.valueOf(entryDN)));
            }
        }
        try {
            DN parentDN = entryDN.getParentDNInSuffix();
            if (parentDN == null) {
                Message message = BackendMessages.ERR_TASKBE_MODIFY_INVALID_ENTRY.get(String.valueOf(entryDN));
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
            }
            if (parentDN.equals(this.scheduledTaskParentDN)) {
                Task t = this.taskScheduler.getScheduledTask(entryDN);
                if (t == null) {
                    Message message = BackendMessages.ERR_TASKBE_MODIFY_NO_SUCH_TASK.get(String.valueOf(entryDN));
                    throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message);
                }
                TaskState state = t.getTaskState();
                if (TaskState.isPending(state)) {
                    Task newTask = this.taskScheduler.entryToScheduledTask(entry, modifyOperation);
                    this.taskScheduler.removePendingTask(t.getTaskID());
                    this.taskScheduler.scheduleTask(newTask, true);
                    return;
                }
                if (TaskState.isRunning(state)) {
                    Message message;
                    boolean acceptable = true;
                    for (Modification m : modifyOperation.getModifications()) {
                        if (m.isInternal()) continue;
                        if (m.getModificationType() != ModificationType.REPLACE) {
                            acceptable = false;
                            break;
                        }
                        Attribute a = m.getAttribute();
                        AttributeType at = a.getAttributeType();
                        if (!at.hasName("ds-task-state")) {
                            acceptable = false;
                            break;
                        }
                        Iterator iterator = a.getValues().iterator();
                        if (!iterator.hasNext()) {
                            acceptable = false;
                            break;
                        }
                        AttributeValue v = (AttributeValue)iterator.next();
                        String valueString = StaticUtils.toLowerCase(v.getStringValue());
                        if (!valueString.startsWith("cancel") && !valueString.startsWith("stop")) {
                            acceptable = false;
                            break;
                        }
                        if (!iterator.hasNext()) continue;
                        acceptable = false;
                        break;
                    }
                    if (acceptable) {
                        message = BackendMessages.INFO_TASKBE_RUNNING_TASK_CANCELLED.get();
                        t.interruptTask(TaskState.STOPPED_BY_ADMINISTRATOR, message);
                        return;
                    }
                    message = BackendMessages.ERR_TASKBE_MODIFY_RUNNING.get(String.valueOf(entryDN));
                    throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
                }
                Message message = BackendMessages.ERR_TASKBE_MODIFY_COMPLETED.get(String.valueOf(entryDN));
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
            }
            if (parentDN.equals(this.recurringTaskParentDN)) {
                Message message = BackendMessages.ERR_TASKBE_MODIFY_RECURRING.get(String.valueOf(entryDN));
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
            }
            Message message = BackendMessages.ERR_TASKBE_MODIFY_INVALID_ENTRY.get(String.valueOf(entryDN));
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
        }
        finally {
            if (entryLock != null) {
                LockManager.unlock(entryDN, entryLock);
            }
        }
    }

    @Override
    public void renameEntry(DN currentDN, Entry entry, ModifyDNOperation modifyDNOperation) throws DirectoryException {
        Message message = BackendMessages.ERR_TASKBE_MODIFY_DN_NOT_SUPPORTED.get();
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void search(SearchOperation searchOperation) throws DirectoryException, CanceledOperationException {
        Entry e;
        boolean searchRoot = false;
        boolean searchScheduledParent = false;
        boolean searchScheduledTasks = false;
        boolean searchRecurringParent = false;
        boolean searchRecurringTasks = false;
        DN baseDN = searchOperation.getBaseDN();
        SearchScope searchScope = searchOperation.getScope();
        SearchFilter searchFilter = searchOperation.getFilter();
        if (baseDN.equals(this.taskRootDN)) {
            switch (searchScope) {
                case BASE_OBJECT: {
                    searchRoot = true;
                    break;
                }
                case SINGLE_LEVEL: {
                    searchScheduledParent = true;
                    searchRecurringParent = true;
                    break;
                }
                case WHOLE_SUBTREE: {
                    searchRoot = true;
                    searchScheduledParent = true;
                    searchRecurringParent = true;
                    searchScheduledTasks = true;
                    searchRecurringTasks = true;
                    break;
                }
                case SUBORDINATE_SUBTREE: {
                    searchScheduledParent = true;
                    searchRecurringParent = true;
                    searchScheduledTasks = true;
                    searchRecurringTasks = true;
                }
            }
        } else if (baseDN.equals(this.scheduledTaskParentDN)) {
            switch (searchScope) {
                case BASE_OBJECT: {
                    searchScheduledParent = true;
                    break;
                }
                case SINGLE_LEVEL: {
                    searchScheduledTasks = true;
                    break;
                }
                case WHOLE_SUBTREE: {
                    searchScheduledParent = true;
                    searchScheduledTasks = true;
                    break;
                }
                case SUBORDINATE_SUBTREE: {
                    searchScheduledTasks = true;
                }
            }
        } else if (baseDN.equals(this.recurringTaskParentDN)) {
            switch (searchScope) {
                case BASE_OBJECT: {
                    searchRecurringParent = true;
                    break;
                }
                case SINGLE_LEVEL: {
                    searchRecurringTasks = true;
                    break;
                }
                case WHOLE_SUBTREE: {
                    searchRecurringParent = true;
                    searchRecurringTasks = true;
                    break;
                }
                case SUBORDINATE_SUBTREE: {
                    searchRecurringTasks = true;
                }
            }
        } else {
            DN parentDN = baseDN.getParentDNInSuffix();
            if (parentDN == null) {
                Message message = BackendMessages.ERR_TASKBE_SEARCH_INVALID_BASE.get(String.valueOf(baseDN));
                throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message);
            }
            if (parentDN.equals(this.scheduledTaskParentDN)) {
                Lock lock = this.taskScheduler.readLockEntry(baseDN);
                try {
                    Entry e2 = this.taskScheduler.getScheduledTaskEntry(baseDN);
                    if (e2 == null) {
                        Message message = BackendMessages.ERR_TASKBE_SEARCH_NO_SUCH_TASK.get(String.valueOf(baseDN));
                        throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, this.scheduledTaskParentDN, null);
                    }
                    if ((searchScope == SearchScope.BASE_OBJECT || searchScope == SearchScope.WHOLE_SUBTREE) && searchFilter.matchesEntry(e2)) {
                        searchOperation.returnEntry(e2, null);
                    }
                    return;
                }
                finally {
                    this.taskScheduler.unlockEntry(baseDN, lock);
                }
            }
            if (parentDN.equals(this.recurringTaskParentDN)) {
                Lock lock = this.taskScheduler.readLockEntry(baseDN);
                try {
                    Entry e3 = this.taskScheduler.getRecurringTaskEntry(baseDN);
                    if (e3 == null) {
                        Message message = BackendMessages.ERR_TASKBE_SEARCH_NO_SUCH_RECURRING_TASK.get(String.valueOf(baseDN));
                        throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, this.recurringTaskParentDN, null);
                    }
                    if ((searchScope == SearchScope.BASE_OBJECT || searchScope == SearchScope.WHOLE_SUBTREE) && searchFilter.matchesEntry(e3)) {
                        searchOperation.returnEntry(e3, null);
                    }
                    return;
                }
                finally {
                    this.taskScheduler.unlockEntry(baseDN, lock);
                }
            }
            Message message = BackendMessages.ERR_TASKBE_SEARCH_INVALID_BASE.get(String.valueOf(baseDN));
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message);
        }
        if (searchRoot && searchFilter.matchesEntry(e = this.taskScheduler.getTaskRootEntry()) && !searchOperation.returnEntry(e, null)) {
            return;
        }
        if (searchScheduledParent && searchFilter.matchesEntry(e = this.taskScheduler.getScheduledTaskParentEntry()) && !searchOperation.returnEntry(e, null)) {
            return;
        }
        if (searchScheduledTasks && !this.taskScheduler.searchScheduledTasks(searchOperation)) {
            return;
        }
        if (searchRecurringParent && searchFilter.matchesEntry(e = this.taskScheduler.getRecurringTaskParentEntry()) && !searchOperation.returnEntry(e, null)) {
            return;
        }
        if (searchRecurringTasks && !this.taskScheduler.searchRecurringTasks(searchOperation)) {
            return;
        }
    }

    public HashSet<String> getSupportedControls() {
        return this.supportedControls;
    }

    public HashSet<String> getSupportedFeatures() {
        return this.supportedFeatures;
    }

    @Override
    public boolean supportsLDIFExport() {
        return true;
    }

    @Override
    public void exportLDIF(LDIFExportConfig exportConfig) throws DirectoryException {
    }

    @Override
    public boolean supportsLDIFImport() {
        return false;
    }

    @Override
    public LDIFImportResult importLDIF(LDIFImportConfig importConfig) throws DirectoryException {
        Message message = BackendMessages.ERR_TASKBE_IMPORT_NOT_SUPPORTED.get();
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public boolean supportsBackup() {
        return true;
    }

    @Override
    public boolean supportsBackup(BackupConfig backupConfig, StringBuilder unsupportedReason) {
        return true;
    }

    @Override
    public void createBackup(BackupConfig backupConfig) throws DirectoryException {
    }

    @Override
    public void removeBackup(BackupDirectory backupDirectory, String backupID) throws DirectoryException {
    }

    @Override
    public boolean supportsRestore() {
        return true;
    }

    @Override
    public void restoreBackup(RestoreConfig restoreConfig) throws DirectoryException {
    }

    @Override
    public boolean isConfigurationAcceptable(Configuration configuration, List<Message> unacceptableReasons) {
        TaskBackendCfg config = (TaskBackendCfg)configuration;
        return TaskBackend.isConfigAcceptable(config, unacceptableReasons, null);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(TaskBackendCfg configEntry, List<Message> unacceptableReasons) {
        return TaskBackend.isConfigAcceptable(configEntry, unacceptableReasons, this.taskBackingFile);
    }

    private static boolean isConfigAcceptable(TaskBackendCfg config, List<Message> unacceptableReasons, String taskBackingFile) {
        boolean configIsAcceptable = true;
        try {
            String tmpBackingFile = config.getTaskBackingFile();
            if (taskBackingFile == null || !taskBackingFile.equals(tmpBackingFile)) {
                File f = StaticUtils.getFileForPath(tmpBackingFile);
                if (f.exists()) {
                    if (taskBackingFile != null) {
                        unacceptableReasons.add(BackendMessages.ERR_TASKBE_BACKING_FILE_EXISTS.get(tmpBackingFile));
                        configIsAcceptable = false;
                    }
                } else {
                    File p = f.getParentFile();
                    if (p == null) {
                        unacceptableReasons.add(BackendMessages.ERR_TASKBE_INVALID_BACKING_FILE_PATH.get(tmpBackingFile));
                        configIsAcceptable = false;
                    } else if (!p.exists()) {
                        unacceptableReasons.add(BackendMessages.ERR_TASKBE_BACKING_FILE_MISSING_PARENT.get(p.getPath(), tmpBackingFile));
                        configIsAcceptable = false;
                    } else if (!p.isDirectory()) {
                        unacceptableReasons.add(BackendMessages.ERR_TASKBE_BACKING_FILE_PARENT_NOT_DIRECTORY.get(p.getPath(), tmpBackingFile));
                        configIsAcceptable = false;
                    }
                }
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            unacceptableReasons.add(BackendMessages.ERR_TASKBE_ERROR_GETTING_BACKING_FILE.get(StaticUtils.getExceptionMessage(e)));
            configIsAcceptable = false;
        }
        return configIsAcceptable;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(TaskBackendCfg configEntry) {
        String tmpNotificationAddress;
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        String tmpBackingFile = this.taskBackingFile;
        try {
            tmpBackingFile = configEntry.getTaskBackingFile();
            if (!this.taskBackingFile.equals(tmpBackingFile)) {
                File f = StaticUtils.getFileForPath(tmpBackingFile);
                if (f.exists()) {
                    messages.add(BackendMessages.ERR_TASKBE_BACKING_FILE_EXISTS.get(tmpBackingFile));
                    resultCode = ResultCode.CONSTRAINT_VIOLATION;
                } else {
                    File p = f.getParentFile();
                    if (p == null) {
                        messages.add(BackendMessages.ERR_TASKBE_INVALID_BACKING_FILE_PATH.get(tmpBackingFile));
                        resultCode = ResultCode.CONSTRAINT_VIOLATION;
                    } else if (!p.exists()) {
                        messages.add(BackendMessages.ERR_TASKBE_BACKING_FILE_MISSING_PARENT.get(String.valueOf(p), tmpBackingFile));
                        resultCode = ResultCode.CONSTRAINT_VIOLATION;
                    } else if (!p.isDirectory()) {
                        messages.add(BackendMessages.ERR_TASKBE_BACKING_FILE_PARENT_NOT_DIRECTORY.get(String.valueOf(p), tmpBackingFile));
                        resultCode = ResultCode.CONSTRAINT_VIOLATION;
                    }
                }
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            messages.add(BackendMessages.ERR_TASKBE_ERROR_GETTING_BACKING_FILE.get(StaticUtils.getExceptionMessage(e)));
            resultCode = DirectoryServer.getServerErrorResultCode();
        }
        long tmpRetentionTime = configEntry.getTaskRetentionTime();
        if (resultCode == ResultCode.SUCCESS) {
            if (this.retentionTime != tmpRetentionTime) {
                this.retentionTime = tmpRetentionTime;
                messages.add(BackendMessages.INFO_TASKBE_UPDATED_RETENTION_TIME.get(this.retentionTime));
            }
            if (!this.taskBackingFile.equals(tmpBackingFile)) {
                this.taskBackingFile = tmpBackingFile;
                this.taskScheduler.writeState();
                messages.add(BackendMessages.INFO_TASKBE_UPDATED_BACKING_FILE.get(this.taskBackingFile));
            }
        }
        if ((tmpNotificationAddress = configEntry.getNotificationSenderAddress()) == null) {
            try {
                tmpNotificationAddress = "opends-task-notification@" + InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (Exception e) {
                tmpNotificationAddress = "opends-task-notification@opends.org";
            }
        }
        this.notificationSenderAddress = tmpNotificationAddress;
        this.currentConfig = configEntry;
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    public DN getConfigEntryDN() {
        return this.configEntryDN;
    }

    public String getTaskBackingFile() {
        File f = StaticUtils.getFileForPath(this.taskBackingFile);
        return f.getPath();
    }

    public String getNotificationSenderAddress() {
        return this.notificationSenderAddress;
    }

    public long getRetentionTime() {
        return this.retentionTime;
    }

    public DN getTaskRootDN() {
        return this.taskRootDN;
    }

    public DN getRecurringTasksParentDN() {
        return this.recurringTaskParentDN;
    }

    public DN getScheduledTasksParentDN() {
        return this.scheduledTaskParentDN;
    }

    public Task getScheduledTask(DN taskEntryDN) {
        return this.taskScheduler.getScheduledTask(taskEntryDN);
    }

    public RecurringTask getRecurringTask(DN taskEntryDN) {
        return this.taskScheduler.getRecurringTask(taskEntryDN);
    }

    @Override
    public void preloadEntryCache() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Operation not supported.");
    }
}

