/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.config;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanParameterInfo;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigConstants;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public final class MultiChoiceConfigAttribute
extends ConfigAttribute {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private List<String> activeValues;
    private List<String> pendingValues;
    private Set<String> allowedValues;

    public MultiChoiceConfigAttribute(String name, Message description, boolean isRequired, boolean isMultiValued, boolean requiresAdminAction, Set<String> allowedValues) {
        super(name, description, isRequired, isMultiValued, requiresAdminAction);
        this.allowedValues = allowedValues;
        this.activeValues = new ArrayList<String>();
        this.pendingValues = this.activeValues;
    }

    public MultiChoiceConfigAttribute(String name, Message description, boolean isRequired, boolean isMultiValued, boolean requiresAdminAction, Set<String> allowedValues, String value) {
        super(name, description, isRequired, isMultiValued, requiresAdminAction, MultiChoiceConfigAttribute.getValueSet(value));
        this.allowedValues = allowedValues;
        if (value == null) {
            this.activeValues = new ArrayList<String>();
        } else {
            this.activeValues = new ArrayList<String>(1);
            this.activeValues.add(value);
        }
        this.pendingValues = this.activeValues;
    }

    public MultiChoiceConfigAttribute(String name, Message description, boolean isRequired, boolean isMultiValued, boolean requiresAdminAction, Set<String> allowedValues, List<String> values) {
        super(name, description, isRequired, isMultiValued, requiresAdminAction, MultiChoiceConfigAttribute.getValueSet(values));
        this.allowedValues = allowedValues;
        if (values == null) {
            this.activeValues = new ArrayList<String>();
            this.pendingValues = this.activeValues;
        } else {
            this.activeValues = values;
            this.pendingValues = this.activeValues;
        }
    }

    public MultiChoiceConfigAttribute(String name, Message description, boolean isRequired, boolean isMultiValued, boolean requiresAdminAction, Set<String> allowedValues, List<String> activeValues, List<String> pendingValues) {
        super(name, description, isRequired, isMultiValued, requiresAdminAction, MultiChoiceConfigAttribute.getValueSet(activeValues), pendingValues != null, MultiChoiceConfigAttribute.getValueSet(pendingValues));
        this.allowedValues = allowedValues;
        this.activeValues = activeValues == null ? new ArrayList<String>() : activeValues;
        this.pendingValues = pendingValues == null ? this.activeValues : pendingValues;
    }

    @Override
    public String getDataType() {
        return "MultiChoice";
    }

    @Override
    public AttributeSyntax getSyntax() {
        return DirectoryServer.getDefaultStringSyntax();
    }

    public String activeValue() throws ConfigException {
        if (this.activeValues == null || this.activeValues.isEmpty()) {
            Message message = ConfigMessages.ERR_CONFIG_ATTR_NO_STRING_VALUE.get(this.getName());
            throw new ConfigException(message);
        }
        if (this.activeValues.size() > 1) {
            Message message = ConfigMessages.ERR_CONFIG_ATTR_MULTIPLE_STRING_VALUES.get(this.getName());
            throw new ConfigException(message);
        }
        return this.activeValues.get(0);
    }

    public List<String> activeValues() {
        return this.activeValues;
    }

    public String pendingValue() throws ConfigException {
        if (!this.hasPendingValues()) {
            return this.activeValue();
        }
        if (this.pendingValues == null || this.pendingValues.isEmpty()) {
            Message message = ConfigMessages.ERR_CONFIG_ATTR_NO_STRING_VALUE.get(this.getName());
            throw new ConfigException(message);
        }
        if (this.pendingValues.size() > 1) {
            Message message = ConfigMessages.ERR_CONFIG_ATTR_MULTIPLE_STRING_VALUES.get(this.getName());
            throw new ConfigException(message);
        }
        return this.pendingValues.get(0);
    }

    public List<String> pendingValues() {
        if (!this.hasPendingValues()) {
            return this.activeValues;
        }
        return this.pendingValues;
    }

    public Set<String> allowedValues() {
        return this.allowedValues;
    }

    public void setValue(String value) throws ConfigException {
        if (value == null || value.length() == 0) {
            Message message = ConfigMessages.ERR_CONFIG_ATTR_EMPTY_STRING_VALUE.get(this.getName());
            throw new ConfigException(message);
        }
        if (!this.allowedValues.contains(value.toLowerCase())) {
            Message message = ConfigMessages.ERR_CONFIG_ATTR_VALUE_NOT_ALLOWED.get(value, this.getName());
            throw new ConfigException(message);
        }
        if (this.requiresAdminAction()) {
            this.pendingValues = new ArrayList<String>(1);
            this.pendingValues.add(value);
            this.setPendingValues(MultiChoiceConfigAttribute.getValueSet(value));
        } else {
            this.activeValues.clear();
            this.activeValues.add(value);
            this.pendingValues = this.activeValues;
            this.setActiveValues(MultiChoiceConfigAttribute.getValueSet(value));
        }
    }

    public void setValues(List<String> values) throws ConfigException {
        if (values == null || values.isEmpty()) {
            if (this.isRequired()) {
                Message message = ConfigMessages.ERR_CONFIG_ATTR_IS_REQUIRED.get(this.getName());
                throw new ConfigException(message);
            }
            if (this.requiresAdminAction()) {
                this.setPendingValues(new LinkedHashSet<AttributeValue>(0));
                this.pendingValues = new ArrayList<String>();
            } else {
                this.setActiveValues(new LinkedHashSet<AttributeValue>(0));
                this.activeValues.clear();
            }
        }
        int numValues = values.size();
        if (!this.isMultiValued() && numValues > 1) {
            Message message = ConfigMessages.ERR_CONFIG_ATTR_SET_VALUES_IS_SINGLE_VALUED.get(this.getName());
            throw new ConfigException(message);
        }
        LinkedHashSet<AttributeValue> valueSet = new LinkedHashSet<AttributeValue>(numValues);
        for (String value : values) {
            Message message;
            if (value == null || value.length() == 0) {
                message = ConfigMessages.ERR_CONFIG_ATTR_EMPTY_STRING_VALUE.get(this.getName());
                throw new ConfigException(message);
            }
            if (!this.allowedValues.contains(value.toLowerCase())) {
                message = ConfigMessages.ERR_CONFIG_ATTR_VALUE_NOT_ALLOWED.get(value, this.getName());
                throw new ConfigException(message);
            }
            AttributeValue attrValue = new AttributeValue(new ASN1OctetString(value), (ByteString)new ASN1OctetString(value));
            if (valueSet.contains(attrValue)) {
                Message message2 = ConfigMessages.ERR_CONFIG_ATTR_ADD_VALUES_ALREADY_EXISTS.get(this.getName(), value);
                throw new ConfigException(message2);
            }
            valueSet.add(attrValue);
        }
        if (this.requiresAdminAction()) {
            this.pendingValues = values;
            this.setPendingValues(valueSet);
        } else {
            this.activeValues = values;
            this.pendingValues = this.activeValues;
            this.setActiveValues(valueSet);
        }
    }

    private static LinkedHashSet<AttributeValue> getValueSet(String value) {
        LinkedHashSet<AttributeValue> valueSet = new LinkedHashSet<AttributeValue>(1);
        valueSet.add(new AttributeValue(new ASN1OctetString(value), (ByteString)new ASN1OctetString(value)));
        return valueSet;
    }

    private static LinkedHashSet<AttributeValue> getValueSet(List<String> values) {
        if (values == null) {
            return null;
        }
        LinkedHashSet<AttributeValue> valueSet = new LinkedHashSet<AttributeValue>(values.size());
        for (String value : values) {
            valueSet.add(new AttributeValue(new ASN1OctetString(value), (ByteString)new ASN1OctetString(value)));
        }
        return valueSet;
    }

    @Override
    public void applyPendingValues() {
        if (!this.hasPendingValues()) {
            return;
        }
        super.applyPendingValues();
        this.activeValues = this.pendingValues;
    }

    @Override
    public boolean valueIsAcceptable(AttributeValue value, StringBuilder rejectReason) {
        String stringValue;
        if (value == null || (stringValue = value.getStringValue()).length() == 0) {
            rejectReason.append(ConfigMessages.ERR_CONFIG_ATTR_EMPTY_STRING_VALUE.get(this.getName()));
            return false;
        }
        if (!this.allowedValues.contains(stringValue.toLowerCase())) {
            rejectReason.append(ConfigMessages.ERR_CONFIG_ATTR_VALUE_NOT_ALLOWED.get(stringValue, this.getName()));
            return false;
        }
        return true;
    }

    @Override
    public LinkedHashSet<AttributeValue> stringsToValues(List<String> valueStrings, boolean allowFailures) throws ConfigException {
        if (valueStrings == null || valueStrings.isEmpty()) {
            if (this.isRequired()) {
                Message message = ConfigMessages.ERR_CONFIG_ATTR_IS_REQUIRED.get(this.getName());
                throw new ConfigException(message);
            }
            return new LinkedHashSet<AttributeValue>();
        }
        int numValues = valueStrings.size();
        if (!this.isMultiValued() && numValues > 1) {
            Message message = ConfigMessages.ERR_CONFIG_ATTR_SET_VALUES_IS_SINGLE_VALUED.get(this.getName());
            throw new ConfigException(message);
        }
        LinkedHashSet<AttributeValue> valueSet = new LinkedHashSet<AttributeValue>(numValues);
        for (String valueString : valueStrings) {
            Message message;
            if (valueString == null || valueString.length() == 0) {
                message = ConfigMessages.ERR_CONFIG_ATTR_EMPTY_STRING_VALUE.get(this.getName());
                if (allowFailures) {
                    ErrorLogger.logError(message);
                    continue;
                }
                throw new ConfigException(message);
            }
            if (!this.allowedValues.contains(valueString.toLowerCase())) {
                message = ConfigMessages.ERR_CONFIG_ATTR_VALUE_NOT_ALLOWED.get(valueString, this.getName());
                if (allowFailures) {
                    ErrorLogger.logError(message);
                    continue;
                }
                throw new ConfigException(message);
            }
            valueSet.add(new AttributeValue(new ASN1OctetString(valueString), (ByteString)new ASN1OctetString(valueString)));
        }
        if (this.isRequired() && valueSet.isEmpty()) {
            Message message = ConfigMessages.ERR_CONFIG_ATTR_IS_REQUIRED.get(this.getName());
            throw new ConfigException(message);
        }
        return valueSet;
    }

    @Override
    public List<String> activeValuesToStrings() {
        return this.activeValues;
    }

    @Override
    public List<String> pendingValuesToStrings() {
        if (this.hasPendingValues()) {
            return this.pendingValues;
        }
        return null;
    }

    @Override
    public ConfigAttribute getConfigAttribute(List<Attribute> attributeList) throws ConfigException {
        ArrayList<String> activeValues = null;
        ArrayList<String> pendingValues = null;
        for (Attribute a : attributeList) {
            String lowerValue;
            Message message;
            int numValues;
            LinkedHashSet<AttributeValue> values;
            Message message2;
            if (a.hasOptions()) {
                if (a.hasOption("pending")) {
                    if (pendingValues != null) {
                        message2 = ConfigMessages.ERR_CONFIG_ATTR_MULTIPLE_PENDING_VALUE_SETS.get(a.getName());
                        throw new ConfigException(message2);
                    }
                    values = a.getValues();
                    if (values.isEmpty()) {
                        if (this.isRequired()) {
                            Message message3 = ConfigMessages.ERR_CONFIG_ATTR_IS_REQUIRED.get(a.getName());
                            throw new ConfigException(message3);
                        }
                        pendingValues = new ArrayList(0);
                        continue;
                    }
                    numValues = values.size();
                    if (numValues > 1 && !this.isMultiValued()) {
                        message = ConfigMessages.ERR_CONFIG_ATTR_SET_VALUES_IS_SINGLE_VALUED.get(a.getName());
                        throw new ConfigException(message);
                    }
                    pendingValues = new ArrayList(numValues);
                    for (AttributeValue v : values) {
                        lowerValue = v.getStringValue().toLowerCase();
                        if (!this.allowedValues.contains(lowerValue)) {
                            Message message4 = ConfigMessages.ERR_CONFIG_ATTR_VALUE_NOT_ALLOWED.get(v.getStringValue(), a.getName());
                            throw new ConfigException(message4);
                        }
                        pendingValues.add(v.getStringValue());
                    }
                    continue;
                }
                message2 = ConfigMessages.ERR_CONFIG_ATTR_OPTIONS_NOT_ALLOWED.get(a.getName());
                throw new ConfigException(message2);
            }
            if (activeValues != null) {
                message2 = ConfigMessages.ERR_CONFIG_ATTR_MULTIPLE_ACTIVE_VALUE_SETS.get(a.getName());
                throw new ConfigException(message2);
            }
            values = a.getValues();
            if (values.isEmpty()) {
                if (this.isRequired()) {
                    Message message5 = ConfigMessages.ERR_CONFIG_ATTR_IS_REQUIRED.get(a.getName());
                    throw new ConfigException(message5);
                }
                activeValues = new ArrayList<String>(0);
                continue;
            }
            numValues = values.size();
            if (numValues > 1 && !this.isMultiValued()) {
                message = ConfigMessages.ERR_CONFIG_ATTR_SET_VALUES_IS_SINGLE_VALUED.get(a.getName());
                throw new ConfigException(message);
            }
            activeValues = new ArrayList(numValues);
            for (AttributeValue v : values) {
                lowerValue = v.getStringValue().toLowerCase();
                if (!this.allowedValues.contains(lowerValue)) {
                    Message message6 = ConfigMessages.ERR_CONFIG_ATTR_VALUE_NOT_ALLOWED.get(v.getStringValue(), a.getName());
                    throw new ConfigException(message6);
                }
                activeValues.add(v.getStringValue());
            }
        }
        if (activeValues == null) {
            Message message = ConfigMessages.ERR_CONFIG_ATTR_NO_ACTIVE_VALUE_SET.get(this.getName());
            throw new ConfigException(message);
        }
        if (pendingValues == null) {
            pendingValues = activeValues;
        }
        return new MultiChoiceConfigAttribute(this.getName(), this.getDescription(), this.isRequired(), this.isMultiValued(), this.requiresAdminAction(), this.allowedValues, activeValues, pendingValues);
    }

    private javax.management.Attribute _toJMXAttribute(boolean pending) {
        String name;
        List<String> requestedValues;
        if (pending) {
            requestedValues = this.pendingValues;
            name = this.getName() + ";" + "pending";
        } else {
            requestedValues = this.activeValues;
            name = this.getName();
        }
        if (this.isMultiValued()) {
            String[] values = new String[requestedValues.size()];
            requestedValues.toArray(values);
            return new javax.management.Attribute(name, values);
        }
        if (requestedValues.isEmpty()) {
            return null;
        }
        return new javax.management.Attribute(name, requestedValues.get(0));
    }

    @Override
    public javax.management.Attribute toJMXAttribute() {
        return this._toJMXAttribute(false);
    }

    @Override
    public javax.management.Attribute toJMXAttributePending() {
        return this._toJMXAttribute(true);
    }

    @Override
    public void toJMXAttribute(AttributeList attributeList) {
        if (this.activeValues.size() > 0) {
            if (this.isMultiValued()) {
                String[] values = new String[this.activeValues.size()];
                this.activeValues.toArray(values);
                attributeList.add(new javax.management.Attribute(this.getName(), values));
            } else {
                attributeList.add(new javax.management.Attribute(this.getName(), this.activeValues.get(0)));
            }
        } else if (this.isMultiValued()) {
            attributeList.add(new javax.management.Attribute(this.getName(), new String[0]));
        } else {
            attributeList.add(new javax.management.Attribute(this.getName(), null));
        }
        if (this.requiresAdminAction() && this.pendingValues != null && this.pendingValues != this.activeValues) {
            String name = this.getName() + ";" + "pending";
            if (this.isMultiValued()) {
                String[] values = new String[this.pendingValues.size()];
                this.pendingValues.toArray(values);
                attributeList.add(new javax.management.Attribute(name, values));
            } else if (!this.pendingValues.isEmpty()) {
                attributeList.add(new javax.management.Attribute(name, this.pendingValues.get(0)));
            }
        }
    }

    @Override
    public void toJMXAttributeInfo(List<MBeanAttributeInfo> attributeInfoList) {
        if (this.isMultiValued()) {
            attributeInfoList.add(new MBeanAttributeInfo(this.getName(), ConfigConstants.JMX_TYPE_STRING_ARRAY, String.valueOf(this.getDescription()), true, true, false));
        } else {
            attributeInfoList.add(new MBeanAttributeInfo(this.getName(), String.class.getName(), String.valueOf(this.getDescription()), true, true, false));
        }
        if (this.requiresAdminAction()) {
            String name = this.getName() + ";" + "pending";
            if (this.isMultiValued()) {
                attributeInfoList.add(new MBeanAttributeInfo(name, ConfigConstants.JMX_TYPE_STRING_ARRAY, String.valueOf(this.getDescription()), true, false, false));
            } else {
                attributeInfoList.add(new MBeanAttributeInfo(name, String.class.getName(), String.valueOf(this.getDescription()), true, false, false));
            }
        }
    }

    @Override
    public MBeanParameterInfo toJMXParameterInfo() {
        if (this.isMultiValued()) {
            return new MBeanParameterInfo(this.getName(), ConfigConstants.JMX_TYPE_STRING_ARRAY, String.valueOf(this.getDescription()));
        }
        return new MBeanParameterInfo(this.getName(), String.class.getName(), String.valueOf(this.getDescription()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setValue(javax.management.Attribute jmxAttribute) throws ConfigException {
        Object value = jmxAttribute.getValue();
        if (value instanceof String) {
            this.setValue((String)value);
            return;
        }
        if (!value.getClass().isArray()) {
            Message message = ConfigMessages.ERR_CONFIG_ATTR_STRING_INVALID_TYPE.get(String.valueOf(value), this.getName(), value.getClass().getName());
            throw new ConfigException(message);
        }
        String componentType = value.getClass().getComponentType().getName();
        int length = Array.getLength(value);
        if (!componentType.equals(String.class.getName())) {
            Message message = ConfigMessages.ERR_CONFIG_ATTR_STRING_INVALID_ARRAY_TYPE.get(this.getName(), componentType);
            throw new ConfigException(message);
        }
        try {
            ArrayList<String> values = new ArrayList<String>(length);
            int i = 0;
            while (true) {
                if (i >= length) {
                    this.setValues(values);
                    return;
                }
                values.add((String)Array.get(value, i));
                ++i;
            }
        }
        catch (ConfigException ce) {
            if (!DebugLogger.debugEnabled()) throw ce;
            TRACER.debugCaught(DebugLogLevel.ERROR, ce);
            throw ce;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ConfigMessages.ERR_CONFIG_ATTR_INVALID_STRING_VALUE.get(this.getName(), String.valueOf(value), String.valueOf(e));
            throw new ConfigException(message, (Throwable)e);
        }
    }

    @Override
    public ConfigAttribute duplicate() {
        return new MultiChoiceConfigAttribute(this.getName(), this.getDescription(), this.isRequired(), this.isMultiValued(), this.requiresAdminAction(), this.allowedValues, this.activeValues, this.pendingValues);
    }
}

