/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opends.messages.CoreMessages;
import org.opends.messages.MessageBuilder;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ExtendedOperationHandler;
import org.opends.server.api.plugin.PluginResult;
import org.opends.server.core.AccessControlConfigManager;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ExtendedOperation;
import org.opends.server.core.PluginConfigManager;
import org.opends.server.loggers.AccessLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.AbstractOperation;
import org.opends.server.types.CancelResult;
import org.opends.server.types.CanceledOperationException;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.OperationType;
import org.opends.server.types.ResultCode;
import org.opends.server.types.operation.PostOperationExtendedOperation;
import org.opends.server.types.operation.PostResponseExtendedOperation;
import org.opends.server.types.operation.PreOperationExtendedOperation;
import org.opends.server.types.operation.PreParseExtendedOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedOperationBasis
extends AbstractOperation
implements ExtendedOperation,
PreParseExtendedOperation,
PreOperationExtendedOperation,
PostOperationExtendedOperation,
PostResponseExtendedOperation {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ASN1OctetString requestValue;
    private ASN1OctetString responseValue;
    private boolean responseSent;
    private List<Control> responseControls;
    private String requestOID;
    private String responseOID;

    public ExtendedOperationBasis(ClientConnection clientConnection, long operationID, int messageID, List<Control> requestControls, String requestOID, ASN1OctetString requestValue) {
        super(clientConnection, operationID, messageID, requestControls);
        this.requestOID = requestOID;
        this.requestValue = requestValue;
        this.responseOID = null;
        this.responseValue = null;
        this.responseControls = new ArrayList<Control>();
        this.cancelRequest = null;
        this.responseSent = false;
        if (requestOID.equals("1.3.6.1.1.8")) {
            this.cancelResult = new CancelResult(ResultCode.CANNOT_CANCEL, CoreMessages.ERR_CANNOT_CANCEL_CANCEL.get());
        }
        if (requestOID.equals("1.3.6.1.4.1.1466.20037")) {
            this.cancelResult = new CancelResult(ResultCode.CANNOT_CANCEL, CoreMessages.ERR_CANNOT_CANCEL_START_TLS.get());
        }
    }

    @Override
    public final String getRequestOID() {
        return this.requestOID;
    }

    @Override
    public final void setRequestOID(String requestOID) {
        this.requestOID = requestOID;
    }

    @Override
    public final ASN1OctetString getRequestValue() {
        return this.requestValue;
    }

    @Override
    public final void setRequestValue(ASN1OctetString requestValue) {
        this.requestValue = requestValue;
    }

    @Override
    public final String getResponseOID() {
        return this.responseOID;
    }

    @Override
    public final void setResponseOID(String responseOID) {
        this.responseOID = responseOID;
    }

    @Override
    public final ASN1OctetString getResponseValue() {
        return this.responseValue;
    }

    @Override
    public final void setResponseValue(ASN1OctetString responseValue) {
        this.responseValue = responseValue;
    }

    @Override
    public final OperationType getOperationType() {
        return OperationType.EXTENDED;
    }

    @Override
    public final String[][] getRequestLogElements() {
        return new String[][]{{"requestOID", this.requestOID}};
    }

    @Override
    public final String[][] getResponseLogElements() {
        String referrals;
        String resultCode = String.valueOf(this.getResultCode().getIntValue());
        MessageBuilder errorMessageBuffer = this.getErrorMessage();
        String errorMessage = errorMessageBuffer == null ? null : errorMessageBuffer.toString();
        DN matchedDN = this.getMatchedDN();
        String matchedDNStr = matchedDN == null ? null : matchedDN.toString();
        List<String> referralURLs = this.getReferralURLs();
        if (referralURLs == null || referralURLs.isEmpty()) {
            referrals = null;
        } else {
            StringBuilder buffer = new StringBuilder();
            Iterator<String> iterator = referralURLs.iterator();
            buffer.append(iterator.next());
            while (iterator.hasNext()) {
                buffer.append(", ");
                buffer.append(iterator.next());
            }
            referrals = buffer.toString();
        }
        String processingTime = String.valueOf(this.getProcessingTime());
        return new String[][]{{"resultCode", resultCode}, {"errorMessage", errorMessage}, {"matchedDN", matchedDNStr}, {"referralURLs", referrals}, {"responseOID", this.responseOID}, {"processingTime", processingTime}};
    }

    @Override
    public final List<Control> getResponseControls() {
        return this.responseControls;
    }

    @Override
    public final void addResponseControl(Control control) {
        this.responseControls.add(control);
    }

    @Override
    public final void removeResponseControl(Control control) {
        this.responseControls.remove(control);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void run() {
        PluginConfigManager pluginConfigManager;
        block38: {
            block37: {
                block36: {
                    block35: {
                        block34: {
                            block33: {
                                this.setResultCode(ResultCode.UNDEFINED);
                                this.setProcessingStartTime();
                                AccessLogger.logExtendedRequest(this);
                                pluginConfigManager = DirectoryServer.getPluginConfigManager();
                                try {
                                    try {
                                        this.checkIfCanceled(false);
                                        PluginResult.PreParse preParseResult = pluginConfigManager.invokePreParseExtendedPlugins(this);
                                        if (!preParseResult.continueProcessing()) {
                                            this.setResultCode(preParseResult.getResultCode());
                                            this.appendErrorMessage(preParseResult.getErrorMessage());
                                            this.setMatchedDN(preParseResult.getMatchedDN());
                                            this.setReferralURLs(preParseResult.getReferralURLs());
                                            Object var9_4 = null;
                                            break block33;
                                        }
                                        this.checkIfCanceled(false);
                                        ExtendedOperationHandler handler = DirectoryServer.getExtendedOperationHandler(this.requestOID);
                                        if (handler == null) {
                                            this.setResultCode(ResultCode.UNWILLING_TO_PERFORM);
                                            this.appendErrorMessage(CoreMessages.ERR_EXTENDED_NO_HANDLER.get(String.valueOf(this.requestOID)));
                                            break block34;
                                        }
                                        List<Control> requestControls = this.getRequestControls();
                                        if (requestControls != null && !requestControls.isEmpty()) {
                                            for (Control c : requestControls) {
                                                if (!AccessControlConfigManager.getInstance().getAccessControlHandler().isAllowed(this.getAuthorizationDN(), this, c)) {
                                                    this.setResultCode(ResultCode.INSUFFICIENT_ACCESS_RIGHTS);
                                                    this.appendErrorMessage(CoreMessages.ERR_CONTROL_INSUFFICIENT_ACCESS_RIGHTS.get(c.getOID()));
                                                    break block35;
                                                }
                                                if (!c.isCritical() || handler.supportsControl(c.getOID())) continue;
                                                this.setResultCode(ResultCode.UNAVAILABLE_CRITICAL_EXTENSION);
                                                this.appendErrorMessage(CoreMessages.ERR_EXTENDED_UNSUPPORTED_CRITICAL_CONTROL.get(String.valueOf(this.requestOID), c.getOID()));
                                                break block36;
                                            }
                                        }
                                        if (!AccessControlConfigManager.getInstance().getAccessControlHandler().isAllowed(this)) {
                                            this.setResultCode(ResultCode.INSUFFICIENT_ACCESS_RIGHTS);
                                            this.appendErrorMessage(CoreMessages.ERR_EXTENDED_AUTHZ_INSUFFICIENT_ACCESS_RIGHTS.get(String.valueOf(this.requestOID)));
                                            break block37;
                                        }
                                        try {
                                            PluginResult.PreOperation preOpResult = pluginConfigManager.invokePreOperationExtendedPlugins(this);
                                            if (!preOpResult.continueProcessing()) {
                                                this.setResultCode(preParseResult.getResultCode());
                                                this.appendErrorMessage(preParseResult.getErrorMessage());
                                                this.setMatchedDN(preParseResult.getMatchedDN());
                                                this.setReferralURLs(preParseResult.getReferralURLs());
                                            }
                                            this.checkIfCanceled(false);
                                            handler.processExtendedOperation(this);
                                            break block38;
                                        }
                                        finally {
                                            pluginConfigManager.invokePostOperationExtendedPlugins(this);
                                        }
                                    }
                                    catch (CanceledOperationException coe) {
                                        if (DebugLogger.debugEnabled()) {
                                            TRACER.debugCaught(DebugLogLevel.ERROR, coe);
                                        }
                                        this.setResultCode(ResultCode.CANCELED);
                                        this.cancelResult = new CancelResult(ResultCode.CANCELED, null);
                                        this.appendErrorMessage(coe.getCancelRequest().getCancelReason());
                                        Object var9_11 = null;
                                        this.setProcessingStopTime();
                                        if (!this.responseSent) {
                                            this.responseSent = true;
                                            if (this.cancelRequest == null || this.cancelResult == null || this.cancelResult.getResultCode() != ResultCode.CANCELED || this.cancelRequest.notifyOriginalRequestor() || DirectoryServer.notifyAbandonedOperations()) {
                                                this.clientConnection.sendResponse(this);
                                            }
                                        }
                                        AccessLogger.logExtendedResponse(this);
                                        pluginConfigManager.invokePostResponseExtendedPlugins(this);
                                        if (this.cancelResult != null) return;
                                        this.cancelResult = new CancelResult(ResultCode.TOO_LATE, null);
                                        return;
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var9_12 = null;
                                    this.setProcessingStopTime();
                                    if (!this.responseSent) {
                                        this.responseSent = true;
                                        if (this.cancelRequest == null || this.cancelResult == null || this.cancelResult.getResultCode() != ResultCode.CANCELED || this.cancelRequest.notifyOriginalRequestor() || DirectoryServer.notifyAbandonedOperations()) {
                                            this.clientConnection.sendResponse(this);
                                        }
                                    }
                                    AccessLogger.logExtendedResponse(this);
                                    pluginConfigManager.invokePostResponseExtendedPlugins(this);
                                    if (this.cancelResult != null) throw throwable;
                                    this.cancelResult = new CancelResult(ResultCode.TOO_LATE, null);
                                    throw throwable;
                                }
                            }
                            this.setProcessingStopTime();
                            if (!this.responseSent) {
                                this.responseSent = true;
                                if (this.cancelRequest == null || this.cancelResult == null || this.cancelResult.getResultCode() != ResultCode.CANCELED || this.cancelRequest.notifyOriginalRequestor() || DirectoryServer.notifyAbandonedOperations()) {
                                    this.clientConnection.sendResponse(this);
                                }
                            }
                            AccessLogger.logExtendedResponse(this);
                            pluginConfigManager.invokePostResponseExtendedPlugins(this);
                            if (this.cancelResult != null) return;
                            this.cancelResult = new CancelResult(ResultCode.TOO_LATE, null);
                            return;
                        }
                        Object var9_5 = null;
                        this.setProcessingStopTime();
                        if (!this.responseSent) {
                            this.responseSent = true;
                            if (this.cancelRequest == null || this.cancelResult == null || this.cancelResult.getResultCode() != ResultCode.CANCELED || this.cancelRequest.notifyOriginalRequestor() || DirectoryServer.notifyAbandonedOperations()) {
                                this.clientConnection.sendResponse(this);
                            }
                        }
                        AccessLogger.logExtendedResponse(this);
                        pluginConfigManager.invokePostResponseExtendedPlugins(this);
                        if (this.cancelResult != null) return;
                        this.cancelResult = new CancelResult(ResultCode.TOO_LATE, null);
                        return;
                    }
                    Object var9_6 = null;
                    this.setProcessingStopTime();
                    if (!this.responseSent) {
                        this.responseSent = true;
                        if (this.cancelRequest == null || this.cancelResult == null || this.cancelResult.getResultCode() != ResultCode.CANCELED || this.cancelRequest.notifyOriginalRequestor() || DirectoryServer.notifyAbandonedOperations()) {
                            this.clientConnection.sendResponse(this);
                        }
                    }
                    AccessLogger.logExtendedResponse(this);
                    pluginConfigManager.invokePostResponseExtendedPlugins(this);
                    if (this.cancelResult != null) return;
                    this.cancelResult = new CancelResult(ResultCode.TOO_LATE, null);
                    return;
                }
                Object var9_7 = null;
                this.setProcessingStopTime();
                if (!this.responseSent) {
                    this.responseSent = true;
                    if (this.cancelRequest == null || this.cancelResult == null || this.cancelResult.getResultCode() != ResultCode.CANCELED || this.cancelRequest.notifyOriginalRequestor() || DirectoryServer.notifyAbandonedOperations()) {
                        this.clientConnection.sendResponse(this);
                    }
                }
                AccessLogger.logExtendedResponse(this);
                pluginConfigManager.invokePostResponseExtendedPlugins(this);
                if (this.cancelResult != null) return;
                this.cancelResult = new CancelResult(ResultCode.TOO_LATE, null);
                return;
            }
            Object var9_8 = null;
            this.setProcessingStopTime();
            if (!this.responseSent) {
                this.responseSent = true;
                if (this.cancelRequest == null || this.cancelResult == null || this.cancelResult.getResultCode() != ResultCode.CANCELED || this.cancelRequest.notifyOriginalRequestor() || DirectoryServer.notifyAbandonedOperations()) {
                    this.clientConnection.sendResponse(this);
                }
            }
            AccessLogger.logExtendedResponse(this);
            pluginConfigManager.invokePostResponseExtendedPlugins(this);
            if (this.cancelResult != null) return;
            this.cancelResult = new CancelResult(ResultCode.TOO_LATE, null);
            return;
        }
        Object var9_10 = null;
        this.setProcessingStopTime();
        if (!this.responseSent) {
            this.responseSent = true;
            if (this.cancelRequest == null || this.cancelResult == null || this.cancelResult.getResultCode() != ResultCode.CANCELED || this.cancelRequest.notifyOriginalRequestor() || DirectoryServer.notifyAbandonedOperations()) {
                this.clientConnection.sendResponse(this);
            }
        }
        AccessLogger.logExtendedResponse(this);
        pluginConfigManager.invokePostResponseExtendedPlugins(this);
        if (this.cancelResult != null) return;
        this.cancelResult = new CancelResult(ResultCode.TOO_LATE, null);
    }

    public final void sendExtendedResponse() {
        if (!this.responseSent) {
            this.responseSent = true;
            this.clientConnection.sendResponse(this);
        }
    }

    @Override
    public final void setResponseSent() {
        this.responseSent = true;
    }

    @Override
    public final void toString(StringBuilder buffer) {
        buffer.append("ExtendedOperation(connID=");
        buffer.append(this.clientConnection.getConnectionID());
        buffer.append(", opID=");
        buffer.append(this.operationID);
        buffer.append(", oid=");
        buffer.append(this.requestOID);
        buffer.append(")");
    }
}

